/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.common.model.options;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import org.jboss.tools.common.model.XModelException;
import org.jboss.tools.common.model.options.Preference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwitchPreference
extends Preference {
    protected Preference switchPreference = null;
    protected Hashtable<Object, Preference> preferencesMap = new Hashtable();

    public SwitchPreference(String attributeName) {
        super("", attributeName);
    }

    public SwitchPreference(String attributeName, Preference switchPreference) {
        this(attributeName);
        this.switchPreference = switchPreference;
    }

    public void setSwitchPreference(Preference pref) {
        this.switchPreference = pref;
    }

    @Override
    public String getValue() {
        if (this.switchPreference == null) {
            throw new IllegalStateException("switchPreference cannot be null, call setSwitchPreferenceFirst.");
        }
        Preference preference = this.preferencesMap.get(this.switchPreference.getValue());
        if (preference == null) {
            throw new IllegalStateException("Preference in't added for switch value '" + this.switchPreference.getValue() + "'");
        }
        return preference.getValue();
    }

    @Override
    public void setValue(String value) throws XModelException {
        if (this.switchPreference == null) {
            throw new IllegalStateException("switchPreference cannot be null, call setSwitchPreferenceFirst.");
        }
        Preference preference = this.preferencesMap.get(this.switchPreference.getValue());
        if (preference == null) {
            throw new IllegalStateException("Preference in't added for switch value '" + this.switchPreference.getValue() + "'");
        }
        preference.setValue(value);
    }

    public void addPreferenceMapping(Object switchValue, Preference pref) {
        this.preferencesMap.put(switchValue, pref);
    }

    public List<Preference> getPreferences() {
        ArrayList<Preference> preferenceList = new ArrayList<Preference>();
        Enumeration<Object> keys = this.preferencesMap.keys();
        while (keys.hasMoreElements()) {
            preferenceList.add(this.preferencesMap.get(keys.nextElement()));
        }
        return Collections.unmodifiableList(preferenceList);
    }

    public static final SwitchPreference createSwitchPreference(String name, Preference switchPreference, SwitchPreferenceMapping[] preferenceMap) {
        SwitchPreference preference = new SwitchPreference(name, switchPreference);
        int i = 0;
        while (i < preferenceMap.length) {
            preference.addPreferenceMapping(preferenceMap[i].getValue(), preferenceMap[i].getPreference());
            ++i;
        }
        return preference;
    }

    public static final SwitchPreferenceMapping createMapping(Object value, Preference preference) {
        return new SwitchPreferenceMapping(value, preference);
    }

    public static class SwitchPreferenceMapping {
        Object[] map;

        public SwitchPreferenceMapping(Object value, Preference preference) {
            this.map = new Object[]{value, preference};
        }

        public Object getValue() {
            return this.map[0];
        }

        public Preference getPreference() {
            return (Preference)this.map[1];
        }
    }
}

