/*
 * Decompiled with CFR 0.152.
 */
package name.herlin.command;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.ResourceBundle;
import name.herlin.command.AbstractProcessableCommand;
import name.herlin.command.CommandProcessor;
import name.herlin.command.CommandProcessorStrategy;
import name.herlin.command.DefaultCommandProcessor;

public class DefaultCommandProcessorStrategy
implements CommandProcessorStrategy {
    private static final CommandProcessor DEFAULT_COMMAND_PROCESSOR = new DefaultCommandProcessor();
    private final Map registeredCommandProcessors = new Hashtable();

    public DefaultCommandProcessorStrategy() {
        this.loadBundle();
    }

    public CommandProcessor getCommandProcessor(AbstractProcessableCommand abstractProcessableCommand) {
        CommandProcessor commandProcessor = this.getRegisteredCommandProcessor(abstractProcessableCommand);
        if (commandProcessor == null) {
            commandProcessor = abstractProcessableCommand.getPreferredCommandProcessor();
        }
        if (commandProcessor == null) {
            commandProcessor = DEFAULT_COMMAND_PROCESSOR;
        }
        return commandProcessor;
    }

    protected CommandProcessor getRegisteredCommandProcessor(AbstractProcessableCommand abstractProcessableCommand) {
        CommandProcessor commandProcessor = null;
        try {
            String string = (String)this.registeredCommandProcessors.get(abstractProcessableCommand.getName());
            if (string != null) {
                Class<?> clazz = Class.forName(string);
                commandProcessor = (CommandProcessor)clazz.newInstance();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return commandProcessor;
    }

    private void loadBundle() {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("properties.CommandProcessorStrategy");
            Enumeration<String> enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                String string2 = resourceBundle.getString(string);
                this.registeredCommandProcessors.put(string, string2);
            }
        }
        catch (RuntimeException runtimeException) {}
    }
}

