/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.hqleditor;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.hibernate.eclipse.hqleditor.HQLColors;
import org.hibernate.eclipse.hqleditor.HQLWordDetector;

public class HQLCodeScanner
extends RuleBasedScanner {
    private static String[] hqlKeywords = new String[]{"between", "class", "delete", "desc", "distinct", "elements", "escape", "exists", "false", "fetch", "from", "full", "group", "having", "in", "indices", "inner", "insert", "into", "is", "join", "left", "like", "new", "not", "null", "or", "order", "outer", "properties", "right", "select", "set", "some", "true", "union", "update", "versioned", "where", "and", "or", "case", "end", "else", "then", "when", "on", "with", "both", "empty", "leading", "member", "object", "of", "trailing"};
    private static String[] builtInFunctions = new String[]{"substring", "locate", "trim", "length", "bit_length", "coalesce", "nullif", "abs", "mod", "sqrt", "upper", "lower", "cast", "extract", "second", "minute", "hour", "day", "month", "year", "str", "sign", "acos", "asin", "atan", "cos", "cosh", "exp", "ln", "sin", "sinh", "stddev", "sqrt", "tan", "tanh", "variance", "round", "trunc", "ceil", "floor", "chr", "initcap", "lower", "ltrim", "rtrim", "soundex", "upper", "ascii", "length", "to_char", "to_date", "current_date", "current_time", "current_timestamp", "lastday", "sysday", "systimestamp", "uid", "user", "rowid", "rownum", "concat", "instr", "instrb", "lpad", "replace", "rpad", "substr", "substrb", "translate", "substring", "locate", "bit_length", "coalesce", "atan2", "log", "mod", "nvl", "nvl2", "power", "add_months", "months_between", "next_day"};

    static {
        Arrays.sort(builtInFunctions);
        Arrays.sort(hqlKeywords);
    }

    public HQLCodeScanner(HQLColors colorProvider) {
        Token commentToken = new Token((Object)new TextAttribute(colorProvider.getColor("hql.comment.color")));
        Token stringToken = new Token((Object)new TextAttribute(colorProvider.getColor("hql.quoted_literal.color")));
        Token keywordToken = new Token(new TextAttribute(colorProvider.getColor("hql.keyword.color"), null, 1)){

            public Object getData() {
                return super.getData();
            }
        };
        Token functionToken = new Token((Object)new TextAttribute(colorProvider.getColor("hql.keyword.color")));
        Token otherToken = new Token((Object)new TextAttribute(colorProvider.getColor("hql.default.color")));
        this.setDefaultReturnToken((IToken)otherToken);
        ArrayList<Object> rules = new ArrayList<Object>();
        rules.add(new EndOfLineRule("--", (IToken)commentToken));
        rules.add(new SingleLineRule("'", "'", (IToken)stringToken, '\\'));
        rules.add(new WhitespaceRule((IWhitespaceDetector)new HQLWhiteSpaceDetector()));
        WordRule wordRule = new WordRule((IWordDetector)new HQLWordDetector(), (IToken)otherToken);
        this.addWordRules((IToken)keywordToken, wordRule, HQLCodeScanner.getHQLKeywords());
        this.addWordRules((IToken)functionToken, wordRule, HQLCodeScanner.getHQLFunctionNames());
        rules.add(wordRule);
        this.setRules(rules.toArray(new IRule[rules.size()]));
    }

    private void addWordRules(IToken token, WordRule wordRule, String[] reservedWords) {
        int i = 0;
        while (i < reservedWords.length) {
            wordRule.addWord(reservedWords[i], token);
            wordRule.addWord(reservedWords[i].toUpperCase(), token);
            ++i;
        }
    }

    public static String[] getHQLKeywords() {
        return hqlKeywords;
    }

    public static String[] getHQLFunctionNames() {
        return builtInFunctions;
    }

    public static class HQLWhiteSpaceDetector
    implements IWhitespaceDetector {
        public boolean isWhitespace(char c) {
            return Character.isWhitespace(c);
        }
    }
}

