/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.console.node;

import org.hibernate.SessionFactory;
import org.hibernate.console.ConcoleConfigurationAdapter;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.ConsoleMessages;
import org.hibernate.console.node.BaseNode;
import org.hibernate.console.node.NodeFactory;

class ConfigurationNode
extends BaseNode {
    private final ConsoleConfiguration configuration;
    private boolean childrenCreated;

    public ConfigurationNode(BaseNode parent, ConsoleConfiguration configuration) {
        super(null, parent);
        this.configuration = configuration;
        configuration.addConsoleConfigurationListener(new ConcoleConfigurationAdapter(){

            @Override
            public void sessionFactoryBuilt(ConsoleConfiguration ccfg, SessionFactory builtSessionFactory) {
                ConfigurationNode.this.clear();
            }

            @Override
            public void sessionFactoryClosing(ConsoleConfiguration configuration, SessionFactory closedSessionFactory) {
                ConfigurationNode.this.clear();
            }

            @Override
            public void configurationReset(ConsoleConfiguration ccfg) {
                ConfigurationNode.this.clear();
            }
        });
        this.name = configuration.getName();
        this.iconName = "images/configuration.gif";
    }

    @Override
    public ConsoleConfiguration getConsoleConfiguration() {
        return this.configuration;
    }

    @Override
    protected void checkChildren() {
        if (!this.childrenCreated) {
            if (this.configuration.isSessionFactoryCreated()) {
                NodeFactory fac = new NodeFactory(this.configuration);
                this.children.add(fac.createConfigurationEntitiesNode(ConsoleMessages.ConfigurationNode_mapped_entities));
                this.childrenCreated = true;
            } else {
                this.children.clear();
            }
        }
    }

    @Override
    public String getHQL() {
        return null;
    }

    @Override
    public void clear() {
        super.clear();
        this.childrenCreated = false;
    }
}

