/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor.template;

import org.eclipse.swt.graphics.Point;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.jboss.tools.jst.jsp.util.NodesManagingUtil;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.AttributeData;
import org.jboss.tools.vpe.editor.mapping.NodeData;
import org.jboss.tools.vpe.editor.mapping.VpeDomMapping;
import org.jboss.tools.vpe.editor.mapping.VpeElementData;
import org.jboss.tools.vpe.editor.mapping.VpeElementMapping;
import org.jboss.tools.vpe.editor.mapping.VpeNodeMapping;
import org.jboss.tools.vpe.editor.template.IKeyEventHandler;
import org.jboss.tools.vpe.editor.template.IZoomEventManager;
import org.jboss.tools.vpe.editor.template.VpeTemplate;
import org.jboss.tools.vpe.editor.util.SelectionUtil;
import org.jboss.tools.vpe.editor.util.TextUtil;
import org.mozilla.interfaces.nsIDOMKeyEvent;
import org.mozilla.interfaces.nsIDOMNode;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class KeyEventManager
implements IKeyEventHandler {
    private static final String EMPTY_STRING = "";
    private StructuredTextEditor sourceEditor;
    private VpeDomMapping domMapping;
    private VpePageContext pageContext;
    private IZoomEventManager zoomEventManager;

    public KeyEventManager(StructuredTextEditor sourceEditor, VpeDomMapping domMapping, VpePageContext pageContext) {
        this.sourceEditor = sourceEditor;
        this.domMapping = domMapping;
        this.pageContext = pageContext;
        this.zoomEventManager = pageContext.getEditPart().getVisualEditor().getController().getZoomEventManager();
    }

    @Override
    public final boolean handleKeyPress(nsIDOMKeyEvent keyEvent) {
        long keyCode = keyEvent.getKeyCode();
        if (keyCode == 14L) {
            return this.handleEnter(keyEvent);
        }
        if (keyEvent.getCtrlKey() && keyEvent.getCharCode() == 61L) {
            return this.handleZoomInEvent(keyEvent);
        }
        if (keyEvent.getCtrlKey() && keyEvent.getCharCode() == 45L) {
            return this.handleZoomOutEvent(keyEvent);
        }
        if (keyEvent.getCtrlKey() && keyEvent.getCharCode() == 48L) {
            return this.handleResetZoomView(keyEvent);
        }
        if (keyCode == 37L && !keyEvent.getShiftKey()) {
            return this.handleLeft(keyEvent);
        }
        if (keyCode == 38L && !keyEvent.getShiftKey()) {
            return this.handleUp(keyEvent);
        }
        if (keyCode == 39L && !keyEvent.getShiftKey()) {
            return this.handleRight(keyEvent);
        }
        if (keyCode == 40L && !keyEvent.getShiftKey()) {
            return this.handleDown(keyEvent);
        }
        if (keyCode == 36L && !keyEvent.getShiftKey()) {
            return this.handleHome(keyEvent);
        }
        if (keyCode == 35L && !keyEvent.getShiftKey()) {
            return this.handleEnd(keyEvent);
        }
        if (keyCode == 8L && !keyEvent.getShiftKey()) {
            return this.handleDelete(keyEvent, 8);
        }
        if (keyCode == 46L && !keyEvent.getShiftKey()) {
            return this.handleDelete(keyEvent, 127);
        }
        if (keyCode == 33L && !keyEvent.getShiftKey()) {
            return this.handlePageUp(keyEvent);
        }
        if (keyEvent.getCharCode() != 0L) {
            return this.handleCharacter(keyEvent);
        }
        if (keyEvent.getKeyCode() == 45L && keyEvent.getShiftKey()) {
            return this.handleInsert(keyEvent);
        }
        return false;
    }

    protected boolean handleCharacter(nsIDOMKeyEvent keyEvent) {
        VpeNodeMapping selectedNodeMapping = SelectionUtil.getNodeMappingBySourceSelection(this.getSourceEditor(), this.getDomMapping());
        if (selectedNodeMapping == null) {
            return false;
        }
        boolean editable = false;
        String enteredChar = TextUtil.getChar(keyEvent);
        if (selectedNodeMapping instanceof VpeElementMapping) {
            nsIDOMNode visualNode;
            VpeElementMapping elementMapping = (VpeElementMapping)selectedNodeMapping;
            VpeElementData elementData = elementMapping.getElementData();
            VpeTemplate template = elementMapping.getTemplate();
            NodeData nodeData = template.getNodeData(visualNode = SelectionUtil.getSelectedNode(this.getPageContext()), elementData, this.domMapping);
            if (nodeData != null) {
                editable = nodeData.isEditable();
                if (editable && nodeData.getType() == 1 && nodeData.getSourceNode() == null) {
                    Node newNode = this.createAttribute((Element)selectedNodeMapping.getSourceNode(), ((AttributeData)nodeData).getAttributeName(), enteredChar);
                    nodeData.setSourceNode(newNode);
                    SelectionUtil.setSourceSelection(this.pageContext, newNode, enteredChar.length());
                    return true;
                }
            } else {
                editable = false;
            }
        } else {
            editable = true;
        }
        if (editable) {
            Point range = this.getSourceEditor().getTextViewer().getSelectedRange();
            this.getSourceEditor().getTextViewer().getTextWidget().replaceTextRange(range.x, range.y, enteredChar);
            this.getSourceEditor().getTextViewer().getTextWidget().setSelection(range.x + enteredChar.length());
        }
        return true;
    }

    private boolean handleDelete(nsIDOMKeyEvent keyEvent, int delete) {
        VpeNodeMapping selectedNodeMapping = SelectionUtil.getNodeMappingBySourceSelection(this.getSourceEditor(), this.getDomMapping());
        if (selectedNodeMapping == null) {
            return false;
        }
        boolean editable = false;
        Node visibleSourceNode = null;
        if (selectedNodeMapping instanceof VpeElementMapping) {
            nsIDOMNode visualNode;
            VpeElementMapping elementMapping = (VpeElementMapping)selectedNodeMapping;
            VpeElementData elementData = elementMapping.getElementData();
            VpeTemplate template = elementMapping.getTemplate();
            NodeData nodeData = template.getNodeData(visualNode = SelectionUtil.getSelectedNode(this.getPageContext()), elementData, this.domMapping);
            if (nodeData != null) {
                if (nodeData.isEditable() && nodeData.getType() == 1 && nodeData.getSourceNode() == null) {
                    Node newNode = this.createAttribute((Element)selectedNodeMapping.getSourceNode(), ((AttributeData)nodeData).getAttributeName(), EMPTY_STRING);
                    nodeData.setSourceNode(newNode);
                    SelectionUtil.setSourceSelection(this.pageContext, newNode, 0);
                    return true;
                }
                editable = nodeData.isEditable() && !this.isBorderPosition(nodeData.getSourceNode(), SelectionUtil.getSourceSelectionRange(this.getSourceEditor()), delete);
                visibleSourceNode = nodeData.getSourceNode();
            } else {
                editable = delete == 127;
            }
        } else {
            visibleSourceNode = selectedNodeMapping.getSourceNode();
            editable = true;
        }
        if (editable) {
            int offset;
            Point range = SelectionUtil.getSourceSelectionRange(this.getSourceEditor());
            if (range.y == 0 && (offset = this.getEscOffset(visibleSourceNode, range, delete)) != 0) {
                SelectionUtil.setSourceSelection(this.pageContext, range.x, offset);
            }
            this.sourceEditor.getTextViewer().getTextWidget().invokeAction(delete);
        }
        return true;
    }

    private boolean handleZoomInEvent(nsIDOMKeyEvent keyEvent) {
        return this.zoomEventManager.zoomIn();
    }

    private boolean handleZoomOutEvent(nsIDOMKeyEvent keyEvent) {
        return this.zoomEventManager.zoomOut();
    }

    private boolean handleResetZoomView(nsIDOMKeyEvent keyEvent) {
        return this.zoomEventManager.resetZoomView();
    }

    protected boolean handleEnd(nsIDOMKeyEvent keyEvent) {
        return false;
    }

    protected boolean handleHome(nsIDOMKeyEvent keyEvent) {
        return false;
    }

    protected boolean handleDown(nsIDOMKeyEvent keyEvent) {
        return false;
    }

    protected boolean handleRight(nsIDOMKeyEvent keyEvent) {
        return false;
    }

    protected boolean handleUp(nsIDOMKeyEvent keyEvent) {
        return false;
    }

    protected boolean handleLeft(nsIDOMKeyEvent keyEvent) {
        return false;
    }

    protected boolean handleEnter(nsIDOMKeyEvent keyEvent) {
        return true;
    }

    protected boolean handleInsert(nsIDOMKeyEvent keyEvent) {
        return false;
    }

    protected boolean handlePageUp(nsIDOMKeyEvent keyEvent) {
        return false;
    }

    protected StructuredTextEditor getSourceEditor() {
        return this.sourceEditor;
    }

    protected VpeDomMapping getDomMapping() {
        return this.domMapping;
    }

    protected VpePageContext getPageContext() {
        return this.pageContext;
    }

    protected Node createAttribute(Element sourceElement, String attributeName, String value) {
        if (sourceElement != null && attributeName != null) {
            sourceElement.setAttribute(attributeName, value != null ? value : EMPTY_STRING);
            return sourceElement.getAttributeNode(attributeName);
        }
        return null;
    }

    private boolean isBorderPosition(Node node, Point selectionRange, int delete) {
        if (selectionRange.y == 0) {
            if (delete == 8) {
                return NodesManagingUtil.getStartOffsetNode((Node)node) == selectionRange.x;
            }
            if (delete == 127) {
                return NodesManagingUtil.getEndOffsetNode((Node)node) == selectionRange.x;
            }
        }
        return false;
    }

    private int getEscOffset(Node visibleNode, Point selectionRange, int delete) {
        int offset = 0;
        offset = delete == 127 ? TextUtil.checkEscToRight(NodesManagingUtil.getSourceText((Node)visibleNode), selectionRange.x - NodesManagingUtil.getStartOffsetNode((Node)visibleNode)) : TextUtil.checkEscToLeft(NodesManagingUtil.getSourceText((Node)visibleNode), selectionRange.x - NodesManagingUtil.getStartOffsetNode((Node)visibleNode));
        return offset;
    }

    public IZoomEventManager getZoomEventManager() {
        return this.zoomEventManager;
    }

    public void setZoomEventManager(IZoomEventManager zoomManager) {
        this.zoomEventManager = zoomManager;
    }
}

