/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.preferences;

import java.util.Comparator;
import net.sourceforge.pmd.Rule;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class RuleTableViewerSorter
extends ViewerSorter {
    public static final Comparator RULE_DEFAULT_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            int n = RULE_RULESET_NAME_COMPARATOR.compare(object, object2);
            if (n == 0) {
                n = RULE_NAME_COMPARATOR.compare(object, object2);
            }
            return n;
        }
    };
    public static final Comparator RULE_RULESET_NAME_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return RuleTableViewerSorter.compareStrings(((Rule)object).getRuleSetName(), ((Rule)object2).getRuleSetName());
        }
    };
    public static final Comparator RULE_NAME_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return RuleTableViewerSorter.compareStrings(((Rule)object).getName(), ((Rule)object2).getName());
        }
    };
    public static final Comparator RULE_SINCE_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return RuleTableViewerSorter.compareStrings(((Rule)object).getSince(), ((Rule)object2).getSince());
        }
    };
    public static final Comparator RULE_PRIORITY_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return ((Rule)object).getPriority() - ((Rule)object2).getPriority();
        }
    };
    public static final Comparator RULE_DESCRIPTION_COMPARATOR = new Comparator(){

        public int compare(Object object, Object object2) {
            return RuleTableViewerSorter.compareStrings(((Rule)object).getDescription(), ((Rule)object2).getDescription());
        }
    };
    private Comparator comparator;
    private boolean sortDescending = false;

    public RuleTableViewerSorter(Comparator comparator) {
        this.comparator = comparator;
    }

    public boolean isSortDescending() {
        return this.sortDescending;
    }

    public void setSortDescending(boolean bl) {
        this.sortDescending = bl;
    }

    public Comparator getComparator() {
        return this.comparator;
    }

    public void setComparator(Comparator comparator) {
        if (this.comparator != comparator) {
            this.comparator = comparator;
        } else {
            this.sortDescending = !this.sortDescending;
        }
    }

    public int compare(Viewer viewer, Object object, Object object2) {
        int n = this.comparator.compare(object, object2);
        return this.sortDescending ? 0 - n : n;
    }

    private static int compareStrings(String string, String string2) {
        String string3 = string == null ? "" : string.trim().toUpperCase();
        String string4 = string2 == null ? "" : string2.trim().toUpperCase();
        return string3.compareTo(string4);
    }
}

