/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.eclipse.ui.views;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import name.herlin.command.CommandException;
import net.sourceforge.pmd.eclipse.plugin.PMDPlugin;
import net.sourceforge.pmd.eclipse.runtime.cmd.DeleteMarkersCommand;
import net.sourceforge.pmd.eclipse.ui.model.AbstractPMDRecord;
import net.sourceforge.pmd.eclipse.ui.model.FileRecord;
import net.sourceforge.pmd.eclipse.ui.model.FileToMarkerRecord;
import net.sourceforge.pmd.eclipse.ui.model.MarkerRecord;
import net.sourceforge.pmd.eclipse.ui.model.PackageRecord;
import net.sourceforge.pmd.eclipse.ui.model.RootRecord;
import net.sourceforge.pmd.eclipse.ui.views.PriorityFilter;
import net.sourceforge.pmd.eclipse.ui.views.ProjectFilter;
import net.sourceforge.pmd.eclipse.ui.views.TableColumnSorter;
import net.sourceforge.pmd.eclipse.ui.views.ViewMemento;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOverviewContentProvider;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOverviewDoubleClickListener;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOverviewLabelProvider;
import net.sourceforge.pmd.eclipse.ui.views.ViolationOverviewMenuManager;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.ITreeViewerListener;
import org.eclipse.jface.viewers.TreeExpansionEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public class ViolationOverview
extends ViewPart
implements ISelectionProvider,
ITreeViewerListener {
    private TreeViewer treeViewer;
    private ViolationOverviewContentProvider contentProvider;
    private ViolationOverviewLabelProvider labelProvider;
    private PriorityFilter priorityFilter;
    private ProjectFilter projectFilter;
    private ViolationOverviewDoubleClickListener doubleClickListener;
    private ViolationOverviewMenuManager menuManager;
    private RootRecord root;
    private ViewMemento memento;
    protected final Integer[] columnWidths = new Integer[5];
    protected final int[] columnSortOrder = new int[]{1, -1, -1, -1, 1};
    protected int currentSortedColumn;
    private int showType;
    protected static final String PACKAGE_SWITCH = "packageSwitch";
    protected static final String PRIORITY_LIST = "priorityFilterList";
    protected static final String PROJECT_LIST = "projectFilterList";
    protected static final String COLUMN_WIDTHS = "tableColumnWidths";
    protected static final String COLUMN_SORTER = "tableColumnSorter";
    public static final int SHOW_PACKAGES_FILES_MARKERS = 1;
    public static final int SHOW_FILES_MARKERS = 2;
    public static final int SHOW_MARKERS_FILES = 3;

    public void init(IViewSite iViewSite) throws PartInitException {
        super.init(iViewSite);
        this.root = (RootRecord)this.getInitialInput();
        this.contentProvider = new ViolationOverviewContentProvider(this);
        this.labelProvider = new ViolationOverviewLabelProvider(this);
        this.priorityFilter = new PriorityFilter();
        this.projectFilter = new ProjectFilter();
        this.doubleClickListener = new ViolationOverviewDoubleClickListener(this);
        this.menuManager = new ViolationOverviewMenuManager(this);
        this.showType = 1;
        this.memento = new ViewMemento("/violationOverview_memento.xml");
        if (this.memento != null) {
            this.rememberFilterSettings();
        }
    }

    public void createPartControl(Composite composite) {
        this.treeViewer = new TreeViewer(composite, 770);
        this.treeViewer.setUseHashlookup(true);
        this.treeViewer.getTree().setHeaderVisible(true);
        this.treeViewer.getTree().setLinesVisible(true);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.addFilter((ViewerFilter)this.priorityFilter);
        this.treeViewer.addFilter((ViewerFilter)this.projectFilter);
        this.treeViewer.addTreeListener((ITreeViewerListener)this);
        this.menuManager.setupActions();
        this.createColumns(this.treeViewer.getTree());
        this.menuManager.createActionBars(this.getViewSite().getActionBars().getToolBarManager());
        this.menuManager.createDropDownMenu(this.getViewSite().getActionBars().getMenuManager());
        this.menuManager.createContextMenu();
        this.treeViewer.setInput((Object)this.root);
        this.treeViewer.addDoubleClickListener((IDoubleClickListener)this.doubleClickListener);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        if (this.memento != null) {
            this.rememberTreeSettings();
        }
    }

    public void dispose() {
        Integer[] integerArray;
        this.memento.putList(PRIORITY_LIST, this.priorityFilter.getPriorityFilterList());
        List list = this.projectFilter.getProjectFilterList();
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        while (n < list.size()) {
            integerArray = (Integer[])list.get(n);
            arrayList.add(integerArray.getName());
            ++n;
        }
        this.memento.putList(PROJECT_LIST, arrayList);
        List<Integer> list2 = Arrays.asList(this.columnWidths);
        this.memento.putList(COLUMN_WIDTHS, list2);
        integerArray = new Integer[]{new Integer(this.currentSortedColumn), new Integer(this.columnSortOrder[this.currentSortedColumn])};
        List<Integer> list3 = Arrays.asList(integerArray);
        this.memento.putList(COLUMN_SORTER, list3);
        this.memento.putInteger(PACKAGE_SWITCH, this.getShowType());
        this.memento.save("/violationOverview_memento.xml");
        super.dispose();
    }

    private Object getInitialInput() {
        return new RootRecord(ResourcesPlugin.getWorkspace().getRoot());
    }

    private void createColumns(Tree tree) {
        TreeColumn treeColumn = new TreeColumn(tree, 16384);
        treeColumn.setText(this.getString("view.overview.column_element"));
        treeColumn.setWidth(260);
        TreeColumn treeColumn2 = new TreeColumn(tree, 131072);
        treeColumn2.setText(this.getString("view.overview.column_vio_total"));
        treeColumn2.setWidth(100);
        TreeColumn treeColumn3 = new TreeColumn(tree, 131072);
        treeColumn3.setText(this.getString("view.overview.column_vio_loc"));
        treeColumn3.setWidth(100);
        TreeColumn treeColumn4 = new TreeColumn(tree, 131072);
        treeColumn4.setText(this.getString("view.overview.column_vio_method"));
        treeColumn4.setWidth(100);
        TreeColumn treeColumn5 = new TreeColumn(tree, 0x1000000);
        treeColumn5.setText(this.getString("view.overview.column_project"));
        treeColumn5.setWidth(100);
        this.createColumnAdapters(this.treeViewer.getTree());
        this.getViewerSorter(3);
    }

    private void createColumnAdapters(Tree tree) {
        TreeColumn[] treeColumnArray = tree.getColumns();
        int n = 0;
        while (n < treeColumnArray.length) {
            this.columnWidths[n] = new Integer(treeColumnArray[n].getWidth());
            treeColumnArray[n].addSelectionListener((SelectionListener)new ColumnSelectionAdapter(n));
            treeColumnArray[n].addControlListener((ControlListener)new ColumnControlAdapter(n));
            ++n;
        }
    }

    private ViewerSorter getViewerSorter(int n) {
        TreeColumn treeColumn = this.treeViewer.getTree().getColumn(n);
        int n2 = this.columnSortOrder[n];
        ViewerSorter viewerSorter = null;
        switch (n) {
            case 1: {
                viewerSorter = this.newViolationsCountSorter(treeColumn, n2);
                break;
            }
            case 2: {
                viewerSorter = this.newViolationsPerLOCSorter(treeColumn, n2);
                break;
            }
            case 3: {
                viewerSorter = this.newViolationsPerMethodsCount(treeColumn, n2);
                break;
            }
            case 4: {
                viewerSorter = this.newProjectNameSorter(treeColumn, n2);
                break;
            }
            default: {
                viewerSorter = this.newPackagesSorter(treeColumn, n2);
            }
        }
        return viewerSorter;
    }

    public int getNumberOfFilteredViolations(AbstractPMDRecord abstractPMDRecord) {
        int n = 0;
        List list = this.priorityFilter.getPriorityFilterList();
        int n2 = 0;
        while (n2 < list.size()) {
            Integer n3 = (Integer)list.get(n2);
            n += abstractPMDRecord.getNumberOfViolationsToPriority(n3, this.getShowType() == 3);
            ++n2;
        }
        return n;
    }

    public void setShowType(int n) {
        this.showType = n;
    }

    public int getShowType() {
        return this.showType;
    }

    public List getProjectFilterList() {
        return this.projectFilter.getProjectFilterList();
    }

    public List getPriorityFilterList() {
        return this.priorityFilter.getPriorityFilterList();
    }

    public void setColumnWidths() {
        if (!this.treeViewer.getTree().isDisposed()) {
            TreeColumn[] treeColumnArray = this.treeViewer.getTree().getColumns();
            int n = 0;
            while (n < this.columnWidths.length) {
                if (this.columnWidths[n] == null) {
                    this.columnWidths[n] = new Integer(75);
                }
                treeColumnArray[n].setWidth(this.columnWidths[n].intValue());
                ++n;
            }
        }
    }

    public void setSorterProperties(Integer[] integerArray) {
        if (integerArray.length > 0) {
            this.currentSortedColumn = integerArray[0];
            this.columnSortOrder[this.currentSortedColumn] = integerArray[1];
            this.treeViewer.setSorter(this.getViewerSorter(this.currentSortedColumn));
        }
    }

    public void setFocus() {
        this.treeViewer.getTree().setFocus();
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    public AbstractPMDRecord[] getAllProjects() {
        AbstractPMDRecord[] abstractPMDRecordArray = AbstractPMDRecord.EMPTY_RECORDS;
        if (this.root != null) {
            abstractPMDRecordArray = this.root.getChildren();
        }
        return abstractPMDRecordArray;
    }

    public void refresh() {
        if (!this.treeViewer.getControl().isDisposed()) {
            this.treeViewer.refresh();
            this.refreshMenu();
        }
    }

    public void refreshMenu() {
        this.menuManager.createDropDownMenu(this.getViewSite().getActionBars().getMenuManager());
        this.menuManager.createContextMenu();
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.treeViewer.addSelectionChangedListener(iSelectionChangedListener);
    }

    public ISelection getSelection() {
        return this.treeViewer.getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.treeViewer.removeSelectionChangedListener(iSelectionChangedListener);
    }

    public void setSelection(ISelection iSelection) {
        this.treeViewer.setSelection(iSelection);
    }

    private String getString(String string) {
        return PMDPlugin.getDefault().getStringTable().getString(string);
    }

    private void rememberFilterSettings() {
        Serializable serializable;
        List list;
        List list2 = this.memento.getIntegerList(PRIORITY_LIST);
        if (!list2.isEmpty()) {
            this.priorityFilter.setPriorityFilterList(list2);
        }
        if (!(list = this.memento.getStringList(PROJECT_LIST)).isEmpty()) {
            serializable = new ArrayList();
            int n = 0;
            while (n < list.size()) {
                AbstractPMDRecord abstractPMDRecord = this.root.findResourceByName(list.get(n).toString(), 4);
                if (abstractPMDRecord != null) {
                    serializable.add(abstractPMDRecord);
                }
                ++n;
            }
            this.projectFilter.setProjectFilterList((List)((Object)serializable));
        }
        if ((serializable = this.memento.getInteger(PACKAGE_SWITCH)) != null) {
            this.setShowType((Integer)serializable);
        }
    }

    private void rememberTreeSettings() {
        List list;
        List list2 = this.memento.getIntegerList(COLUMN_WIDTHS);
        if (!list2.isEmpty()) {
            list2.toArray(this.columnWidths);
            this.setColumnWidths();
        }
        if (!(list = this.memento.getIntegerList(COLUMN_SORTER)).isEmpty()) {
            Integer[] integerArray = new Integer[list.size()];
            list.toArray(integerArray);
            this.setSorterProperties(integerArray);
        }
    }

    private ViewerSorter newPackagesSorter(TreeColumn treeColumn, final int n) {
        return new TableColumnSorter(treeColumn, n){

            public int compare(Viewer viewer, Object object, Object object2) {
                String string = "";
                String string2 = "";
                if (object instanceof PackageRecord && object2 instanceof PackageRecord) {
                    string = ((PackageRecord)object).getName();
                    string2 = ((PackageRecord)object2).getName();
                } else if (object instanceof FileRecord && object2 instanceof FileRecord) {
                    string = ((FileRecord)object).getName();
                    string2 = ((FileRecord)object2).getName();
                }
                return string.compareToIgnoreCase(string2) * n;
            }
        };
    }

    private ViewerSorter newViolationsCountSorter(TreeColumn treeColumn, final int n) {
        return new TableColumnSorter(treeColumn, n){

            public int compare(Viewer viewer, Object object, Object object2) {
                int n3 = 0;
                int n2 = 0;
                if (object instanceof PackageRecord && object2 instanceof PackageRecord || object instanceof FileRecord && object2 instanceof FileRecord || object instanceof MarkerRecord && object2 instanceof MarkerRecord || object instanceof FileToMarkerRecord && object2 instanceof FileToMarkerRecord) {
                    n3 = ViolationOverview.this.getNumberOfFilteredViolations((AbstractPMDRecord)object);
                    n2 = ViolationOverview.this.getNumberOfFilteredViolations((AbstractPMDRecord)object2);
                }
                return new Integer(n3).compareTo(new Integer(n2)) * n;
            }
        };
    }

    private ViewerSorter newViolationsPerLOCSorter(TreeColumn treeColumn, final int n) {
        return new TableColumnSorter(treeColumn, n){

            public int compare(Viewer viewer, Object object, Object object2) {
                Float f = new Float(0.0f);
                Float f2 = new Float(0.0f);
                if (object instanceof PackageRecord && object2 instanceof PackageRecord || object instanceof FileRecord && object2 instanceof FileRecord || object instanceof MarkerRecord && object2 instanceof MarkerRecord || object instanceof FileToMarkerRecord && object2 instanceof FileToMarkerRecord) {
                    int n5 = ViolationOverview.this.getNumberOfFilteredViolations((AbstractPMDRecord)object);
                    int n2 = ViolationOverview.this.getNumberOfFilteredViolations((AbstractPMDRecord)object2);
                    int n3 = ViolationOverview.this.getLOC((AbstractPMDRecord)object);
                    int n4 = ViolationOverview.this.getLOC((AbstractPMDRecord)object2);
                    if (n3 > 0) {
                        f = new Float((float)n5 / (float)n3);
                    }
                    if (n4 > 0) {
                        f2 = new Float((float)n2 / (float)n4);
                    }
                }
                return f.compareTo(f2) * n;
            }
        };
    }

    private ViewerSorter newViolationsPerMethodsCount(TreeColumn treeColumn, final int n) {
        return new TableColumnSorter(treeColumn, n){

            public int compare(Viewer viewer, Object object, Object object2) {
                Float f = new Float(0.0f);
                Float f2 = new Float(0.0f);
                if (object instanceof PackageRecord && object2 instanceof PackageRecord || object instanceof FileRecord && object2 instanceof FileRecord || object instanceof MarkerRecord && object2 instanceof MarkerRecord || object instanceof FileToMarkerRecord && object2 instanceof FileToMarkerRecord) {
                    int n5 = ViolationOverview.this.getNumberOfFilteredViolations((AbstractPMDRecord)object);
                    int n2 = ViolationOverview.this.getNumberOfFilteredViolations((AbstractPMDRecord)object2);
                    int n3 = ViolationOverview.this.getNumberOfMethods((AbstractPMDRecord)object);
                    int n4 = ViolationOverview.this.getNumberOfMethods((AbstractPMDRecord)object2);
                    if (n3 > 0) {
                        f = new Float((float)n5 / (float)n3);
                    }
                    if (n4 > 0) {
                        f2 = new Float((float)n2 / (float)n4);
                    }
                }
                return f.compareTo(f2) * n;
            }
        };
    }

    private ViewerSorter newProjectNameSorter(TreeColumn treeColumn, final int n) {
        return new TableColumnSorter(treeColumn, n){

            public int compare(Viewer viewer, Object object, Object object2) {
                AbstractPMDRecord abstractPMDRecord = null;
                AbstractPMDRecord abstractPMDRecord2 = null;
                int n2 = 0;
                if (object instanceof PackageRecord && object2 instanceof PackageRecord) {
                    abstractPMDRecord = ((PackageRecord)object).getParent();
                    abstractPMDRecord2 = ((PackageRecord)object2).getParent();
                    n2 = abstractPMDRecord.getName().compareToIgnoreCase(abstractPMDRecord2.getName()) * n;
                }
                return n2;
            }
        };
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        Object object = treeExpansionEvent.getElement();
        if (object instanceof PackageRecord) {
            PackageRecord packageRecord = (PackageRecord)object;
            AbstractPMDRecord[] abstractPMDRecordArray = packageRecord.getChildren();
            int n = 0;
            while (n < abstractPMDRecordArray.length) {
                if (abstractPMDRecordArray[n] instanceof FileRecord) {
                    FileRecord fileRecord = (FileRecord)abstractPMDRecordArray[n];
                    fileRecord.calculateLinesOfCode();
                    fileRecord.calculateNumberOfMethods();
                }
                ++n;
            }
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ViolationOverview.this.getViewer().refresh();
            }
        });
    }

    public void deleteMarkers(AbstractPMDRecord abstractPMDRecord) throws CoreException {
        if (abstractPMDRecord instanceof MarkerRecord) {
            MarkerRecord markerRecord = (MarkerRecord)abstractPMDRecord;
            IMarker[] iMarkerArray = new IMarker[]{};
            switch (this.getShowType()) {
                case 1: 
                case 2: {
                    iMarkerArray = markerRecord.findMarkers();
                    break;
                }
                case 3: {
                    AbstractPMDRecord abstractPMDRecord2 = markerRecord.getParent().getParent();
                    iMarkerArray = abstractPMDRecord2.findMarkersByAttribute("rulename", markerRecord.getName());
                }
            }
            this.deleteMarkers(iMarkerArray);
        } else if (abstractPMDRecord instanceof FileToMarkerRecord) {
            FileToMarkerRecord fileToMarkerRecord = (FileToMarkerRecord)abstractPMDRecord;
            IMarker[] iMarkerArray = new IMarker[]{};
            iMarkerArray = fileToMarkerRecord.findMarkers();
            this.deleteMarkers(iMarkerArray);
        } else if (abstractPMDRecord instanceof AbstractPMDRecord) {
            AbstractPMDRecord abstractPMDRecord3 = abstractPMDRecord;
            abstractPMDRecord3.getResource().deleteMarkers("net.sourceforge.pmd.eclipse.plugin.pmdMarker", true, 2);
        }
    }

    private void deleteMarkers(IMarker[] iMarkerArray) {
        if (iMarkerArray.length > 0) {
            DeleteMarkersCommand deleteMarkersCommand = new DeleteMarkersCommand();
            deleteMarkersCommand.setMarkers(iMarkerArray);
            try {
                deleteMarkersCommand.performExecute();
            }
            catch (CommandException commandException) {
                PMDPlugin.getDefault().showError(this.getString("message.error.core_exception"), commandException.getCause());
            }
        }
    }

    public int getLOC(AbstractPMDRecord abstractPMDRecord) {
        int n = 0;
        n = abstractPMDRecord instanceof MarkerRecord && this.getShowType() == 3 ? abstractPMDRecord.getParent().getParent().getLOC() : abstractPMDRecord.getLOC();
        return n;
    }

    public int getNumberOfMethods(AbstractPMDRecord abstractPMDRecord) {
        int n = 0;
        n = abstractPMDRecord instanceof MarkerRecord && this.getShowType() == 3 ? abstractPMDRecord.getParent().getParent().getNumberOfMethods() : abstractPMDRecord.getNumberOfMethods();
        return n;
    }

    private class ColumnControlAdapter
    extends ControlAdapter {
        private final int column;

        public ColumnControlAdapter(int n) {
            this.column = n;
        }

        public void controlResized(ControlEvent controlEvent) {
            ViolationOverview.this.columnWidths[this.column] = new Integer(ViolationOverview.this.treeViewer.getTree().getColumn(this.column).getWidth());
        }
    }

    private class ColumnSelectionAdapter
    extends SelectionAdapter {
        private final int column;

        public ColumnSelectionAdapter(int n) {
            this.column = n;
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            int n = this.column;
            ViolationOverview.this.columnSortOrder[n] = ViolationOverview.this.columnSortOrder[n] * -1;
            ViolationOverview.this.treeViewer.setSorter(ViolationOverview.this.getViewerSorter(this.column));
        }
    }
}

