/*******************************************************************************
 * Copyright (c) 2007-2012 Red Hat, Inc.
 * Distributed under license by Red Hat, Inc. All rights reserved.
 * This program is made available under the terms of the
 * Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Red Hat, Inc. - initial API and implementation
 ******************************************************************************/ 

package com.jboss.jbds.product;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchCommandConstants;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

public class Activator extends AbstractUIPlugin {
	public static final String PLUGIN_ID = "com.jboss.jbds.product"; //$NON-NLS-1$
	static Activator INSTANCE;

	public Activator() {
		INSTANCE = this;
	}

	public static Activator getDefault() {
		if(INSTANCE == null) {
			Platform.getBundle(PLUGIN_ID);
		}
		return INSTANCE;
	}

	public static void logError(String pluginId, Throwable t) {
		try {
			IStatus status = new Status(IStatus.INFO, pluginId,
					0, t.getMessage() , t);
			Bundle bundle = Platform.getBundle(pluginId);
			Platform.getLog(bundle).log(status);
		} catch (Throwable x) {
			// Ignore
		}
	}
	
	public static void logError(String pluginId, String error) {
		try {
			IStatus status = new Status(IStatus.INFO, pluginId,
					0, error , null);
			Bundle bundle = Platform.getBundle(pluginId);
			Platform.getLog(bundle).log(status);
		} catch (Throwable x) {
			// Ignore
		}
	}

	/*
	 * This is a workaround for JBDS-1923's UpStream issue. 
	 * See: https://bugs.eclipse.org/bugs/show_bug.cgi?id=370119
	 * 
	 * TODO: Remove this workaround method after 
	 * 	https://bugs.eclipse.org/bugs/show_bug.cgi?id=370119 is fixed!!!
	 */
	@Override
	protected void refreshPluginActions() {
		super.refreshPluginActions();
		
        // If the workbench is not started yet, or is no longer running, do nothing.
        if (!PlatformUI.isWorkbenchRunning()) {
			return;
		}
        
        Display.getDefault().asyncExec(new Runnable() {
            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window instanceof WorkbenchWindow) {
                	final WorkbenchWindow ww = (WorkbenchWindow)window;
	                if (window.getWorkbench().getIntroManager().hasIntro()) {
	                	// Remove action handler for IWorkbenchCommandConstants.HELP_WELCOME command
	                	Map globalActionHandlersByCommandId = null;
                		try {
                			Field f = WorkbenchWindow.class.getDeclaredField("globalActionHandlersByCommandId"); //$NON-NLS-1$
                			f.setAccessible(true);
                			Object value = f.get(ww);
                			if (value instanceof Map) {
                				globalActionHandlersByCommandId = (Map)value;
                			}
                		} catch (Exception e) {
                			logError(PLUGIN_ID, e);
                		}
	                	
	                	if (globalActionHandlersByCommandId != null) {
	                		Object handlerObject = globalActionHandlersByCommandId.get(IWorkbenchCommandConstants.HELP_WELCOME);
	                		if (handlerObject != null) {
	                			globalActionHandlersByCommandId.remove(IWorkbenchCommandConstants.HELP_WELCOME);
	                		}
	                	}
	                	// Call submitGlobalActions() due to apply changes in globalActionHandlersByCommandId map
                		try {
                			Method m = WorkbenchWindow.class.getDeclaredMethod("submitGlobalActions"); //$NON-NLS-1$
                			m.setAccessible(true);
                			m.invoke(ww);
                		} catch (Exception e) {
                			logError(PLUGIN_ID, e);
                		}
	                }
                }
            }
        });
	}
}
