/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.solder.exception.filter;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import org.jboss.solder.exception.control.ExceptionStack;
import org.jboss.solder.exception.control.ExceptionStackItem;
import org.jboss.solder.exception.filter.StackFrame;
import org.jboss.solder.exception.filter.StackFrameFilter;
import org.jboss.solder.exception.filter.StackFrameImpl;

public class ExceptionStackOutput<T extends Throwable> {
    private final Deque<ExceptionStackItem> exceptionStackItems;
    private final StackFrameFilter<T> filter;
    public static final String ROOT_CAUSE_TEXT = "Root exception {0}" + System.getProperty("line.separator");
    public static final String AT_TEXT = "\t at {0}" + System.getProperty("line.separator");
    public static final String WRAPPED_BY_TEXT = "Wrapped within {0} and re-thrown" + System.getProperty("line.separator");

    public ExceptionStackOutput(T exception) {
        this(exception, null);
    }

    public ExceptionStackOutput(T exception, StackFrameFilter<T> filter) {
        this.exceptionStackItems = new ExceptionStack(exception).getOrigExceptionStackItems();
        this.filter = filter;
    }

    public String printTrace() {
        StringBuilder traceBuffer = new StringBuilder();
        int exceptionStackItemsSize = this.exceptionStackItems.size();
        block5: for (int i = 0; i < exceptionStackItemsSize; ++i) {
            ExceptionStackItem item = this.exceptionStackItems.removeFirst();
            ExceptionStackItem nextItem = this.exceptionStackItems.peekFirst();
            if (i == 0) {
                traceBuffer.append(MessageFormat.format(ROOT_CAUSE_TEXT, item.getThrowable()));
            } else {
                traceBuffer.append(MessageFormat.format(WRAPPED_BY_TEXT, item.getThrowable()));
            }
            Collection<StackFrame> stackFrames = nextItem != null ? this.buildCollectionUpToNextWrapper(item.getThrowable(), nextItem.getThrowable()) : this.createStackFrameCollectionFrom(item.getThrowable());
            block6: for (StackFrame stackFrame : stackFrames) {
                if (this.filter != null) {
                    switch (this.filter.process(stackFrame)) {
                        case TERMINATE_AFTER: {
                            traceBuffer.append(MessageFormat.format(AT_TEXT, stackFrame.getStackTraceElement()));
                        }
                        case TERMINATE: 
                        case DROP_REMAINING: {
                            continue block5;
                        }
                        case DROP: {
                            continue block6;
                        }
                        default: {
                            traceBuffer.append(MessageFormat.format(AT_TEXT, stackFrame.getStackTraceElement()));
                            break;
                        }
                    }
                    continue;
                }
                traceBuffer.append(MessageFormat.format(AT_TEXT, stackFrame.getStackTraceElement()));
            }
        }
        return traceBuffer.toString();
    }

    private Collection<StackFrame> createStackFrameCollectionFrom(Throwable throwable) {
        ArrayList<StackFrame> frameList = new ArrayList<StackFrame>(throwable.getStackTrace().length);
        for (int i = 0; i < throwable.getStackTrace().length; ++i) {
            if (i == 0) {
                frameList.add(new StackFrameImpl(throwable));
                continue;
            }
            frameList.add(new StackFrameImpl((StackFrameImpl)frameList.get(i - 1), throwable.getStackTrace()[i], i));
        }
        return frameList;
    }

    private Collection<StackFrame> buildCollectionUpToNextWrapper(Throwable t1, Throwable t2) {
        ArrayList<StackFrame> returningCollection = new ArrayList<StackFrame>();
        StackTraceElement[] t1StackTraceElements = t1.getStackTrace();
        StackTraceElement[] t2StackTraceElements = t2.getStackTrace();
        for (int i = 0; i < t1StackTraceElements.length; ++i) {
            StackFrameImpl previousFrame;
            StackFrameImpl newFrame;
            if (i == 0) {
                previousFrame = newFrame = new StackFrameImpl(t1);
                if (!returningCollection.contains(newFrame)) {
                    returningCollection.add(newFrame);
                }
            } else {
                previousFrame = newFrame = new StackFrameImpl((StackFrameImpl)returningCollection.get(i - 1), t1StackTraceElements[i + 1], i);
                if (!returningCollection.contains(newFrame)) {
                    returningCollection.add(newFrame);
                }
            }
            for (StackTraceElement t2StackTraceElement : t2StackTraceElements) {
                if (!t1StackTraceElements[i].equals(t2StackTraceElement)) continue;
                returningCollection.remove(previousFrame);
                return returningCollection;
            }
        }
        return returningCollection;
    }
}

