/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.forge.shell.project.resources;

import java.util.HashMap;
import java.util.Map;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AnnotatedConstructor;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.jboss.forge.resources.Resource;
import org.jboss.forge.shell.plugins.Current;
import org.jboss.solder.reflection.annotated.AnnotatedTypeBuilder;

public class ResourceProducerExtension
implements Extension {
    private final Map<Class<?>, AnnotatedType<?>> typeOverrides = new HashMap();

    public <T> void processAnnotatedType(final @Observes ProcessAnnotatedType<T> event) {
        class BuilderHolder {
            private AnnotatedTypeBuilder<T> builder;

            BuilderHolder() {
            }

            public AnnotatedTypeBuilder<T> getBuilder() {
                if (this.builder == null) {
                    this.builder = new AnnotatedTypeBuilder();
                    this.builder.readFromType(event.getAnnotatedType());
                }
                return this.builder;
            }
        }
        BuilderHolder builderHolder = new BuilderHolder();
        boolean modifiedType = false;
        for (AnnotatedConstructor c : event.getAnnotatedType().getConstructors()) {
            if (!c.isAnnotationPresent(Current.class)) continue;
            for (AnnotatedParameter p : c.getParameters()) {
                if (!p.getTypeClosure().contains(Resource.class)) continue;
                builderHolder.getBuilder().overrideConstructorParameterType(c.getJavaMember(), p.getPosition(), Resource.class);
                modifiedType = true;
            }
        }
        for (AnnotatedField f : event.getAnnotatedType().getFields()) {
            if (!f.isAnnotationPresent(Current.class)) continue;
            builderHolder.getBuilder().overrideFieldType(f.getJavaMember(), Resource.class);
            modifiedType = true;
        }
        if (modifiedType) {
            AnnotatedType replacement = builderHolder.getBuilder().create();
            this.typeOverrides.put(replacement.getJavaClass(), replacement);
            event.setAnnotatedType(replacement);
        }
    }
}

