/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.eclipse.codegen;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.undo.CreateFileOperation;
import org.eclipse.ui.ide.undo.WorkspaceUndoUtil;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.hibernate.console.ConsoleConfiguration;
import org.hibernate.console.KnownConfigurations;
import org.hibernate.console.preferences.ConsoleConfigurationPreferences;
import org.hibernate.eclipse.console.HibernateConsoleMessages;
import org.hibernate.eclipse.console.utils.LaunchHelper;
import org.hibernate.eclipse.launch.CodeGenXMLFactory;
import org.hibernate.eclipse.launch.ExporterAttributes;

public class ExportAntCodeGenWizardPage
extends WizardNewFileCreationPage
implements Listener {
    protected ComboDialogField consoleConfigurationName;
    protected CodeGenXMLFactory codeGenXMLFactory = null;

    public ExportAntCodeGenWizardPage(String pageName, IStructuredSelection selection) {
        super(pageName, selection);
        this.setPageComplete(false);
    }

    protected void setControl(Control newControl) {
        newControl.setLayoutData((Object)new GridData(784));
        super.setControl(newControl);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite topLevel = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginWidth = 0;
        topLevel.setLayout((Layout)layout);
        topLevel.setLayoutData((Object)new GridData(784));
        topLevel.setFont(parent.getFont());
        this.setControlCombo((Control)topLevel);
        super.createControl(topLevel);
        this.setControl((Control)topLevel);
    }

    protected void setControlCombo(Control newControl) {
        ILaunchConfiguration[] launchCfgs;
        this.consoleConfigurationName = new ComboDialogField(8);
        this.consoleConfigurationName.setLabelText(HibernateConsoleMessages.ExportAntCodeGenWizardPage_hibernate_code_generation_configurations);
        try {
            launchCfgs = LaunchHelper.findFilteredCodeGenerationConfigsSorted();
        }
        catch (CoreException coreException) {
            launchCfgs = new ILaunchConfiguration[]{};
        }
        String[] names = new String[launchCfgs.length];
        int i = 0;
        while (i < launchCfgs.length) {
            ILaunchConfiguration launchCfg = launchCfgs[i];
            names[i] = launchCfg.getName();
            ++i;
        }
        this.consoleConfigurationName.setItems(names);
        IDialogFieldListener fieldlistener = new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                ExportAntCodeGenWizardPage.this.setPageComplete(ExportAntCodeGenWizardPage.this.validatePage());
            }
        };
        this.consoleConfigurationName.setDialogFieldListener(fieldlistener);
        this.consoleConfigurationName.doFillIntoGrid((Composite)newControl, 2);
    }

    protected boolean validatePage() {
        boolean res = super.validatePage();
        if (res) {
            if (this.consoleConfigurationName.getSelectionIndex() == -1) {
                this.setErrorMessage(HibernateConsoleMessages.ExportAntCodeGenWizardPage_empty_hibernate_code_generation_configuration);
                res = false;
            } else {
                ILaunchConfiguration lc = this.getSelectedLaunchConfig();
                if (lc == null) {
                    this.setErrorMessage(HibernateConsoleMessages.ExportAntCodeGenWizardPage_cannot_find_selected_hibernate_code_generation_configuration);
                    res = false;
                } else {
                    String checkMessage = this.checkCodeGenLaunchConfig(lc);
                    if (checkMessage != null) {
                        this.setMessage(checkMessage, 2);
                    }
                }
            }
        }
        return res;
    }

    protected ConsoleConfigurationPreferences getConsoleConfigPreferences(String consoleConfigName) {
        ConsoleConfiguration consoleConfig = KnownConfigurations.getInstance().find(consoleConfigName);
        if (consoleConfig == null) {
            return null;
        }
        return consoleConfig.getPreferences();
    }

    protected String checkCodeGenLaunchConfig(ILaunchConfiguration lc) {
        String checkMessage = null;
        ExporterAttributes attributes = null;
        try {
            attributes = new ExporterAttributes(lc);
            checkMessage = attributes.checkExporterAttributes();
        }
        catch (CoreException e) {
            checkMessage = e.getMessage();
        }
        if (checkMessage != null) {
            checkMessage = NLS.bind((String)HibernateConsoleMessages.ExportAntCodeGenWizardPage_error_in_hibernate_code_generation_configuration, (Object)checkMessage);
        }
        if (checkMessage == null && attributes != null) {
            String connProfileName;
            String consoleConfigName = attributes.getConsoleConfigurationName();
            ConsoleConfigurationPreferences consoleConfigPrefs = this.getConsoleConfigPreferences(consoleConfigName);
            String string = connProfileName = consoleConfigPrefs == null ? null : consoleConfigPrefs.getConnectionProfileName();
            if (!CodeGenXMLFactory.isEmpty(connProfileName)) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                String externalPropFileName = "hibernate.properties";
                externalPropFileName = String.valueOf(this.getFileName()) + "." + externalPropFileName;
                String problemMessage = NLS.bind((String)HibernateConsoleMessages.ExportAntCodeGenWizardPage_warning, (Object)externalPropFileName);
                IPath resourcePath = this.getContainerFullPath().append(externalPropFileName);
                if (workspace.getRoot().getFile(resourcePath).exists()) {
                    checkMessage = problemMessage;
                }
            }
        }
        return checkMessage;
    }

    public ILaunchConfiguration getSelectedLaunchConfig() {
        ILaunchConfiguration[] launchCfgs;
        try {
            launchCfgs = LaunchHelper.findFilteredCodeGenerationConfigsSorted();
        }
        catch (CoreException coreException) {
            launchCfgs = new ILaunchConfiguration[]{};
        }
        int n = this.consoleConfigurationName.getSelectionIndex();
        if (n >= 0 && n < launchCfgs.length) {
            return launchCfgs[n];
        }
        return null;
    }

    protected InputStream getInitialContents() {
        ILaunchConfiguration lc = this.getSelectedLaunchConfig();
        if (lc == null) {
            return null;
        }
        this.codeGenXMLFactory = new CodeGenXMLFactory(lc);
        String externalPropFileName = CodeGenXMLFactory.getExternalPropFileNameStandard(this.getFileName());
        this.codeGenXMLFactory.setExternalPropFileName(externalPropFileName);
        this.codeGenXMLFactory.setPlace2Generate(this.getContainerFullPath().toString());
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        if (workspace != null && workspace.getRoot() != null && workspace.getRoot().getLocation() != null) {
            this.codeGenXMLFactory.setWorkspacePath(workspace.getRoot().getLocation().toString());
        }
        String buildXml = this.codeGenXMLFactory.createCodeGenXML();
        return new ByteArrayInputStream(buildXml.getBytes());
    }

    public IFile createNewFile() {
        String propFileContentPreSave;
        this.codeGenXMLFactory = null;
        IFile res = super.createNewFile();
        if (this.codeGenXMLFactory != null && res != null && !CodeGenXMLFactory.isEmpty(propFileContentPreSave = this.codeGenXMLFactory.getPropFileContentPreSave())) {
            IPath path = res.getFullPath();
            path = path.removeLastSegments(1);
            path = path.append(this.codeGenXMLFactory.getExternalPropFileName());
            final IFile newFileHandle = this.createFileHandle(path);
            final ByteArrayInputStream initialContents = new ByteArrayInputStream(propFileContentPreSave.getBytes());
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    CreateFileOperation op = new CreateFileOperation(newFileHandle, null, initialContents, IDEWorkbenchMessages.WizardNewFileCreationPage_title);
                    try {
                        op.execute(monitor, WorkspaceUndoUtil.getUIInfoAdapter((Shell)ExportAntCodeGenWizardPage.this.getShell()));
                    }
                    catch (ExecutionException e) {
                        ExportAntCodeGenWizardPage.this.getContainer().getShell().getDisplay().syncExec(new Runnable(){

                            @Override
                            public void run() {
                                if (e.getCause() instanceof CoreException) {
                                    ErrorDialog.openError((Shell)ExportAntCodeGenWizardPage.this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFileCreationPage_errorTitle, null, (IStatus)((CoreException)e.getCause()).getStatus());
                                } else {
                                    IDEWorkbenchPlugin.log(this.getClass(), (String)"createNewFile()", (Throwable)e.getCause());
                                    MessageDialog.openError((Shell)ExportAntCodeGenWizardPage.this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorMessage, (Object)e.getCause().getMessage()));
                                }
                            }
                        });
                    }
                }
            };
            try {
                this.getContainer().run(true, true, op);
            }
            catch (InterruptedException interruptedException) {
            }
            catch (InvocationTargetException e) {
                IDEWorkbenchPlugin.log(((Object)((Object)this)).getClass(), (String)"createNewFile()", (Throwable)e.getTargetException());
                MessageDialog.open((int)1, (Shell)this.getContainer().getShell(), (String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorTitle, (String)NLS.bind((String)IDEWorkbenchMessages.WizardNewFileCreationPage_internalErrorMessage, (Object)e.getTargetException().getMessage()), (int)0x10000000);
            }
        }
        return res;
    }
}

