/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.vpe.editor;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.bindings.TriggerSequence;
import org.eclipse.jface.bindings.keys.KeySequence;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.custom.LineStyleEvent;
import org.eclipse.swt.custom.LineStyleListener;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.keys.WorkbenchKeyboard;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.sse.core.internal.model.ModelLifecycleEvent;
import org.eclipse.wst.sse.core.internal.provisional.IModelLifecycleListener;
import org.eclipse.wst.sse.core.internal.provisional.INodeAdapter;
import org.eclipse.wst.sse.core.internal.provisional.INodeNotifier;
import org.eclipse.wst.sse.core.internal.provisional.IStructuredModel;
import org.eclipse.wst.sse.core.internal.provisional.IndexedRegion;
import org.eclipse.wst.sse.ui.StructuredTextEditor;
import org.eclipse.wst.sse.ui.internal.view.events.INodeSelectionListener;
import org.eclipse.wst.sse.ui.internal.view.events.ITextSelectionListener;
import org.eclipse.wst.sse.ui.internal.view.events.NodeSelectionChangedEvent;
import org.eclipse.wst.sse.ui.internal.view.events.TextSelectionChangedEvent;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMDocument;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMModel;
import org.jboss.tools.common.el.core.ELReferenceList;
import org.jboss.tools.common.model.XModel;
import org.jboss.tools.common.model.XModelObject;
import org.jboss.tools.common.model.event.XModelTreeEvent;
import org.jboss.tools.common.model.event.XModelTreeListener;
import org.jboss.tools.common.model.project.IModelNature;
import org.jboss.tools.common.model.ui.util.ModelUtilities;
import org.jboss.tools.common.model.util.EclipseResourceUtil;
import org.jboss.tools.common.model.util.XModelTreeListenerSWTSync;
import org.jboss.tools.common.resref.core.ResourceReferenceListListener;
import org.jboss.tools.common.util.SwtUtil;
import org.jboss.tools.jst.jsp.JspEditorPlugin;
import org.jboss.tools.jst.jsp.bundle.BundleMap;
import org.jboss.tools.jst.jsp.editor.IJSPTextEditor;
import org.jboss.tools.jst.jsp.editor.IVisualController;
import org.jboss.tools.jst.jsp.jspeditor.dnd.JSPPaletteInsertHelper;
import org.jboss.tools.jst.jsp.preferences.VpePreference;
import org.jboss.tools.jst.jsp.selection.SelectionHelper;
import org.jboss.tools.jst.web.model.helpers.WebAppHelper;
import org.jboss.tools.jst.web.project.WebProject;
import org.jboss.tools.vpe.VpeDebug;
import org.jboss.tools.vpe.VpePlugin;
import org.jboss.tools.vpe.dnd.VpeDnD;
import org.jboss.tools.vpe.editor.IVpeUpdateListener;
import org.jboss.tools.vpe.editor.VpeDisposeException;
import org.jboss.tools.vpe.editor.VpeDropWindow;
import org.jboss.tools.vpe.editor.VpeEditorPart;
import org.jboss.tools.vpe.editor.VpeEventBean;
import org.jboss.tools.vpe.editor.VpeSourceDomBuilder;
import org.jboss.tools.vpe.editor.VpeVisualDomBuilder;
import org.jboss.tools.vpe.editor.context.VpePageContext;
import org.jboss.tools.vpe.editor.mapping.VpeDomMapping;
import org.jboss.tools.vpe.editor.mapping.VpeNodeMapping;
import org.jboss.tools.vpe.editor.menu.VpeMenuCreator;
import org.jboss.tools.vpe.editor.mozilla.MozillaEditor;
import org.jboss.tools.vpe.editor.mozilla.MozillaEventAdapter;
import org.jboss.tools.vpe.editor.mozilla.listener.MozillaAfterPaintListener;
import org.jboss.tools.vpe.editor.mozilla.listener.MozillaContextMenuListener;
import org.jboss.tools.vpe.editor.mozilla.listener.MozillaKeyListener;
import org.jboss.tools.vpe.editor.mozilla.listener.MozillaMouseListener;
import org.jboss.tools.vpe.editor.mozilla.listener.MozillaResizeListener;
import org.jboss.tools.vpe.editor.mozilla.listener.MozillaScrollListener;
import org.jboss.tools.vpe.editor.mozilla.listener.MozillaSelectionListener;
import org.jboss.tools.vpe.editor.mozilla.listener.MozillaTooltipListener;
import org.jboss.tools.vpe.editor.scrolling.ScrollCoordinator;
import org.jboss.tools.vpe.editor.selection.VpeSelectionController;
import org.jboss.tools.vpe.editor.template.IKeyEventHandler;
import org.jboss.tools.vpe.editor.template.ISelectionManager;
import org.jboss.tools.vpe.editor.template.IZoomEventManager;
import org.jboss.tools.vpe.editor.template.KeyEventManager;
import org.jboss.tools.vpe.editor.template.SelectionManager;
import org.jboss.tools.vpe.editor.template.VpeIncludeList;
import org.jboss.tools.vpe.editor.template.VpeTemplateListener;
import org.jboss.tools.vpe.editor.template.VpeTemplateManager;
import org.jboss.tools.vpe.editor.template.ZoomEventManager;
import org.jboss.tools.vpe.editor.toolbar.format.FormatControllerManager;
import org.jboss.tools.vpe.editor.util.DocTypeUtil;
import org.jboss.tools.vpe.editor.util.SelectionUtil;
import org.jboss.tools.vpe.editor.util.VisualDomUtil;
import org.jboss.tools.vpe.editor.util.VpeDebugUtil;
import org.jboss.tools.vpe.messages.VpeUIMessages;
import org.jboss.tools.vpe.resref.core.AbsoluteFolderReferenceList;
import org.jboss.tools.vpe.resref.core.CSSReferenceList;
import org.jboss.tools.vpe.resref.core.RelativeFolderReferenceList;
import org.jboss.tools.vpe.resref.core.TaglibReferenceList;
import org.jboss.tools.vpe.xulrunner.editor.IVpeSelectionListener;
import org.jboss.tools.vpe.xulrunner.editor.XulRunnerEditor;
import org.jboss.tools.vpe.xulrunner.util.XPCOM;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMEvent;
import org.mozilla.interfaces.nsIDOMKeyEvent;
import org.mozilla.interfaces.nsIDOMMouseEvent;
import org.mozilla.interfaces.nsIDOMMutationEvent;
import org.mozilla.interfaces.nsIDOMNSUIEvent;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMWindow;
import org.mozilla.interfaces.nsIDOMWindowInternal;
import org.mozilla.interfaces.nsISelection;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIWebBrowser;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class VpeController
implements INodeAdapter,
IModelLifecycleListener,
INodeSelectionListener,
ITextSelectionListener,
SelectionListener,
VpeTemplateListener,
XModelTreeListener,
ResourceReferenceListListener,
ISelectionChangedListener,
IVisualController,
MozillaMouseListener,
MozillaKeyListener,
MozillaTooltipListener,
MozillaSelectionListener,
MozillaContextMenuListener,
MozillaResizeListener,
MozillaAfterPaintListener,
MozillaScrollListener {
    private ScrollCoordinator scrollCoordinator;
    private SelectionListener sourceScrollSelectionListener;
    private ScrollBar sourceEditorVerticalScrollBar;
    private boolean sourceScrollEventFlag = false;
    private boolean visualScrollEventFlag = false;
    boolean visualSelectionIsAlreadyInProgress = false;
    public static final int DEFAULT_UPDATE_DELAY_TIME = 400;
    private boolean visualEditorVisible = true;
    private boolean synced = true;
    StructuredTextEditor sourceEditor;
    private MozillaEditor visualEditor;
    XulRunnerEditor xulRunnerEditor;
    private VpeSelectionController visualSelectionController;
    VpeDomMapping domMapping;
    private VpeSourceDomBuilder sourceBuilder;
    private VpeVisualDomBuilder visualBuilder;
    private VpeDnD vpeDnD;
    private Attr lastRemovedAttr;
    private String lastRemovedAttrName;
    private boolean mouseUpSelectionReasonFlag;
    private boolean sourceChangeFlag;
    private boolean commentNodeChanged;
    private int commentRemoveCount = 0;
    private int commentAddCount = 0;
    private VpePageContext pageContext;
    private VpeEditorPart editPart;
    private BundleMap bundleMap;
    public static final int LEFT_BUTTON = 0;
    private CSSReferenceList cssReferenceListListener;
    private TaglibReferenceList taglibReferenceListListener;
    private ELReferenceList elReferenceListListener;
    private AbsoluteFolderReferenceList absoluteFolderReferenceListListener;
    private RelativeFolderReferenceList relativeFolderReferenceListListener;
    private VpeIncludeList includeList = new VpeIncludeList();
    private FormatControllerManager toolbarFormatControllerManager = null;
    private XModelTreeListenerSWTSync optionsListener;
    private UIJob job = null;
    private UIJob uiJob;
    private UIJob visualRefreshJob;
    private UIJob reinitJob;
    private IZoomEventManager zoomEventManager;
    private VpeDropWindow dropWindow = null;
    private static List<String> vpeCategoryCommands = null;
    private LinkedList<VpeEventBean> changeEvents;
    Shell tip;
    private ISelectionManager selectionManager;
    private IKeyEventHandler keyEventHandler;
    private int vpeUpdateDelayTime;
    private ListenerList updateListeners = new ListenerList();

    public VpeController(VpeEditorPart editPart) {
        this.editPart = editPart;
        this.dropWindow = new VpeDropWindow(editPart.getSite().getShell());
    }

    void init(StructuredTextEditor sourceEditor, MozillaEditor visualEditor, BundleMap bundleMap) {
        this.sourceEditor = sourceEditor;
        this.bundleMap = bundleMap;
        if (sourceEditor instanceof IJSPTextEditor) {
            ((IJSPTextEditor)sourceEditor).setVPEController((IVisualController)this);
            this.dropWindow.setEditor((IJSPTextEditor)sourceEditor);
        }
        this.visualEditor = visualEditor;
        visualEditor.setController(this);
        bundleMap.init(sourceEditor.getEditorInput());
        this.pageContext = new VpePageContext(bundleMap, this.editPart);
        this.domMapping = new VpeDomMapping(this.pageContext);
        this.sourceBuilder = new VpeSourceDomBuilder(this.domMapping, this, VpeTemplateManager.getInstance(), sourceEditor, this.pageContext);
        this.visualBuilder = new VpeVisualDomBuilder(this.domMapping, this, visualEditor, this.pageContext);
        this.vpeDnD = new VpeDnD(this, visualEditor);
        visualEditor.getXulRunnerEditor().addSelectionListener((IVpeSelectionListener)this.vpeDnD);
        this.pageContext.setSourceDomBuilder(this.sourceBuilder);
        this.pageContext.setVisualDomBuilder(this.visualBuilder);
        IDOMModel sourceModel = (IDOMModel)this.getModel();
        if (sourceModel == null) {
            return;
        }
        sourceModel.addModelLifecycleListener((IModelLifecycleListener)this);
        IEditorInput editorInput = this.pageContext.getEditPart().getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            XModel xm = null;
            IProject project = ((IFileEditorInput)editorInput).getFile().getProject();
            IModelNature mn = EclipseResourceUtil.getModelNature((IProject)project);
            if (mn != null) {
                xm = mn.getModel();
            }
            if (xm != null) {
                WebProject.getInstance((XModel)xm).getTaglibMapping().revalidate(WebAppHelper.getWebApp((XModel)xm));
            }
        }
        visualEditor.getEditor();
        IDOMDocument sourceDocument = sourceModel.getDocument();
        this.visualBuilder.buildDom((Document)sourceDocument);
        VpeTemplateManager.getInstance().addTemplateListener(this);
        this.xulRunnerEditor = visualEditor.getXulRunnerEditor();
        this.zoomEventManager = new ZoomEventManager(this.xulRunnerEditor);
        this.visualSelectionController = new VpeSelectionController(visualEditor.getEditor().getSelectionController());
        this.visualSelectionController.setSelectionFlags((short)7);
        this.selectionManager = new SelectionManager(this.pageContext, sourceEditor, this.visualSelectionController);
        this.keyEventHandler = new KeyEventManager(sourceEditor, this.domMapping, this.pageContext);
        ISelectionProvider provider = sourceEditor.getSelectionProvider();
        provider.addSelectionChangedListener((ISelectionChangedListener)this);
        StyledText textWidget = SelectionHelper.getSourceTextWidget((StructuredTextEditor)sourceEditor);
        if (textWidget != null) {
            textWidget.addSelectionListener((SelectionListener)this);
        }
        this.scrollCoordinator = new ScrollCoordinator(sourceEditor, visualEditor, this.domMapping);
        if (visualEditor != null && sourceEditor != null) {
            nsIWebBrowser webBrowser;
            this.sourceEditorVerticalScrollBar = textWidget.getVerticalBar();
            if (this.sourceEditorVerticalScrollBar != null && visualEditor.getXulRunnerEditor() != null && (webBrowser = visualEditor.getXulRunnerEditor().getWebBrowser()) != null) {
                final nsIDOMWindow domWindow = webBrowser.getContentDOMWindow();
                final nsIDOMWindowInternal windowInternal = (nsIDOMWindowInternal)XPCOM.queryInterface((nsISupports)domWindow, nsIDOMWindowInternal.class);
                this.sourceScrollSelectionListener = new SelectionListener(){

                    public void widgetSelected(SelectionEvent e) {
                        int scrollMaxYVisual = windowInternal.getScrollMaxY();
                        if (JspEditorPlugin.getDefault().getPreferenceStore().getBoolean("Synchronize scrolling between source and visual panes") && !VpeController.this.visualScrollEventFlag && !VpeController.this.selectionManager.isUpdateSelectionEventPerformed() && VpeController.this.editPart.getVisualMode() == 0 && scrollMaxYVisual > 0) {
                            VpeController.this.sourceScrollEventFlag = true;
                            int posY = VpeController.this.scrollCoordinator.computeVisualPositionFromSource();
                            if (posY != -1) {
                                if (posY > scrollMaxYVisual) {
                                    posY = scrollMaxYVisual;
                                }
                                domWindow.scrollTo(windowInternal.getPageXOffset(), posY);
                            }
                        } else {
                            VpeController.this.visualScrollEventFlag = false;
                            VpeController.this.selectionManager.setUpdateSelectionEventFlag(false);
                        }
                    }

                    public void widgetDefaultSelected(SelectionEvent e) {
                    }
                };
                this.sourceEditorVerticalScrollBar.addSelectionListener(this.sourceScrollSelectionListener);
            }
        }
        this.registerEventTargets();
        if (this.optionsListener == null) {
            XModelObject optionsObject = ModelUtilities.getPreferenceModel().getByPath(VpePreference.EDITOR_PATH);
            this.optionsListener = new XModelTreeListenerSWTSync((XModelTreeListener)this);
            optionsObject.getModel().addModelTreeListener((XModelTreeListener)this.optionsListener);
        }
        this.cssReferenceListListener = CSSReferenceList.getInstance();
        this.cssReferenceListListener.addChangeListener((ResourceReferenceListListener)this);
        this.taglibReferenceListListener = TaglibReferenceList.getInstance();
        this.taglibReferenceListListener.addChangeListener((ResourceReferenceListListener)this);
        this.absoluteFolderReferenceListListener = AbsoluteFolderReferenceList.getInstance();
        this.absoluteFolderReferenceListListener.addChangeListener((ResourceReferenceListListener)this);
        this.relativeFolderReferenceListListener = RelativeFolderReferenceList.getInstance();
        this.relativeFolderReferenceListListener.addChangeListener((ResourceReferenceListListener)this);
        this.elReferenceListListener = ELReferenceList.getInstance();
        this.elReferenceListListener.addChangeListener((ResourceReferenceListListener)this);
        this.vpeUpdateDelayTime = 400;
        this.sourceSelectionChanged();
        this.refreshCommands();
        visualEditor.updateExternalizeStringsToolbarIconState(sourceEditor.getSelectionProvider().getSelection());
        this.selectionManager.setUpdateSelectionEventFlag(false);
    }

    private void removeSourceScrollListener() {
        if (this.sourceEditorVerticalScrollBar != null && this.sourceScrollSelectionListener != null) {
            this.sourceEditorVerticalScrollBar.removeSelectionListener(this.sourceScrollSelectionListener);
        }
    }

    private void addSourceScrollListener() {
        if (this.sourceEditorVerticalScrollBar != null && this.sourceScrollSelectionListener != null) {
            this.sourceEditorVerticalScrollBar.addSelectionListener(this.sourceScrollSelectionListener);
        }
    }

    public void dispose() {
        IDOMModel sourceModel;
        if (this.job != null) {
            this.job.cancel();
            this.job = null;
        }
        if (this.uiJob != null) {
            this.uiJob.cancel();
            this.getChangeEvents().clear();
            this.uiJob = null;
        }
        if (this.visualRefreshJob != null) {
            this.visualRefreshJob.cancel();
            this.visualRefreshJob = null;
        }
        if (this.optionsListener != null) {
            XModelObject optionsObject = ModelUtilities.getPreferenceModel().getByPath(VpePreference.EDITOR_PATH);
            optionsObject.getModel().removeModelTreeListener((XModelTreeListener)this.optionsListener);
            this.optionsListener.dispose();
            this.optionsListener = null;
        }
        if ((sourceModel = (IDOMModel)this.getModel()) != null) {
            sourceModel.removeModelLifecycleListener((IModelLifecycleListener)this);
        }
        VpeTemplateManager.getInstance().removeTemplateListener(this);
        if (this.visualBuilder != null) {
            this.visualBuilder.dispose();
            this.visualBuilder = null;
        }
        this.sourceBuilder = null;
        if (this.sourceEditor != null) {
            ISelectionProvider provider = this.sourceEditor.getSelectionProvider();
            provider.removeSelectionChangedListener((ISelectionChangedListener)this);
            StyledText textWidget = SelectionHelper.getSourceTextWidget((StructuredTextEditor)this.sourceEditor);
            if (textWidget != null) {
                textWidget.removeSelectionListener((SelectionListener)this);
            }
            ((IJSPTextEditor)this.sourceEditor).setVPEController(null);
        }
        if (this.dropWindow != null) {
            this.dropWindow.setEditor(null);
        }
        if (this.visualEditor != null) {
            this.unregisterEventTargets();
            if (this.visualSelectionController != null) {
                this.visualSelectionController = null;
            }
            this.visualEditor = null;
        }
        if (this.cssReferenceListListener != null) {
            this.cssReferenceListListener.removeChangeListener((ResourceReferenceListListener)this);
        }
        if (this.taglibReferenceListListener != null) {
            this.taglibReferenceListListener.removeChangeListener((ResourceReferenceListListener)this);
        }
        if (this.absoluteFolderReferenceListListener != null) {
            this.absoluteFolderReferenceListListener.removeChangeListener((ResourceReferenceListListener)this);
        }
        if (this.elReferenceListListener != null) {
            this.elReferenceListListener.removeChangeListener((ResourceReferenceListListener)this);
        }
        if (this.relativeFolderReferenceListListener != null) {
            this.relativeFolderReferenceListListener.removeChangeListener((ResourceReferenceListListener)this);
        }
        this.toolbarFormatControllerManager = null;
    }

    private void registerEventTargets() {
        if (this.visualEditor != null) {
            this.visualEditor.setResizeListener(this);
            this.visualEditor.setTooltipListener(this);
            MozillaEventAdapter mozillaEventAdapter = this.visualEditor.getMozillaEventAdapter();
            if (mozillaEventAdapter != null) {
                mozillaEventAdapter.addContextMenuListener(this);
                mozillaEventAdapter.addDndListener(this.vpeDnD);
                mozillaEventAdapter.addKeyListener(this);
                mozillaEventAdapter.addMouseListener(this);
                mozillaEventAdapter.addSelectionListener(this);
                mozillaEventAdapter.addSelectionListener(this.vpeDnD);
                mozillaEventAdapter.addAfterPaintListener(this);
                mozillaEventAdapter.addScrollListener(this);
            }
        }
    }

    private void unregisterEventTargets() {
        if (this.visualEditor != null) {
            this.visualEditor.setResizeListener(null);
            this.visualEditor.setTooltipListener(null);
            MozillaEventAdapter mozillaEventAdapter = this.visualEditor.getMozillaEventAdapter();
            if (mozillaEventAdapter != null) {
                mozillaEventAdapter.removeContextMenuListener(this);
                mozillaEventAdapter.removeDndListener(this.vpeDnD);
                mozillaEventAdapter.removeKeyListener(this);
                mozillaEventAdapter.removeMouseListener(this);
                mozillaEventAdapter.removeSelectionListener(this);
                mozillaEventAdapter.removeSelectionListener(this.vpeDnD);
                mozillaEventAdapter.removeAfterPaintListener(this);
                mozillaEventAdapter.removeScrollListener(this);
            }
        }
    }

    public boolean isAdapterForType(Object type) {
        return type == this;
    }

    public void notifyChanged(final INodeNotifier notifier, final int eventType, final Object feature, final Object oldValue, final Object newValue, final int pos) {
        if (!this.isVisualEditorVisible()) {
            this.setSynced(false);
            return;
        }
        Display display = null;
        if (PlatformUI.isWorkbenchRunning()) {
            display = PlatformUI.getWorkbench().getDisplay();
        }
        if (display != null && Thread.currentThread() == display.getThread()) {
            this.getChangeEvents().addLast(new VpeEventBean(notifier, eventType, feature, oldValue, newValue, pos));
            if (this.uiJob == null) {
                this.uiJob = new VPEUpdateJob(VpeUIMessages.VPE_UPDATE_JOB_TITLE);
            }
            if (this.uiJob.getState() != 4) {
                this.uiJob.setPriority(30);
                this.uiJob.schedule((long)this.getVpeUpdateDelayTime());
            } else {
                this.uiJob.cancel();
                this.uiJob.schedule((long)this.getVpeUpdateDelayTime());
                this.setVpeUpdateDelayTime(400);
            }
            return;
        }
        if (this.job != null) {
            this.job.cancel();
        }
        this.job = new UIJob("NotifyChangedJob"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                VpeController.this.notifyChangedInUiThread(notifier, eventType, feature, oldValue, newValue, pos);
                return Status.OK_STATUS;
            }
        };
        this.job.setPriority(30);
        this.job.schedule(1000L);
    }

    public void notifyChangedInUiThread(INodeNotifier notifier, int eventType, Object feature, Object oldValue, Object newValue, int pos) {
        if (this.editPart.getVisualMode() != 1) {
            if (VpeDebug.PRINT_SOURCE_MUTATION_EVENT) {
                VpeDebugUtil.printSourceEvent(notifier, eventType, feature, oldValue, newValue, pos);
            }
            if (this.visualBuilder == null) {
                return;
            }
            switch (eventType) {
                case 1: {
                    this.sourceChangeFlag = true;
                    short type = ((Node)notifier).getNodeType();
                    this.visualEditor.hideResizer();
                    this.visualBuilder.clearSelectionRectangle();
                    if (type == 4) {
                        this.visualBuilder.setCdataText((Node)notifier);
                    } else if (type == 3) {
                        boolean update = this.visualBuilder.setText((Node)notifier);
                        this.visualEditor.showResizer();
                        if (!update) {
                            this.visualBuilder.updateNode((Node)notifier);
                        }
                    } else if (type == 8) {
                        if ("yes".equals(VpePreference.SHOW_COMMENTS.getValue())) {
                            this.visualBuilder.clearSelectionRectangle();
                            this.visualBuilder.updateNode((Node)notifier);
                        }
                    } else if (feature != null && ((Node)feature).getNodeType() == 2) {
                        if (newValue != null) {
                            String attrName = ((Attr)feature).getName();
                            if ((Attr)feature == this.lastRemovedAttr && !attrName.equals(this.lastRemovedAttrName)) {
                                this.lastRemovedAttr = null;
                                this.visualBuilder.removeAttribute((Element)notifier, this.lastRemovedAttrName);
                            }
                            this.visualBuilder.setAttribute((Element)notifier, ((Attr)feature).getName(), (String)newValue);
                        } else {
                            this.lastRemovedAttr = (Attr)feature;
                            this.lastRemovedAttrName = ((Attr)feature).getName();
                            this.visualBuilder.removeAttribute((Element)notifier, this.lastRemovedAttrName);
                        }
                    }
                    this.visualEditor.showResizer();
                    break;
                }
                case 2: {
                    if (newValue instanceof Node && 8 != ((Node)newValue).getNodeType()) {
                        this.visualBuilder.removeNode((Node)newValue);
                        --this.commentAddCount;
                        break;
                    }
                    if (!(newValue instanceof Node) || 8 != ((Node)newValue).getNodeType()) break;
                    ++this.commentAddCount;
                    break;
                }
                case 3: {
                    if (8 == ((Node)feature).getNodeType()) {
                        ++this.commentRemoveCount;
                        this.visualBuilder.updateNode((Node)feature);
                        this.commentNodeChanged = true;
                        break;
                    }
                    --this.commentRemoveCount;
                    this.visualBuilder.stopToggle((Node)feature);
                    this.visualBuilder.removeNode((Node)feature);
                    break;
                }
                case 4: {
                    if (!this.commentNodeChanged || this.commentNodeChanged && (this.commentAddCount != 1 || this.commentRemoveCount != 1)) {
                        this.visualEditor.hideResizer();
                        this.visualBuilder.clearSelectionRectangle();
                        this.visualBuilder.updateNode((Node)notifier);
                    } else {
                        this.commentNodeChanged = false;
                    }
                    this.commentAddCount = 0;
                    this.commentRemoveCount = 0;
                    break;
                }
                case 5: {
                    if (!this.sourceChangeFlag) {
                        if (feature == null || ((Node)feature).getNodeType() != 3) break;
                        this.visualEditor.hideResizer();
                        this.visualBuilder.clearSelectionRectangle();
                        this.visualBuilder.setText((Node)feature);
                        this.visualEditor.showResizer();
                        break;
                    }
                    this.sourceChangeFlag = false;
                }
            }
        }
    }

    public void nodeSelectionChanged(NodeSelectionChangedEvent event) {
    }

    public void textSelectionChanged(TextSelectionChangedEvent event) {
        if (this.editPart.getVisualMode() != 1) {
            if (VpeDebug.PRINT_SOURCE_SELECTION_EVENT) {
                System.out.println(">>>>>>>>>>>>>> textSelectionChanged  " + event.getSource());
            }
            this.sourceSelectionChanged();
        }
    }

    public void widgetSelected(SelectionEvent event) {
        if (this.editPart.getVisualMode() != 1) {
            if (VpeDebug.PRINT_SOURCE_SELECTION_EVENT) {
                System.out.println(">>>>>>>>>>>>>> widgetSelected");
            }
            if (event.getSource() instanceof StyledText) {
                this.sourceSelectionChanged();
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
        if (VpeDebug.PRINT_SOURCE_SELECTION_EVENT) {
            System.out.println(">>>>>>>>>>>>>> widgetDefaultSelected");
        }
    }

    public void sourceSelectionChanged() {
        if (this.getChangeEvents().size() > 0) {
            return;
        }
        if (this.selectionManager != null && !this.visualSelectionIsAlreadyInProgress) {
            this.selectionManager.refreshVisualSelection();
        }
    }

    public void sourceSelectionToVisualSelection() {
        if (this.editPart.getVisualMode() != 1) {
            this.sourceSelectionChanged();
        }
    }

    public void processPreModelEvent(ModelLifecycleEvent event) {
    }

    public void processPostModelEvent(ModelLifecycleEvent event) {
        if (this.editPart.getVisualMode() != 1 && event.getType() == 2) {
            if (VpeDebug.PRINT_SOURCE_MODEL_LIFECYCLE_EVENT) {
                System.out.println(">>> processPostModelEvent: " + event.toString());
            }
            IStructuredModel model = event.getModel();
            model.removeModelLifecycleListener((IModelLifecycleListener)this);
            IDOMModel sourceModel = (IDOMModel)this.getModel();
            sourceModel.addModelLifecycleListener((IModelLifecycleListener)this);
            this.bundleMap.clearAll();
            this.bundleMap.refresh();
            sourceModel.getDocument();
        }
    }

    public void nodeRemovedFromDocument(nsIDOMMutationEvent mutationEvent) {
        if (VpeDebug.PRINT_VISUAL_MUTATION_EVENT) {
            VpeDebugUtil.printVisualEvent((nsIDOMEvent)mutationEvent);
        }
    }

    @Override
    public void notifySelectionChanged(nsIDOMDocument doc, nsISelection selection, short reason) {
        if (!this.visualSelectionIsAlreadyInProgress) {
            this.visualSelectionIsAlreadyInProgress = true;
            boolean bl = this.mouseUpSelectionReasonFlag = (reason & 4) != 0;
            if ((reason & 0x1A) != 0) {
                nsIDOMNode node;
                if (VpeDebug.PRINT_VISUAL_SELECTION_EVENT) {
                    System.out.println("<<< notifySelectionChanged: " + reason);
                }
                if ((node = SelectionUtil.getSelectedNode(selection)) != null) {
                    this.selectionManager.setSelection(SelectionUtil.getSelectedNode(selection), selection.getFocusOffset(), selection.getAnchorOffset());
                }
            }
            this.visualSelectionController.setCaretEnabled(true);
            this.visualSelectionController.setCaretEnabled(true);
            this.visualSelectionIsAlreadyInProgress = false;
        }
    }

    @Override
    public void mouseDown(nsIDOMMouseEvent mouseEvent) {
        if (VpeDebug.PRINT_VISUAL_MOUSE_EVENT) {
            System.out.println("<<< mouseDown  targetNode:");
        }
        if (mouseEvent.getButton() == 0) {
            if (this.vpeDnD.isDragIconClicked(mouseEvent)) {
                this.vpeDnD.dragStart((nsIDOMEvent)mouseEvent);
            } else {
                int rangeOffset = ((nsIDOMNSUIEvent)XPCOM.queryInterface((nsISupports)mouseEvent, nsIDOMNSUIEvent.class)).getRangeOffset();
                this.selectionManager.setSelection(VisualDomUtil.getTargetNode((nsIDOMEvent)mouseEvent), rangeOffset, rangeOffset);
            }
        }
    }

    @Override
    public void mouseUp(nsIDOMMouseEvent mouseEvent) {
        if (VpeDebug.PRINT_VISUAL_MOUSE_EVENT) {
            System.out.println("<<< mouseUp");
        }
    }

    @Override
    public void mouseClick(nsIDOMMouseEvent mouseEvent) {
        nsIDOMNode visualNode = VisualDomUtil.getTargetNode((nsIDOMEvent)mouseEvent);
        if (visualNode != null) {
            VpeNodeMapping toggledMapping;
            if (VpeDebug.PRINT_VISUAL_MOUSE_EVENT) {
                VpeDebugUtil.printVisualMouseEvent(visualNode);
            }
            if (!this.mouseUpSelectionReasonFlag) {
                this.visualBuilder.isContentArea(visualNode);
            } else {
                this.mouseUpSelectionReasonFlag = false;
            }
            Element toggledElement = this.visualBuilder.doToggle(visualNode);
            if (toggledElement != null && (toggledMapping = this.getDomMapping().getNearNodeMapping(toggledElement)) != null && toggledMapping.getVisualNode() != null) {
                this.selectionManager.setSelection(toggledMapping.getVisualNode(), 0, 0);
            }
        }
    }

    @Override
    public void mouseDblClick(nsIDOMMouseEvent mouseEvent) {
        nsIDOMNode visualNode = VisualDomUtil.getTargetNode((nsIDOMEvent)mouseEvent);
        if (visualNode != null) {
            this.sourceBuilder.openOn(visualNode);
            if (VpeDebug.PRINT_VISUAL_MOUSE_EVENT) {
                VpeDebugUtil.printVisualMouseEvent(visualNode);
            }
        }
    }

    @Override
    public void mouseMove(nsIDOMMouseEvent mouseEvent) {
        this.onRefresh();
    }

    @Override
    public void keyPress(nsIDOMKeyEvent keyEvent) {
        if (VpeDebug.PRINT_VISUAL_KEY_EVENT) {
            VpeDebugUtil.printKeyEvent(keyEvent);
        }
        this.visualEditor.hideResizer();
        this.setVpeUpdateDelayTime(0);
        Event keyboardEvent = this.xulRunnerEditor.createSWTKeyEvent(keyEvent);
        if (!this.isKeyBinding(keyboardEvent) || this.isZoomEvent(keyEvent)) {
            IZoomEventManager zoomEventManager;
            if (this.keyEventHandler instanceof KeyEventManager && (zoomEventManager = ((KeyEventManager)this.keyEventHandler).getZoomEventManager()) == null) {
                this.zoomEventManager = new ZoomEventManager(this.getXulRunnerEditor());
                ((KeyEventManager)this.keyEventHandler).setZoomEventManager(this.zoomEventManager);
            }
            if (this.keyEventHandler.handleKeyPress(keyEvent)) {
                keyEvent.preventDefault();
            }
        }
        this.onRefresh();
    }

    public boolean isKeyBinding(Event keyboardEvent) {
        boolean keyBindingPressed = false;
        List possibleKeyStrokes = WorkbenchKeyboard.generatePossibleKeyStrokes((Event)keyboardEvent);
        if (PlatformUI.getWorkbench().hasService(IBindingService.class)) {
            IBindingService iBindingService = (IBindingService)PlatformUI.getWorkbench().getService(IBindingService.class);
            KeySequence sequenceBeforeKeyStroke = KeySequence.getInstance();
            for (KeyStroke keyStroke : possibleKeyStrokes) {
                Binding binding;
                KeySequence sequenceAfterKeyStroke = KeySequence.getInstance((KeySequence)sequenceBeforeKeyStroke, (KeyStroke)keyStroke);
                if (!iBindingService.isPerfectMatch((TriggerSequence)sequenceAfterKeyStroke) || (binding = iBindingService.getPerfectMatch((TriggerSequence)sequenceAfterKeyStroke)) == null || binding.getParameterizedCommand() == null || binding.getParameterizedCommand().getCommand() == null) continue;
                keyBindingPressed = true;
            }
        }
        return keyBindingPressed;
    }

    private boolean isZoomEvent(nsIDOMKeyEvent keyEvent) {
        return keyEvent.getCtrlKey() && (keyEvent.getCharCode() == 61L || keyEvent.getCharCode() == 45L || keyEvent.getCharCode() == 48L);
    }

    @Override
    public void elementResized(nsIDOMElement element, int constrains, int top, int left, int width, int height) {
        this.visualEditor.hideResizer();
        this.visualBuilder.resize(element, constrains, top, left, width, height);
        this.sourceSelectionChanged();
    }

    @Override
    public void afterPaint(nsIDOMEvent domEvent) {
        this.onRefresh();
    }

    @Override
    public void editorScrolled(nsIDOMEvent domEvent) {
        this.onRefresh();
        if (JspEditorPlugin.getDefault().getPreferenceStore().getBoolean("Synchronize scrolling between source and visual panes") && !this.sourceScrollEventFlag && !this.selectionManager.isUpdateSelectionEventPerformed() && this.editPart.getVisualMode() == 0) {
            this.removeSourceScrollListener();
            this.visualScrollEventFlag = true;
            int line = this.scrollCoordinator.computeSourcePositionFromVisual();
            if (line != -1 && this.sourceEditor.getTextViewer() != null) {
                this.sourceEditor.getTextViewer().setTopIndex(line);
            }
            this.addSourceScrollListener();
        } else {
            this.sourceScrollEventFlag = false;
            this.selectionManager.setUpdateSelectionEventFlag(false);
        }
    }

    @Override
    public void onShowContextMenu(long contextFlags, nsIDOMEvent event, nsIDOMNode node) {
        Node selectedSourceNode = null;
        VpeNodeMapping nodeMapping = SelectionUtil.getNodeMappingBySourceSelection(this.sourceEditor, this.domMapping);
        if (nodeMapping != null) {
            selectedSourceNode = nodeMapping.getSourceNode();
        }
        MenuManager menuManager = new MenuManager("#popup");
        Menu contextMenu = menuManager.createContextMenu(this.visualEditor.getControl());
        contextMenu.addMenuListener(new MenuListener(contextMenu){
            Menu menu;
            {
                this.menu = menu;
            }

            public void menuHidden(MenuEvent e) {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        menu.dispose();
                    }
                });
            }

            public void menuShown(MenuEvent e) {
            }
        });
        new VpeMenuCreator(menuManager, selectedSourceNode).createMenu();
        contextMenu.setVisible(true);
        this.onRefresh();
    }

    @Override
    public void templateReloaded() {
        this.visualRefresh();
    }

    public void visualRefresh() {
        if (!this.isVisualEditorVisible()) {
            this.setSynced(false);
            return;
        }
        if (this.uiJob != null && this.uiJob.getState() != 0) {
            return;
        }
        if (this.visualRefreshJob == null || this.visualRefreshJob.getState() == 0) {
            this.visualRefreshJob = new UIJob(VpeUIMessages.VPE_VISUAL_REFRESH_JOB){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    if (monitor.isCanceled()) {
                        return Status.CANCEL_STATUS;
                    }
                    monitor.beginTask(VpeUIMessages.VPE_VISUAL_REFRESH_JOB, -1);
                    VpeController.this.visualRefreshImpl();
                    monitor.done();
                    VpeController.this.setSynced(true);
                    VpeController.this.notifyVpeUpdateListeners();
                    return Status.OK_STATUS;
                }
            };
            this.visualRefreshJob.setPriority(20);
            this.visualRefreshJob.schedule();
        }
    }

    public void visualRefreshImpl() {
        if (this.editPart.getVisualMode() != 1) {
            this.visualEditor.hideResizer();
            String currentDoctype = DocTypeUtil.getDoctype(this.visualEditor.getEditorInput());
            String visualEditorDoctype = this.visualEditor.getDoctype();
            if (currentDoctype != null && visualEditorDoctype != null && !visualEditorDoctype.equals(currentDoctype)) {
                this.visualEditor.reload();
            } else {
                this.visualBuilder.clearSelectionRectangle();
                this.visualEditor.reload();
            }
        }
    }

    public void preLongOperation() {
    }

    public void postLongOperation() {
        this.visualRefresh();
    }

    void refreshTemplates() {
        if (this.includeList.includesRefresh()) {
            this.visualRefresh();
        }
        VpeTemplateManager.getInstance().reload();
        if (this.bundleMap != null) {
            this.bundleMap.refresh();
            if (this.pageContext != null && this.editPart.getVisualMode() != 1) {
                this.pageContext.refreshBundleValues();
            }
        }
    }

    public void nodeChanged(XModelTreeEvent event) {
        this.visualRefresh();
    }

    public void structureChanged(XModelTreeEvent event) {
    }

    public void refreshExternalLinks() {
        this.pageContext.getVisualBuilder().refreshExternalLinks();
    }

    public IPath getPath() {
        IEditorInput input;
        if (this.editPart != null && (input = this.editPart.getEditorInput()) instanceof IFileEditorInput) {
            return ((IFileEditorInput)input).getFile().getFullPath();
        }
        return null;
    }

    public void changed(Object source) {
        if (this.cssReferenceListListener == source) {
            this.pageContext.getVisualBuilder().refreshExternalLinks();
        } else if (this.absoluteFolderReferenceListListener == source || this.relativeFolderReferenceListListener == source || this.taglibReferenceListListener == source || this.elReferenceListListener == source) {
            this.visualRefresh();
        }
    }

    public String getTagName(XModelObject object) {
        String tagname = object.getAttributeValue("name");
        XModelObject parent = object.getParent();
        String uri = parent == null ? "" : parent.getAttributeValue("library uri");
        String defaultPrefix = parent == null ? "" : parent.getAttributeValue("default prefix");
        String[] texts = new String[]{"<" + tagname + ">"};
        JSPPaletteInsertHelper.applyPrefix((String[])texts, (ITextEditor)this.sourceEditor, (String)tagname, (String)uri, (String)defaultPrefix);
        tagname = texts[0].substring(1, texts[0].length() - 1);
        return tagname;
    }

    @Override
    public void onShowTooltip(int x, int y, String text) {
        if (this.tip != null && !this.tip.isDisposed()) {
            this.tip.dispose();
        }
        Display display = this.visualEditor.getControl().getDisplay();
        Shell parent = this.visualEditor.getControl().getShell();
        this.tip = new Shell(parent, 540672);
        Color bckgColor = new Color((Device)this.tip.getDisplay(), 255, 250, 236);
        SwtUtil.bindDisposal((Resource)bckgColor, (Widget)this.tip);
        this.tip.setBackground(bckgColor);
        Shell composite = this.tip;
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        final StyledText tipControlHeaderText = new StyledText((Composite)composite, 10);
        tipControlHeaderText.setForeground(bckgColor);
        tipControlHeaderText.setBackground(bckgColor);
        String formatText = text.trim();
        String[] attributeString = formatText.split("\n");
        String[] buffer = attributeString[0].split(" ");
        tipControlHeaderText.setText(buffer[0].toString());
        tipControlHeaderText.addLineStyleListener(new LineStyleListener(){

            public void lineGetStyle(LineStyleEvent event) {
                Color color = new Color((Device)tipControlHeaderText.getDisplay(), 201, 51, 40);
                SwtUtil.bindDisposal((Resource)color, (Widget)tipControlHeaderText);
                if (event.lineOffset == 0) {
                    StyleRange st = new StyleRange();
                    st.fontStyle = 1;
                    st.foreground = color;
                    event.styles = new StyleRange[]{st};
                    st.start = event.lineOffset;
                    st.length = event.lineText.length();
                }
            }
        });
        GridData gridData = new GridData(1809);
        gridData.horizontalAlignment = 4;
        gridData.horizontalSpan = 2;
        tipControlHeaderText.setLayoutData((Object)gridData);
        StringBuilder tempAttr = new StringBuilder();
        StringBuilder tempValue = new StringBuilder();
        if (attributeString.length >= 2) {
            int i = 1;
            while (i < attributeString.length) {
                buffer = attributeString[i].split(" ", 2);
                if (i == 1) {
                    tempAttr.append(buffer[0]).append(" ");
                    tempValue.append(buffer.length >= 2 ? buffer[1] : "").append(" ");
                } else {
                    tempAttr.append("\n").append(buffer[0]).append(" ");
                    tempValue.append(" \n").append(buffer.length >= 2 ? buffer[1] : "").append(" ");
                }
                ++i;
            }
            final StyledText tipControlAttributeText = new StyledText((Composite)composite, 10);
            tipControlAttributeText.setForeground(bckgColor);
            tipControlAttributeText.setBackground(bckgColor);
            tipControlAttributeText.setText(tempAttr.toString());
            tipControlAttributeText.addLineStyleListener(new LineStyleListener(){

                public void lineGetStyle(LineStyleEvent event) {
                    Color color = new Color((Device)tipControlHeaderText.getDisplay(), 42, 148, 0);
                    SwtUtil.bindDisposal((Resource)color, (Widget)tipControlAttributeText);
                    StyleRange st = new StyleRange();
                    st.start = event.lineOffset;
                    st.length = event.lineText.length();
                    st.foreground = color;
                    st.fontStyle = 0;
                    event.styles = new StyleRange[]{st};
                }
            });
            GridData gridData1 = new GridData(1809);
            gridData1.horizontalAlignment = 4;
            tipControlAttributeText.setLayoutData((Object)gridData1);
            StyledText tipControlValueText = new StyledText((Composite)composite, 10);
            tipControlValueText.setBackground(bckgColor);
            tipControlValueText.setText(tempValue.toString());
            GridData gridData2 = new GridData(1809);
            gridData2.horizontalAlignment = 4;
            tipControlValueText.setLayoutData((Object)gridData2);
        }
        Point point = display.getCursorLocation();
        point.y += 21;
        this.tip.setLocation(point);
        this.tip.pack();
        this.tip.setVisible(true);
    }

    @Override
    public void onHideTooltip() {
        if (this.tip != null && !this.tip.isDisposed()) {
            this.tip.dispose();
        }
        this.tip = null;
    }

    public VpePageContext getPageContext() {
        return this.pageContext;
    }

    public StructuredTextEditor getSourceEditor() {
        return this.sourceEditor;
    }

    public FormatControllerManager getToolbarFormatControllerManager() {
        return this.toolbarFormatControllerManager;
    }

    public void setToolbarFormatControllerManager(FormatControllerManager formatControllerManager) {
        this.toolbarFormatControllerManager = formatControllerManager;
    }

    public IStructuredModel getModel() {
        return this.sourceEditor.getModel();
    }

    public VpeDomMapping getDomMapping() {
        return this.domMapping;
    }

    public VpeIncludeList getIncludeList() {
        if (this.includeList == null) {
            VpePlugin.getPluginLog().logError("includeList - NULL!!!");
        }
        return this.includeList;
    }

    public VpeDnD getVpeDnD() {
        return this.vpeDnD;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        if (!this.isVisualEditorVisible()) {
            return;
        }
        this.visualEditor.updateExternalizeStringsToolbarIconState(this.sourceEditor.getSelectionProvider().getSelection());
        if (this.editPart.getVisualMode() != 1 && this.toolbarFormatControllerManager != null) {
            this.toolbarFormatControllerManager.selectionChanged();
        }
        if (this.editPart.getVisualMode() != 1) {
            if (VpeDebug.PRINT_SOURCE_SELECTION_EVENT) {
                System.out.println(">>>>>>>>>>>>>> selectionChanged  " + event.getSource());
            }
            this.sourceSelectionChanged();
        }
    }

    public void drop(Node node, Node parentNode, int offset) {
        this.visualBuilder.innerDrop(node, parentNode, offset);
    }

    public void onRefresh() {
        Display.getDefault().asyncExec((Runnable)new Thread(){

            @Override
            public void run() {
                if (VpeController.this.getXulRunnerEditor() != null) {
                    VpeController.this.getXulRunnerEditor().redrawSelectionRectangle();
                }
            }
        });
    }

    public XulRunnerEditor getXulRunnerEditor() {
        return this.xulRunnerEditor;
    }

    public void setXulRunnerEditor(XulRunnerEditor xulRunnerEditor) {
        this.xulRunnerEditor = xulRunnerEditor;
    }

    public boolean isVisualEditorVisible() {
        return this.visualEditorVisible;
    }

    public void setVisualEditorVisible(boolean visualEditorVisible) {
        this.visualEditorVisible = visualEditorVisible;
    }

    public boolean isSynced() {
        return this.synced;
    }

    public void setSynced(boolean synced) {
        this.synced = synced;
    }

    public LinkedList<VpeEventBean> getChangeEvents() {
        if (this.changeEvents == null) {
            this.changeEvents = new LinkedList();
        }
        return this.changeEvents;
    }

    public void reinit() {
        if (this.reinitJob != null) {
            this.reinitJob.cancel();
        }
        this.reinitJob = new UIJob(VpeUIMessages.VPE_VISUAL_REFRESH_JOB){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                VpeController.this.reinitImpl();
                return Status.OK_STATUS;
            }
        };
        this.reinitJob.schedule();
    }

    private void reinitImpl() {
        if (this.editPart.getVisualMode() != 1) {
            try {
                this.visualEditor.reinitDesignMode();
                this.visualBuilder.clearSelectionRectangle();
                this.selectionManager = null;
                IDOMModel sourceModel = (IDOMModel)this.getModel();
                if (sourceModel != null) {
                    IDOMDocument sourceDocument = sourceModel.getDocument();
                    this.visualBuilder.rebuildDom((Document)sourceDocument);
                } else {
                    this.visualBuilder.rebuildDom(null);
                }
                this.visualSelectionController = new VpeSelectionController(this.visualEditor.getEditor().getSelectionController());
                this.visualSelectionController.setSelectionFlags((short)7);
                this.selectionManager = new SelectionManager(this.pageContext, this.sourceEditor, this.visualSelectionController);
                this.selectionManager.refreshVisualSelection();
                this.keyEventHandler = new KeyEventManager(this.sourceEditor, this.domMapping, this.pageContext);
                float currentZoom = this.zoomEventManager.getCurrentZoom();
                this.zoomEventManager = new ZoomEventManager(this.getXulRunnerEditor());
                this.zoomEventManager.setCurrentZoom(currentZoom);
                ((KeyEventManager)this.keyEventHandler).setZoomEventManager(this.zoomEventManager);
                this.sourceSelectionChanged();
            }
            catch (VpeDisposeException vpeDisposeException) {
            }
            catch (RuntimeException ex) {
                VpePlugin.getPluginLog().logError((Throwable)ex);
            }
        }
    }

    public void refreshCommands() {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        for (String commandId : this.getVpeCategoryCommands()) {
            commandService.refreshElements(commandId, null);
        }
    }

    private List<String> getVpeCategoryCommands() {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        if (vpeCategoryCommands == null) {
            Command[] definedCommands;
            vpeCategoryCommands = new ArrayList<String>();
            Command[] commandArray = definedCommands = commandService.getDefinedCommands();
            int n = definedCommands.length;
            int n2 = 0;
            while (n2 < n) {
                Command command = commandArray[n2];
                try {
                    if ("org.jboss.tools.vpe.category".equals(command.getCategory().getId())) {
                        vpeCategoryCommands.add(command.getId());
                    }
                }
                catch (NotDefinedException e) {
                    VpePlugin.reportProblem((Exception)((Object)e));
                }
                ++n2;
            }
        }
        return vpeCategoryCommands;
    }

    public VpeSelectionController getVisualSelectionController() {
        return this.visualSelectionController;
    }

    public VpeSourceDomBuilder getSourceBuilder() {
        return this.sourceBuilder;
    }

    public VpeVisualDomBuilder getVisualBuilder() {
        return this.visualBuilder;
    }

    private int getVpeUpdateDelayTime() {
        return this.vpeUpdateDelayTime;
    }

    private void setVpeUpdateDelayTime(int vpeUpdateDelayTime) {
        this.vpeUpdateDelayTime = vpeUpdateDelayTime;
    }

    public ISelectionManager getSelectionManager() {
        return this.selectionManager;
    }

    public IZoomEventManager getZoomEventManager() {
        return this.zoomEventManager;
    }

    public void setZoomEventManager(IZoomEventManager zoomEventManager) {
        this.zoomEventManager = zoomEventManager;
    }

    public VpeDropWindow getDropWindow() {
        return this.dropWindow;
    }

    public void addVpeRefreshListener(IVpeUpdateListener listener) {
        this.updateListeners.add((Object)listener);
    }

    public void removeVpeRefreshListener(IVpeUpdateListener listener) {
        this.updateListeners.remove((Object)listener);
    }

    private void notifyVpeUpdateListeners() {
        Object[] objectArray = this.updateListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((IVpeUpdateListener)listener).vpeUpdated();
            ++n2;
        }
    }

    private class VPEUpdateJob
    extends UIJob {
        private boolean cancelled;
        static final int MAX_EVENTS_TILL_REFRESH = 30;

        private VPEUpdateJob(String name) {
            super(name);
            this.cancelled = false;
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            this.cancelled = false;
            monitor.beginTask(VpeUIMessages.VPE_UPDATE_JOB_TITLE, 100);
            while (VpeController.this.getChangeEvents().size() > 0) {
                if (monitor.isCanceled() || this.cancelled) {
                    return Status.CANCEL_STATUS;
                }
                if (VpeController.this.changeEvents.size() > 30) {
                    monitor.worked(5000);
                    VpeController.this.reinitImpl();
                    monitor.worked(10000);
                    VpeController.this.changeEvents.clear();
                    return Status.OK_STATUS;
                }
                monitor.worked(100 / VpeController.this.getChangeEvents().size());
                VpeEventBean eventBean = VpeController.this.getChangeEvents().getFirst();
                try {
                    try {
                        VpeController.this.notifyChangedInUiThread(eventBean.getNotifier(), eventBean.getEventType(), eventBean.getFeature(), eventBean.getOldValue(), eventBean.getNewValue(), eventBean.getPos());
                    }
                    catch (VpeDisposeException vpeDisposeException) {
                        VpeController.this.getChangeEvents().remove(eventBean);
                        break;
                    }
                }
                catch (Throwable throwable) {
                    VpeController.this.getChangeEvents().remove(eventBean);
                    throw throwable;
                }
                VpeController.this.getChangeEvents().remove(eventBean);
            }
            if (VpeController.this.editPart.getVisualMode() != 1) {
                VpeController.this.sourceSelectionChanged();
                if (VpeController.this.toolbarFormatControllerManager != null) {
                    VpeController.this.toolbarFormatControllerManager.selectionChanged();
                }
            }
            monitor.done();
            VpeController.this.notifyVpeUpdateListeners();
            return Status.OK_STATUS;
        }

        protected void canceling() {
            this.cancelled = true;
        }
    }

    class VpeSelection
    implements ITextSelection {
        String text = "";
        int offset;
        int length;

        public VpeSelection(int position) {
            this.offset = position;
            this.length = 0;
        }

        public VpeSelection(int offset, int length) {
            this.offset = offset;
            this.length = length;
            if (length > 0) {
                try {
                    this.text = VpeController.this.sourceEditor.getTextViewer().getDocument().get(offset, length);
                }
                catch (BadLocationException e) {
                    VpePlugin.getPluginLog().logError((Throwable)e);
                }
            }
        }

        public VpeSelection(IndexedRegion region) {
            this.offset = region.getStartOffset();
            this.length = region.getEndOffset() - this.offset;
            try {
                this.text = VpeController.this.sourceEditor.getTextViewer().getDocument().get(this.offset, this.length);
            }
            catch (BadLocationException ex) {
                VpePlugin.reportProblem((Exception)((Object)ex));
            }
        }

        public int getEndLine() {
            return 0;
        }

        public int getLength() {
            return this.length;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getStartLine() {
            return 0;
        }

        public String getText() {
            return this.text;
        }

        public boolean isEmpty() {
            return false;
        }
    }

    public class VpeSelectionProvider
    implements ISelectionProvider {
        VpeSelection selection;

        public VpeSelectionProvider(IndexedRegion region) {
            this.selection = new VpeSelection(region);
        }

        public VpeSelectionProvider(int position) {
            this.selection = new VpeSelection(position);
        }

        public VpeSelectionProvider(int offset, int length) {
            this.selection = new VpeSelection(offset, length);
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return this.selection;
        }

        public void setSelection(ISelection selection) {
        }
    }
}

