/*******************************************************************************
 * Copyright (c) 2006 Jeff Mesnil
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    "Rob Stryker" <rob.stryker@redhat.com> - Initial implementation
 *******************************************************************************/
package org.jboss.tools.jmx.ui.internal.views.navigator;


import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.navigator.ILinkHelper;
import org.jboss.tools.jmx.core.MBeanFeatureInfoWrapper;
import org.jboss.tools.jmx.ui.internal.EditorUtils;
import org.jboss.tools.jmx.ui.internal.editors.AttributesPage;
import org.jboss.tools.jmx.ui.internal.editors.MBeanEditor;
import org.jboss.tools.jmx.ui.internal.editors.OperationsPage;

/**
 * The link helper to activate the editor
 */
public class JMXLinkHelper implements ILinkHelper {

	public void activateEditor(IWorkbenchPage page,
			IStructuredSelection selection) {
		Object obj = selection.getFirstElement();
		if (selection.size() == 1) {
			IEditorPart part = EditorUtils.isOpenInEditor(obj);
			if (part != null) {
				page.bringToTop(part);
				if (obj instanceof MBeanFeatureInfoWrapper) {
					EditorUtils.revealInEditor(part, obj);
				}
			}
		}
	}

	public IStructuredSelection findSelection(IEditorInput anInput) {
		IEditorPart part = EditorUtils.isOpenInEditor(anInput);
		if( part instanceof MBeanEditor ) {
			MBeanEditor editor = (MBeanEditor)part;
			Object page = editor.getSelectedPage();
			IStructuredSelection sel = null;
			if( page instanceof AttributesPage) {
				sel = ((AttributesPage)page).getSelection();
			} else if( page instanceof OperationsPage) {
				sel = ((OperationsPage)page).getSelection();
			}
			return sel;
		}
		
		return null;
	}

}
