/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.extensions.wsrm.common.serialization;

import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import org.jboss.ws.extensions.wsrm.api.RMException;
import org.jboss.ws.extensions.wsrm.common.serialization.RMSerializationHelper;
import org.jboss.ws.extensions.wsrm.common.serialization.RMSerializer;
import org.jboss.ws.extensions.wsrm.protocol.RMConstants;
import org.jboss.ws.extensions.wsrm.protocol.RMProvider;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMSequence;
import org.jboss.ws.extensions.wsrm.protocol.spi.RMSerializable;

final class RMSequenceSerializer
implements RMSerializer {
    private static final RMSerializer INSTANCE = new RMSequenceSerializer();

    private RMSequenceSerializer() {
    }

    static RMSerializer getInstance() {
        return INSTANCE;
    }

    public final void deserialize(RMSerializable object, RMProvider provider, SOAPMessage soapMessage) throws RMException {
        RMSequence o = (RMSequence)object;
        try {
            SOAPHeader soapHeader = soapMessage.getSOAPPart().getEnvelope().getHeader();
            RMConstants wsrmConstants = provider.getConstants();
            QName sequenceQName = wsrmConstants.getSequenceQName();
            SOAPElement sequenceElement = RMSerializationHelper.getRequiredElement((SOAPElement)soapHeader, sequenceQName, "soap header");
            QName identifierQName = wsrmConstants.getIdentifierQName();
            SOAPElement identifierElement = RMSerializationHelper.getRequiredElement(sequenceElement, identifierQName, sequenceQName);
            String identifier = RMSerializationHelper.getRequiredTextContent(identifierElement, identifierQName);
            o.setIdentifier(identifier);
            QName messageNumberQName = wsrmConstants.getMessageNumberQName();
            SOAPElement messageNumberElement = RMSerializationHelper.getRequiredElement(sequenceElement, messageNumberQName, sequenceQName);
            String messageNumberString = RMSerializationHelper.getRequiredTextContent(messageNumberElement, messageNumberQName);
            long messageNumberValue = RMSerializationHelper.stringToLong(messageNumberString, "Unable to parse MessageNumber element text content");
            o.setMessageNumber(messageNumberValue);
            QName lastMessageQName = wsrmConstants.getLastMessageQName();
            SOAPElement lastMessageElement = RMSerializationHelper.getOptionalElement(sequenceElement, lastMessageQName, sequenceQName);
            if (lastMessageElement != null) {
                o.setLastMessage();
            }
        }
        catch (SOAPException se) {
            throw new RMException("Unable to deserialize RM message", se);
        }
        catch (RuntimeException re) {
            throw new RMException("Unable to deserialize RM message", re);
        }
    }

    public final void serialize(RMSerializable object, RMProvider provider, SOAPMessage soapMessage) throws RMException {
        RMSequence o = (RMSequence)object;
        try {
            SOAPEnvelope soapEnvelope = soapMessage.getSOAPPart().getEnvelope();
            RMConstants wsrmConstants = provider.getConstants();
            soapEnvelope.addNamespaceDeclaration(wsrmConstants.getPrefix(), wsrmConstants.getNamespaceURI());
            QName sequenceQName = wsrmConstants.getSequenceQName();
            SOAPElement sequenceElement = soapEnvelope.getHeader().addChildElement(sequenceQName);
            QName identifierQName = wsrmConstants.getIdentifierQName();
            sequenceElement.addChildElement(identifierQName).setValue(o.getIdentifier());
            QName messageNumberQName = wsrmConstants.getMessageNumberQName();
            SOAPElement messageNumberElement = sequenceElement.addChildElement(messageNumberQName);
            messageNumberElement.setValue(String.valueOf(o.getMessageNumber()));
            if (o.isLastMessage()) {
                QName lastMessageQName = wsrmConstants.getLastMessageQName();
                sequenceElement.addChildElement(lastMessageQName);
            }
        }
        catch (SOAPException se) {
            throw new RMException("Unable to serialize RM message", se);
        }
    }
}

