/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.ast.tree;

import antlr.RecognitionException;
import antlr.SemanticException;
import antlr.collections.AST;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.QueryException;
import org.hibernate.engine.JoinSequence;
import org.hibernate.hql.ast.SqlGenerator;
import org.hibernate.hql.ast.tree.FromClause;
import org.hibernate.hql.ast.tree.FromElement;
import org.hibernate.hql.ast.tree.FromElementFactory;
import org.hibernate.hql.ast.tree.FromReferenceNode;
import org.hibernate.hql.ast.util.SessionFactoryHelper;
import org.hibernate.persister.collection.QueryableCollection;
import org.hibernate.type.CollectionType;
import org.hibernate.type.Type;

public class IndexNode
extends FromReferenceNode {
    private static final Log log = LogFactory.getLog((Class)IndexNode.class);

    public void setScalarColumnText(int i) throws SemanticException {
        throw new UnsupportedOperationException("An IndexNode cannot generate column text!");
    }

    public void prepareForDot(String propertyName) throws SemanticException {
        FromElement fromElement = this.getFromElement();
        if (fromElement == null) {
            throw new IllegalStateException("No FROM element for index operator!");
        }
        QueryableCollection queryableCollection = fromElement.getQueryableCollection();
        if (queryableCollection != null && !queryableCollection.isOneToMany()) {
            FromReferenceNode collectionNode = (FromReferenceNode)this.getFirstChild();
            String path = collectionNode.getPath() + "[]." + propertyName;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating join for many-to-many elements for " + path));
            }
            FromElementFactory factory = new FromElementFactory(fromElement.getFromClause(), fromElement, path);
            FromElement elementJoin = factory.createElementJoin(queryableCollection);
            this.setFromElement(elementJoin);
        }
    }

    public void resolveIndex(AST parent) throws SemanticException {
        throw new UnsupportedOperationException();
    }

    public void resolve(boolean generateJoin, boolean implicitJoin, String classAlias, AST parent) throws SemanticException {
        String path;
        if (this.isResolved()) {
            return;
        }
        FromReferenceNode collectionNode = (FromReferenceNode)this.getFirstChild();
        SessionFactoryHelper sessionFactoryHelper = this.getSessionFactoryHelper();
        collectionNode.resolveIndex((AST)this);
        Type type = collectionNode.getDataType();
        if (!type.isCollectionType()) {
            throw new SemanticException("The [] operator cannot be applied to type " + type.toString());
        }
        String collectionRole = ((CollectionType)type).getRole();
        QueryableCollection queryableCollection = sessionFactoryHelper.requireQueryableCollection(collectionRole);
        if (!queryableCollection.hasIndex()) {
            throw new QueryException("unindexed fromElement before []: " + collectionNode.getPath());
        }
        FromElement fromElement = collectionNode.getFromElement();
        String elementTable = fromElement.getTableAlias();
        FromClause fromClause = fromElement.getFromClause();
        FromElement elem = fromClause.findCollectionJoin(path = collectionNode.getPath());
        if (elem == null) {
            FromElementFactory factory = new FromElementFactory(fromClause, fromElement, path);
            elem = factory.createCollectionElementsJoin(queryableCollection, elementTable);
            if (log.isDebugEnabled()) {
                log.debug((Object)("No FROM element found for the elements of collection join path " + path + ", created " + elem));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("FROM element found for collection join path " + path));
        }
        AST index = collectionNode.getNextSibling();
        if (index == null) {
            throw new QueryException("No index value!");
        }
        this.setFromElement(fromElement);
        String collectionTableAlias = elementTable;
        if (elem.getCollectionTableAlias() != null) {
            collectionTableAlias = elem.getCollectionTableAlias();
        }
        JoinSequence joinSequence = fromElement.getJoinSequence();
        String[] indexCols = queryableCollection.getIndexColumnNames();
        if (indexCols.length != 1) {
            throw new QueryException("composite-index appears in []: " + collectionNode.getPath());
        }
        SqlGenerator gen = new SqlGenerator(this.getSessionFactoryHelper().getFactory());
        try {
            gen.simpleExpr(index);
        }
        catch (RecognitionException e) {
            throw new QueryException(e.getMessage(), e);
        }
        String expression = gen.getSQL();
        joinSequence.addCondition(collectionTableAlias + '.' + indexCols[0] + " = " + expression);
        String[] elementColumns = queryableCollection.getElementColumnNames(elementTable);
        this.setText(elementColumns[0]);
        this.setResolved();
    }
}

