/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.context;

import com.sun.faces.el.ELContextImpl;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.application.ApplicationFactory;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseStream;
import javax.faces.context.ResponseWriter;
import javax.faces.lifecycle.Lifecycle;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FacesContextImpl
extends FacesContext {
    private static final String FACESCONTEXT_IMPL_ATTR_NAME = "com.sun.faces.FacesContextImpl";
    private static Logger LOGGER = FacesLogger.CONTEXT.getLogger();
    private boolean released;
    private ResponseStream responseStream = null;
    private ResponseWriter responseWriter = null;
    private ExternalContext externalContext = null;
    private Application application = null;
    private UIViewRoot viewRoot = null;
    private ELContext elContext = null;
    private RenderKitFactory rkFactory;
    private RenderKit lastRk;
    private String lastRkId;
    private Map<String, List<FacesMessage>> componentMessageLists;
    private boolean renderResponse = false;
    private boolean responseComplete = false;

    public FacesContextImpl() {
    }

    public FacesContextImpl(ExternalContext ec, Lifecycle lifecycle) {
        if (null == ec) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "ec"));
        }
        if (null == lifecycle) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "lifecycle"));
        }
        this.externalContext = ec;
        FacesContextImpl.setCurrentInstance((FacesContext)this);
        this.externalContext.getRequestMap().put(FACESCONTEXT_IMPL_ATTR_NAME, this);
        this.rkFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
    }

    public ExternalContext getExternalContext() {
        this.assertNotReleased();
        return this.externalContext;
    }

    public Application getApplication() {
        this.assertNotReleased();
        if (null != this.application) {
            return this.application;
        }
        ApplicationFactory aFactory = (ApplicationFactory)FactoryFinder.getFactory((String)"javax.faces.application.ApplicationFactory");
        this.application = aFactory.getApplication();
        assert (null != this.application);
        return this.application;
    }

    public ELContext getELContext() {
        this.assertNotReleased();
        if (this.elContext == null) {
            this.elContext = new ELContextImpl(this.getApplication().getELResolver());
            this.elContext.putContext(FacesContext.class, (Object)this);
            UIViewRoot root = this.getViewRoot();
            if (null != root) {
                this.elContext.setLocale(root.getLocale());
            }
        }
        return this.elContext;
    }

    public Iterator<String> getClientIdsWithMessages() {
        this.assertNotReleased();
        return this.componentMessageLists == null ? Collections.emptyList().iterator() : this.componentMessageLists.keySet().iterator();
    }

    public FacesMessage.Severity getMaximumSeverity() {
        this.assertNotReleased();
        FacesMessage.Severity max = FacesMessage.SEVERITY_INFO;
        if (null == this.componentMessageLists) {
            return null;
        }
        List<FacesMessage> messages = this.getMergedMessageLists();
        int size = messages.size();
        for (int i = 0; i < size; ++i) {
            FacesMessage.Severity s = messages.get(i).getSeverity();
            if (s.getOrdinal() > max.getOrdinal()) {
                max = s;
            }
            if (FacesMessage.SEVERITY_FATAL.equals(max)) break;
        }
        return max;
    }

    public Iterator<FacesMessage> getMessages() {
        List<FacesMessage> messages;
        this.assertNotReleased();
        if (null == this.componentMessageLists) {
            List emptyList = Collections.emptyList();
            return emptyList.iterator();
        }
        Map requestMap = this.getExternalContext().getRequestMap();
        if (requestMap.containsKey("com.sun.faces.clientIdMessagesNotDisplayed")) {
            Set pendingClientIds = (Set)requestMap.get("com.sun.faces.clientIdMessagesNotDisplayed");
            pendingClientIds.clear();
        }
        if ((messages = this.getMergedMessageLists()).size() > 0) {
            return messages.iterator();
        }
        List emptyList = Collections.emptyList();
        return emptyList.iterator();
    }

    public Iterator<FacesMessage> getMessages(String clientId) {
        this.assertNotReleased();
        Map requestMap = this.getExternalContext().getRequestMap();
        Set pendingClientIds = (Set)requestMap.get("com.sun.faces.clientIdMessagesNotDisplayed");
        if (pendingClientIds != null && !pendingClientIds.isEmpty()) {
            pendingClientIds.remove(clientId);
        }
        if (null == this.componentMessageLists) {
            List emptyList = Collections.emptyList();
            return emptyList.iterator();
        }
        List<FacesMessage> list = this.componentMessageLists.get(clientId);
        if (list == null) {
            List emptyList = Collections.emptyList();
            return emptyList.iterator();
        }
        return list.iterator();
    }

    public RenderKit getRenderKit() {
        this.assertNotReleased();
        UIViewRoot vr = this.getViewRoot();
        if (vr == null) {
            return null;
        }
        String renderKitId = vr.getRenderKitId();
        if (renderKitId == null) {
            return null;
        }
        if (renderKitId.equals(this.lastRkId)) {
            return this.lastRk;
        }
        this.lastRk = this.rkFactory.getRenderKit((FacesContext)this, renderKitId);
        this.lastRkId = renderKitId;
        return this.lastRk;
    }

    public ResponseStream getResponseStream() {
        this.assertNotReleased();
        return this.responseStream;
    }

    public void setResponseStream(ResponseStream newResponseStream) {
        this.assertNotReleased();
        if (newResponseStream == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_RESPONSE_STREAM_ERROR", new Object[0]));
        }
        this.responseStream = newResponseStream;
    }

    public UIViewRoot getViewRoot() {
        this.assertNotReleased();
        return this.viewRoot;
    }

    public void setViewRoot(UIViewRoot root) {
        this.assertNotReleased();
        if (root == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "root"));
        }
        this.viewRoot = root;
    }

    public ResponseWriter getResponseWriter() {
        this.assertNotReleased();
        return this.responseWriter;
    }

    public void setResponseWriter(ResponseWriter newResponseWriter) {
        this.assertNotReleased();
        if (newResponseWriter == null) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_RESPONSE_WRITER_ERROR", new Object[0]));
        }
        this.responseWriter = newResponseWriter;
    }

    public void addMessage(String clientId, FacesMessage message) {
        List<FacesMessage> list;
        this.assertNotReleased();
        if (null == message) {
            throw new NullPointerException(MessageUtils.getExceptionMessageString("com.sun.faces.NULL_PARAMETERS_ERROR", "message"));
        }
        if (this.componentMessageLists == null) {
            this.componentMessageLists = new LinkedHashMap<String, List<FacesMessage>>();
        }
        if ((list = this.componentMessageLists.get(clientId)) == null) {
            list = new ArrayList<FacesMessage>();
            this.componentMessageLists.put(clientId, list);
        }
        list.add(message);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Adding Message[sourceId=" + (clientId != null ? clientId : "<<NONE>>") + ",summary=" + message.getSummary() + ")");
        }
    }

    public void release() {
        this.externalContext.getRequestMap().remove(FACESCONTEXT_IMPL_ATTR_NAME);
        this.externalContext.getRequestMap().remove("com.sun.faces.clientIdMessagesNotDisplayed");
        this.released = true;
        this.externalContext = null;
        this.responseStream = null;
        this.responseWriter = null;
        this.componentMessageLists = null;
        this.renderResponse = false;
        this.responseComplete = false;
        this.viewRoot = null;
        FacesContextImpl.setCurrentInstance(null);
    }

    public void renderResponse() {
        this.assertNotReleased();
        this.renderResponse = true;
    }

    public void responseComplete() {
        this.assertNotReleased();
        this.responseComplete = true;
    }

    public boolean getRenderResponse() {
        this.assertNotReleased();
        return this.renderResponse;
    }

    public boolean getResponseComplete() {
        this.assertNotReleased();
        return this.responseComplete;
    }

    private void assertNotReleased() {
        if (this.released) {
            throw new IllegalStateException();
        }
    }

    private List<FacesMessage> getMergedMessageLists() {
        ArrayList<FacesMessage> mergedList = new ArrayList<FacesMessage>();
        if (this.componentMessageLists != null) {
            Iterator<List<FacesMessage>> i = this.componentMessageLists.values().iterator();
            while (i.hasNext()) {
                Iterator<FacesMessage> ii = i.next().iterator();
                while (ii.hasNext()) {
                    mergedList.add(ii.next());
                }
            }
        }
        return mergedList;
    }
}

