package org.jboss.eap.util.xp.patch.stream.manager;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;

import org.jboss.eap.util.xp.patch.stream.manager.server.wrapper.ServerException;
import org.jboss.eap.util.xp.patch.stream.manager.server.wrapper.ServerWrapperProxy;

/**
 * @author <a href="mailto:kabir.khan@jboss.com">Kabir Khan</a>
 */
public class ManagerPatchApplyAction extends ManagerAction {
    private final Path patch;
    private final ServerWrapperProxy serverWrapperProxy;

    public ManagerPatchApplyAction(ManagerStatus managerStatus, ServerWrapperProxy serverWrapperProxy, Path patch) {
        super(ManagerCommand.PATCH_APPLY, managerStatus, null, true);
        this.patch = patch;
        this.serverWrapperProxy = serverWrapperProxy;
    }

    @Override
    Status doExecute() throws Exception {
        PatchXml.Validator xml = PatchXml.parse(PatchXml.findPatchXmlInZip(patch));
        if (xml.isXpPatch()) {
            String patchStream = xml.getPatchStreamName();
            if (status.getManagerState() != ManagerState.INSTALLED) {
                throw ManagerLogger.LOGGER.patchApplyForXPPatchCanOnlyBeAppliedOncePatchStreamIsEnabled(patchStream);
            }
            ManagerManifestConfig.XPConfig config = ManagerManifestConfig.INSTANCE.getCurrentXpConfig();
            Set<String> currentStreams = new HashSet<>(config.getPatchStreamNames());
            if (!currentStreams.contains(patchStream)) {
                throw ManagerLogger.LOGGER.patchApplyForWrongXPPatchStream(patchStream, config.getPatchStreamNames());
            }
        }

        try {
            serverWrapperProxy.start();
            serverWrapperProxy.applyPatch(patch);
            return Status.OK;
        } catch (ServerException e) {
            return Status.ERROR;
        } finally {
            serverWrapperProxy.stop();
        }
    }
}
