package org.jboss.eap.util.xp.patch.stream.manager;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Set;

/**
 * @author <a href="mailto:kabir.khan@jboss.com">Kabir Khan</a>
 */
public abstract class ManagerAction {

    private final ManagerCommand managerCommand;
    protected final ManagerStatus status;
    protected final ManagerState toManagerState;
    protected final boolean supportPolicyAccepted;

    public ManagerAction(ManagerCommand managerCommand, ManagerStatus status, ManagerState toManagerState, boolean supportPolicyAccepted) {
        this.managerCommand = managerCommand;
        this.status = status;
        this.toManagerState = toManagerState;
        this.supportPolicyAccepted = supportPolicyAccepted;

        if (!managerCommand.isAlwaysAvailable()) {
            Set<ManagerCommand> availableCommands = status.getAvailableCommands();
            if (!availableCommands.contains(managerCommand)) {
                System.err.println(ManagerLogger.LOGGER.commandNotAvailableInCurrentContext(managerCommand));
                System.exit(1);
            }
        }
    }

    ManagerState getToManagerState() {
        return toManagerState;
    }

    abstract Status doExecute() throws Exception;

    final Status execute() throws Exception {
        acceptSupportLevel();
        return doExecute();
    }

    private void acceptSupportLevel() throws IOException {
        ManagerState toState = getToManagerState();
        if (toState != ManagerState.CLEAN && toState != ManagerState.INSTALLED) {
            return;
        }
        System.out.println();
        if (toState == ManagerState.INSTALLED) {
            System.out.println(ManagerLogger.LOGGER.xpSupportPolicy());
        } else {
            System.out.println(ManagerLogger.LOGGER.xpRemoveSupportPolicy());
        }

        if (supportPolicyAccepted) {
            System.out.println();
            System.out.println(ManagerLogger.LOGGER.supportPolicyAcceptedWithArg());
            return;
        }

        boolean accepted = false;

        while (!accepted) {
            System.out.println();
            System.out.print(ManagerLogger.LOGGER.acceptSupportPolicy() + " ");

            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String answer = reader.readLine().toLowerCase();
            if (answer.equals("yes") || answer.equals("y")) {
                accepted = true;
                System.out.println();
            }  else if (answer.equals("no") || answer.equals("n")) {
                System.exit(0);
            } else {
                System.out.println(ManagerLogger.LOGGER.invalidSupportPolicyResponse());
            }
        }
    }

    /**
     * Status of performed action. Would be used to determine status code of the JVM process.
     */
    public enum Status {
        OK, ERROR;
    }
}
