/*
 * Decompiled with CFR 0.152.
 */
package org.junitee.runner;

import junit.framework.Test;
import junit.framework.TestCase;

public class TestInfo {
    private Test test;
    private String testClassName;
    private String testName;
    private long elapsedTime;
    private Throwable error;
    private Throwable failure;

    public TestInfo(Test test) {
        this.test = test;
        if (test instanceof TestCase) {
            this.testClassName = test.getClass().getName();
            this.testName = ((TestCase)test).getName();
        }
    }

    public Test getTest() {
        return this.test;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public void setElapsedTime(long elapsedTime) {
        this.elapsedTime = elapsedTime;
    }

    public String getTestClassName() {
        return this.testClassName;
    }

    public String getTestName() {
        return this.testName;
    }

    public boolean isTestCase() {
        return this.testClassName != null && this.testName != null;
    }

    public void setError(Throwable t) {
        this.error = t;
    }

    public void setFailure(Throwable t) {
        this.failure = t;
    }

    public boolean hasFailure() {
        return this.failure != null;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public boolean successful() {
        return !this.hasError() && !this.hasFailure();
    }

    public Throwable getFailure() {
        return this.failure;
    }

    public Throwable getError() {
        return this.error;
    }

    public String toString() {
        return this.test.toString();
    }
}

