/*
 * Decompiled with CFR 0.152.
 */
package org.jbpm.bpel.variable.exe;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.jbpm.bpel.BpelException;
import org.jbpm.bpel.graph.exe.BpelFaultException;
import org.jbpm.bpel.variable.def.MessageType;
import org.jbpm.bpel.xml.BpelConstants;
import org.jbpm.bpel.xml.util.XmlUtil;
import org.w3c.dom.Element;

public class MessageValue {
    long id;
    private MessageType type;
    private Map parts;

    MessageValue() {
    }

    public MessageValue(MessageType type) {
        this.type = type;
    }

    public MessageType getType() {
        return this.type;
    }

    public void setType(MessageType type) {
        this.type = type;
    }

    public Element getPart(String partName) {
        Element part = (Element)this.getParts().get(partName);
        if (part == null) {
            Part wsdlPart = this.type.getMessage().getPart(partName);
            if (wsdlPart == null) {
                throw new BpelException("undefined part: " + partName);
            }
            throw new BpelFaultException(BpelConstants.FAULT_UNINITIALIZED_VARIABLE);
        }
        return part;
    }

    public Element getPartForAssign(String partName) {
        Map parts = this.getParts();
        Element part = (Element)parts.get(partName);
        if (part == null) {
            Part wsdlPart = this.type.getMessage().getPart(partName);
            if (wsdlPart == null) {
                throw new BpelException("undefined part: " + partName);
            }
            QName elementName = wsdlPart.getElementName();
            part = elementName != null ? XmlUtil.createElement(elementName) : XmlUtil.createElement(partName);
            parts.put(partName, part);
        }
        return part;
    }

    public void setPart(String partName, Object value) {
        Element part = this.getPartForAssign(partName);
        XmlUtil.setObjectValue(part, value);
    }

    public Map getParts() {
        if (this.parts == null) {
            this.parts = new HashMap();
        }
        return this.parts;
    }

    public void setParts(Map newParts) {
        if (this.parts == null) {
            this.parts = new HashMap();
        } else {
            this.parts.clear();
        }
        Map wsdlParts = this.type.getMessage().getParts();
        Iterator partEntryIt = newParts.entrySet().iterator();
        while (partEntryIt.hasNext()) {
            Map.Entry partEntry = partEntryIt.next();
            Object partName = partEntry.getKey();
            if (!wsdlParts.containsKey(partName)) {
                throw new BpelException("undefined part: " + partName);
            }
            this.parts.put(partName, partEntry.getValue());
        }
    }

    public boolean isInitialized() {
        Map wsdlParts = this.type.getMessage().getParts();
        return wsdlParts == null || wsdlParts.isEmpty() ? true : this.parts != null && !this.parts.isEmpty();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("type", (Object)this.type).append("parts", (Object)this.parts).append("id", this.id).toString();
    }
}

