/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.validator;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.validator.Arg;
import org.apache.commons.validator.Msg;
import org.apache.commons.validator.ValidatorUtil;
import org.apache.commons.validator.Var;

public class Field
implements Cloneable,
Serializable {
    public static final String ARG_DEFAULT = "org.apache.commons.validator.Field.DEFAULT";
    public static final String TOKEN_INDEXED = "[]";
    protected static final String TOKEN_START = "${";
    protected static final String TOKEN_END = "}";
    protected static final String TOKEN_VAR = "var:";
    protected String property = null;
    protected String indexedProperty = null;
    protected String indexedListProperty = null;
    protected String key = null;
    protected String depends = null;
    protected int page = 0;
    protected int fieldOrder = 0;
    protected FastHashMap hDependencies = new FastHashMap();
    protected FastHashMap hVars = new FastHashMap();
    protected FastHashMap hMsgs = new FastHashMap();
    protected FastHashMap hArg0 = new FastHashMap();
    protected FastHashMap hArg1 = new FastHashMap();
    protected FastHashMap hArg2 = new FastHashMap();
    protected FastHashMap hArg3 = new FastHashMap();

    public int getPage() {
        return this.page;
    }

    public void setPage(int n) {
        this.page = n;
    }

    public int getFieldOrder() {
        return this.fieldOrder;
    }

    public void setFieldOrder(int n) {
        this.fieldOrder = n;
    }

    public String getProperty() {
        return this.property;
    }

    public void setProperty(String string) {
        this.property = string;
    }

    public String getIndexedProperty() {
        return this.indexedProperty;
    }

    public void setIndexedProperty(String string) {
        this.indexedProperty = string;
    }

    public String getIndexedListProperty() {
        return this.indexedListProperty;
    }

    public void setIndexedListProperty(String string) {
        this.indexedListProperty = string;
    }

    public String getDepends() {
        return this.depends;
    }

    public void setDepends(String string) {
        this.depends = string;
    }

    public void addMsg(Msg msg) {
        if (msg != null && msg.getKey() != null && msg.getKey().length() > 0 && msg.getName() != null && msg.getName().length() > 0) {
            this.hMsgs.put((Object)msg.getName(), (Object)msg.getKey());
        }
    }

    public String getMsg(String string) {
        return (String)this.hMsgs.get((Object)string);
    }

    public void addArg0(Arg arg) {
        if (arg != null && arg.getKey() != null && arg.getKey().length() > 0) {
            if (arg.getName() != null && arg.getName().length() > 0) {
                this.hArg0.put((Object)arg.getName(), (Object)arg);
            } else {
                this.hArg0.put((Object)ARG_DEFAULT, (Object)arg);
            }
        }
    }

    public Arg getArg0() {
        return (Arg)this.hArg0.get((Object)ARG_DEFAULT);
    }

    public Arg getArg0(String string) {
        Object object = this.hArg0.get((Object)string);
        return object != null ? (Arg)object : this.getArg0();
    }

    public void addArg1(Arg arg) {
        if (arg != null && arg.getKey() != null && arg.getKey().length() > 0) {
            if (arg.getName() != null && arg.getName().length() > 0) {
                this.hArg1.put((Object)arg.getName(), (Object)arg);
            } else {
                this.hArg1.put((Object)ARG_DEFAULT, (Object)arg);
            }
        }
    }

    public Arg getArg1() {
        return (Arg)this.hArg1.get((Object)ARG_DEFAULT);
    }

    public Arg getArg1(String string) {
        Object object = this.hArg1.get((Object)string);
        return object != null ? (Arg)object : this.getArg1();
    }

    public void addArg2(Arg arg) {
        if (arg != null && arg.getKey() != null && arg.getKey().length() > 0) {
            if (arg.getName() != null && arg.getName().length() > 0) {
                this.hArg2.put((Object)arg.getName(), (Object)arg);
            } else {
                this.hArg2.put((Object)ARG_DEFAULT, (Object)arg);
            }
        }
    }

    public Arg getArg2() {
        return (Arg)this.hArg2.get((Object)ARG_DEFAULT);
    }

    public Arg getArg2(String string) {
        Object object = this.hArg2.get((Object)string);
        return object != null ? (Arg)object : this.getArg2();
    }

    public void addArg3(Arg arg) {
        if (arg != null && arg.getKey() != null && arg.getKey().length() > 0) {
            if (arg.getName() != null && arg.getName().length() > 0) {
                this.hArg3.put((Object)arg.getName(), (Object)arg);
            } else {
                this.hArg3.put((Object)ARG_DEFAULT, (Object)arg);
            }
        }
    }

    public Arg getArg3() {
        return (Arg)this.hArg3.get((Object)ARG_DEFAULT);
    }

    public Arg getArg3(String string) {
        Object object = this.hArg3.get((Object)string);
        return object != null ? (Arg)object : this.getArg3();
    }

    public void addVar(Var var) {
        if (var != null && var.getName() != null && var.getName().length() > 0 && var.getValue() != null) {
            this.hVars.put((Object)var.getName(), (Object)var);
        }
    }

    public void addVarParam(String string, String string2, String string3) {
        if (string != null && string.length() > 0 && string2 != null) {
            this.hVars.put((Object)string, (Object)new Var(string, string2, string3));
        }
    }

    public Var getVar(String string) {
        return (Var)this.hVars.get((Object)string);
    }

    public String getVarValue(String string) {
        String string2 = null;
        Object object = this.hVars.get((Object)string);
        if (object != null && object instanceof Var) {
            Var var = (Var)object;
            string2 = var.getValue();
        }
        return string2;
    }

    public Map getVars() {
        return Collections.unmodifiableMap(this.hVars);
    }

    public String getKey() {
        if (this.key == null) {
            this.generateKey();
        }
        return this.key;
    }

    public void setKey(String string) {
        this.key = string;
    }

    public boolean isIndexed() {
        return this.indexedListProperty != null && this.indexedListProperty.length() > 0;
    }

    public void generateKey() {
        this.key = this.isIndexed() ? this.indexedListProperty + TOKEN_INDEXED + "." + this.property : this.property;
    }

    public void process(Map map, Map map2) {
        Object object;
        String string;
        Object object2;
        Object object3;
        Object object4;
        this.hMsgs.setFast(true);
        this.hArg0.setFast(true);
        this.hArg1.setFast(true);
        this.hArg2.setFast(true);
        this.hArg3.setFast(true);
        this.hVars.setFast(true);
        this.generateKey();
        Iterator iterator = map2.keySet().iterator();
        while (iterator.hasNext()) {
            object4 = (String)iterator.next();
            object3 = TOKEN_START + (String)object4 + TOKEN_END;
            object2 = (String)map2.get(object4);
            this.property = ValidatorUtil.replace(this.property, (String)object3, (String)object2);
            this.processVars((String)object3, (String)object2);
            this.processMessageComponents((String)object3, (String)object2);
        }
        object4 = map.keySet().iterator();
        while (object4.hasNext()) {
            object3 = (String)object4.next();
            object2 = TOKEN_START + (String)object3 + TOKEN_END;
            string = (String)map.get(object3);
            this.property = ValidatorUtil.replace(this.property, (String)object2, string);
            this.processVars((String)object2, string);
            this.processMessageComponents((String)object2, string);
        }
        object3 = this.hVars.keySet().iterator();
        while (object3.hasNext()) {
            object2 = (String)object3.next();
            string = "${var:" + (String)object2 + TOKEN_END;
            object = (Var)this.hVars.get(object2);
            String string2 = ((Var)object).getValue();
            this.processMessageComponents(string, string2);
        }
        if (this.getDepends() != null) {
            object2 = new StringTokenizer(this.getDepends(), ",");
            string = "";
            while (((StringTokenizer)object2).hasMoreTokens()) {
                object = ((StringTokenizer)object2).nextToken().trim();
                if (object == null || ((String)object).length() <= 0) continue;
                this.hDependencies.put(object, (Object)string);
            }
            this.hDependencies.setFast(true);
        }
    }

    private void processVars(String string, String string2) {
        Iterator iterator = this.hVars.keySet().iterator();
        while (iterator.hasNext()) {
            String string3 = (String)iterator.next();
            Var var = (Var)this.hVars.get((Object)string3);
            var.setValue(ValidatorUtil.replace(var.getValue(), string, string2));
        }
    }

    public void processMessageComponents(String string, String string2) {
        String string3 = "${var:";
        if (string != null && !string.startsWith(string3)) {
            Iterator iterator = this.hMsgs.keySet().iterator();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                String string5 = (String)this.hMsgs.get((Object)string4);
                this.hMsgs.put((Object)string4, (Object)ValidatorUtil.replace(string5, string, string2));
            }
        }
        this.processArg((Map)this.hArg0, string, string2);
        this.processArg((Map)this.hArg1, string, string2);
        this.processArg((Map)this.hArg2, string, string2);
        this.processArg((Map)this.hArg3, string, string2);
    }

    private void processArg(Map map, String string, String string2) {
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            Arg arg = (Arg)iterator.next();
            if (arg == null) continue;
            arg.setKey(ValidatorUtil.replace(arg.getKey(), string, string2));
        }
    }

    public boolean isDependency(String string) {
        if (this.hDependencies != null) {
            return this.hDependencies.containsKey((Object)string);
        }
        return false;
    }

    public Collection getDependencies() {
        return Collections.unmodifiableMap(this.hDependencies).keySet();
    }

    public Object clone() {
        try {
            Field field = (Field)super.clone();
            if (this.key != null) {
                field.setKey(new String(this.key));
            }
            if (this.property != null) {
                field.setProperty(new String(this.property));
            }
            if (this.indexedProperty != null) {
                field.setIndexedProperty(new String(this.indexedProperty));
            }
            if (this.indexedListProperty != null) {
                field.setIndexedListProperty(new String(this.indexedListProperty));
            }
            if (this.depends != null) {
                field.setDepends(new String(this.depends));
            }
            field.hDependencies = ValidatorUtil.copyFastHashMap(this.hDependencies);
            field.hVars = ValidatorUtil.copyFastHashMap(this.hVars);
            field.hMsgs = ValidatorUtil.copyFastHashMap(this.hMsgs);
            field.hArg0 = ValidatorUtil.copyFastHashMap(this.hArg0);
            field.hArg1 = ValidatorUtil.copyFastHashMap(this.hArg1);
            field.hArg2 = ValidatorUtil.copyFastHashMap(this.hArg2);
            field.hArg3 = ValidatorUtil.copyFastHashMap(this.hArg3);
            return field;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\t\tkey=                 " + this.key + "\n");
        stringBuffer.append("\t\tproperty=            " + this.property + "\n");
        stringBuffer.append("\t\tindexedProperty=     " + this.indexedProperty + "\n");
        stringBuffer.append("\t\tindexedListProperty= " + this.indexedListProperty + "\n");
        stringBuffer.append("\t\tdepends=             " + this.depends + "\n");
        stringBuffer.append("\t\tpage=                " + this.page + "\n");
        stringBuffer.append("\t\tfieldOrder=          " + this.fieldOrder + "\n");
        if (this.hVars != null) {
            stringBuffer.append("\t\tVars:\n");
            Iterator iterator = this.hVars.keySet().iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                stringBuffer.append("\t\t\t");
                stringBuffer.append(e);
                stringBuffer.append("=");
                stringBuffer.append(this.hVars.get(e));
                stringBuffer.append("\n");
            }
        }
        return stringBuffer.toString();
    }
}

