/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.context;

import com.icesoft.faces.application.D2DViewHandler;
import com.icesoft.faces.context.BridgeExternalContext;
import com.icesoft.faces.context.BridgeFacesContext;
import com.icesoft.faces.context.DOMSerializer;
import com.icesoft.faces.context.effects.JavascriptContext;
import com.icesoft.faces.renderkit.ApplicationBaseLocator;
import com.icesoft.faces.util.DOMUtils;
import com.icesoft.faces.webapp.xmlhttp.ResponseState;
import java.beans.Beans;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMResponseWriter
extends ResponseWriter {
    private static final Log log = LogFactory.getLog((Class)DOMResponseWriter.class);
    public static final String STREAM_WRITING = "com.icesoft.faces.streamWriting";
    public static final String DOCTYPE_PUBLIC = "com.icesoft.doctype.public";
    public static final String DOCTYPE_SYSTEM = "com.icesoft.doctype.system";
    public static final String DOCTYPE_ROOT = "com.icesoft.doctype.root";
    public static final String DOCTYPE_OUTPUT = "com.icesoft.doctype.output";
    public static final String DOCTYPE_PRETTY_PRINTING = "com.icesoft.doctype.prettyprinting";
    public static final String RESPONSE_DOM = "com.icesoft.domResponseDocument";
    public static final String RESPONSE_DOM_ID = "com.icesoft.domResponseDocumentID";
    public static final String OLD_DOM = "com.icesoft.oldDocument";
    public static final String RESPONSE_VIEWROOT = "com.icesoft.domResponseViewRoot";
    public static final String RESPONSE_CONTEXTS_TABLE = "com.icesoft.domResponseContexts";
    public static final String RESPONSE_CONTEXT_SERVLET_TABLE = "com.icesoft.domResponseContextServlet";
    public static final String RESPONSE_MODIFIED_NODES = "com.icesoft.domResponseContextModNodes";
    public static final String USE_DOM_DIFF = "com.icesoft.faces.useDOMDiff";
    private static DocumentBuilder DOCUMENT_BUILDER;
    private static boolean isStreamWritingFlag;
    private String contentType;
    private String encoding;
    private Writer writer;
    private Document document;
    private Document oldDocument;
    private Node cursor;
    private Map domResponseContexts;
    private Map contextServletTable;

    public DOMResponseWriter(Writer writer, String contentType, String encoding) {
        this.writer = writer;
        this.initialize();
        this.contentType = contentType == null ? "text/html" : contentType;
        DOMResponseWriter.checkEncoding(encoding);
        this.encoding = encoding;
    }

    Map getDomResponseContexts() {
        return this.domResponseContexts;
    }

    public Node getCursorParent() {
        return this.cursor;
    }

    Document getDocument() {
        return this.document;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCharacterEncoding() {
        return this.encoding;
    }

    public void startDocument() throws IOException {
    }

    private void initialize() {
        FacesContext context = FacesContext.getCurrentInstance();
        this.contextServletTable = D2DViewHandler.getContextServletTable(context);
        if (this.contextServletTable.containsKey(RESPONSE_CONTEXTS_TABLE)) {
            this.domResponseContexts = (Map)this.contextServletTable.get(RESPONSE_CONTEXTS_TABLE);
        }
        if (null == this.domResponseContexts) {
            this.domResponseContexts = new HashMap();
            this.contextServletTable.put(RESPONSE_CONTEXTS_TABLE, this.domResponseContexts);
        }
        this.contextServletTable.put(RESPONSE_VIEWROOT, context.getViewRoot());
        this.document = DOCUMENT_BUILDER.newDocument();
        this.cursor = this.document;
        this.contextServletTable.put(RESPONSE_DOM, this.document);
        boolean streamWritingParam = "true".equalsIgnoreCase(context.getExternalContext().getInitParameter(STREAM_WRITING));
        isStreamWritingFlag = Beans.isDesignTime() || streamWritingParam;
    }

    public void endDocument() throws IOException {
        if (null != this.writer) {
            this.writer.flush();
        }
    }

    public void flush() throws IOException {
    }

    public void startElement(String name, UIComponent componentForElement) throws IOException {
        Node oldCursor = this.cursor;
        Element elem = this.document.createElement(name);
        this.cursor = this.cursor.appendChild(elem);
        if (log.isTraceEnabled()) {
            log.trace((Object)("startElement()  name: " + name + "  elem: " + elem + "  oldCursor: " + oldCursor + "  newCursor: " + this.cursor));
        }
    }

    public void endElement(String name) throws IOException {
        Node oldCursor = this.cursor;
        this.cursor = this.cursor.getParentNode();
        if (log.isTraceEnabled()) {
            log.trace((Object)("endElement()  name: " + name + "  oldCursor: " + oldCursor + "  newCursor: " + this.cursor));
        }
    }

    public void writeAttribute(String name, Object value, String componentPropertyName) throws IOException {
        ((Element)this.cursor).setAttribute(name.trim(), String.valueOf(value));
    }

    public void writeURIAttribute(String name, Object value, String componentPropertyName) throws IOException {
        String stringValue = String.valueOf(value);
        if (stringValue.startsWith("javascript:")) {
            ((Element)this.cursor).setAttribute(name, stringValue);
        } else {
            ((Element)this.cursor).setAttribute(name, stringValue.replace(' ', '+'));
        }
    }

    public void writeComment(Object comment) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("writeComment()  comment: " + comment));
        }
        this.cursor.appendChild(this.document.createComment(String.valueOf(comment)));
    }

    public void writeText(Object text, String componentPropertyName) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("writeText(O,S)  text: " + text));
        }
        this.cursor.appendChild(this.document.createTextNode(String.valueOf(text)));
    }

    public void writeText(char[] text, int off, int len) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("writeText(c[],i,i)  text: " + new String(text, off, len)));
        }
        this.cursor.appendChild(this.document.createTextNode(new String(text, off, len)));
    }

    public ResponseWriter cloneWithWriter(Writer writer) {
        if (null != this.document) {
            try {
                this.writeDOM();
            }
            catch (IOException e) {
                throw new IllegalStateException(e.toString());
            }
        }
        try {
            return new DOMResponseWriter(writer, this.getContentType(), this.getCharacterEncoding());
        }
        catch (FacesException e) {
            throw new IllegalStateException();
        }
    }

    public void close() throws IOException {
        this.writer.close();
    }

    public void write(char[] cbuf, int off, int len) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("writeText(c[],i,i)  str: " + new String(cbuf, off, len)));
        }
        this.cursor.appendChild(this.document.createTextNode(new String(cbuf, off, len)));
    }

    public void write(int c) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("write(i)  hex: " + Integer.toHexString(c) + "  decimal: " + c));
        }
        this.cursor.appendChild(this.document.createTextNode(String.valueOf((char)c)));
    }

    public void write(String str) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("write(S)  str: " + str));
        }
        this.cursor.appendChild(this.document.createTextNode(str));
    }

    public void write(String str, int off, int len) throws IOException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("write(S,i,i)  str_sub: " + str.substring(off, len)));
        }
        this.cursor.appendChild(this.document.createTextNode(str.substring(off, len)));
    }

    public void writeDOM() throws IOException {
        if (DOMResponseWriter.isStreamWriting()) {
            return;
        }
        this.enhanceAndFixDocument();
        FacesContext facesContext = FacesContext.getCurrentInstance();
        if (!(facesContext instanceof BridgeFacesContext)) {
            if (log.isErrorEnabled()) {
                log.error((Object)"ICEfaces requires the PersistentFacesServlet. Please check your web.xml servlet mappings");
            }
            throw new IllegalStateException("ICEfaces requires the PersistentFacesServlet. Please check your web.xml servlet mappings");
        }
        BridgeExternalContext externalContext = (BridgeExternalContext)facesContext.getExternalContext();
        Map sessionMap = externalContext.getApplicationSessionMap();
        String viewNumber = ((BridgeFacesContext)facesContext).getViewNumber();
        ResponseState nodeWriter = (ResponseState)sessionMap.get(viewNumber + "/" + ResponseState.STATE);
        Object session = null;
        if (null != nodeWriter) {
            this.oldDocument = (Document)sessionMap.get(this.getOldDOMKey());
            if (null != this.oldDocument) {
                int i;
                Node[] changed = DOMUtils.domDiff(this.oldDocument, this.document);
                for (i = 0; i < changed.length; ++i) {
                    Element changeRoot = DOMUtils.ascendToNodeWithID(changed[i]);
                    for (int j = 0; j < i; ++j) {
                        if (changed[j] == null) continue;
                        if (changeRoot == changed[j]) {
                            changeRoot = null;
                            break;
                        }
                        if (this.isAncestor(changeRoot, changed[j])) {
                            changed[j] = null;
                            continue;
                        }
                        if (!this.isAncestor(changed[j], changeRoot)) continue;
                        changeRoot = null;
                        break;
                    }
                    changed[i] = changeRoot;
                }
                for (i = 0; i < changed.length; ++i) {
                    Element element = (Element)changed[i];
                    if (null == element) continue;
                    nodeWriter.writeElement(element);
                }
            }
            nodeWriter.flush();
        }
        sessionMap.put(this.getOldDOMKey(), this.document);
        if (null != this.writer) {
            this.writeDOM(this.writer);
        }
    }

    private void enhanceAndFixDocument() {
        Element html = this.document.getDocumentElement();
        html = "html".equals(html.getTagName()) ? html : this.fixHtml();
        Element head = (Element)this.document.getElementsByTagName("head").item(0);
        this.enhanceHead(head == null ? this.fixHead(html) : head);
        Element body = (Element)this.document.getElementsByTagName("body").item(0);
        this.enhanceBody(body == null ? this.fixBody(html) : body);
    }

    private void enhanceBody(Element body) {
        String focusId;
        HttpServletRequest httpRequest;
        FacesContext facesContext = FacesContext.getCurrentInstance();
        body.setAttribute("id", "body");
        Element iframe = this.document.createElement("iframe");
        body.insertBefore(iframe, body.getFirstChild());
        iframe.setAttribute("id", "history-frame");
        Object request = facesContext.getExternalContext().getRequest();
        String frameURI = request instanceof HttpServletRequest ? ((httpRequest = (HttpServletRequest)request).getRequestURI() == null ? "about:blank" : httpRequest.getContextPath() + "/xmlhttp/blank.iface") : "about:blank";
        iframe.setAttribute("src", frameURI);
        iframe.setAttribute("frameborder", "0");
        iframe.setAttribute("style", "z-index: 10000; visibility: hidden; width: 0; height: 0; opacity: 0.22; filter: alpha(opacity=22);");
        if (facesContext instanceof BridgeFacesContext && (focusId = ((BridgeFacesContext)facesContext).getFocusId()) != null && !focusId.equals("null")) {
            JavascriptContext.focus(facesContext, focusId);
        }
        Element script = (Element)body.appendChild(this.document.createElement("script"));
        script.setAttribute("id", "dynamic-code");
        script.setAttribute("language", "javascript");
        String calls = JavascriptContext.getJavascriptCalls(facesContext);
        script.appendChild(this.document.createTextNode(calls));
    }

    private void enhanceHead(Element head) {
        Element meta = (Element)head.appendChild(this.document.createElement("meta"));
        meta.setAttribute("name", "icefaces");
        meta.setAttribute("content", "Rendered by ICEFaces\u00e2\u0084\u00a2 D2D");
        Element noscript = (Element)head.appendChild(this.document.createElement("noscript"));
        Element noscriptMeta = (Element)noscript.appendChild(this.document.createElement("meta"));
        noscriptMeta.setAttribute("http-equiv", "refresh");
        noscriptMeta.setAttribute("content", "0;url=./xmlhttp/javascript-blocked");
        FacesContext facesContext = FacesContext.getCurrentInstance();
        String base = ApplicationBaseLocator.locate(facesContext);
        ArrayList<String> libs = new ArrayList<String>();
        libs.add("xmlhttp/icefaces-d2d.js");
        if (facesContext.getExternalContext().getRequestMap().get("javax.servlet.include.servlet_path") == null) {
            libs.addAll(Arrays.asList(JavascriptContext.getIncludedLibs(facesContext)));
        }
        Iterator iterator = libs.iterator();
        while (iterator.hasNext()) {
            String lib = (String)iterator.next();
            Element script = (Element)head.appendChild(this.document.createElement("script"));
            script.setAttribute("language", "javascript");
            script.setAttribute("src", base + lib);
        }
    }

    private Element fixHtml() {
        Element root = this.document.getDocumentElement();
        Element html = this.document.createElement("html");
        this.document.replaceChild(html, root);
        html.appendChild(root);
        return html;
    }

    private Element fixBody(Element html) {
        int i;
        Element body = this.document.createElement("body");
        NodeList children = html.getChildNodes();
        int length = children.getLength();
        Node[] nodes = new Node[length];
        for (i = 0; i < nodes.length; ++i) {
            nodes[i] = children.item(i);
        }
        for (i = 0; i < nodes.length; ++i) {
            Node node = nodes[i];
            if (node instanceof Element && "head".equals(((Element)node).getTagName())) continue;
            body.appendChild(node);
        }
        html.appendChild(body);
        return body;
    }

    private Element fixHead(Element html) {
        Element head = this.document.createElement("head");
        html.insertBefore(head, html.getFirstChild());
        return head;
    }

    private void writeDOM(Writer writer) throws IOException {
        FacesContext context = FacesContext.getCurrentInstance();
        Map requestMap = context.getExternalContext().getRequestMap();
        String includeServletPath = (String)requestMap.get("javax.servlet.include.servlet_path");
        String portletParam = (String)requestMap.get("com.sun.faces.portlet.INIT");
        if (null != includeServletPath || null != portletParam) {
            Node body = DOMUtils.getChildByNodeName(this.document.getDocumentElement(), "body");
            if (null != body) {
                FacesContext facesContext = FacesContext.getCurrentInstance();
                String base = ApplicationBaseLocator.locate(facesContext);
                writer.write("<script language='javascript' src='" + base + "xmlhttp/icefaces-d2d.js'></script>");
                writer.write(DOMUtils.childrenToString(body));
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"null body");
                log.debug((Object)DOMUtils.DOMtoString(this.document));
            }
        } else {
            String publicID = (String)requestMap.get(DOCTYPE_PUBLIC);
            String systemID = (String)requestMap.get(DOCTYPE_SYSTEM);
            String root = (String)requestMap.get(DOCTYPE_ROOT);
            String output = (String)requestMap.get(DOCTYPE_OUTPUT);
            boolean prettyPrinting = Boolean.valueOf((String)requestMap.get(DOCTYPE_PRETTY_PRINTING));
            if (output == null || "html".equals(output) && !prettyPrinting) {
                if (publicID != null && systemID != null && root != null) {
                    writer.write(DOMUtils.DocumentTypetoString(publicID, systemID, root));
                }
                writer.write(DOMUtils.DOMtoString(this.document));
            } else {
                try {
                    DOMSerializer serializer = new DOMSerializer(writer, publicID, systemID);
                    if ("xml".equals(output)) {
                        serializer.outputAsXML();
                    } else {
                        serializer.outputAsHTML();
                    }
                    if (prettyPrinting) {
                        serializer.printPretty();
                    }
                    serializer.serialize(this.document);
                }
                catch (TransformerException e) {
                    new IOException(e.getMessage());
                }
            }
        }
        writer.flush();
    }

    protected void setCursorParent(Node cursorParent) {
        this.cursor = cursorParent;
    }

    boolean isAncestor(Node test, Node child) {
        if (test == null || child == null) {
            return false;
        }
        if (!test.hasChildNodes()) {
            return false;
        }
        Node parent = child;
        while ((parent = parent.getParentNode()) != null) {
            if (!test.equals(parent)) continue;
            return true;
        }
        return false;
    }

    String getOldDOMKey() {
        FacesContext context = FacesContext.getCurrentInstance();
        String viewNumber = "-";
        if (context instanceof BridgeFacesContext) {
            viewNumber = ((BridgeFacesContext)context).getViewNumber();
        }
        return DOMResponseWriter.getOldDOMKey(viewNumber);
    }

    public static String getOldDOMKey(String viewNumber) {
        return viewNumber + "/" + OLD_DOM;
    }

    private static void checkEncoding(String encoding) throws IllegalArgumentException {
        try {
            new String(new byte[]{65}, encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalArgumentException("Unsupported Encoding " + encoding);
        }
    }

    public static void applyBrowserDOMChanges(BridgeFacesContext facesContext) {
        ExternalContext externalContext = facesContext.getExternalContext();
        Document document = (Document)externalContext.getSessionMap().get(DOMResponseWriter.getOldDOMKey(facesContext.getViewNumber()));
        if (document == null) {
            return;
        }
        Map parameters = externalContext.getRequestParameterValuesMap();
        NodeList inputElements = document.getElementsByTagName("input");
        int inputElementsLength = inputElements.getLength();
        for (int i = 0; i < inputElementsLength; ++i) {
            Element inputElement = (Element)inputElements.item(i);
            String id = inputElement.getAttribute("id");
            if (!parameters.containsKey(id)) continue;
            String value = ((String[])parameters.get(id))[0];
            inputElement.setAttribute("value", value);
        }
        NodeList textareaElements = document.getElementsByTagName("textarea");
        int textareaElementsLength = textareaElements.getLength();
        for (int i = 0; i < textareaElementsLength; ++i) {
            Element textareaElement = (Element)textareaElements.item(i);
            String id = textareaElement.getAttribute("id");
            if (!parameters.containsKey(id)) continue;
            String value = ((String[])parameters.get(id))[0];
            textareaElement.getFirstChild().setNodeValue(value);
        }
        NodeList selectElements = document.getElementsByTagName("select");
        int selectElementsLength = selectElements.getLength();
        for (int i = 0; i < selectElementsLength; ++i) {
            Element selectElement = (Element)selectElements.item(i);
            String id = selectElement.getAttribute("id");
            if (!parameters.containsKey(id)) continue;
            List<String> values = Arrays.asList((String[])parameters.get(id));
            NodeList optionElements = selectElement.getElementsByTagName("option");
            int optionElementsLength = optionElements.getLength();
            for (int j = 0; j < optionElementsLength; ++j) {
                Element optionElement = (Element)optionElements.item(j);
                if (values.contains(optionElement.getAttribute("value"))) {
                    optionElement.setAttribute("selected", "selected");
                    continue;
                }
                optionElement.removeAttribute("selected");
            }
        }
    }

    public static boolean isStreamWriting() {
        return isStreamWritingFlag;
    }

    static {
        try {
            DOCUMENT_BUILDER = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"Cannot acquire a DocumentBuilder", (Throwable)e);
        }
        isStreamWritingFlag = false;
    }
}

