/*
 * Decompiled with CFR 0.152.
 */
package de.hunsicker.antlr;

import de.hunsicker.antlr.CharScanner;
import de.hunsicker.antlr.RecognitionException;
import de.hunsicker.antlr.collections.impl.BitSet;

public class MismatchedCharException
extends RecognitionException {
    public static final int CHAR = 1;
    public static final int NOT_CHAR = 2;
    public static final int RANGE = 3;
    public static final int NOT_RANGE = 4;
    public static final int SET = 5;
    public static final int NOT_SET = 6;
    public int mismatchType;
    public char foundChar;
    public int expecting;
    public int upper;
    public BitSet set;
    public CharScanner scanner;

    public MismatchedCharException() {
        super("Mismatched char");
    }

    public MismatchedCharException(char c, char lower, char upper_, boolean matchNot, CharScanner scanner_) {
        super("Mismatched char", scanner_.getFilename(), scanner_.getLine(), scanner_.getColumn());
        this.mismatchType = matchNot ? 4 : 3;
        this.foundChar = c;
        this.expecting = lower;
        this.upper = upper_;
        this.scanner = scanner_;
    }

    public MismatchedCharException(char c, char expecting_, boolean matchNot, CharScanner scanner_) {
        super("Mismatched char", scanner_.getFilename(), scanner_.getLine(), scanner_.getColumn());
        this.mismatchType = matchNot ? 2 : 1;
        this.foundChar = c;
        this.expecting = expecting_;
        this.scanner = scanner_;
    }

    public MismatchedCharException(char c, BitSet set_, boolean matchNot, CharScanner scanner_) {
        super("Mismatched char", scanner_.getFilename(), scanner_.getLine(), scanner_.getColumn());
        this.mismatchType = matchNot ? 6 : 5;
        this.foundChar = c;
        this.set = set_;
        this.scanner = scanner_;
    }

    public String getMessage() {
        StringBuffer sb = new StringBuffer();
        switch (this.mismatchType) {
            case 1: {
                sb.append("expecting '" + (char)this.expecting + "', found '" + this.foundChar + "'");
                break;
            }
            case 2: {
                sb.append("expecting anything but '" + (char)this.expecting + "'; got it anyway");
                break;
            }
            case 3: {
                sb.append("expecting token in range: '" + (char)this.expecting + "'..'" + (char)this.upper + "', found '" + this.foundChar + "'");
                break;
            }
            case 4: {
                sb.append("expecting token NOT in range: " + (char)this.expecting + "'..'" + (char)this.upper + "', found '" + this.foundChar + "'");
                break;
            }
            case 5: 
            case 6: {
                sb.append("expecting " + (this.mismatchType == 6 ? "NOT " : "") + "one of (");
                int[] elems = this.set.toArray();
                int i = 0;
                while (i < elems.length) {
                    sb.append(" '");
                    sb.append((char)elems[i]);
                    sb.append("'");
                    ++i;
                }
                sb.append("), found '" + this.foundChar + "'");
                break;
            }
            default: {
                sb.append(super.getMessage());
            }
        }
        return sb.toString();
    }
}

