/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resource.adapter.jdbc;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jboss.resource.adapter.jdbc.StatementAccess;
import org.jboss.resource.adapter.jdbc.WrappedConnection;
import org.jboss.resource.adapter.jdbc.WrappedResultSet;

public class WrappedStatement
implements Statement,
StatementAccess,
org.jboss.ejb.plugins.cmp.jdbc.WrappedStatement {
    private final WrappedConnection lc;
    private final Statement s;
    private HashMap resultSets;
    private boolean closed = false;
    private Object lock = new Object();

    public WrappedStatement(WrappedConnection lc, Statement s) {
        this.lc = lc;
        this.s = s;
        lc.registerStatement(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new SQLException("Already closed");
            }
            this.closed = true;
        }
        this.lc.unregisterStatement(this);
        this.internalClose();
    }

    public boolean execute(String sql) throws SQLException {
        this.checkTransaction();
        try {
            this.checkConfiguredQueryTimeout();
            return this.s.execute(sql);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkTransaction();
        try {
            this.checkConfiguredQueryTimeout();
            return this.s.execute(sql, autoGeneratedKeys);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        this.checkTransaction();
        try {
            this.checkConfiguredQueryTimeout();
            return this.s.execute(sql, columnIndexes);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        this.checkTransaction();
        try {
            this.checkConfiguredQueryTimeout();
            return this.s.execute(sql, columnNames);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Connection getConnection() throws SQLException {
        return this.lc;
    }

    public SQLWarning getWarnings() throws SQLException {
        this.checkState();
        try {
            return this.s.getWarnings();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void clearWarnings() throws SQLException {
        this.checkState();
        try {
            this.s.clearWarnings();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkTransaction();
        try {
            this.checkConfiguredQueryTimeout();
            ResultSet result = this.s.executeQuery(sql);
            return this.registerResultSet(result);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public int executeUpdate(String sql) throws SQLException {
        this.checkTransaction();
        try {
            this.checkConfiguredQueryTimeout();
            return this.s.executeUpdate(sql);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkTransaction();
        try {
            this.checkConfiguredQueryTimeout();
            return this.s.executeUpdate(sql, autoGeneratedKeys);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        this.checkTransaction();
        try {
            this.checkConfiguredQueryTimeout();
            return this.s.executeUpdate(sql, columnIndexes);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        this.checkTransaction();
        try {
            this.checkConfiguredQueryTimeout();
            return this.s.executeUpdate(sql, columnNames);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public int getMaxFieldSize() throws SQLException {
        this.checkState();
        try {
            return this.s.getMaxFieldSize();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this.checkState();
        try {
            this.s.setMaxFieldSize(max);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public int getMaxRows() throws SQLException {
        this.checkState();
        try {
            return this.s.getMaxRows();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setMaxRows(int max) throws SQLException {
        this.checkState();
        try {
            this.s.setMaxRows(max);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this.checkState();
        try {
            this.s.setEscapeProcessing(enable);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public int getQueryTimeout() throws SQLException {
        this.checkState();
        try {
            return this.s.getQueryTimeout();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setQueryTimeout(int timeout) throws SQLException {
        this.checkState();
        try {
            this.s.setQueryTimeout(timeout);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void cancel() throws SQLException {
        this.checkState();
        try {
            this.s.cancel();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setCursorName(String name) throws SQLException {
        this.checkState();
        try {
            this.s.setCursorName(name);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public ResultSet getResultSet() throws SQLException {
        this.checkState();
        try {
            ResultSet result = this.s.getResultSet();
            if (result == null) {
                return null;
            }
            return this.registerResultSet(result);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public int getUpdateCount() throws SQLException {
        this.checkState();
        try {
            return this.s.getUpdateCount();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public boolean getMoreResults() throws SQLException {
        this.checkState();
        try {
            return this.s.getMoreResults();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public boolean getMoreResults(int current) throws SQLException {
        this.checkState();
        try {
            return this.s.getMoreResults(current);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setFetchDirection(int direction) throws SQLException {
        this.checkState();
        try {
            this.s.setFetchDirection(direction);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public int getFetchDirection() throws SQLException {
        this.checkState();
        try {
            return this.s.getFetchDirection();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void setFetchSize(int rows) throws SQLException {
        this.checkState();
        try {
            this.s.setFetchSize(rows);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public int getFetchSize() throws SQLException {
        this.checkState();
        try {
            return this.s.getFetchSize();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public int getResultSetConcurrency() throws SQLException {
        this.checkState();
        try {
            return this.s.getResultSetConcurrency();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public int getResultSetType() throws SQLException {
        this.checkState();
        try {
            return this.s.getResultSetType();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void addBatch(String sql) throws SQLException {
        this.checkState();
        try {
            this.s.addBatch(sql);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public void clearBatch() throws SQLException {
        this.checkState();
        try {
            this.s.clearBatch();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public int[] executeBatch() throws SQLException {
        this.checkState();
        try {
            this.checkConfiguredQueryTimeout();
            return this.s.executeBatch();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        this.checkState();
        try {
            ResultSet resultSet = this.s.getGeneratedKeys();
            return this.registerResultSet(resultSet);
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public int getResultSetHoldability() throws SQLException {
        this.checkState();
        try {
            return this.s.getResultSetHoldability();
        }
        catch (Throwable t) {
            throw this.checkException(t);
        }
    }

    public Statement getUnderlyingStatement() throws SQLException {
        this.checkState();
        return this.s;
    }

    protected SQLException checkException(Throwable t) throws SQLException {
        throw this.lc.checkException(t);
    }

    protected void checkTransaction() throws SQLException {
        this.checkState();
        this.lc.checkTransaction();
    }

    protected void checkConfiguredQueryTimeout() throws SQLException {
        this.lc.checkConfiguredQueryTimeout(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void internalClose() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            this.closed = true;
        }
        try {
            this.closeResultSets();
        }
        finally {
            this.s.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkState() throws SQLException {
        Object object = this.lock;
        synchronized (object) {
            if (this.closed) {
                throw new SQLException("The statement is closed.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResultSet registerResultSet(ResultSet resultSet) {
        if (resultSet != null) {
            resultSet = new WrappedResultSet(this, resultSet);
        }
        if (this.lc.getTrackStatements() == 0) {
            return resultSet;
        }
        WrappedStatement wrappedStatement = this;
        synchronized (wrappedStatement) {
            if (this.resultSets == null) {
                this.resultSets = new HashMap();
            }
            if (this.lc.getTrackStatements() == 1) {
                this.resultSets.put(resultSet, new Throwable("STACKTRACE"));
            } else {
                this.resultSets.put(resultSet, null);
            }
        }
        return resultSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterResultSet(WrappedResultSet resultSet) {
        if (this.lc.getTrackStatements() == 0) {
            return;
        }
        WrappedStatement wrappedStatement = this;
        synchronized (wrappedStatement) {
            if (this.resultSets != null) {
                this.resultSets.remove(resultSet);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeResultSets() {
        if (this.lc.getTrackStatements() == 0) {
            return;
        }
        WrappedStatement wrappedStatement = this;
        synchronized (wrappedStatement) {
            if (this.resultSets == null) {
                return;
            }
            Iterator i = this.resultSets.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                WrappedResultSet resultSet = (WrappedResultSet)entry.getKey();
                if (this.lc.getTrackStatements() == 1) {
                    Throwable stackTrace = (Throwable)entry.getValue();
                    this.lc.getLogger().warn("Closing a result set you left open! Please close it yourself.", stackTrace);
                }
                try {
                    resultSet.internalClose();
                }
                catch (Throwable t) {
                    this.lc.getLogger().warn("Error closing a result set you left open! Please close it yourself.", t);
                }
            }
            this.resultSets.clear();
        }
    }
}

