/*
 * Decompiled with CFR 0.152.
 */
package org.testng;

import java.util.ArrayList;
import java.util.List;
import org.testng.ITestContext;
import org.testng.ITestListener;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestListenerAdapter
implements ITestListener {
    private List<ITestNGMethod> m_allTestMethods = new ArrayList<ITestNGMethod>();
    private List<ITestResult> m_passedTests = new ArrayList<ITestResult>();
    private List<ITestResult> m_failedTests = new ArrayList<ITestResult>();
    private List<ITestResult> m_skippedTests = new ArrayList<ITestResult>();
    private List<ITestResult> m_failedButWithinSuccessPercentageTests = new ArrayList<ITestResult>();

    @Override
    public void onTestSuccess(ITestResult tr) {
        this.m_allTestMethods.add(tr.getMethod());
        this.m_passedTests.add(tr);
    }

    @Override
    public void onTestFailure(ITestResult tr) {
        this.m_allTestMethods.add(tr.getMethod());
        this.m_failedTests.add(tr);
    }

    @Override
    public void onTestSkipped(ITestResult tr) {
        this.m_allTestMethods.add(tr.getMethod());
        this.m_skippedTests.add(tr);
    }

    @Override
    public void onTestFailedButWithinSuccessPercentage(ITestResult tr) {
        this.m_allTestMethods.add(tr.getMethod());
        this.m_failedButWithinSuccessPercentageTests.add(tr);
    }

    protected ITestNGMethod[] getAllTestMethods() {
        return this.m_allTestMethods.toArray(new ITestNGMethod[this.m_allTestMethods.size()]);
    }

    @Override
    public void onStart(ITestContext testContext) {
    }

    @Override
    public void onFinish(ITestContext testContext) {
    }

    public List<ITestResult> getFailedButWithinSuccessPercentageTests() {
        return this.m_failedButWithinSuccessPercentageTests;
    }

    public List<ITestResult> getFailedTests() {
        return this.m_failedTests;
    }

    public List<ITestResult> getPassedTests() {
        return this.m_passedTests;
    }

    public List<ITestResult> getSkippedTests() {
        return this.m_skippedTests;
    }

    private static void ppp(String s) {
        System.out.println("[TestListenerAdapter] " + s);
    }

    public void setAllTestMethods(List<ITestNGMethod> allTestMethods) {
        this.m_allTestMethods = allTestMethods;
    }

    public void setFailedButWithinSuccessPercentageTests(List<ITestResult> failedButWithinSuccessPercentageTests) {
        this.m_failedButWithinSuccessPercentageTests = failedButWithinSuccessPercentageTests;
    }

    public void setFailedTests(List<ITestResult> failedTests) {
        this.m_failedTests = failedTests;
    }

    public void setPassedTests(List<ITestResult> passedTests) {
        this.m_passedTests = passedTests;
    }

    public void setSkippedTests(List<ITestResult> skippedTests) {
        this.m_skippedTests = skippedTests;
    }

    @Override
    public void onTestStart(ITestResult result) {
    }
}

