/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.xml.ws.util;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ByteArrayBuffer
extends OutputStream {
    private byte[] buf;
    private int count;

    public ByteArrayBuffer() {
        this(32);
    }

    public ByteArrayBuffer(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException();
        }
        this.buf = new byte[size];
    }

    public ByteArrayBuffer(byte[] data) {
        this.buf = data;
    }

    public void write(InputStream in) throws IOException {
        int cap;
        int sz;
        while ((sz = in.read(this.buf, this.count, cap = this.buf.length - this.count)) >= 0) {
            this.count += sz;
            if (cap != sz) continue;
            this.ensureCapacity(this.buf.length * 2);
        }
        return;
    }

    public void write(int b) {
        int newcount = this.count + 1;
        this.ensureCapacity(newcount);
        this.buf[this.count] = (byte)b;
        this.count = newcount;
    }

    public void write(byte[] b, int off, int len) {
        int newcount = this.count + len;
        this.ensureCapacity(newcount);
        System.arraycopy(b, off, this.buf, this.count, len);
        this.count = newcount;
    }

    private void ensureCapacity(int newcount) {
        if (newcount > this.buf.length) {
            byte[] newbuf = new byte[Math.max(this.buf.length << 1, newcount)];
            System.arraycopy(this.buf, 0, newbuf, 0, this.count);
            this.buf = newbuf;
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    public void reset() {
        this.count = 0;
    }

    public byte[] toByteArray() {
        byte[] newbuf = new byte[this.count];
        System.arraycopy(this.buf, 0, newbuf, 0, this.count);
        return newbuf;
    }

    public int size() {
        return this.count;
    }

    public void close() {
    }

    public InputStream newInputStream() {
        return new ByteArrayInputStream(this.buf, 0, this.count);
    }

    public InputStream newInputStream(int start, int length) {
        return new ByteArrayInputStream(this.buf, start, length);
    }
}

