/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import java.io.IOException;
import java.util.HashSet;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import org.ajax4jsf.ajax.repeat.DataVisitor;
import org.ajax4jsf.ajax.repeat.Range;
import org.richfaces.component.LastElementAware;
import org.richfaces.component.TreeDataModel;
import org.richfaces.component.TreeNode;
import org.richfaces.component.TreeNodeImpl;
import org.richfaces.component.TreeRowKey;
import org.richfaces.component.state.TreeRange;

public class CacheableTreeDataModel
extends TreeDataModel
implements StateHolder {
    private TreeDataModel treeDataModel;
    private HashSet leafSet = new HashSet();

    public boolean isLeaf() {
        return !this.leafSet.contains(this.getRowKey());
    }

    public CacheableTreeDataModel() {
        this.setWrappedData(new TreeNodeImpl());
    }

    public void walkModel(FacesContext context, DataVisitor visitor, TreeRange range, TreeRowKey key, Object argument, boolean last) throws IOException {
        this.treeDataModel.walkModel(context, new Visitor(visitor), range, key, argument, last);
    }

    public void setTreeDataModel(TreeDataModel treeDataModel) {
        this.treeDataModel = treeDataModel;
    }

    public void walk(FacesContext context, DataVisitor dataVisitor, Range range, TreeRowKey rowKey, Object argument, boolean last) throws IOException {
        if (rowKey == null && ((TreeNode)this.getWrappedData()).isLeaf() || this.locateTreeNode(rowKey) == null) {
            this.treeDataModel.walk(context, new Visitor(dataVisitor), range, rowKey, argument, last);
        } else {
            super.walk(context, dataVisitor, range, rowKey, argument, last);
        }
    }

    public void setRowData(Object object) {
        this.locateTreeNode((TreeRowKey)this.getRowKey()).setData(object);
    }

    public boolean isTransient() {
        return false;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] _state = (Object[])state;
        this.setWrappedData(_state[0]);
        this.leafSet = (HashSet)_state[1];
    }

    public Object saveState(FacesContext context) {
        Object[] state = new Object[]{this.getWrappedData(), this.leafSet};
        return state;
    }

    public void setTransient(boolean newTransientValue) {
        if (newTransientValue) {
            throw new IllegalArgumentException("ReplaceableTreeDataModel shouldn't be transient!");
        }
    }

    private final class Visitor
    implements DataVisitor,
    LastElementAware {
        private final DataVisitor visitor;

        private Visitor(DataVisitor visitor) {
            this.visitor = visitor;
        }

        public void process(FacesContext context, Object rowKey, Object argument) throws IOException {
            CacheableTreeDataModel.this.treeDataModel.setRowKey(rowKey);
            if (!CacheableTreeDataModel.this.treeDataModel.isLeaf()) {
                CacheableTreeDataModel.this.leafSet.add(rowKey);
            } else {
                CacheableTreeDataModel.this.leafSet.remove(rowKey);
            }
            CacheableTreeDataModel.this.locateTreeNode((TreeRowKey)rowKey, true).setData(CacheableTreeDataModel.this.treeDataModel.getRowData());
            if (this.visitor != null) {
                this.visitor.process(context, rowKey, argument);
            }
        }

        public void resetLastElement() {
            if (this.visitor instanceof LastElementAware) {
                ((LastElementAware)this.visitor).resetLastElement();
            }
        }

        public void setLastElement() {
            if (this.visitor instanceof LastElementAware) {
                ((LastElementAware)this.visitor).setLastElement();
            }
        }
    }
}

