/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.component;

import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIComponentBase;
import javax.faces.component.UIData;
import javax.faces.context.FacesContext;
import javax.faces.el.MethodBinding;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.FacesEvent;
import org.richfaces.event.DataScrollerAdapter;
import org.richfaces.event.DataScrollerEvent;
import org.richfaces.event.DataScrollerListener;
import org.richfaces.event.DataScrollerSource;

public abstract class UIDatascroller
extends UIComponentBase
implements DataScrollerSource {
    public static final String COMPONENT_TYPE = "org.richfaces.Datascroller";
    public static final String COMPONENT_FAMILY = "org.richfaces.Datascroller";
    public static final String FIRST_FACET_NAME = "first";
    public static final String LAST_FACET_NAME = "last";
    public static final String NEXT_FACET_NAME = "next";
    public static final String PREVIOUS_FACET_NAME = "previous";
    public static final String FAST_FORWARD_FACET_NAME = "fastforward";
    public static final String FAST_REWIND_FACET_NAME = "fastrewind";
    private transient UIData _UIData;
    private transient boolean allowCache;
    static /* synthetic */ Class class$org$richfaces$event$DataScrollerListener;
    static /* synthetic */ Class class$javax$faces$component$UIData;

    public void addScrollerListener(DataScrollerListener listener) {
        this.addFacesListener(listener);
    }

    public DataScrollerListener[] getScrollerListeners() {
        return (DataScrollerListener[])this.getFacesListeners(class$org$richfaces$event$DataScrollerListener == null ? (class$org$richfaces$event$DataScrollerListener = UIDatascroller.class$("org.richfaces.event.DataScrollerListener")) : class$org$richfaces$event$DataScrollerListener);
    }

    public void removeScrollerListener(DataScrollerListener listener) {
        this.removeFacesListener(listener);
    }

    public void broadcast(FacesEvent event) throws AbortProcessingException {
        super.broadcast(event);
        if (event instanceof DataScrollerEvent && this.getScrollerListeners().length < 1) {
            this.addScrollerListener(new DataScrollerAdapter(this.getScrollerListener()));
        }
    }

    public abstract MethodBinding getScrollerListener();

    public abstract void setScrollerListener(MethodBinding var1);

    public abstract void setFor(String var1);

    public abstract String getFor();

    public abstract int getFastStep();

    public abstract void setFastStep(int var1);

    public abstract boolean isRenderIfSinglePage();

    public abstract void setRenderIfSinglePage(boolean var1);

    public abstract int getMaxPages();

    public abstract void setMaxPages(int var1);

    public abstract boolean isRenderCurrentAsText();

    public abstract void setRenderCurrentAsText(boolean var1);

    public abstract String getSelectedStyleClass();

    public abstract void setSelectedStyleClass(String var1);

    public abstract String getSelectedStyle();

    public abstract void setSelectedStyle(String var1);

    public abstract String getEventsQueue();

    public abstract void setEventsQueue(String var1);

    public abstract boolean isAjaxSingle();

    public abstract void setAjaxSingle(boolean var1);

    public abstract int getRequestDelay();

    public abstract void setRequestDelay(int var1);

    public abstract String getTableStyleClass();

    public abstract void setTableStyleClass(String var1);

    public abstract String getStyleClass();

    public abstract String getStyle();

    public abstract void setStyleClass(String var1);

    public abstract void setStyle(String var1);

    public abstract String getHandleValue();

    public abstract void setHandleValue(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processUpdates(FacesContext context) {
        this.allowCache = false;
        this._UIData = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processValidators(FacesContext context) {
        this.allowCache = false;
        this._UIData = null;
    }

    public void processDecodes(FacesContext context) {
        try {
            this.decode(context);
        }
        catch (RuntimeException e) {
            context.renderResponse();
            throw e;
        }
        finally {
            this.allowCache = false;
            this._UIData = null;
        }
    }

    private UIData getUIData() {
        if (!this.allowCache) {
            this._UIData = this.getDataTable();
            this.allowCache = true;
        }
        return this._UIData;
    }

    protected UIData getDataTable() {
        String forAttribute = this.getFor();
        if (forAttribute == null) {
            UIDatascroller forComp = this;
            while ((forComp = forComp.getParent()) != null) {
                if (!(forComp instanceof UIData)) continue;
                this.setFor(forComp.getId());
                return (UIData)forComp;
            }
            throw new FacesException("could not dataTable for  datascroller " + this.getId());
        }
        UIComponent forComp = this.findComponent(forAttribute);
        if (forComp == null) {
            throw new IllegalArgumentException("could not dataTable with id '" + forAttribute + "'");
        }
        if (!(forComp instanceof UIData)) {
            throw new IllegalArgumentException("component with id '" + forAttribute + "' must be of type " + (class$javax$faces$component$UIData == null ? (class$javax$faces$component$UIData = UIDatascroller.class$("javax.faces.component.UIData")) : class$javax$faces$component$UIData).getName() + ", not type " + forComp.getClass().getName());
        }
        return (UIData)forComp;
    }

    public int getPageIndex() {
        UIData uiData = this.getUIData();
        int rows = this.getRows();
        if (0 == rows) {
            throw new FacesException("Missing 'rows' attribute on component '" + uiData.getId() + "'");
        }
        int pageIndex = rows > 0 ? this.getFirstRow() / rows + 1 : 0;
        if (this.getFirstRow() % rows > 0) {
            ++pageIndex;
        }
        return pageIndex;
    }

    public void setPage(String facetName) {
        UIData dataTable = this.getUIData();
        if (FIRST_FACET_NAME.equals(facetName)) {
            dataTable.setFirst(0);
        } else if (PREVIOUS_FACET_NAME.equals(facetName)) {
            int previous = dataTable.getFirst() - this.getRows();
            if (previous >= 0) {
                dataTable.setFirst(previous);
            }
        } else if (NEXT_FACET_NAME.equals(facetName)) {
            int next = dataTable.getFirst() + this.getRows();
            if (next > this.getMaxPages()) {
                next = this.getMaxPages();
            }
            if (next < this.getRowCount()) {
                dataTable.setFirst(next);
            }
        } else if (FAST_FORWARD_FACET_NAME.equals(facetName)) {
            int rowcount;
            int next;
            int fastStep = this.getFastStep();
            if (fastStep <= 0) {
                fastStep = 1;
            }
            if ((next = dataTable.getFirst() + this.getRows() * fastStep) >= (rowcount = this.getRowCount())) {
                next = rowcount - 1 - (rowcount - 1) % this.getRows();
            }
            if (next > this.getMaxPages()) {
                next = this.getMaxPages();
            }
            dataTable.setFirst(next);
        } else if (FAST_REWIND_FACET_NAME.equals(facetName)) {
            int previous;
            int fastStep = this.getFastStep();
            if (fastStep <= 0) {
                fastStep = 1;
            }
            if ((previous = dataTable.getFirst() - this.getRows() * fastStep) < 0) {
                previous = 0;
            }
            dataTable.setFirst(previous);
        } else if (LAST_FACET_NAME.equals(facetName)) {
            int first;
            int rows;
            int rowcount = this.getRowCount();
            int delta = rowcount % (rows = this.getRows());
            int n = first = delta > 0 && delta < rows ? rowcount - delta : rowcount - rows;
            if (first >= 0) {
                if (first > this.getMaxPages()) {
                    first = this.getMaxPages();
                }
                dataTable.setFirst(first);
            } else {
                dataTable.setFirst(0);
            }
        } else {
            int pageCount;
            int pageindex = Integer.parseInt(facetName);
            if (pageindex > (pageCount = this.getPageCount())) {
                pageindex = pageCount;
            } else if (pageindex <= 0) {
                pageindex = 1;
            }
            dataTable.setFirst(this.getRows() * (pageindex - 1));
        }
    }

    public void setPageIndex(int page) {
        UIData uiData = this.getUIData();
        int rows = this.getRows();
        if (0 == rows) {
            throw new FacesException("Missing 'rows' attribute on component '" + uiData.getId() + "'");
        }
        uiData.setFirst(page * rows);
    }

    public int getPageCount() {
        int pageCount;
        int rows = this.getRows();
        if (rows > 0) {
            int n = pageCount = rows <= 0 ? 1 : this.getRowCount() / rows;
            if (this.getRowCount() % rows > 0) {
                ++pageCount;
            }
        } else {
            rows = 1;
            pageCount = 1;
        }
        return pageCount;
    }

    public int getRowCount() {
        return this.BinarySearch(this.getUIData());
    }

    private int BinarySearch(UIData Data2) {
        int n = 1;
        int k = 2;
        while (true) {
            Data2.setRowIndex(k - 1);
            if (!Data2.isRowAvailable()) break;
            n = k;
            k *= 2;
        }
        while (n < k) {
            int kk = Math.round((n + k) / 2) + 1;
            Data2.setRowIndex(kk - 1);
            if (Data2.isRowAvailable()) {
                n = kk;
                continue;
            }
            k = kk - 1;
        }
        Data2.setRowIndex(k - 1);
        if (Data2.isRowAvailable()) {
            return k;
        }
        return 0;
    }

    public int getRows() {
        int row = 0;
        row = this.getUIData().getRows();
        if (row == 0) {
            row = this.getRowCount();
        }
        return row;
    }

    public UIComponent getFirst() {
        return this.getFacet(FIRST_FACET_NAME);
    }

    public UIComponent getLast() {
        return this.getFacet(LAST_FACET_NAME);
    }

    public UIComponent getNext() {
        return this.getFacet(NEXT_FACET_NAME);
    }

    public UIComponent getFastForward() {
        return this.getFacet(FAST_FORWARD_FACET_NAME);
    }

    public UIComponent getFastRewind() {
        return this.getFacet(FAST_REWIND_FACET_NAME);
    }

    public UIComponent getPrevious() {
        return this.getFacet(PREVIOUS_FACET_NAME);
    }

    public int getFirstRow() {
        return this.getUIData().getFirst();
    }

    public String getFamily() {
        return "org.richfaces.Datascroller";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

