/*
 * JBoss, Home of Professional Open Source.
 * Copyright 2007, Red Hat Middleware LLC, and individual contributors
 * as indicated by the @author tags. See the copyright.txt file in the
 * distribution for a full listing of individual contributors.
  *
 * This is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this software; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA, or see the FSF site: http://www.fsf.org.
 */
package org.jboss.ejb3.test.epcpropagation;

import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.ejb.Local;
import javax.ejb.Remote;
import javax.ejb.SessionContext;
import javax.ejb.Stateful;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.PersistenceContextType;
import javax.transaction.Status;
import javax.transaction.UserTransaction;

import org.jboss.logging.Logger;

/**
 * @author <a href="mailto:bdecoste@jboss.com">William DeCoste</a>
 */
@Stateful
@TransactionManagement(TransactionManagementType.BEAN)
@Remote(StatefulRemote.class)
public class StatefulBean implements StatefulRemote
{
   private static final Logger log = Logger.getLogger(StatefulBean.class);
   
   @PersistenceContext(type=PersistenceContextType.EXTENDED,unitName="mypc")
   EntityManager em;

   @Resource
   SessionContext sessionContext;

   @EJB
   StatelessRemote cmtBean;
   
   public boolean execute(Integer pId, String pName)
   {

      try
      {
         UserTransaction tx1 = sessionContext.getUserTransaction();
         log.info("!!!!! execute tx1 " + tx1 + " " + tx1.getStatus());
         tx1.begin();
         log.info("!!!!! execute begin " + tx1.getStatus());
         em.joinTransaction();
         MyEntity eb = em.find(MyEntity.class, pId);
         eb.setName(pName.toUpperCase());
         cmtBean.updateEntity(pId, pName.toLowerCase());
         UserTransaction tx2 = sessionContext.getUserTransaction();
         log.info("!!!!! execute tx2 " + tx2 + " " + tx2.getStatus());
         tx1.commit();
         
         log.info("!!!! execute state " + tx1.getStatus() + " " + tx2.getStatus() + " " + Status.STATUS_NO_TRANSACTION);
         return true;
      }
      catch (Exception e)
      {
         e.printStackTrace();
         try
         {
            sessionContext.getUserTransaction().rollback();
         }
         catch (Exception e1)
         {
            System.out.println("ROLLBACK: "+e1);
         }
         return false;
      }
   }
}