/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.stateless;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import javax.naming.Context;
import org.jboss.aop.Advisor;
import org.jboss.ejb3.Container;
import org.jboss.ejb3.ProxyFactory;
import org.jboss.ejb3.session.BaseSessionProxyFactory;
import org.jboss.logging.Logger;
import org.jboss.naming.Util;

public abstract class BaseStatelessProxyFactory
extends BaseSessionProxyFactory
implements ProxyFactory {
    private static final Logger log = Logger.getLogger(BaseStatelessProxyFactory.class);
    protected Class proxyClass;
    protected Constructor proxyConstructor;
    protected Context proxyFactoryContext;
    protected String jndiName;

    public void init() throws Exception {
        this.initializeJndiName();
        Class[] interfaces = this.getInterfaces();
        Class<?> proxyClass = Proxy.getProxyClass(this.container.getBeanClass().getClassLoader(), interfaces);
        Class[] constructorParams = new Class[]{InvocationHandler.class};
        this.proxyConstructor = proxyClass.getConstructor(constructorParams);
    }

    public void start() throws Exception {
        this.init();
        Object proxy = this.createProxy();
        Util.bind((Context)this.container.getInitialContext(), (String)this.jndiName, (Object)proxy);
    }

    public void stop() throws Exception {
        Util.unbind((Context)this.container.getInitialContext(), (String)this.jndiName);
    }

    protected abstract Class[] getInterfaces();

    protected abstract void initializeJndiName();

    public void setContainer(Container container) {
        this.container = container;
        this.advisor = (Advisor)container;
    }
}

