/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.util.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import org.jboss.logging.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class JBossEntityResolver
implements EntityResolver {
    private static final Logger log = Logger.getLogger(EntityResolver.class);
    private static Hashtable entities = new Hashtable();
    private boolean entityResolved = false;

    public static void registerEntity(String publicId, String dtdFileName) {
        entities.put(publicId, dtdFileName);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        this.entityResolved = false;
        if (publicId == null && systemId == null) {
            return null;
        }
        InputSource inputSource = null;
        String entityFileName = this.getLocalEntityName(publicId, systemId);
        if (entityFileName != null) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                URL url = loader.getResource(entityFileName);
                InputStream inputStream = null;
                if (url != null) {
                    if (log.isTraceEnabled()) {
                        log.trace(entityFileName + " maps to URL: " + url);
                    }
                    try {
                        inputStream = url.openStream();
                    }
                    catch (IOException e) {
                        log.debug("Failed to open url stream", e);
                    }
                }
                if (inputStream != null) {
                    inputSource = new InputSource(inputStream);
                }
            }
            catch (Exception e) {
                log.error("Cannot load local entity: " + entityFileName);
            }
        }
        this.entityResolved = inputSource != null;
        return inputSource;
    }

    private String getLocalEntityName(String publicId, String systemId) {
        String filename = null;
        if (publicId != null) {
            filename = (String)entities.get(publicId);
        }
        if (filename == null && systemId != null) {
            filename = (String)entities.get(systemId);
        }
        if (filename == null && systemId != null) {
            try {
                URL url = new URL(systemId);
                String path = url.getPath();
                int slash = path.lastIndexOf(47);
                filename = path.substring(slash + 1);
            }
            catch (MalformedURLException ignored) {
                log.trace("SystemId is not a url: " + systemId, ignored);
                return null;
            }
        }
        if (!entities.values().contains(filename)) {
            log.warn("Entity is not registered, publicId=" + publicId + " systemId=" + systemId);
        }
        if (filename.endsWith(".dtd")) {
            filename = "dtd/" + filename;
        } else if (filename.endsWith(".xsd")) {
            filename = "schema/" + filename;
        }
        return filename;
    }

    public boolean isEntityResolved() {
        return this.entityResolved;
    }

    static {
        JBossEntityResolver.registerEntity("urn:jboss:bean-deployer bean-deployer_1_0.xsd", "bean-deployer_1_0.xsd");
        JBossEntityResolver.registerEntity("http://java.sun.com/xml/ns/j2ee/j2ee_1_4.xsd", "j2ee_1_4.xsd");
        JBossEntityResolver.registerEntity("http://java.sun.com/xml/ns/j2ee/application_1_4.xsd", "application_1_4.xsd");
        JBossEntityResolver.registerEntity("http://java.sun.com/xml/ns/j2ee/application-client_1_4.xsd", "application-client_1_4.xsd");
        JBossEntityResolver.registerEntity("http://java.sun.com/xml/ns/j2ee/connector_1_5.xsd", "connector_1_5.xsd");
        JBossEntityResolver.registerEntity("http://java.sun.com/xml/ns/j2ee/ejb-jar_2_1.xsd", "ejb-jar_2_1.xsd");
        JBossEntityResolver.registerEntity("http://www.ibm.com/webservices/xsd/j2ee_web_services_client_1_1.xsd", "j2ee_web_services_client_1_1.xsd");
        JBossEntityResolver.registerEntity("http://www.ibm.com/webservices/xsd/j2ee_web_services_1_1.xsd", "j2ee_web_services_1_1.xsd");
        JBossEntityResolver.registerEntity("http://www.ibm.com/webservices/xsd/j2ee_jaxrpc_mapping_1_1.xsd", "j2ee_jaxrpc_mapping_1_1.xsd");
        JBossEntityResolver.registerEntity("http://java.sun.com/xml/ns/j2ee/web-app_2_4.xsd", "web-app_2_4.xsd");
        JBossEntityResolver.registerEntity("http://www.w3.org/2001/xml.xsd", "xml.xsd");
        JBossEntityResolver.registerEntity("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 1.1//EN", "ejb-jar.dtd");
        JBossEntityResolver.registerEntity("-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN", "ejb-jar_2_0.dtd");
        JBossEntityResolver.registerEntity("-//Sun Microsystems, Inc.//DTD J2EE Application 1.2//EN", "application_1_2.dtd");
        JBossEntityResolver.registerEntity("-//Sun Microsystems, Inc.//DTD J2EE Application 1.3//EN", "application_1_3.dtd");
        JBossEntityResolver.registerEntity("-//Sun Microsystems, Inc.//DTD J2EE Application Client 1.3//EN", "application-client_1_3.dtd");
        JBossEntityResolver.registerEntity("-//Sun Microsystems, Inc.//DTD Connector 1.0//EN", "connector_1_0.dtd");
        JBossEntityResolver.registerEntity("-//Sun Microsystems, Inc.//DTD Web Application 2.2//EN", "web-app_2_2.dtd");
        JBossEntityResolver.registerEntity("-//Sun Microsystems, Inc.//DTD Web Application 2.3//EN", "web-app_2_3.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD J2EE Application 1.3//EN", "jboss-app_3_0.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD J2EE Application 1.3V2//EN", "jboss-app_3_2.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD J2EE Application 1.4//EN", "jboss-app_4_0.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD JAWS//EN", "jaws.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD JAWS 2.4//EN", "jaws_2_4.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD JAWS 3.0//EN", "jaws_3_0.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD JBOSS//EN", "jboss.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD JBOSS 2.4//EN", "jboss_2_4.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD JBOSS 3.0//EN", "jboss_3_0.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD JBOSS 3.2//EN", "jboss_3_2.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD JBOSS 4.0//EN", "jboss_4_0.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD JBOSSCMP-JDBC 3.0//EN", "jbosscmp-jdbc_3_0.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD JBOSSCMP-JDBC 3.2//EN", "jbosscmp-jdbc_3_2.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD JBOSSCMP-JDBC 4.0//EN", "jbosscmp-jdbc_4_0.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD Web Application 2.2//EN", "jboss-web.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD Web Application 2.3//EN", "jboss-web_3_0.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD Web Application 2.3V2//EN", "jboss-web_3_2.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD Web Application 2.4//EN", "jboss-web_4_0.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD Application Client 3.2//EN", "jboss-client_3_2.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD Application Client 4.0//EN", "jboss-client_4_0.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD MBean Service 3.2//EN", "jboss-service_3_2.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD MBean Service 4.0//EN", "jboss-service_4_0.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD JBOSS Security Config 3.0//EN", "security_config.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD JBOSS JCA Config 1.0//EN", "jboss-ds_1_0.dtd");
        JBossEntityResolver.registerEntity("-//JBoss//DTD JBOSS JCA Config 1.5//EN", "jboss-ds_1_5.dtd");
        JBossEntityResolver.registerEntity("http://www.jboss.org/j2ee/schema/security-config_4_0.xsd", "security-config_4_0.xsd");
        JBossEntityResolver.registerEntity("http://www.jboss.com/ws-security/schema/jboss-ws-security_1_0.xsd", "jboss-ws-security_1_0.xsd");
        JBossEntityResolver.registerEntity("-//W3C//DTD/XMLSCHEMA 200102//EN", "XMLSchema.dtd");
        JBossEntityResolver.registerEntity("datatypes", "datatypes.dtd");
    }
}

