/*
 * Decompiled with CFR 0.152.
 */
package com.icesoft.faces.webapp.parser;

import com.icesoft.faces.webapp.parser.BodyContentImpl;
import com.icesoft.faces.webapp.parser.ComponentRuleSet;
import com.icesoft.faces.webapp.parser.JsfJspDigester;
import com.icesoft.faces.webapp.parser.JspWriterImpl;
import com.icesoft.faces.webapp.parser.StubHttpServletResponse;
import com.icesoft.faces.webapp.parser.StubPageContext;
import com.icesoft.faces.webapp.parser.TagToComponentMap;
import com.icesoft.faces.webapp.parser.TagWire;
import com.icesoft.faces.webapp.parser.XhtmlTag;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.FacesContext;
import javax.faces.webapp.UIComponentBodyTag;
import javax.faces.webapp.UIComponentTag;
import javax.servlet.ServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyContent;
import javax.servlet.jsp.tagext.Tag;
import org.apache.commons.digester.RuleSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.SAXException;

public class Parser {
    private static final Log log = LogFactory.getLog((Class)Parser.class);
    private JsfJspDigester digester = new JsfJspDigester();

    public Parser(InputStream fis) throws IOException {
        this.digester.setNamespaceAware(true);
        this.digester.setValidating(false);
        this.digester.setUseContextClassLoader(false);
        this.digester.setClassLoader(this.getClass().getClassLoader());
        try {
            TagToComponentMap map = TagToComponentMap.loadFrom(fis);
            this.digester.addRuleSet((RuleSet)new ComponentRuleSet(map, ""));
        }
        catch (ClassNotFoundException e) {
            throw new IOException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(Reader page, FacesContext context) throws IOException, SAXException {
        StubPageContext pageContext = new StubPageContext();
        StubHttpServletResponse response = new StubHttpServletResponse();
        pageContext.initialize(null, null, (ServletResponse)response, null, false, 1024, false);
        HashSet componentIds = new HashSet();
        XhtmlTag rootTag = new XhtmlTag();
        rootTag.setTagName("ICEtag");
        rootTag.setParent(null);
        TagWire rootWire = new TagWire();
        rootWire.setTag((Tag)rootTag);
        Parser parser = this;
        synchronized (parser) {
            this.digester.clear();
            this.digester.push((Object)rootTag);
            this.digester.push(rootWire);
            this.digester.parse(page);
        }
        try {
            String viewTagClassName = this.digester.getViewTagClassName();
            if (null == viewTagClassName) {
                throw new IllegalStateException("ICEfaces parser unable to determine JSF implementation ViewTag class.");
            }
            Tag viewTag = (Tag)Class.forName(viewTagClassName).newInstance();
            viewTag.setParent(null);
            rootWire.setTag(viewTag);
            this.executeJspLifecycle(rootWire, pageContext, context, componentIds);
            pageContext.removeAttribute("javax.faces.webapp.COMPONENT_TAG_STACK", 2);
        }
        catch (Exception e) {
            log.error((Object)"Failed to execute JSP lifecycle.", (Throwable)e);
            throw new FacesException("Failed to execute JSP lifecycle.", (Throwable)e);
        }
    }

    public void executeJspLifecycle(TagWire wire, PageContext pageContext, FacesContext facesContext, Set componentIds) throws JspException {
        UIComponentTag compTag;
        UIComponent myComponent;
        boolean processingViewTag = false;
        Tag tag = wire.getTag();
        tag.setPageContext(pageContext);
        tag.doStartTag();
        if (tag instanceof UIComponentTag && (myComponent = (compTag = (UIComponentTag)tag).getComponentInstance()) != null) {
            String componentId;
            if (myComponent instanceof UIViewRoot) {
                myComponent.setId("_view");
                processingViewTag = true;
            }
            if (componentIds.contains(componentId = myComponent.getClientId(facesContext))) {
                throw new IllegalStateException("Duplicate component ID : " + componentId);
            }
            componentIds.add(componentId);
        }
        Iterator children = wire.getChildren().iterator();
        while (children.hasNext()) {
            TagWire childWire = (TagWire)children.next();
            this.executeJspLifecycle(childWire, pageContext, facesContext, componentIds);
        }
        if (!processingViewTag && tag instanceof UIComponentBodyTag) {
            UIComponentBodyTag bodyTag = (UIComponentBodyTag)tag;
            if (bodyTag.getBodyContent() == null) {
                JspWriterImpl jspWriter = new JspWriterImpl(new PrintWriter(System.out));
                BodyContentImpl imp = new BodyContentImpl(jspWriter);
                bodyTag.setBodyContent((BodyContent)imp);
            }
            bodyTag.doAfterBody();
        }
        tag.doEndTag();
    }
}

