/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.odmg;

import cirrus.hibernate.HibernateException;
import cirrus.hibernate.LockMode;
import cirrus.hibernate.Session;
import cirrus.hibernate.odmg.Database;
import cirrus.hibernate.odmg.Implementation;
import java.sql.SQLException;
import org.odmg.LockNotGrantedException;
import org.odmg.ODMGException;
import org.odmg.ODMGRuntimeException;

public class Transaction
implements org.odmg.Transaction {
    private final Database database;
    private final Session session;
    private cirrus.hibernate.Transaction tx;

    public Transaction(org.odmg.Database database) throws ODMGException {
        this.database = (Database)database;
        try {
            this.session = this.database.getSessionFactory().openSession();
        }
        catch (SQLException sqle) {
            throw new ODMGException(sqle.getMessage());
        }
        this.database.associateThread(this);
    }

    public Transaction() throws ODMGException {
        this(Implementation.getInstance().currentDatabase());
    }

    public Session getSession() {
        return this.session;
    }

    public void join() {
        this.database.associateThread(this);
    }

    public void leave() {
        this.database.disassociateThread();
    }

    public void begin() {
        try {
            this.tx = this.session.beginTransaction();
        }
        catch (HibernateException he) {
            throw new ODMGRuntimeException(he.getMessage());
        }
    }

    public boolean isOpen() {
        return this.tx == null;
    }

    public void commit() {
        this.database.disassociateThread();
        try {
            this.tx.commit();
        }
        catch (HibernateException he) {
            throw new ODMGRuntimeException(he.getMessage());
        }
        catch (SQLException sqle) {
            throw new ODMGRuntimeException(sqle.getMessage());
        }
        finally {
            this.tx = null;
            try {
                this.session.close();
            }
            catch (HibernateException he) {
                throw new ODMGRuntimeException(he.getMessage());
            }
            catch (SQLException sqle) {
                throw new ODMGRuntimeException(sqle.getMessage());
            }
        }
    }

    public void abort() {
        this.database.disassociateThread();
        try {
            this.tx.rollback();
        }
        catch (HibernateException he) {
            throw new ODMGRuntimeException(he.getMessage());
        }
        finally {
            this.tx = null;
            try {
                this.session.close();
            }
            catch (HibernateException he) {
                throw new ODMGRuntimeException(he.getMessage());
            }
            catch (SQLException sqle) {
                throw new ODMGRuntimeException(sqle.getMessage());
            }
        }
    }

    public void checkpoint() {
        try {
            this.tx.commit();
            this.tx = this.session.beginTransaction();
        }
        catch (HibernateException he) {
            throw new ODMGRuntimeException(he.getMessage());
        }
        catch (SQLException sqle) {
            throw new ODMGRuntimeException(sqle.getMessage());
        }
    }

    public void lock(Object obj, int lockMode) throws LockNotGrantedException {
        try {
            if (lockMode == 1) {
                this.session.lock(obj, LockMode.READ);
            } else {
                this.session.lock(obj, LockMode.UPGRADE);
            }
        }
        catch (HibernateException he) {
            throw new ODMGRuntimeException(he.getMessage());
        }
        catch (SQLException sqle) {
            throw new ODMGRuntimeException(sqle.getMessage());
        }
    }

    public boolean tryLock(Object obj, int lockMode) {
        throw new UnsupportedOperationException("try using lock()");
    }
}

