/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.kernel.plugins.bootstrap.basic;

import org.jboss.kernel.Kernel;
import org.jboss.kernel.plugins.bootstrap.AbstractKernelInitializer;
import org.jboss.kernel.plugins.registry.AbstractKernelRegistryEntry;
import org.jboss.kernel.spi.config.KernelConfigurator;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.event.KernelEventManager;
import org.jboss.kernel.spi.registry.KernelBus;
import org.jboss.kernel.spi.registry.KernelRegistry;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;

public class BasicKernelInitializer
extends AbstractKernelInitializer {
    public void initKernel(Kernel kernel) throws Throwable {
        KernelRegistry registry = this.createKernelRegistry(kernel);
        if (this.trace) {
            this.log.trace("Using Registry: " + registry);
        }
        registry.setKernel(kernel);
        kernel.setRegistry(registry);
        KernelEventManager eventManager = this.createKernelEventManager(kernel);
        if (this.trace) {
            this.log.trace("Using EventManager: " + eventManager);
        }
        eventManager.setKernel(kernel);
        kernel.setEventManager(eventManager);
        KernelBus bus = this.createKernelBus(kernel);
        if (this.trace) {
            this.log.trace("Using Bus: " + bus);
        }
        bus.setKernel(kernel);
        kernel.setBus(bus);
        KernelConfigurator configurator = this.createKernelConfigurator(kernel);
        if (this.trace) {
            this.log.trace("Using Configurator: " + configurator);
        }
        configurator.setKernel(kernel);
        kernel.setConfigurator(configurator);
        KernelController controller = this.createKernelController(kernel);
        if (this.trace) {
            this.log.trace("Using Controller: " + controller);
        }
        controller.setKernel(kernel);
        kernel.setController(controller);
        this.register(kernel, "jboss.kernel:service=KernelConfig", (Object)kernel.getConfig());
        this.register(kernel, "jboss.kernel:service=KernelInit", (Object)this);
        this.register(kernel, "jboss.kernel:service=Kernel", (Object)kernel);
        this.register(kernel, "jboss.kernel:service=KernelRegistry", (Object)registry);
        this.register(kernel, "jboss.kernel:service=KernelEventManager", (Object)eventManager);
        this.register(kernel, "jboss.kernel:service=KernelBus", (Object)bus);
        this.register(kernel, "jboss.kernel:service=KernelConfigurator", (Object)configurator);
        this.register(kernel, "jboss.kernel:service=KernelController", (Object)controller);
    }

    protected KernelBus createKernelBus(Kernel kernel) throws Throwable {
        return kernel.getConfig().createKernelBus();
    }

    protected KernelConfigurator createKernelConfigurator(Kernel kernel) throws Throwable {
        return kernel.getConfig().createKernelConfigurator();
    }

    protected KernelController createKernelController(Kernel kernel) throws Throwable {
        return kernel.getConfig().createKernelController();
    }

    protected KernelEventManager createKernelEventManager(Kernel kernel) throws Throwable {
        return kernel.getConfig().createKernelEventManager();
    }

    protected KernelRegistry createKernelRegistry(Kernel kernel) throws Throwable {
        return kernel.getConfig().createKernelRegistry();
    }

    protected void register(Kernel kernel, String name, Object object) throws Throwable {
        this.register(kernel, this.getName(name), object);
    }

    protected void register(Kernel kernel, Object name, Object object) throws Throwable {
        KernelRegistryEntry entry = this.createKernelRegistryEntry(kernel, object);
        KernelRegistry registry = kernel.getRegistry();
        registry.registerEntry(name, entry);
    }

    protected Object getName(String name) throws Throwable {
        return name;
    }

    protected KernelRegistryEntry createKernelRegistryEntry(Kernel kernel, Object object) throws Throwable {
        return new AbstractKernelRegistryEntry(object);
    }
}

