/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.soap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import javax.xml.soap.Text;
import org.jboss.ws.core.soap.NameImpl;
import org.jboss.ws.core.soap.SOAPElementImpl;
import org.jboss.ws.core.soap.SOAPHeaderElementImpl;
import org.jboss.ws.core.utils.SAAJUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;

public class SOAPHeaderImpl
extends SOAPElementImpl
implements SOAPHeader {
    public SOAPHeaderImpl(String prefix, String namespace) {
        super("Header", prefix, namespace);
    }

    public SOAPElement addChildElement(SOAPElement child) throws SOAPException {
        QName qname = child.getElementQName();
        if (qname == null || qname.getNamespaceURI().length() == 0) {
            throw new SOAPException("Invalid SOAPHeaderElement name: " + qname);
        }
        if (!(child instanceof SOAPHeaderElement)) {
            child = SOAPHeaderImpl.convertToHeaderElement((Node)child);
        }
        return super.addChildElement(child);
    }

    public SOAPElement addTextNode(String value) throws SOAPException {
        if ("http://www.w3.org/2003/05/soap-envelope".equals(this.getNamespaceURI())) {
            throw new SOAPException("Attaching a Text node to this SOAP 1.2 Element is not legal: " + this.getLocalName());
        }
        return super.addTextNode(value);
    }

    public SOAPHeaderElement addHeaderElement(Name name) throws SOAPException {
        if (name == null) {
            throw new SOAPException("Invalid SOAPHeaderElement name: " + name);
        }
        return this.addHeaderElement(((NameImpl)name).toQName());
    }

    public SOAPHeaderElement addHeaderElement(QName qname) throws SOAPException {
        if (qname == null || qname.getNamespaceURI().length() == 0 || qname.getPrefix().length() == 0) {
            throw new SOAPException("Invalid SOAPHeaderElement name: " + qname);
        }
        SOAPHeaderElementImpl headerElement = new SOAPHeaderElementImpl(qname);
        this.addChildElement(headerElement);
        return headerElement;
    }

    public Iterator examineAllHeaderElements() {
        ArrayList<SOAPHeaderElement> list = new ArrayList<SOAPHeaderElement>();
        Iterator it = this.getChildElements();
        while (it.hasNext()) {
            SOAPHeaderElement shElement = (SOAPHeaderElement)it.next();
            list.add(shElement);
        }
        return list.iterator();
    }

    public Iterator examineHeaderElements(String actor) {
        if (actor == null) {
            throw new IllegalArgumentException("Invalid actor: " + actor);
        }
        ArrayList<SOAPHeaderElement> list = new ArrayList<SOAPHeaderElement>();
        Iterator it = this.getChildElements();
        while (it.hasNext()) {
            SOAPHeaderElement shElement = (SOAPHeaderElement)it.next();
            if (!actor.equals(shElement.getActor())) continue;
            list.add(shElement);
        }
        return list.iterator();
    }

    public Iterator examineMustUnderstandHeaderElements(String actor) {
        if (actor == null) {
            throw new IllegalArgumentException("Invalid actor: " + actor);
        }
        ArrayList<SOAPHeaderElement> list = new ArrayList<SOAPHeaderElement>();
        Iterator it = this.getChildElements();
        while (it.hasNext()) {
            SOAPHeaderElement shElement = (SOAPHeaderElement)it.next();
            if (!actor.equals(shElement.getActor()) || !shElement.getMustUnderstand()) continue;
            list.add(shElement);
        }
        return list.iterator();
    }

    public Iterator extractAllHeaderElements() {
        ArrayList<SOAPHeaderElement> list = new ArrayList<SOAPHeaderElement>();
        Iterator it = this.getChildElements();
        while (it.hasNext()) {
            SOAPHeaderElement shElement = (SOAPHeaderElement)it.next();
            this.removeChild((Node)shElement);
            list.add(shElement);
        }
        return list.iterator();
    }

    public Iterator extractHeaderElements(String actor) {
        if (actor == null) {
            throw new IllegalArgumentException("Invalid actor: " + actor);
        }
        ArrayList<SOAPHeaderElement> list = new ArrayList<SOAPHeaderElement>();
        Iterator it = this.getChildElements();
        while (it.hasNext()) {
            SOAPHeaderElement shElement = (SOAPHeaderElement)it.next();
            if (!actor.equals(shElement.getActor())) continue;
            this.removeChild((Node)shElement);
            list.add(shElement);
        }
        return list.iterator();
    }

    public Node appendChild(Node newChild) throws DOMException {
        if (SOAPHeaderImpl.needsConversionToHeaderElement((Node)newChild)) {
            newChild = SOAPHeaderImpl.convertToHeaderElement((Node)newChild);
        }
        return super.appendChild((Node)newChild);
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        if (SOAPHeaderImpl.needsConversionToHeaderElement((Node)newChild)) {
            newChild = SOAPHeaderImpl.convertToHeaderElement((Node)newChild);
        }
        return super.insertBefore((Node)newChild, refChild);
    }

    public Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        if (SOAPHeaderImpl.needsConversionToHeaderElement((Node)newChild)) {
            newChild = SOAPHeaderImpl.convertToHeaderElement((Node)newChild);
        }
        return super.replaceChild((Node)newChild, oldChild);
    }

    public SOAPHeaderElement addNotUnderstoodHeaderElement(QName qname) throws SOAPException {
        if ("http://schemas.xmlsoap.org/soap/envelope/".equals(this.getNamespaceURI())) {
            throw new UnsupportedOperationException("SOAP 1.1 Header does not support the concept of NotUnderstood");
        }
        QName notUnderstoodName = new QName(this.getNamespaceURI(), "NotUnderstood", this.getPrefix());
        SOAPHeaderElement notUnderstoodElement = this.addHeaderElement(notUnderstoodName);
        SAAJUtils.setQualifiedAttributeValue((SOAPElement)notUnderstoodElement, "qname", qname);
        return notUnderstoodElement;
    }

    public SOAPHeaderElement addUpgradeHeaderElement(Iterator supportedSoapUris) throws SOAPException {
        if (supportedSoapUris == null) {
            throw new SOAPException("list of supported URIs cannot be null");
        }
        if (!supportedSoapUris.hasNext()) {
            throw new SOAPException("list of supported URIs cannot be empty");
        }
        String namespaceURI = this.getNamespaceURI();
        String prefix = this.getPrefix();
        QName upgradeName = new QName(namespaceURI, "Upgrade", prefix);
        SOAPHeaderElement upgradeElement = this.addHeaderElement(upgradeName);
        while (supportedSoapUris.hasNext()) {
            String soapUri = (String)supportedSoapUris.next();
            SOAPElement supportedElement = upgradeElement.addChildElement("SupportedEnvelope", prefix, namespaceURI);
            SAAJUtils.setQualifiedAttributeValue(supportedElement, "qname", new QName(soapUri, "Envelope"));
        }
        return upgradeElement;
    }

    public SOAPHeaderElement addUpgradeHeaderElement(String[] supportedSoapUris) throws SOAPException {
        if (supportedSoapUris == null) {
            throw new SOAPException("list of supported URIs cannot be null");
        }
        return this.addUpgradeHeaderElement(Arrays.asList(supportedSoapUris).iterator());
    }

    public SOAPHeaderElement addUpgradeHeaderElement(String supportedSoapUri) throws SOAPException {
        if (supportedSoapUri == null) {
            throw new SOAPException("supported URI cannot be null");
        }
        return this.addUpgradeHeaderElement(Collections.singletonList(supportedSoapUri).iterator());
    }

    private static boolean needsConversionToHeaderElement(Node newChild) {
        return !(newChild instanceof SOAPHeaderElementImpl) && !(newChild instanceof DocumentFragment) && !(newChild instanceof Text);
    }

    private static SOAPHeaderElementImpl convertToHeaderElement(Node node) {
        if (!(node instanceof SOAPElementImpl)) {
            throw new IllegalArgumentException("SOAPElement expected");
        }
        SOAPElementImpl element = (SOAPElementImpl)((Object)node);
        element.detachNode();
        return new SOAPHeaderElementImpl(element);
    }
}

