/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfigTemplate;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferInt;
import java.awt.image.ImageObserver;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.VolatileImage;
import java.awt.image.renderable.RenderableImage;
import java.io.StringWriter;
import java.text.AttributedCharacterIterator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.batik.ext.awt.g2d.AbstractGraphics2D;
import org.apache.batik.ext.awt.g2d.GraphicContext;
import org.apache.fop.apps.FOPException;
import org.apache.fop.datatypes.ColorSpace;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.FopImageException;
import org.apache.fop.image.JpegImage;
import org.apache.fop.layout.FontState;
import org.apache.fop.pdf.PDFAnnotList;
import org.apache.fop.pdf.PDFColor;
import org.apache.fop.pdf.PDFDocument;
import org.apache.fop.pdf.PDFFilter;
import org.apache.fop.pdf.PDFFunction;
import org.apache.fop.pdf.PDFNumber;
import org.apache.fop.pdf.PDFPattern;
import org.apache.fop.render.pdf.CIDFont;
import org.apache.fop.render.pdf.fonts.LazyFont;

public class PDFGraphics2D
extends AbstractGraphics2D {
    boolean standalone = false;
    protected PDFDocument pdfDoc;
    PDFAnnotList currentAnnotList = null;
    protected FontState fontState;
    protected FontState ovFontState = null;
    StringWriter currentStream = new StringWriter();
    protected String currentFontName;
    protected int currentFontSize;
    protected int currentYPosition = 0;
    protected int currentXPosition = 0;
    PDFColor currentColour = new PDFColor(0, 0, 0);
    private Map imageInfos = new HashMap();
    private Graphics2D fmg;

    public PDFGraphics2D(boolean textAsShapes, FontState fs, PDFDocument doc, String font, int size, int xpos, int ypos) {
        super(textAsShapes);
        BufferedImage bi = new BufferedImage(1, 1, 2);
        this.fmg = bi.createGraphics();
        this.pdfDoc = doc;
        this.currentFontName = font;
        this.currentFontSize = size;
        this.currentYPosition = ypos;
        this.currentXPosition = xpos;
        this.fontState = fs;
    }

    public PDFGraphics2D(boolean textAsShapes) {
        super(textAsShapes);
        BufferedImage bi = new BufferedImage(1, 1, 2);
        this.fmg = bi.createGraphics();
    }

    public String getString() {
        return this.currentStream.toString();
    }

    public void setGraphicContext(GraphicContext c) {
        this.gc = c;
    }

    public void setOverrideFontState(FontState infont) {
        this.ovFontState = infont;
    }

    public PDFGraphics2D(PDFGraphics2D g) {
        super((AbstractGraphics2D)g);
        BufferedImage bi = new BufferedImage(1, 1, 2);
        this.fmg = bi.createGraphics();
    }

    public Graphics create() {
        return new PDFGraphics2D(this);
    }

    public void addLink(Shape bounds, AffineTransform trans, String dest, int linkType) {
        if (this.currentAnnotList == null) {
            this.currentAnnotList = this.pdfDoc.makeAnnotList();
        }
        AffineTransform at = this.getTransform();
        Shape b = at.createTransformedShape(bounds);
        b = trans.createTransformedShape(b);
        Rectangle rect = b.getBounds();
        rect.x *= 1000;
        rect.y *= 1000;
        rect.height = -rect.height * 1000;
        rect.width *= 1000;
        if (linkType != 1) {
            String pdfdest = "/XYZ " + dest;
            this.currentAnnotList.addLink(this.pdfDoc.makeLinkCurrentPage(rect, pdfdest));
        } else {
            this.currentAnnotList.addLink(this.pdfDoc.makeLink(rect, dest, linkType));
        }
    }

    public PDFAnnotList getAnnotList() {
        return this.currentAnnotList;
    }

    public void addJpegImage(JpegImage jpeg, float x, float y, float width, float height) {
        int xObjectNum = this.pdfDoc.addImage(jpeg);
        AffineTransform at = this.getTransform();
        double[] matrix = new double[6];
        at.getMatrix(matrix);
        this.currentStream.write("q\n");
        Shape imclip = this.getClip();
        this.writeClip(imclip);
        this.currentStream.write("" + matrix[0] + " " + matrix[1] + " " + matrix[2] + " " + matrix[3] + " " + matrix[4] + " " + matrix[5] + " cm\n");
        this.currentStream.write("" + width + " 0 0 " + -height + " " + x + " " + (y + height) + " cm\n" + "/Im" + xObjectNum + " Do\nQ\n");
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        ImageInfo imageInfo = (ImageInfo)this.imageInfos.get(img);
        if (imageInfo == null) {
            imageInfo = new ImageInfo();
            imageInfo.width = img.getWidth(observer);
            imageInfo.height = img.getHeight(observer);
            if (imageInfo.width == -1 || imageInfo.height == -1) {
                return false;
            }
            Dimension size = new Dimension(imageInfo.width * 3, imageInfo.height * 3);
            BufferedImage buf = this.buildBufferedImage(size);
            Graphics2D g = buf.createGraphics();
            g.setComposite(AlphaComposite.SrcOver);
            g.setBackground(new Color(1, 1, 1, 0));
            g.setPaint(new Color(1, 1, 1, 0));
            g.fillRect(0, 0, imageInfo.width * 3, imageInfo.height * 3);
            g.clip(new Rectangle(0, 0, buf.getWidth(), buf.getHeight()));
            if (!g.drawImage(img, 0, 0, buf.getWidth(), buf.getHeight(), observer)) {
                return false;
            }
            g.dispose();
            byte[] result = new byte[buf.getWidth() * buf.getHeight() * 3];
            byte[] mask = new byte[buf.getWidth() * buf.getHeight()];
            Raster raster = buf.getData();
            DataBuffer bd = raster.getDataBuffer();
            int count = 0;
            boolean maskpos = false;
            switch (bd.getDataType()) {
                case 3: {
                    int[][] idata = ((DataBufferInt)bd).getBankData();
                    for (int i = 0; i < idata.length; ++i) {
                        int[] iarray = idata[i];
                        for (int j = 0; j < iarray.length; ++j) {
                            int val = iarray[j];
                            int alpha = val >>> 24;
                            if (alpha != 255) {
                                int add = 255 - alpha;
                                int mult = (alpha << 16) / 255;
                                result[count++] = (byte)(add + ((val >> 16 & 0xFF) * mult >> 16));
                                result[count++] = (byte)(add + ((val >> 8 & 0xFF) * mult >> 16));
                                result[count++] = (byte)(add + ((val & 0xFF) * mult >> 16));
                                continue;
                            }
                            result[count++] = (byte)(val >> 16 & 0xFF);
                            result[count++] = (byte)(val >> 8 & 0xFF);
                            result[count++] = (byte)(val & 0xFF);
                        }
                    }
                    break;
                }
            }
            try {
                TempImage fopimg = new TempImage("TempImage:" + img.toString(), buf.getWidth(), buf.getHeight(), result, mask);
                imageInfo.xObjectNum = this.pdfDoc.addImage(fopimg);
                this.imageInfos.put(img, imageInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        AffineTransform at = this.getTransform();
        double[] matrix = new double[6];
        at.getMatrix(matrix);
        this.currentStream.write("q\n");
        Shape imclip = this.getClip();
        this.writeClip(imclip);
        this.currentStream.write("" + matrix[0] + " " + matrix[1] + " " + matrix[2] + " " + matrix[3] + " " + matrix[4] + " " + matrix[5] + " cm\n");
        this.currentStream.write("" + imageInfo.width + " 0 0 " + -imageInfo.height + " " + x + " " + (y + imageInfo.height) + " cm\n" + "/Im" + imageInfo.xObjectNum + " Do\nQ\n");
        return true;
    }

    public BufferedImage buildBufferedImage(Dimension size) {
        return new BufferedImage(size.width, size.height, 2);
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        System.out.println("drawImage");
        return true;
    }

    public void dispose() {
        this.pdfDoc = null;
        this.fontState = null;
        this.currentStream = null;
        this.currentFontName = null;
        this.currentColour = null;
    }

    public void draw(Shape s) {
        Color c = this.getColor();
        if (c.getAlpha() == 0) {
            return;
        }
        this.currentStream.write("q\n");
        Shape imclip = this.getClip();
        this.writeClip(imclip);
        this.applyColor(c, false);
        this.applyPaint(this.getPaint(), false);
        this.applyStroke(this.getStroke());
        AffineTransform trans = this.getTransform();
        double[] tranvals = new double[6];
        trans.getMatrix(tranvals);
        this.currentStream.write(PDFNumber.doubleOut(tranvals[0], 8) + " " + PDFNumber.doubleOut(tranvals[1], 8) + " " + PDFNumber.doubleOut(tranvals[2], 8) + " " + PDFNumber.doubleOut(tranvals[3], 8) + " " + PDFNumber.doubleOut(tranvals[4], 8) + " " + PDFNumber.doubleOut(tranvals[5], 8) + " cm\n");
        PathIterator iter = s.getPathIterator(new AffineTransform());
        while (!iter.isDone()) {
            double[] vals = new double[6];
            int type = iter.currentSegment(vals);
            switch (type) {
                case 3: {
                    this.currentStream.write(PDFNumber.doubleOut(vals[0]) + " " + PDFNumber.doubleOut(vals[1]) + " " + PDFNumber.doubleOut(vals[2]) + " " + PDFNumber.doubleOut(vals[3]) + " " + PDFNumber.doubleOut(vals[4]) + " " + PDFNumber.doubleOut(vals[5]) + " c\n");
                    break;
                }
                case 1: {
                    this.currentStream.write(PDFNumber.doubleOut(vals[0]) + " " + PDFNumber.doubleOut(vals[1]) + " l\n");
                    break;
                }
                case 0: {
                    this.currentStream.write(PDFNumber.doubleOut(vals[0]) + " " + PDFNumber.doubleOut(vals[1]) + " m\n");
                    break;
                }
                case 2: {
                    this.currentStream.write(PDFNumber.doubleOut(vals[0]) + " " + PDFNumber.doubleOut(vals[1]) + " " + PDFNumber.doubleOut(vals[2]) + " " + PDFNumber.doubleOut(vals[3]) + " y\n");
                    break;
                }
                case 4: {
                    this.currentStream.write("h\n");
                    break;
                }
            }
            iter.next();
        }
        this.doDrawing(false, true, false);
        this.currentStream.write("Q\n");
    }

    protected void writeClip(Shape s) {
        if (s == null) {
            return;
        }
        PathIterator iter = s.getPathIterator(this.getTransform());
        while (!iter.isDone()) {
            double[] vals = new double[6];
            int type = iter.currentSegment(vals);
            switch (type) {
                case 3: {
                    this.currentStream.write(PDFNumber.doubleOut(vals[0]) + " " + PDFNumber.doubleOut(vals[1]) + " " + PDFNumber.doubleOut(vals[2]) + " " + PDFNumber.doubleOut(vals[3]) + " " + PDFNumber.doubleOut(vals[4]) + " " + PDFNumber.doubleOut(vals[5]) + " c\n");
                    break;
                }
                case 1: {
                    this.currentStream.write(PDFNumber.doubleOut(vals[0]) + " " + PDFNumber.doubleOut(vals[1]) + " l\n");
                    break;
                }
                case 0: {
                    this.currentStream.write(PDFNumber.doubleOut(vals[0]) + " " + PDFNumber.doubleOut(vals[1]) + " m\n");
                    break;
                }
                case 2: {
                    this.currentStream.write(PDFNumber.doubleOut(vals[0]) + " " + PDFNumber.doubleOut(vals[1]) + " " + PDFNumber.doubleOut(vals[2]) + " " + PDFNumber.doubleOut(vals[3]) + " y\n");
                    break;
                }
                case 4: {
                    this.currentStream.write("h\n");
                    break;
                }
            }
            iter.next();
        }
        this.currentStream.write("W\n");
        this.currentStream.write("n\n");
    }

    protected void applyColor(Color col, boolean fill) {
        Color c = col;
        if (c.getColorSpace().getType() == 5) {
            this.currentColour = new PDFColor(c.getRed(), c.getGreen(), c.getBlue());
            this.currentStream.write(this.currentColour.getColorSpaceOut(fill));
        } else if (c.getColorSpace().getType() == 9) {
            float[] cComps = c.getColorComponents(new float[3]);
            double[] cmyk = new double[3];
            for (int i = 0; i < 3; ++i) {
                cmyk[i] = cComps[i];
            }
            this.currentColour = new PDFColor(cmyk[0], cmyk[1], cmyk[2], cmyk[3]);
            this.currentStream.write(this.currentColour.getColorSpaceOut(fill));
        } else if (c.getColorSpace().getType() == 12) {
            float[] cComps = c.getColorComponents(new float[1]);
            double[] blackMagenta = new double[1];
            for (int i = 0; i < 1; ++i) {
                blackMagenta[i] = cComps[i];
            }
            this.currentStream.write(this.currentColour.getColorSpaceOut(fill));
        } else {
            System.err.println("Color Space not supported by PDFGraphics2D");
        }
    }

    protected void applyPaint(Paint paint, boolean fill) {
        if (paint instanceof GradientPaint) {
            GradientPaint gp = (GradientPaint)paint;
            Color c1 = gp.getColor1();
            Color c2 = gp.getColor2();
            Point2D p1 = gp.getPoint1();
            Point2D p2 = gp.getPoint2();
            boolean cyclic = gp.isCyclic();
            ArrayList<Double> theCoords = new ArrayList<Double>();
            theCoords.add(new Double(p1.getX()));
            theCoords.add(new Double(p1.getY()));
            theCoords.add(new Double(p2.getX()));
            theCoords.add(new Double(p2.getY()));
            ArrayList<Boolean> theExtend = new ArrayList<Boolean>();
            theExtend.add(new Boolean(true));
            theExtend.add(new Boolean(true));
            ArrayList<Double> theDomain = new ArrayList<Double>();
            theDomain.add(new Double(0.0));
            theDomain.add(new Double(1.0));
            ArrayList<Double> theEncode = new ArrayList<Double>();
            theEncode.add(new Double(0.0));
            theEncode.add(new Double(1.0));
            theEncode.add(new Double(0.0));
            theEncode.add(new Double(1.0));
            ArrayList<Double> theBounds = new ArrayList<Double>();
            theBounds.add(new Double(0.0));
            theBounds.add(new Double(1.0));
            ArrayList theFunctions = new ArrayList();
            ArrayList<PDFColor> someColors = new ArrayList<PDFColor>();
            PDFColor color1 = new PDFColor(c1.getRed(), c1.getGreen(), c1.getBlue());
            someColors.add(color1);
            PDFColor color2 = new PDFColor(c2.getRed(), c2.getGreen(), c2.getBlue());
            someColors.add(color2);
            PDFFunction myfunc = this.pdfDoc.makeFunction(2, theDomain, null, (List)color1.getVector(), (List)color2.getVector(), 1.0);
            ColorSpace aColorSpace = new ColorSpace(2);
            PDFPattern myPat = this.pdfDoc.createGradient(false, aColorSpace, someColors, null, theCoords);
            this.currentStream.write(myPat.getColorSpaceOut(fill));
        } else if (paint instanceof TexturePaint) {
            // empty if block
        }
    }

    protected void applyStroke(Stroke stroke) {
        if (stroke instanceof BasicStroke) {
            BasicStroke bs = (BasicStroke)stroke;
            float[] da = bs.getDashArray();
            if (da != null) {
                this.currentStream.write("[");
                for (int count = 0; count < da.length; ++count) {
                    if ((int)da[count] == 0) {
                        this.currentStream.write("1");
                    } else {
                        this.currentStream.write("" + (int)da[count]);
                    }
                    if (count >= da.length - 1) continue;
                    this.currentStream.write(" ");
                }
                this.currentStream.write("] ");
                float offset = bs.getDashPhase();
                this.currentStream.write((int)offset + " d\n");
            }
            int ec = bs.getEndCap();
            switch (ec) {
                case 0: {
                    this.currentStream.write("0 J\n");
                    break;
                }
                case 1: {
                    this.currentStream.write("1 J\n");
                    break;
                }
                case 2: {
                    this.currentStream.write("2 J\n");
                }
            }
            int lj = bs.getLineJoin();
            switch (lj) {
                case 0: {
                    this.currentStream.write("0 j\n");
                    break;
                }
                case 1: {
                    this.currentStream.write("1 j\n");
                    break;
                }
                case 2: {
                    this.currentStream.write("2 j\n");
                }
            }
            float lw = bs.getLineWidth();
            this.currentStream.write(PDFNumber.doubleOut(lw) + " w\n");
            float ml = bs.getMiterLimit();
            this.currentStream.write(PDFNumber.doubleOut(ml) + " M\n");
        }
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        System.out.println("drawRenderedImage");
    }

    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        System.out.println("drawRenderableImage");
    }

    public void drawString(String s, float x, float y) {
        if (this.ovFontState == null) {
            Font gFont = this.getFont();
            String n = gFont.getFamily();
            if (n.equals("sanserif")) {
                n = "sans-serif";
            }
            int siz = gFont.getSize();
            String style = gFont.isItalic() ? "italic" : "normal";
            String weight = gFont.isBold() ? "bold" : "normal";
            try {
                this.fontState = new FontState(this.fontState.getFontInfo(), n, style, weight, siz * 1000, 0);
            }
            catch (FOPException fope) {
                fope.printStackTrace();
            }
        } else {
            this.fontState = this.ovFontState;
            this.ovFontState = null;
        }
        String name = this.fontState.getFontName();
        int size = this.fontState.getFontSize() / 1000;
        if (!name.equals(this.currentFontName) || size != this.currentFontSize) {
            this.currentFontName = name;
            this.currentFontSize = size;
            this.currentStream.write("/" + name + " " + size + " Tf\n");
        }
        this.currentStream.write("q\n");
        Shape imclip = this.getClip();
        this.writeClip(imclip);
        Color c = this.getColor();
        this.applyColor(c, true);
        c = this.getBackground();
        this.applyColor(c, false);
        this.currentStream.write("BT\n");
        Map kerning = null;
        boolean kerningAvailable = false;
        kerning = this.fontState.getKerning();
        if (kerning != null && !kerning.isEmpty()) {
            kerningAvailable = true;
        }
        boolean useMultiByte = false;
        org.apache.fop.render.pdf.Font f = (org.apache.fop.render.pdf.Font)this.fontState.getFontInfo().getFonts().get(name);
        if (f instanceof LazyFont) {
            if (((LazyFont)f).getRealFont() instanceof CIDFont) {
                useMultiByte = true;
            }
        } else if (f instanceof CIDFont) {
            useMultiByte = true;
        }
        String startText = useMultiByte ? "<" : "(";
        String endText = useMultiByte ? "> " : ") ";
        AffineTransform trans = this.getTransform();
        trans.translate(x, y);
        double[] vals = new double[6];
        trans.getMatrix(vals);
        this.currentStream.write(PDFNumber.doubleOut(vals[0], 8) + " " + PDFNumber.doubleOut(vals[1], 8) + " " + PDFNumber.doubleOut(vals[2], 8) + " " + PDFNumber.doubleOut(vals[3], 8) + " " + PDFNumber.doubleOut(vals[4], 8) + " " + PDFNumber.doubleOut(vals[5], 8) + " cm\n");
        this.currentStream.write("1 0 0 -1 0 0 Tm [" + startText);
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            char ch = this.fontState.mapChar(s.charAt(i));
            if (!useMultiByte) {
                if (ch > '\u007f') {
                    this.currentStream.write("\\");
                    this.currentStream.write(Integer.toOctalString(ch));
                } else {
                    switch (ch) {
                        case '(': 
                        case ')': 
                        case '\\': {
                            this.currentStream.write("\\");
                        }
                    }
                    this.currentStream.write(ch);
                }
            } else {
                this.currentStream.write(this.getUnicodeString(ch));
            }
            if (!kerningAvailable || i + 1 >= l) continue;
            this.addKerning(this.currentStream, new Integer(ch), new Integer(this.fontState.mapChar(s.charAt(i + 1))), kerning, startText, endText);
        }
        this.currentStream.write(endText);
        this.currentStream.write("] TJ\n");
        this.currentStream.write("ET\n");
        this.currentStream.write("Q\n");
    }

    private void addKerning(StringWriter buf, Integer ch1, Integer ch2, Map kerning, String startText, String endText) {
        Integer width;
        Map kernPair = (Map)kerning.get(ch1);
        if (kernPair != null && (width = (Integer)kernPair.get(ch2)) != null) {
            this.currentStream.write(endText + -width.intValue() + " " + startText);
        }
    }

    private String getUnicodeString(char c) {
        StringBuffer buf = new StringBuffer(4);
        byte[] uniBytes = null;
        try {
            char[] a = new char[]{c};
            uniBytes = new String(a).getBytes("UnicodeBigUnmarked");
        }
        catch (Exception e) {
            // empty catch block
        }
        for (int i = 0; i < uniBytes.length; ++i) {
            int b = uniBytes[i] < 0 ? 256 + uniBytes[i] : uniBytes[i];
            String hexString = Integer.toHexString(b);
            buf = hexString.length() == 1 ? buf.append("0" + hexString) : buf.append(hexString);
        }
        return buf.toString();
    }

    public void drawString(AttributedCharacterIterator iterator, float x, float y) {
        System.err.println("drawString(AttributedCharacterIterator)");
        Shape imclip = this.getClip();
        this.writeClip(imclip);
        Color c = this.getColor();
        this.applyColor(c, true);
        c = this.getBackground();
        this.applyColor(c, false);
        this.currentStream.write("BT\n");
        AffineTransform trans = this.getTransform();
        trans.translate(x, y);
        double[] vals = new double[6];
        trans.getMatrix(vals);
        char ch = iterator.first();
        while (ch != '\uffff') {
            Map<AttributedCharacterIterator.Attribute, Object> attr = iterator.getAttributes();
            String name = this.fontState.getFontName();
            int size = this.fontState.getFontSize();
            if (!name.equals(this.currentFontName) || size != this.currentFontSize) {
                this.currentFontName = name;
                this.currentFontSize = size;
                this.currentStream.write("/" + name + " " + size / 1000 + " Tf\n");
            }
            this.currentStream.write(PDFNumber.doubleOut(vals[0], 8) + " " + PDFNumber.doubleOut(vals[1], 8) + " " + PDFNumber.doubleOut(vals[2], 8) + " " + PDFNumber.doubleOut(vals[3], 8) + " " + PDFNumber.doubleOut(vals[4], 8) + " " + PDFNumber.doubleOut(vals[5], 8) + " Tm (" + ch + ") Tj\n");
            ch = iterator.next();
        }
        this.currentStream.write("ET\n");
    }

    public void fill(Shape s) {
        Color c = this.getBackground();
        if (c.getAlpha() == 0 && (c = this.getColor()).getAlpha() == 0) {
            return;
        }
        this.currentStream.write("q\n");
        Shape imclip = this.getClip();
        this.writeClip(imclip);
        c = this.getColor();
        this.applyColor(c, true);
        c = this.getBackground();
        this.applyColor(c, false);
        this.applyPaint(this.getPaint(), true);
        PathIterator iter = s.getPathIterator(this.getTransform());
        while (!iter.isDone()) {
            double[] vals = new double[6];
            int type = iter.currentSegment(vals);
            switch (type) {
                case 3: {
                    this.currentStream.write(PDFNumber.doubleOut(vals[0]) + " " + PDFNumber.doubleOut(vals[1]) + " " + PDFNumber.doubleOut(vals[2]) + " " + PDFNumber.doubleOut(vals[3]) + " " + PDFNumber.doubleOut(vals[4]) + " " + PDFNumber.doubleOut(vals[5]) + " c\n");
                    break;
                }
                case 1: {
                    this.currentStream.write(PDFNumber.doubleOut(vals[0]) + " " + PDFNumber.doubleOut(vals[1]) + " l\n");
                    break;
                }
                case 0: {
                    this.currentStream.write(PDFNumber.doubleOut(vals[0]) + " " + PDFNumber.doubleOut(vals[1]) + " m\n");
                    break;
                }
                case 2: {
                    this.currentStream.write(PDFNumber.doubleOut(vals[0]) + " " + PDFNumber.doubleOut(vals[1]) + " " + PDFNumber.doubleOut(vals[2]) + " " + PDFNumber.doubleOut(vals[3]) + " y\n");
                    break;
                }
                case 4: {
                    this.currentStream.write("h\n");
                    break;
                }
            }
            iter.next();
        }
        this.doDrawing(true, false, iter.getWindingRule() == 0);
        this.currentStream.write("Q\n");
    }

    protected void doDrawing(boolean fill, boolean stroke, boolean nonzero) {
        if (fill) {
            if (stroke) {
                if (nonzero) {
                    this.currentStream.write("B*\n");
                } else {
                    this.currentStream.write("B\n");
                }
            } else if (nonzero) {
                this.currentStream.write("f*\n");
            } else {
                this.currentStream.write("f\n");
            }
        } else {
            this.currentStream.write("S\n");
        }
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return new PDFGraphicsConfiguration();
    }

    public FontMetrics getFontMetrics(Font f) {
        return this.fmg.getFontMetrics(f);
    }

    public void setXORMode(Color c1) {
        System.out.println("setXORMode");
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        System.out.println("copyArea");
    }

    static class PDFGraphicsDevice
    extends GraphicsDevice {
        GraphicsConfiguration gc;

        PDFGraphicsDevice(PDFGraphicsConfiguration gc) {
            this.gc = gc;
        }

        public GraphicsConfiguration getBestConfiguration(GraphicsConfigTemplate gct) {
            return this.gc;
        }

        public GraphicsConfiguration[] getConfigurations() {
            return new GraphicsConfiguration[]{this.gc};
        }

        public GraphicsConfiguration getDefaultConfiguration() {
            return this.gc;
        }

        public String getIDstring() {
            return this.toString();
        }

        public int getType() {
            return 1;
        }
    }

    static class PDFGraphicsConfiguration
    extends GraphicsConfiguration {
        static BufferedImage BIWithAlpha = new BufferedImage(1, 1, 2);
        static BufferedImage BIWithOutAlpha = new BufferedImage(1, 1, 1);

        PDFGraphicsConfiguration() {
        }

        public BufferedImage createCompatibleImage(int width, int height, int transparency) {
            if (transparency == 1) {
                return new BufferedImage(width, height, 1);
            }
            return new BufferedImage(width, height, 2);
        }

        public BufferedImage createCompatibleImage(int width, int height) {
            return new BufferedImage(width, height, 2);
        }

        public Rectangle getBounds() {
            System.out.println("getting getBounds");
            return null;
        }

        public ColorModel getColorModel() {
            return BIWithAlpha.getColorModel();
        }

        public ColorModel getColorModel(int transparency) {
            if (transparency == 1) {
                return BIWithOutAlpha.getColorModel();
            }
            return BIWithAlpha.getColorModel();
        }

        public AffineTransform getDefaultTransform() {
            System.out.println("getting getDefaultTransform");
            return new AffineTransform();
        }

        public AffineTransform getNormalizingTransform() {
            System.out.println("getting getNormalizingTransform");
            return new AffineTransform(2.0f, 0.0f, 0.0f, 2.0f, 0.0f, 0.0f);
        }

        public GraphicsDevice getDevice() {
            return new PDFGraphicsDevice(this);
        }

        public VolatileImage createCompatibleVolatileImage(int width, int height) {
            return null;
        }
    }

    class TempImage
    implements FopImage {
        int m_height;
        int m_width;
        int m_bitsPerPixel;
        ColorSpace m_colorSpace;
        int m_bitmapSiye;
        byte[] m_bitmaps;
        byte[] m_mask;
        PDFColor transparent = new PDFColor(255, 255, 255);
        String url;

        TempImage(String url, int width, int height, byte[] result, byte[] mask) throws FopImageException {
            this.url = url;
            this.m_height = height;
            this.m_width = width;
            this.m_bitsPerPixel = 8;
            this.m_colorSpace = new ColorSpace(2);
            this.m_bitmaps = result;
            this.m_mask = mask;
        }

        public boolean invertImage() {
            return false;
        }

        public String getURL() {
            return this.url;
        }

        public int getWidth() throws FopImageException {
            return this.m_width;
        }

        public int getHeight() throws FopImageException {
            return this.m_height;
        }

        public ColorSpace getColorSpace() throws FopImageException {
            return this.m_colorSpace;
        }

        public int getBitsPerPixel() throws FopImageException {
            return this.m_bitsPerPixel;
        }

        public boolean isTransparent() throws FopImageException {
            return this.transparent != null;
        }

        public PDFColor getTransparentColor() throws FopImageException {
            return this.transparent;
        }

        public byte[] getMask() throws FopImageException {
            return this.m_mask;
        }

        public byte[] getBitmaps() throws FopImageException {
            return this.m_bitmaps;
        }

        public int getBitmapsSize() throws FopImageException {
            return this.m_width * this.m_height * 3;
        }

        public byte[] getRessourceBytes() throws FopImageException {
            return null;
        }

        public int getRessourceBytesSize() throws FopImageException {
            return 0;
        }

        public PDFFilter getPDFFilter() throws FopImageException {
            return null;
        }

        public void close() {
        }
    }

    private static class ImageInfo {
        public int width;
        public int height;
        public int xObjectNum;

        private ImageInfo() {
        }
    }
}

