/*
 * Decompiled with CFR 0.152.
 */
package net.sf.cglib.proxy;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import net.sf.cglib.proxy.ClassFileConstants;
import org.apache.bcel.generic.AASTORE;
import org.apache.bcel.generic.ALOAD;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.ARETURN;
import org.apache.bcel.generic.ASTORE;
import org.apache.bcel.generic.ATHROW;
import org.apache.bcel.generic.ArrayType;
import org.apache.bcel.generic.BIPUSH;
import org.apache.bcel.generic.BasicType;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ClassGen;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.DCONST;
import org.apache.bcel.generic.DLOAD;
import org.apache.bcel.generic.DRETURN;
import org.apache.bcel.generic.DUP;
import org.apache.bcel.generic.FCONST;
import org.apache.bcel.generic.FLOAD;
import org.apache.bcel.generic.FRETURN;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.ICONST;
import org.apache.bcel.generic.IFNONNULL;
import org.apache.bcel.generic.ILOAD;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.IRETURN;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionFactory;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InstructionList;
import org.apache.bcel.generic.LCONST;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LLOAD;
import org.apache.bcel.generic.LRETURN;
import org.apache.bcel.generic.MethodGen;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.ObjectType;
import org.apache.bcel.generic.RETURN;
import org.apache.bcel.generic.SIPUSH;
import org.apache.bcel.generic.Type;

class ClassFileUtils
implements ClassFileConstants {
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Number;

    private ClassFileUtils() {
    }

    static Instruction getIntConst(int i, ConstantPoolGen cp) {
        if (i < 0) {
            return new LDC(cp.addInteger(i));
        }
        if (i <= 5) {
            return new ICONST(i);
        }
        if (i < 127) {
            return new BIPUSH((byte)i);
        }
        if (i < Short.MAX_VALUE) {
            return new SIPUSH((short)i);
        }
        return new LDC(cp.addInteger(i));
    }

    static Class defineClass(final ClassLoader loader, final String name, final byte[] b) {
        return (Class)AccessController.doPrivileged(new PrivilegedAction(){
            static /* synthetic */ Class class$java$lang$String;
            static /* synthetic */ Class array$B;
            static /* synthetic */ Class class$java$lang$ClassLoader;

            public Object run() {
                try {
                    Method m = (class$java$lang$ClassLoader == null ? (class$java$lang$ClassLoader = 1.class$("java.lang.ClassLoader")) : class$java$lang$ClassLoader).getDeclaredMethod("defineClass", class$java$lang$String == null ? (class$java$lang$String = 1.class$("java.lang.String")) : class$java$lang$String, array$B == null ? (array$B = 1.class$("[B")) : array$B, Integer.TYPE, Integer.TYPE);
                    boolean flag = m.isAccessible();
                    ((AccessibleObject)m).setAccessible(true);
                    Class result = (Class)m.invoke((Object)loader, name, b, new Integer(0), new Integer(b.length));
                    ((AccessibleObject)m).setAccessible(flag);
                    return result;
                }
                catch (InvocationTargetException ite) {
                    Throwable e = ite.getTargetException();
                    throw new Error(e.getClass().getName() + ":" + e.getMessage());
                }
                catch (Throwable e) {
                    throw new Error(e.getClass().getName() + ":" + e.getMessage());
                }
            }

            static /* synthetic */ Class class$(String x0) {
                try {
                    return Class.forName(x0);
                }
                catch (ClassNotFoundException x1) {
                    throw new NoClassDefFoundError(x1.getMessage());
                }
            }
        });
    }

    static int loadArg(InstructionList il, Type t, int pos) {
        if (t instanceof BasicType) {
            if (t.equals(Type.LONG)) {
                il.append(new LLOAD(pos));
                return pos += 2;
            }
            if (t.equals(Type.DOUBLE)) {
                il.append(new DLOAD(pos));
                return pos += 2;
            }
            if (t.equals(Type.FLOAT)) {
                il.append(new FLOAD(pos));
                return ++pos;
            }
            il.append(new ILOAD(pos));
            return ++pos;
        }
        il.append(new ALOAD(pos));
        return ++pos;
    }

    static MethodGen toMethodGen(Method mtd, String className, InstructionList il, ConstantPoolGen cp) {
        MethodGen mg = new MethodGen(0x10 | mtd.getModifiers() & 0xFFFFFBFF & 0xFFFFFEFF & 0xFFFFFFDF, ClassFileUtils.toType(mtd.getReturnType()), ClassFileUtils.toType(mtd.getParameterTypes()), null, mtd.getName(), className, il, cp);
        Class<?>[] exeptions = mtd.getExceptionTypes();
        int i = 0;
        while (i < exeptions.length) {
            mg.addException(exeptions[i].getName());
            ++i;
        }
        return mg;
    }

    static Type[] toType(Class[] cls) {
        Type[] tp = new Type[cls.length];
        int i = 0;
        while (i < cls.length) {
            tp[i] = ClassFileUtils.toType(cls[i]);
            ++i;
        }
        return tp;
    }

    static Type toType(Class cls) {
        if (cls.equals(Void.TYPE)) {
            return Type.VOID;
        }
        if (cls.isPrimitive()) {
            if (Integer.TYPE.equals(cls)) {
                return Type.INT;
            }
            if (Character.TYPE.equals(cls)) {
                return Type.CHAR;
            }
            if (Short.TYPE.equals(cls)) {
                return Type.SHORT;
            }
            if (Byte.TYPE.equals(cls)) {
                return Type.BYTE;
            }
            if (Long.TYPE.equals(cls)) {
                return Type.LONG;
            }
            if (Float.TYPE.equals(cls)) {
                return Type.FLOAT;
            }
            if (Double.TYPE.equals(cls)) {
                return Type.DOUBLE;
            }
            if (Boolean.TYPE.equals(cls)) {
                return Type.BOOLEAN;
            }
        } else {
            if (cls.isArray()) {
                return new ArrayType(ClassFileUtils.toType(cls.getComponentType()), cls.getName().lastIndexOf(91) + 1);
            }
            return new ObjectType(cls.getName());
        }
        throw new InternalError(cls.getName());
    }

    static int createArgArray(InstructionList il, InstructionFactory factory, ConstantPoolGen cp, Type[] args) {
        int argCount = args.length;
        il.append(ClassFileUtils.getIntConst(argCount, cp));
        il.append(new ANEWARRAY(cp.addClass(Type.OBJECT)));
        int load = 1;
        int i = 0;
        while (i < argCount) {
            il.append(new DUP());
            il.append(ClassFileUtils.getIntConst(i, cp));
            if (args[i] instanceof BasicType) {
                if (args[i].equals(Type.BOOLEAN)) {
                    il.append(new NEW(cp.addClass(ClassFileConstants.BOOLEAN_OBJECT)));
                    il.append(new DUP());
                    il.append(new ILOAD(load++));
                    il.append(new INVOKESPECIAL(cp.addMethodref((class$java$lang$Boolean == null ? ClassFileUtils.class$("java.lang.Boolean") : class$java$lang$Boolean).getName(), "<init>", "(Z)V")));
                } else if (args[i].equals(Type.INT)) {
                    il.append(new NEW(cp.addClass(ClassFileConstants.INTEGER_OBJECT)));
                    il.append(new DUP());
                    il.append(new ILOAD(load++));
                    il.append(new INVOKESPECIAL(cp.addMethodref((class$java$lang$Integer == null ? ClassFileUtils.class$("java.lang.Integer") : class$java$lang$Integer).getName(), "<init>", "(I)V")));
                } else if (args[i].equals(Type.CHAR)) {
                    il.append(new NEW(cp.addClass(ClassFileConstants.CHARACTER_OBJECT)));
                    il.append(new DUP());
                    il.append(new ILOAD(load++));
                    il.append(new INVOKESPECIAL(cp.addMethodref((class$java$lang$Character == null ? ClassFileUtils.class$("java.lang.Character") : class$java$lang$Character).getName(), "<init>", "(C)V")));
                } else if (args[i].equals(Type.BYTE)) {
                    il.append(new NEW(cp.addClass(ClassFileConstants.BYTE_OBJECT)));
                    il.append(new DUP());
                    il.append(new ILOAD(load++));
                    il.append(new INVOKESPECIAL(cp.addMethodref((class$java$lang$Byte == null ? ClassFileUtils.class$("java.lang.Byte") : class$java$lang$Byte).getName(), "<init>", "(B)V")));
                } else if (args[i].equals(Type.SHORT)) {
                    il.append(new NEW(cp.addClass(ClassFileConstants.SHORT_OBJECT)));
                    il.append(new DUP());
                    il.append(new ILOAD(load++));
                    il.append(new INVOKESPECIAL(cp.addMethodref((class$java$lang$Short == null ? ClassFileUtils.class$("java.lang.Short") : class$java$lang$Short).getName(), "<init>", "(S)V")));
                } else if (args[i].equals(Type.LONG)) {
                    il.append(new NEW(cp.addClass(ClassFileConstants.LONG_OBJECT)));
                    il.append(new DUP());
                    il.append(new LLOAD(load));
                    load += 2;
                    il.append(new INVOKESPECIAL(cp.addMethodref((class$java$lang$Long == null ? ClassFileUtils.class$("java.lang.Long") : class$java$lang$Long).getName(), "<init>", "(J)V")));
                } else if (args[i].equals(Type.DOUBLE)) {
                    il.append(new NEW(cp.addClass(ClassFileConstants.DOUBLE_OBJECT)));
                    il.append(new DUP());
                    il.append(new DLOAD(load));
                    load += 2;
                    il.append(new INVOKESPECIAL(cp.addMethodref((class$java$lang$Double == null ? ClassFileUtils.class$("java.lang.Double") : class$java$lang$Double).getName(), "<init>", "(D)V")));
                } else if (args[i].equals(Type.FLOAT)) {
                    il.append(new NEW(cp.addClass(ClassFileConstants.FLOAT_OBJECT)));
                    il.append(new DUP());
                    il.append(new FLOAD(load++));
                    il.append(new INVOKESPECIAL(cp.addMethodref((class$java$lang$Float == null ? ClassFileUtils.class$("java.lang.Float") : class$java$lang$Float).getName(), "<init>", "(F)V")));
                }
                il.append(new AASTORE());
            } else {
                il.append(new ALOAD(load++));
                il.append(new AASTORE());
            }
            ++i;
        }
        return load;
    }

    static org.apache.bcel.classfile.Method getMethod(MethodGen mg) {
        mg.stripAttributes(true);
        mg.setMaxLocals();
        mg.setMaxStack();
        return mg.getMethod();
    }

    static Instruction initWrapper(Type type, ConstantPoolGen cp) {
        if (type instanceof BasicType) {
            if (type.equals(Type.BOOLEAN)) {
                return new INVOKESPECIAL(cp.addMethodref((class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClassFileUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName(), "<init>", "(Z)V"));
            }
            if (type.equals(Type.INT)) {
                return new INVOKESPECIAL(cp.addMethodref((class$java$lang$Integer == null ? (class$java$lang$Integer = ClassFileUtils.class$("java.lang.Integer")) : class$java$lang$Integer).getName(), "<init>", "(I)V"));
            }
            if (type.equals(Type.CHAR)) {
                return new INVOKESPECIAL(cp.addMethodref((class$java$lang$Character == null ? (class$java$lang$Character = ClassFileUtils.class$("java.lang.Character")) : class$java$lang$Character).getName(), "<init>", "(C)V"));
            }
            if (type.equals(Type.BYTE)) {
                return new INVOKESPECIAL(cp.addMethodref((class$java$lang$Byte == null ? (class$java$lang$Byte = ClassFileUtils.class$("java.lang.Byte")) : class$java$lang$Byte).getName(), "<init>", "(B)V"));
            }
            if (type.equals(Type.SHORT)) {
                return new INVOKESPECIAL(cp.addMethodref((class$java$lang$Short == null ? (class$java$lang$Short = ClassFileUtils.class$("java.lang.Short")) : class$java$lang$Short).getName(), "<init>", "(S)V"));
            }
            if (type.equals(Type.LONG)) {
                return new INVOKESPECIAL(cp.addMethodref((class$java$lang$Long == null ? (class$java$lang$Long = ClassFileUtils.class$("java.lang.Long")) : class$java$lang$Long).getName(), "<init>", "(J)V"));
            }
            if (type.equals(Type.DOUBLE)) {
                return new INVOKESPECIAL(cp.addMethodref((class$java$lang$Double == null ? (class$java$lang$Double = ClassFileUtils.class$("java.lang.Double")) : class$java$lang$Double).getName(), "<init>", "(D)V"));
            }
            if (type.equals(Type.FLOAT)) {
                return new INVOKESPECIAL(cp.addMethodref((class$java$lang$Float == null ? (class$java$lang$Float = ClassFileUtils.class$("java.lang.Float")) : class$java$lang$Float).getName(), "<init>", "(F)V"));
            }
        }
        throw new InternalError(type.toString());
    }

    static void invokeSuper(ClassGen cg, MethodGen mg, Type[] args) {
        ConstantPoolGen cp = cg.getConstantPool();
        InstructionList il = mg.getInstructionList();
        int pos = 1;
        il.append(new ALOAD(0));
        int i = 0;
        while (i < args.length) {
            pos = ClassFileUtils.loadArg(il, args[i], pos);
            ++i;
        }
        il.append(new INVOKESPECIAL(cp.addMethodref(cg.getSuperclassName(), mg.getName(), mg.getSignature())));
    }

    static Instruction newReturn(Type t) {
        if (t instanceof BasicType) {
            if (t.equals(Type.LONG)) {
                return new LRETURN();
            }
            if (t.equals(Type.DOUBLE)) {
                return new DRETURN();
            }
            if (t.equals(Type.FLOAT)) {
                return new FRETURN();
            }
            if (t.equals(Type.VOID)) {
                return new RETURN();
            }
            return new IRETURN();
        }
        return new ARETURN();
    }

    static Instruction newWrapper(Type type, ConstantPoolGen cp) {
        if (type instanceof BasicType) {
            if (type.equals(Type.BOOLEAN)) {
                return new NEW(cp.addClass(ClassFileConstants.BOOLEAN_OBJECT));
            }
            if (type.equals(Type.INT)) {
                return new NEW(cp.addClass(ClassFileConstants.INTEGER_OBJECT));
            }
            if (type.equals(Type.CHAR)) {
                return new NEW(cp.addClass(ClassFileConstants.CHARACTER_OBJECT));
            }
            if (type.equals(Type.BYTE)) {
                return new NEW(cp.addClass(ClassFileConstants.BYTE_OBJECT));
            }
            if (type.equals(Type.SHORT)) {
                return new NEW(cp.addClass(ClassFileConstants.SHORT_OBJECT));
            }
            if (type.equals(Type.LONG)) {
                return new NEW(cp.addClass(ClassFileConstants.LONG_OBJECT));
            }
            if (type.equals(Type.DOUBLE)) {
                return new NEW(cp.addClass(ClassFileConstants.DOUBLE_OBJECT));
            }
            if (type.equals(Type.FLOAT)) {
                return new NEW(cp.addClass(ClassFileConstants.FLOAT_OBJECT));
            }
        }
        return null;
    }

    static InstructionHandle generateReturnValue(InstructionList il, InstructionFactory factory, ConstantPoolGen cp, Type returnType, int stack) {
        if (returnType.equals(Type.VOID)) {
            return il.append(new RETURN());
        }
        il.append(new ASTORE(stack));
        il.append(new ALOAD(stack));
        if (returnType instanceof ObjectType || returnType instanceof ArrayType) {
            if (returnType instanceof ArrayType) {
                il.append(new CHECKCAST(cp.addArrayClass((ArrayType)returnType)));
                return il.append(new ARETURN());
            }
            if (!returnType.equals(Type.OBJECT)) {
                il.append(new CHECKCAST(cp.addClass((ObjectType)returnType)));
                return il.append(new ARETURN());
            }
            return il.append(new ARETURN());
        }
        if (returnType instanceof BasicType) {
            if (returnType.equals(Type.BOOLEAN)) {
                IFNONNULL ifNNull = new IFNONNULL(null);
                il.append(ifNNull);
                il.append(new ICONST(0));
                il.append(new IRETURN());
                ifNNull.setTarget(il.append(new ALOAD(stack)));
                il.append(new CHECKCAST(cp.addClass(ClassFileConstants.BOOLEAN_OBJECT)));
                il.append(factory.createInvoke((class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClassFileUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName(), "booleanValue", Type.BOOLEAN, new Type[0], (short)182));
                return il.append(new IRETURN());
            }
            if (returnType.equals(Type.CHAR)) {
                IFNONNULL ifNNull = new IFNONNULL(null);
                il.append(ifNNull);
                il.append(new ICONST(0));
                il.append(new IRETURN());
                ifNNull.setTarget(il.append(new ALOAD(stack)));
                il.append(new CHECKCAST(cp.addClass(ClassFileConstants.CHARACTER_OBJECT)));
                il.append(factory.createInvoke((class$java$lang$Character == null ? (class$java$lang$Character = ClassFileUtils.class$("java.lang.Character")) : class$java$lang$Character).getName(), "charValue", Type.CHAR, new Type[0], (short)182));
                return il.append(new IRETURN());
            }
            if (returnType.equals(Type.LONG)) {
                IFNONNULL ifNNull = new IFNONNULL(null);
                il.append(ifNNull);
                il.append(new LCONST(0L));
                il.append(new LRETURN());
                ifNNull.setTarget(il.append(new ALOAD(stack)));
                il.append(new CHECKCAST(cp.addClass(ClassFileConstants.NUMBER_OBJECT)));
                il.append(factory.createInvoke((class$java$lang$Number == null ? (class$java$lang$Number = ClassFileUtils.class$("java.lang.Number")) : class$java$lang$Number).getName(), "longValue", Type.LONG, new Type[0], (short)182));
                return il.append(new LRETURN());
            }
            if (returnType.equals(Type.DOUBLE)) {
                IFNONNULL ifNNull = new IFNONNULL(null);
                il.append(ifNNull);
                il.append(new DCONST(0.0));
                il.append(new DRETURN());
                ifNNull.setTarget(il.append(new ALOAD(stack)));
                il.append(new CHECKCAST(cp.addClass(ClassFileConstants.NUMBER_OBJECT)));
                il.append(factory.createInvoke((class$java$lang$Number == null ? (class$java$lang$Number = ClassFileUtils.class$("java.lang.Number")) : class$java$lang$Number).getName(), "doubleValue", Type.DOUBLE, new Type[0], (short)182));
                return il.append(new DRETURN());
            }
            if (returnType.equals(Type.FLOAT)) {
                IFNONNULL ifNNull = new IFNONNULL(null);
                il.append(ifNNull);
                il.append(new FCONST(0.0f));
                il.append(new FRETURN());
                ifNNull.setTarget(il.append(new ALOAD(stack)));
                il.append(new CHECKCAST(cp.addClass(ClassFileConstants.NUMBER_OBJECT)));
                il.append(factory.createInvoke((class$java$lang$Number == null ? (class$java$lang$Number = ClassFileUtils.class$("java.lang.Number")) : class$java$lang$Number).getName(), "floatValue", Type.FLOAT, new Type[0], (short)182));
                return il.append(new FRETURN());
            }
            IFNONNULL ifNNull = new IFNONNULL(null);
            il.append(ifNNull);
            il.append(new ICONST(0));
            il.append(new IRETURN());
            ifNNull.setTarget(il.append(new ALOAD(stack)));
            il.append(new CHECKCAST(cp.addClass(ClassFileConstants.NUMBER_OBJECT)));
            il.append(factory.createInvoke((class$java$lang$Number == null ? (class$java$lang$Number = ClassFileUtils.class$("java.lang.Number")) : class$java$lang$Number).getName(), "intValue", Type.INT, new Type[0], (short)182));
            return il.append(new IRETURN());
        }
        throw new InternalError(returnType.toString());
    }

    static void loadClass(InstructionList il, ClassGen cg, ConstantPoolGen cp, Class cls) {
        GETSTATIC instruction = null;
        String cln = "Ljava/lang/Class;";
        String t = "TYPE";
        if (cls == Integer.TYPE) {
            instruction = new GETSTATIC(cp.addFieldref((class$java$lang$Integer == null ? (class$java$lang$Integer = ClassFileUtils.class$("java.lang.Integer")) : class$java$lang$Integer).getName(), t, cln));
        }
        if (cls == Byte.TYPE) {
            instruction = new GETSTATIC(cp.addFieldref((class$java$lang$Byte == null ? (class$java$lang$Byte = ClassFileUtils.class$("java.lang.Byte")) : class$java$lang$Byte).getName(), t, cln));
        }
        if (cls == Character.TYPE) {
            instruction = new GETSTATIC(cp.addFieldref((class$java$lang$Character == null ? (class$java$lang$Character = ClassFileUtils.class$("java.lang.Character")) : class$java$lang$Character).getName(), t, cln));
        }
        if (cls == Short.TYPE) {
            instruction = new GETSTATIC(cp.addFieldref((class$java$lang$Short == null ? (class$java$lang$Short = ClassFileUtils.class$("java.lang.Short")) : class$java$lang$Short).getName(), t, cln));
        }
        if (cls == Boolean.TYPE) {
            instruction = new GETSTATIC(cp.addFieldref((class$java$lang$Boolean == null ? (class$java$lang$Boolean = ClassFileUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean).getName(), t, cln));
        }
        if (cls == Long.TYPE) {
            instruction = new GETSTATIC(cp.addFieldref((class$java$lang$Long == null ? (class$java$lang$Long = ClassFileUtils.class$("java.lang.Long")) : class$java$lang$Long).getName(), t, cln));
        }
        if (cls == Float.TYPE) {
            instruction = new GETSTATIC(cp.addFieldref((class$java$lang$Float == null ? (class$java$lang$Float = ClassFileUtils.class$("java.lang.Float")) : class$java$lang$Float).getName(), t, cln));
        }
        if (cls == Double.TYPE) {
            instruction = new GETSTATIC(cp.addFieldref((class$java$lang$Double == null ? (class$java$lang$Double = ClassFileUtils.class$("java.lang.Double")) : class$java$lang$Double).getName(), t, cln));
        }
        if (instruction != null) {
            il.append(instruction);
        } else {
            il.append(new LDC(cp.addString(cls.getName())));
            il.append(new INVOKESTATIC(cp.addMethodref(cg.getClassName(), "CGLIB$findClass", "(Ljava/lang/String;)Ljava/lang/Class;")));
        }
    }

    static MethodGen generateFindClass(ClassGen cg, ConstantPoolGen cp) {
        InstructionList il = new InstructionList();
        MethodGen findClass = new MethodGen(10, ClassFileConstants.CLASS_OBJECT, new Type[]{Type.STRING}, null, "CGLIB$findClass", cg.getClassName(), il, cp);
        InstructionHandle start = il.append(new ALOAD(0));
        il.append(new INVOKESTATIC(cp.addMethodref("java.lang.Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;")));
        InstructionHandle h1 = il.append(new ARETURN());
        InstructionHandle h2 = il.append(new ASTORE(1));
        il.append(new NEW(cp.addClass("java.lang.NoClassDefFoundError")));
        il.append(new DUP());
        il.append(new ALOAD(1));
        il.append(new INVOKEVIRTUAL(cp.addMethodref("java.lang.ClassNotFoundException", "getMessage", "()Ljava/lang/String;")));
        il.append(new INVOKESPECIAL(cp.addMethodref("java.lang.NoClassDefFoundError", "<init>", "(Ljava/lang/String;)V")));
        il.append(new ATHROW());
        findClass.addExceptionHandler(start, h1, h2, new ObjectType("java.lang.ClassNotFoundException"));
        cg.addMethod(ClassFileUtils.getMethod(findClass));
        return findClass;
    }

    static String getPackageName(String className) throws Throwable {
        int index = className.lastIndexOf(46);
        if (index == -1) {
            return "";
        }
        return className.substring(0, index);
    }

    static boolean equals(Method m1, Method m2) {
        Class<?>[] params2;
        Class<?>[] params1;
        if (m1 == m2) {
            return true;
        }
        if (m1.getName().equals(m2.getName()) && (params1 = m1.getParameterTypes()).length == (params2 = m2.getParameterTypes()).length) {
            int i = 0;
            while (i < params1.length) {
                if (!params1[i].getName().equals(params2[i].getName())) {
                    return false;
                }
                ++i;
            }
            if (!m1.getReturnType().getName().equals(m2.getReturnType().getName())) {
                throw new IllegalArgumentException("Can't implement:\n" + m1.getDeclaringClass().getName() + "\n      and\n" + m2.getDeclaringClass().getName() + "\n" + m1.toString() + "\n" + m2.toString());
            }
            return true;
        }
        return false;
    }

    static boolean isVisible(Member m, String packageName) throws Throwable {
        int mod = m.getModifiers();
        if (Modifier.isPrivate(mod)) {
            return false;
        }
        if (Modifier.isProtected(mod) || Modifier.isPublic(mod)) {
            return true;
        }
        return ClassFileUtils.getPackageName(m.getDeclaringClass().getName()).equals(packageName);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

