/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.test;

import org.antlr.test.TestCompileAndExecSupport;
import org.antlr.test.unit.TestSuite;

public class TestRewriteTemplates
extends TestSuite {
    protected boolean debug = false;

    public void testDelete() throws Exception {
        String string = "grammar T;\noptions {output=template;}\na : ID INT -> ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "abc 34", this.debug);
        String string3 = "";
        this.assertEqual(string2, string3);
    }

    public void testAction() throws Exception {
        String string = "grammar T;\noptions {output=template;}\na : ID INT -> {new StringTemplate($ID.text)} ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "abc 34", this.debug);
        String string3 = "abc\n";
        this.assertEqual(string2, string3);
    }

    public void testEmbeddedLiteralConstructor() throws Exception {
        String string = "grammar T;\noptions {output=template;}\na : ID INT -> {%{$ID.text}} ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "abc 34", this.debug);
        String string3 = "abc\n";
        this.assertEqual(string2, string3);
    }

    public void testInlineTemplate() throws Exception {
        String string = "grammar T;\noptions {output=template;}\na : ID INT -> template(x={$ID},y={$INT}) <<x:<x.text>, y:<y.text>;>> ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "abc 34", this.debug);
        String string3 = "x:abc, y:34;\n";
        this.assertEqual(string2, string3);
    }

    public void testNamedTemplate() throws Exception {
        String string = "grammar T;\noptions {output=template;}\na : ID INT -> foo(x={$ID.text},y={$INT.text}) ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "abc 34", this.debug);
        String string3 = "abc 34\n";
        this.assertEqual(string2, string3);
    }

    public void testIndirectTemplate() throws Exception {
        String string = "grammar T;\noptions {output=template;}\na : ID INT -> ({\"foo\"})(x={$ID.text},y={$INT.text}) ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "abc 34", this.debug);
        String string3 = "abc 34\n";
        this.assertEqual(string2, string3);
    }

    public void testInlineTemplateInvokingLib() throws Exception {
        String string = "grammar T;\noptions {output=template;}\na : ID INT -> template(x={$ID.text},y={$INT.text}) \"<foo(...)>\" ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "abc 34", this.debug);
        String string3 = "abc 34\n";
        this.assertEqual(string2, string3);
    }

    public void testPredicatedAlts() throws Exception {
        String string = "grammar T;\noptions {output=template;}\na : ID INT -> {false}? foo(x={$ID.text},y={$INT.text})\n           -> foo(x={\"hi\"}, y={$ID.text})\n  ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "abc 34", this.debug);
        String string3 = "hi abc\n";
        this.assertEqual(string2, string3);
    }

    public void testTemplateReturn() throws Exception {
        String string = "grammar T;\noptions {output=template;}\na : b {System.out.println($b.st);} ;\nb : ID INT -> foo(x={$ID.text},y={$INT.text}) ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "abc 34", this.debug);
        String string3 = "abc 34\n";
        this.assertEqual(string2, string3);
    }

    public void testReturnValueWithTemplate() throws Exception {
        String string = "grammar T;\noptions {output=template;}\na : b {System.out.println($b.i);} ;\nb returns [int i] : ID INT {$i=8;} ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "abc 34", this.debug);
        String string3 = "8\n";
        this.assertEqual(string2, string3);
    }

    public void testTemplateRefToDynamicAttributes() throws Exception {
        String string = "grammar T;\noptions {output=template;}\na scope {String id;} : ID {$a::id=$ID.text;} b\n\t{System.out.println($b.st.toString());}\n   ;\nb : INT -> foo(x={$a::id}) ;\nID : 'a'..'z'+ ;\nINT : '0'..'9'+;\nWS : (' '|'\\n') {channel=99;} ;\n";
        String string2 = TestCompileAndExecSupport.execParser("t.g", string, "T", "TLexer", "a", "abc 34", this.debug);
        String string3 = "abc \n";
        this.assertEqual(string2, string3);
    }
}

