/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm;

import javax.management.ObjectName;
import javax.transaction.xa.Xid;
import org.jboss.mx.util.ObjectNameFactory;
import org.jboss.system.ServiceMBeanSupport;
import org.jboss.tm.GlobalId;
import org.jboss.tm.XidFactoryImpl;
import org.jboss.tm.XidFactoryMBean;
import org.jboss.tm.XidImpl;

public class XidFactory
extends ServiceMBeanSupport
implements XidFactoryMBean {
    private static final ObjectName NAMING_OBJECT_NAME = ObjectNameFactory.create((String)"jboss:service=Naming");
    private XidFactoryImpl factory = new XidFactoryImpl();

    protected void startService() throws Exception {
        long jndiPortOrStartUpTime;
        try {
            Integer jndiPort = (Integer)this.getServer().getAttribute(NAMING_OBJECT_NAME, "Port");
            jndiPortOrStartUpTime = jndiPort.intValue();
        }
        catch (Exception e) {
            jndiPortOrStartUpTime = System.currentTimeMillis();
        }
        this.factory.setUniqueInstanceId(jndiPortOrStartUpTime);
        this.factory.start();
    }

    public XidFactoryMBean getInstance() {
        return this;
    }

    public String getBaseGlobalId() {
        return this.factory.getBaseGlobalId();
    }

    public void setBaseGlobalId(String baseGlobalId) {
        this.factory.setBaseGlobalId(baseGlobalId);
    }

    public long getGlobalIdNumber() {
        return this.factory.getGlobalIdNumber();
    }

    public void setGlobalIdNumber(long globalIdNumber) {
        this.factory.setGlobalIdNumber(globalIdNumber);
    }

    public String getBranchQualifier() {
        return this.factory.getBranchQualifier();
    }

    public void setBranchQualifier(String branchQualifier) {
        this.factory.setBranchQualifier(branchQualifier);
    }

    public boolean isPad() {
        return this.factory.isPad();
    }

    public void setPad(boolean pad) {
        this.factory.setPad(pad);
    }

    public XidImpl newXid() {
        return this.factory.newXid();
    }

    public XidImpl newBranch(GlobalId globalId) {
        return this.factory.newBranch(globalId);
    }

    public XidImpl newBranch(XidImpl xid, long branchIdNum) {
        return this.factory.newBranch(xid, branchIdNum);
    }

    public XidImpl recreateXid(long localId) {
        return this.factory.recreateXid(localId);
    }

    public XidImpl recreateXid(long localId, GlobalId globalId) {
        return this.factory.recreateXid(localId, globalId);
    }

    public byte[] localIdToGlobalId(long localId) {
        return this.factory.localIdToGlobalId(localId);
    }

    public long extractLocalIdFrom(byte[] globalId) {
        return this.factory.extractLocalIdFrom(globalId);
    }

    public String getBaseBranchQualifier(byte[] branchQualifier) {
        return this.factory.getBaseBranchQualifier(branchQualifier);
    }

    public String toString(Xid xid) {
        return this.factory.toString(xid);
    }
}

