/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tm.remoting;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import javax.transaction.HeuristicCommitException;
import javax.transaction.HeuristicMixedException;
import javax.transaction.HeuristicRollbackException;
import org.jboss.remoting.InvokerLocator;
import org.jboss.tm.GlobalId;
import org.jboss.tm.remoting.interfaces.Coordinator;
import org.jboss.tm.remoting.interfaces.HeuristicHazardException;
import org.jboss.tm.remoting.interfaces.RecoveryCoordinator;
import org.jboss.tm.remoting.interfaces.Resource;
import org.jboss.tm.remoting.interfaces.Status;
import org.jboss.tm.remoting.interfaces.Synchronization;
import org.jboss.tm.remoting.interfaces.TransactionInactiveException;
import org.jboss.tm.remoting.interfaces.TransactionNotPreparedException;
import org.jboss.tm.remoting.interfaces.TxPropagationContext;
import org.jboss.tm.remoting.interfaces.Vote;

public class Invocation
implements Serializable {
    static final long serialVersionUID = -7256134284357215230L;
    private static final Invoker[] invokerArray = new Invoker[]{ITransactionFactory.CREATE, ITransactionFactory.RECREATE, ICoordinator.GET_STATUS, ICoordinator.IS_SAME_TRANSACTION, ICoordinator.HASH_TRANSACTION, ICoordinator.REGISTER_RESOURCE, ICoordinator.REGISTER_SYNCHRONIZATION, ICoordinator.ROLLBACK_ONLY, ICoordinator.GET_TRANSACTION_CONTEXT, ICoordinator.GET_TRANSACTION_ID, ITerminator.COMMIT, ITerminator.ROLLBACK, IResource.PREPARE, IResource.ROLLBACK, IResource.COMMIT, IResource.COMMIT_ONE_PHASE, IResource.FORGET, IRecoveryCoordinator.REPLAY_COMPLETION, ISynchronization.BEFORE_COMPLETION, ISynchronization.AFTER_COMPLETION};
    private long targetId;
    private int methodId;
    private Object[] args;
    static /* synthetic */ Class class$org$jboss$tm$remoting$interfaces$TransactionFactory;
    static /* synthetic */ Class class$org$jboss$tm$remoting$interfaces$Coordinator;
    static /* synthetic */ Class class$org$jboss$tm$remoting$interfaces$Terminator;
    static /* synthetic */ Class class$org$jboss$tm$remoting$interfaces$Resource;
    static /* synthetic */ Class class$org$jboss$tm$remoting$interfaces$RecoveryCoordinator;
    static /* synthetic */ Class class$org$jboss$tm$remoting$interfaces$Synchronization;

    private static int getMethodId(Method m) {
        Class<?> clz = m.getDeclaringClass();
        if (clz == (class$org$jboss$tm$remoting$interfaces$TransactionFactory == null ? (class$org$jboss$tm$remoting$interfaces$TransactionFactory = Invocation.class$("org.jboss.tm.remoting.interfaces.TransactionFactory")) : class$org$jboss$tm$remoting$interfaces$TransactionFactory)) {
            String name = m.getName();
            if (name.equals("create")) {
                return 0;
            }
            return 1;
        }
        if (clz == (class$org$jboss$tm$remoting$interfaces$Coordinator == null ? (class$org$jboss$tm$remoting$interfaces$Coordinator = Invocation.class$("org.jboss.tm.remoting.interfaces.Coordinator")) : class$org$jboss$tm$remoting$interfaces$Coordinator)) {
            String name = m.getName();
            if (name.equals("getStatus")) {
                return 2;
            }
            if (name.equals("isSameTransaction")) {
                return 3;
            }
            if (name.equals("hashTransaction")) {
                return 4;
            }
            if (name.equals("registerResource")) {
                return 5;
            }
            if (name.equals("registerSynchronization")) {
                return 6;
            }
            if (name.equals("rollbackOnly")) {
                return 7;
            }
            if (name.equals("getTransactionContext")) {
                return 8;
            }
            return 9;
        }
        if (clz == (class$org$jboss$tm$remoting$interfaces$Terminator == null ? (class$org$jboss$tm$remoting$interfaces$Terminator = Invocation.class$("org.jboss.tm.remoting.interfaces.Terminator")) : class$org$jboss$tm$remoting$interfaces$Terminator)) {
            String name = m.getName();
            if (name.equals("commit")) {
                return 10;
            }
            return 11;
        }
        if (clz == (class$org$jboss$tm$remoting$interfaces$Resource == null ? (class$org$jboss$tm$remoting$interfaces$Resource = Invocation.class$("org.jboss.tm.remoting.interfaces.Resource")) : class$org$jboss$tm$remoting$interfaces$Resource)) {
            String name = m.getName();
            if (name.equals("prepare")) {
                return 12;
            }
            if (name.equals("rollback")) {
                return 13;
            }
            if (name.equals("commit")) {
                return 14;
            }
            if (name.equals("commitOnePhase")) {
                return 15;
            }
            return 16;
        }
        if (clz == (class$org$jboss$tm$remoting$interfaces$RecoveryCoordinator == null ? (class$org$jboss$tm$remoting$interfaces$RecoveryCoordinator = Invocation.class$("org.jboss.tm.remoting.interfaces.RecoveryCoordinator")) : class$org$jboss$tm$remoting$interfaces$RecoveryCoordinator)) {
            return 17;
        }
        if (clz == (class$org$jboss$tm$remoting$interfaces$Synchronization == null ? (class$org$jboss$tm$remoting$interfaces$Synchronization = Invocation.class$("org.jboss.tm.remoting.interfaces.Synchronization")) : class$org$jboss$tm$remoting$interfaces$Synchronization)) {
            String name = m.getName();
            if (name.equals("beforeCompletion")) {
                return 18;
            }
            return 19;
        }
        throw new RuntimeException("Method " + m + " does not belong to" + " a transaction service interface");
    }

    public Invocation(long targetId, Method method, Object[] args) {
        this.targetId = targetId;
        this.methodId = Invocation.getMethodId(method);
        this.args = args;
    }

    public Object perform(InvokerLocator locator, Object servant) throws Throwable {
        return invokerArray[this.methodId].invoke(servant, this.targetId, this.args);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface ISynchronization {
        public static final int M_BEFORE_COMPLETION = 18;
        public static final int M_AFTER_COMPLETION = 19;
        public static final Invoker BEFORE_COMPLETION = new Invoker(){

            public Object invoke(Object servant, long targetId, Object[] args) throws Throwable {
                ((ISynchronization)servant).beforeCompletion(targetId);
                return null;
            }
        };
        public static final Invoker AFTER_COMPLETION = new Invoker(){

            public Object invoke(Object servant, long targetId, Object[] args) throws Throwable {
                ((ISynchronization)servant).afterCompletion(targetId);
                return null;
            }
        };

        public void beforeCompletion(long var1);

        public void afterCompletion(long var1);
    }

    public static interface IRecoveryCoordinator {
        public static final int M_REPLAY_COMPLETION = 17;
        public static final Invoker REPLAY_COMPLETION = new Invoker(){

            public Object invoke(Object servant, long targetId, Object[] args) throws Throwable {
                Resource r = (Resource)args[0];
                return ((IRecoveryCoordinator)servant).replayCompletion(targetId, r);
            }
        };

        public Status replayCompletion(long var1, Resource var3) throws RemoteException, TransactionNotPreparedException;
    }

    public static interface IResource {
        public static final int M_PREPARE = 12;
        public static final int M_ROLLBACK = 13;
        public static final int M_COMMIT = 14;
        public static final int M_COMMIT_ONE_PHASE = 15;
        public static final int M_FORGET = 16;
        public static final Invoker PREPARE = new Invoker(){

            public Object invoke(Object servant, long targetId, Object[] args) throws Throwable {
                return ((IResource)servant).prepare(targetId);
            }
        };
        public static final Invoker ROLLBACK = new Invoker(){

            public Object invoke(Object servant, long targetId, Object[] args) throws Throwable {
                ((IResource)servant).rollbackResource(targetId);
                return null;
            }
        };
        public static final Invoker COMMIT = new Invoker(){

            public Object invoke(Object servant, long targetId, Object[] args) throws Throwable {
                ((IResource)servant).commit(targetId);
                return null;
            }
        };
        public static final Invoker COMMIT_ONE_PHASE = new Invoker(){

            public Object invoke(Object servant, long targetId, Object[] args) throws Throwable {
                ((IResource)servant).commitOnePhase(targetId);
                return null;
            }
        };
        public static final Invoker FORGET = new Invoker(){

            public Object invoke(Object servant, long targetId, Object[] args) throws Throwable {
                ((IResource)servant).forget(targetId);
                return null;
            }
        };

        public Vote prepare(long var1) throws RemoteException, HeuristicMixedException, HeuristicHazardException;

        public void rollbackResource(long var1) throws RemoteException, HeuristicCommitException, HeuristicMixedException, HeuristicHazardException;

        public void commit(long var1) throws RemoteException, TransactionNotPreparedException, HeuristicRollbackException, HeuristicMixedException, HeuristicHazardException;

        public void commitOnePhase(long var1) throws RemoteException, HeuristicHazardException;

        public void forget(long var1) throws RemoteException;
    }

    public static interface ITerminator {
        public static final int M_COMMIT = 10;
        public static final int M_ROLLBACK = 11;
        public static final Invoker COMMIT = new Invoker(){

            public Object invoke(Object servant, long targetId, Object[] args) throws Throwable {
                boolean reportHeuristics = (Boolean)args[0];
                ((ITerminator)servant).commit(targetId, reportHeuristics);
                return null;
            }
        };
        public static final Invoker ROLLBACK = new Invoker(){

            public Object invoke(Object servant, long targetId, Object[] args) throws Throwable {
                ((ITerminator)servant).rollback(targetId);
                return null;
            }
        };

        public void commit(long var1, boolean var3) throws RemoteException, HeuristicMixedException, HeuristicHazardException;

        public void rollback(long var1) throws RemoteException;
    }

    public static interface ICoordinator {
        public static final int M_GET_STATUS = 2;
        public static final int M_IS_SAME_TRANSACTION = 3;
        public static final int M_HASH_TRANSACTION = 4;
        public static final int M_REGISTER_RESOURCE = 5;
        public static final int M_REGISTER_SYNCHRONIZATION = 6;
        public static final int M_ROLLBACK_ONLY = 7;
        public static final int M_GET_TRANSACTION_CONTEXT = 8;
        public static final int M_GET_TRANSACTION_ID = 9;
        public static final Invoker GET_STATUS = new Invoker(){

            public Object invoke(Object servant, long targetId, Object[] args) throws Throwable {
                return ((ICoordinator)servant).getStatus(targetId);
            }
        };
        public static final Invoker IS_SAME_TRANSACTION = new Invoker(){

            public Object invoke(Object servant, long targetId, Object[] args) throws Throwable {
                Coordinator other = (Coordinator)args[0];
                boolean retVal = ((ICoordinator)servant).isSameTransaction(targetId, other);
                return retVal;
            }
        };
        public static final Invoker HASH_TRANSACTION = new Invoker(){

            public Object invoke(Object servant, long targetId, Object[] args) throws Throwable {
                int retVal = ((ICoordinator)servant).hashTransaction(targetId);
                return new Integer(retVal);
            }
        };
        public static final Invoker REGISTER_RESOURCE = new Invoker(){

            public Object invoke(Object servant, long targetId, Object[] args) throws Throwable {
                Resource r = (Resource)args[0];
                return ((ICoordinator)servant).registerResource(targetId, r);
            }
        };
        public static final Invoker REGISTER_SYNCHRONIZATION = new Invoker(){

            public Object invoke(Object servant, long targetId, Object[] args) throws Throwable {
                Synchronization sync = (Synchronization)args[0];
                ((ICoordinator)servant).registerSynchronization(targetId, sync);
                return null;
            }
        };
        public static final Invoker ROLLBACK_ONLY = new Invoker(){

            public Object invoke(Object servant, long targetId, Object[] args) throws Throwable {
                ((ICoordinator)servant).rollbackOnly(targetId);
                return null;
            }
        };
        public static final Invoker GET_TRANSACTION_CONTEXT = new Invoker(){

            public Object invoke(Object servant, long targetId, Object[] args) throws Throwable {
                return ((ICoordinator)servant).getTransactionContext(targetId);
            }
        };
        public static final Invoker GET_TRANSACTION_ID = new Invoker(){

            public Object invoke(Object servant, long targetId, Object[] args) throws Throwable {
                return ((ICoordinator)servant).getTransactionId(targetId);
            }
        };

        public Status getStatus(long var1) throws RemoteException;

        public boolean isSameTransaction(long var1, Coordinator var3) throws RemoteException;

        public int hashTransaction(long var1) throws RemoteException;

        public RecoveryCoordinator registerResource(long var1, Resource var3) throws RemoteException, TransactionInactiveException;

        public void registerSynchronization(long var1, Synchronization var3) throws RemoteException, TransactionInactiveException;

        public void rollbackOnly(long var1) throws RemoteException, TransactionInactiveException;

        public TxPropagationContext getTransactionContext(long var1) throws RemoteException;

        public GlobalId getTransactionId(long var1) throws RemoteException;
    }

    public static interface ITransactionFactory {
        public static final int M_CREATE = 0;
        public static final int M_RECREATE = 1;
        public static final Invoker CREATE = new Invoker(){

            public Object invoke(Object servant, long targetId, Object[] args) throws Throwable {
                int timeout = (Integer)args[0];
                return ((ITransactionFactory)servant).create(targetId, timeout);
            }
        };
        public static final Invoker RECREATE = new Invoker(){

            public Object invoke(Object servant, long targetId, Object[] args) throws Throwable {
                TxPropagationContext tpc = (TxPropagationContext)args[0];
                return ((ITransactionFactory)servant).recreate(targetId, tpc);
            }
        };

        public TxPropagationContext create(long var1, int var3) throws RemoteException;

        public TxPropagationContext recreate(long var1, TxPropagationContext var3) throws RemoteException;
    }

    private static interface Invoker {
        public Object invoke(Object var1, long var2, Object[] var4) throws Throwable;
    }
}

