/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.tools.ws.wscompile;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.tools.apt.Main;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.Holder;
import javax.xml.ws.soap.SOAPBinding;
import org.jboss.com.sun.tools.ws.ToolVersion;
import org.jboss.com.sun.tools.ws.processor.Processor;
import org.jboss.com.sun.tools.ws.processor.ProcessorAction;
import org.jboss.com.sun.tools.ws.processor.ProcessorNotificationListener;
import org.jboss.com.sun.tools.ws.processor.config.ClassModelInfo;
import org.jboss.com.sun.tools.ws.processor.config.Configuration;
import org.jboss.com.sun.tools.ws.processor.config.WSDLModelInfo;
import org.jboss.com.sun.tools.ws.processor.config.parser.Reader;
import org.jboss.com.sun.tools.ws.processor.generator.CustomExceptionGenerator;
import org.jboss.com.sun.tools.ws.processor.generator.JAXBTypeGenerator;
import org.jboss.com.sun.tools.ws.processor.generator.SeiGenerator;
import org.jboss.com.sun.tools.ws.processor.generator.ServiceGenerator;
import org.jboss.com.sun.tools.ws.processor.model.Model;
import org.jboss.com.sun.tools.ws.processor.modeler.annotation.AnnotationProcessorContext;
import org.jboss.com.sun.tools.ws.processor.modeler.annotation.WebServiceAP;
import org.jboss.com.sun.tools.ws.processor.util.ClientProcessorEnvironment;
import org.jboss.com.sun.tools.ws.processor.util.GeneratedFileInfo;
import org.jboss.com.sun.tools.ws.processor.util.ProcessorEnvironment;
import org.jboss.com.sun.tools.ws.processor.util.ProcessorEnvironmentBase;
import org.jboss.com.sun.tools.ws.util.ForkEntityResolver;
import org.jboss.com.sun.tools.ws.util.JavaCompilerHelper;
import org.jboss.com.sun.tools.ws.util.ToolBase;
import org.jboss.com.sun.xml.ws.binding.BindingImpl;
import org.jboss.com.sun.xml.ws.binding.soap.SOAPBindingImpl;
import org.jboss.com.sun.xml.ws.model.RuntimeModel;
import org.jboss.com.sun.xml.ws.modeler.RuntimeModeler;
import org.jboss.com.sun.xml.ws.util.JAXWSUtils;
import org.jboss.com.sun.xml.ws.util.localization.Localizable;
import org.jboss.com.sun.xml.ws.util.xml.XmlUtil;
import org.jboss.com.sun.xml.ws.wsdl.writer.WSDLGenerator;
import org.jboss.com.sun.xml.ws.wsdl.writer.WSDLOutputResolver;
import org.xml.sax.EntityResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompileTool
extends ToolBase
implements ProcessorNotificationListener,
AnnotationProcessorFactory {
    static final Collection<String> supportedOptions = Collections.unmodifiableSet(new HashSet());
    static Collection<String> supportedAnnotations;
    private AnnotationProcessorContext context;
    private WebServiceAP webServiceAP;
    private int round = 0;
    protected Properties properties;
    protected ProcessorEnvironment environment;
    protected Configuration configuration;
    protected ProcessorNotificationListener listener;
    protected Processor processor;
    protected Map<String, ProcessorAction> actions;
    protected List<String> inputFiles = new ArrayList<String>();
    protected File sourceDir;
    protected File destDir;
    protected File nonclassDestDir;
    protected boolean doNothing = false;
    protected boolean compilerDebug = false;
    protected boolean compilerOptimize = false;
    protected boolean verbose = false;
    protected boolean keepGenerated = false;
    protected boolean doNotOverWrite = false;
    protected boolean extensions = false;
    protected String userClasspath = null;
    protected Set<String> bindingFiles = new HashSet<String>();
    protected boolean genWsdl = false;
    protected String protocol = "soap1.1";
    protected boolean protocolSet = false;
    protected String transport = "http";
    protected static final String SOAP11 = "soap1.1";
    protected static final String X_SOAP12 = "Xsoap1.2";
    protected static final String HTTP = "http";
    protected static final String WSIMPORT = "wsimport";
    protected static final String WSGEN = "wsgen";
    protected static final String SOAP11_ID = "http://schemas.xmlsoap.org/wsdl/soap/http";
    protected static final String SOAP12_ID = "http://www.w3.org/2003/05/soap/bindings/HTTP/";
    protected static final String VALID_PROTOCOLS = "soap1.1, Xsoap1.2";
    protected static final String VALID_TRANSPORTS = "http";
    protected String targetVersion = null;
    protected String wsdlLocation;
    protected String defaultPackage;
    protected String catalog;
    protected QName serviceName;
    protected QName portName;
    protected static final String PORTNAME_OPTION = "-portname";
    protected static final String SERVICENAME_OPTION = "-servicename";
    protected EntityResolver entityResolver;

    public CompileTool(OutputStream out, String program) {
        super(out, program);
        this.listener = this;
    }

    @Override
    protected boolean parseArguments(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            int index;
            String value;
            if (args[i].equals("")) {
                args[i] = null;
                continue;
            }
            if (args[i].equals("-g")) {
                this.compilerDebug = true;
                args[i] = null;
                continue;
            }
            if (args[i].equals("-verbose")) {
                this.verbose = true;
                args[i] = null;
                continue;
            }
            if (args[i].equals("-b")) {
                if (this.program.equals(WSGEN)) {
                    this.onError(this.getMessage("wscompile.invalidOption", args[i]));
                    this.usage();
                    return false;
                }
                if (i + 1 < args.length) {
                    args[i] = null;
                    String file = args[++i];
                    args[i] = null;
                    this.bindingFiles.add(JAXWSUtils.absolutize(JAXWSUtils.getFileOrURLName(file)));
                    continue;
                }
                this.onError(this.getMessage("wscompile.missingOptionArgument", "-b"));
                this.usage();
                return false;
            }
            if (args[i].equals("-version")) {
                this.report(ToolVersion.VERSION.BUILD_VERSION);
                this.doNothing = true;
                args[i] = null;
                return true;
            }
            if (args[i].equals("-keep")) {
                this.keepGenerated = true;
                args[i] = null;
                continue;
            }
            if (args[i].equals("-wsdllocation")) {
                if (this.program.equals(WSGEN)) {
                    this.onError(this.getMessage("wscompile.invalidOption", args[i]));
                    this.usage();
                    return false;
                }
                if (i + 1 < args.length) {
                    args[i] = null;
                    this.wsdlLocation = args[++i];
                    args[i] = null;
                    continue;
                }
                this.onError(this.getMessage("wscompile.missingOptionArgument", args[i]));
                this.usage();
                return false;
            }
            if (args[i].equals("-p")) {
                if (this.program.equals(WSGEN)) {
                    this.onError(this.getMessage("wscompile.invalidOption", args[i]));
                    this.usage();
                    return false;
                }
                if (i + 1 < args.length) {
                    args[i] = null;
                    this.defaultPackage = args[++i];
                    args[i] = null;
                    continue;
                }
                this.onError(this.getMessage("wscompile.missingOptionArgument", args[i]));
                this.usage();
                return false;
            }
            if (args[i].equals("-catalog")) {
                if (this.program.equals(WSGEN)) {
                    this.onError(this.getMessage("wscompile.invalidOption", args[i]));
                    this.usage();
                    return false;
                }
                if (i + 1 < args.length) {
                    args[i] = null;
                    this.catalog = args[++i];
                    args[i] = null;
                    continue;
                }
                this.onError(this.getMessage("wscompile.missingOptionArgument", args[i]));
                this.usage();
                return false;
            }
            if (args[i].equals(SERVICENAME_OPTION)) {
                if (this.program.equals(WSIMPORT)) {
                    this.onError(this.getMessage("wscompile.invalidOption", args[i]));
                    this.usage();
                    return false;
                }
                if (i + 1 < args.length) {
                    args[i] = null;
                    this.serviceName = QName.valueOf(args[++i]);
                    if (this.serviceName.getNamespaceURI() == null || this.serviceName.getNamespaceURI().length() == 0) {
                        this.onError(this.getMessage("wsgen.servicename.missing.namespace", args[i]));
                        this.usage();
                        return false;
                    }
                    if (this.serviceName.getLocalPart() == null || this.serviceName.getLocalPart().length() == 0) {
                        this.onError(this.getMessage("wsgen.servicename.missing.localname", args[i]));
                        this.usage();
                        return false;
                    }
                    args[i] = null;
                    continue;
                }
                this.onError(this.getMessage("wscompile.missingOptionArgument", args[i]));
                this.usage();
                return false;
            }
            if (args[i].equals(PORTNAME_OPTION)) {
                if (this.program.equals(WSIMPORT)) {
                    this.onError(this.getMessage("wscompile.invalidOption", args[i]));
                    this.usage();
                    return false;
                }
                if (i + 1 < args.length) {
                    args[i] = null;
                    this.portName = QName.valueOf(args[++i]);
                    if (this.portName.getNamespaceURI() == null || this.portName.getNamespaceURI().length() == 0) {
                        this.onError(this.getMessage("wsgen.portname.missing.namespace", args[i]));
                        this.usage();
                        return false;
                    }
                    if (this.portName.getLocalPart() == null || this.portName.getLocalPart().length() == 0) {
                        this.onError(this.getMessage("wsgen.portname.missing.localname", args[i]));
                        this.usage();
                        return false;
                    }
                    args[i] = null;
                    continue;
                }
                this.onError(this.getMessage("wscompile.missingOptionArgument", args[i]));
                this.usage();
                return false;
            }
            if (args[i].equals("-d")) {
                if (i + 1 < args.length) {
                    if (this.destDir != null) {
                        this.onError(this.getMessage("wscompile.duplicateOption", "-d"));
                        this.usage();
                        return false;
                    }
                    args[i] = null;
                    this.destDir = new File(args[++i]);
                    args[i] = null;
                    if (this.destDir.exists()) continue;
                    this.onError(this.getMessage("wscompile.noSuchDirectory", this.destDir.getPath()));
                    this.usage();
                    return false;
                }
                this.onError(this.getMessage("wscompile.missingOptionArgument", "-d"));
                this.usage();
                return false;
            }
            if (args[i].equals("-r")) {
                if (this.program.equals(WSIMPORT)) {
                    this.onError(this.getMessage("wscompile.invalidOption", args[i]));
                    this.usage();
                    return false;
                }
                if (i + 1 < args.length) {
                    if (this.nonclassDestDir != null) {
                        this.onError(this.getMessage("wscompile.duplicateOption", "-r"));
                        this.usage();
                        return false;
                    }
                    args[i] = null;
                    this.nonclassDestDir = new File(args[++i]);
                    args[i] = null;
                    if (this.nonclassDestDir.exists()) continue;
                    this.onError(this.getMessage("wscompile.noSuchDirectory", this.nonclassDestDir.getPath()));
                    this.usage();
                    return false;
                }
                this.onError(this.getMessage("wscompile.missingOptionArgument", "-r"));
                this.usage();
                return false;
            }
            if (args[i].equals("-s")) {
                if (i + 1 < args.length) {
                    if (this.sourceDir != null) {
                        this.onError(this.getMessage("wscompile.duplicateOption", "-s"));
                        this.usage();
                        return false;
                    }
                    args[i] = null;
                    this.sourceDir = new File(args[++i]);
                    args[i] = null;
                    if (!this.sourceDir.exists()) {
                        this.onError(this.getMessage("wscompile.noSuchDirectory", this.sourceDir.getPath()));
                        this.usage();
                        return false;
                    }
                    this.keepGenerated = true;
                    continue;
                }
                this.onError(this.getMessage("wscompile.missingOptionArgument", "-s"));
                this.usage();
                return false;
            }
            if (args[i].equals("-classpath") || args[i].equals("-cp")) {
                if (this.program.equals(WSIMPORT)) {
                    this.onError(this.getMessage("wscompile.invalidOption", args[i]));
                    this.usage();
                    return false;
                }
                if (i + 1 < args.length) {
                    if (this.userClasspath != null) {
                        this.onError(this.getMessage("wscompile.duplicateOption", args[i]));
                        this.usage();
                        return false;
                    }
                    args[i] = null;
                    this.userClasspath = args[++i];
                    args[i] = null;
                    continue;
                }
                this.onError(this.getMessage("wscompile.missingOptionArgument", args[i]));
                this.usage();
                return false;
            }
            if (args[i].startsWith("-httpproxy:")) {
                if (this.program.equals(WSGEN)) {
                    this.onError(this.getMessage("wscompile.invalidOption", args[i]));
                    this.usage();
                    return false;
                }
                value = args[i].substring(11);
                if (value.length() == 0) {
                    this.onError(this.getMessage("wscompile.invalidOption", args[i]));
                    this.usage();
                    return false;
                }
                index = value.indexOf(58);
                if (index == -1) {
                    System.setProperty("proxySet", "true");
                    System.setProperty("proxyHost", value);
                    System.setProperty("proxyPort", "8080");
                } else {
                    System.setProperty("proxySet", "true");
                    System.setProperty("proxyHost", value.substring(0, index));
                    System.setProperty("proxyPort", value.substring(index + 1));
                }
                args[i] = null;
                continue;
            }
            if (args[i].startsWith("-wsdl")) {
                if (this.program.equals(WSIMPORT)) {
                    this.onError(this.getMessage("wscompile.invalidOption", args[i]));
                    this.usage();
                    return false;
                }
                this.genWsdl = true;
                value = args[i].substring(5);
                index = value.indexOf(58);
                if (index == 0) {
                    index = (value = value.substring(1)).indexOf(47);
                    if (index == -1) {
                        this.protocol = value;
                        this.transport = "http";
                    } else {
                        this.protocol = value.substring(0, index);
                        this.transport = value.substring(index + 1);
                    }
                    if (!CompileTool.isValidProtocol(this.protocol)) {
                        this.onError(this.getMessage("wsgen.invalid.protocol", this.protocol, VALID_PROTOCOLS));
                    }
                    this.protocolSet = true;
                    if (!CompileTool.isValidTransport(this.transport)) {
                        this.onError(this.getMessage("wsgen.invalid.transport", this.transport, "http"));
                    }
                }
                args[i] = null;
                continue;
            }
            if (args[i].equals("-extension")) {
                this.extensions = true;
                args[i] = null;
                continue;
            }
            if (args[i].startsWith("-help")) {
                this.help();
                return false;
            }
            if (!args[i].equals("-Xdonotoverwrite")) continue;
            if (this.program.equals(WSIMPORT)) {
                this.onError(this.getMessage("wscompile.invalidOption", args[i]));
                this.usage();
                return false;
            }
            this.doNotOverWrite = true;
            args[i] = null;
        }
        for (String arg : args) {
            if (arg == null) continue;
            if (arg.startsWith("-")) {
                this.onError(this.getMessage("wscompile.invalidOption", arg));
                this.usage();
                return false;
            }
            String fileName = arg;
            if (this.program.equals(WSGEN) && !this.isValidWSGenClass(fileName)) {
                return false;
            }
            this.inputFiles.add(fileName);
        }
        if (this.inputFiles.isEmpty()) {
            this.onError(this.getMessage(this.program + ".missingFile"));
            this.usage();
            return false;
        }
        if (!this.extensions && this.hasExtensions()) {
            return false;
        }
        this.properties.put("bindingFiles", this.bindingFiles);
        if (!this.validateArguments()) {
            this.usage();
            return false;
        }
        return true;
    }

    protected boolean isValidWSGenClass(String className) {
        Class clazz = this.getClass(className);
        if (clazz == null) {
            this.onError(this.getMessage("wsgen.class.not.found", className));
            return false;
        }
        if (clazz.isEnum() || clazz.isInterface() || clazz.isPrimitive()) {
            this.onError(this.getMessage("wsgen.class.must.be.implementation.class", className));
            return false;
        }
        if (this.genWsdl) {
            BindingImpl binding = (BindingImpl)BindingImpl.getBinding(null, clazz, null, false);
            if (!(binding instanceof SOAPBinding)) {
                this.onError(this.getMessage("wsgen.cannot.gen.wsdl.for.non.soap.binding", new Object[]{className, binding.getBindingId()}));
                return false;
            }
            SOAPBindingImpl soapBinding = (SOAPBindingImpl)binding;
            if (!(!soapBinding.getActualBindingId().equals(SOAP12_ID) && !soapBinding.getActualBindingId().equals("http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true") || this.protocol.equals(X_SOAP12) && this.extensions)) {
                this.onError(this.getMessage("wsgen.cannot.gen.wsdl.for.soap12.binding", new Object[]{className, binding.getBindingId()}));
                return false;
            }
            if (soapBinding.getActualBindingId().equals("http://java.sun.com/xml/ns/jaxws/2003/05/soap/bindings/HTTP/") && !this.extensions) {
                this.onError(this.getMessage("wsgen.cannot.gen.wsdl.for.xsoap12.binding.wo.extention", new Object[]{className, binding.getBindingId()}));
                return false;
            }
        }
        return true;
    }

    protected boolean validateArguments() {
        if (!this.genWsdl) {
            if (this.serviceName != null) {
                this.onError(this.getMessage("wsgen.wsdl.arg.no.genwsdl", SERVICENAME_OPTION));
                return false;
            }
            if (this.portName != null) {
                this.onError(this.getMessage("wsgen.wsdl.arg.no.genwsdl", PORTNAME_OPTION));
                return false;
            }
        }
        return true;
    }

    protected boolean hasExtensions() {
        if (this.protocol.equalsIgnoreCase(X_SOAP12)) {
            this.onError(this.getMessage("wsgen.soap12.without.extension"));
            return true;
        }
        return false;
    }

    public static boolean isValidProtocol(String protocol) {
        return protocol.equalsIgnoreCase(SOAP11) || protocol.equalsIgnoreCase(X_SOAP12);
    }

    public static boolean isValidTransport(String transport) {
        return transport.equalsIgnoreCase("http");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run() throws Exception {
        if (this.doNothing) {
            return;
        }
        try {
            this.beforeHook();
            if (this.entityResolver == null) {
                if (this.catalog != null && this.catalog.length() > 0) {
                    this.entityResolver = XmlUtil.createEntityResolver(JAXWSUtils.getFileOrURL(this.catalog));
                }
            } else if (this.catalog != null && this.catalog.length() > 0) {
                EntityResolver er = XmlUtil.createEntityResolver(JAXWSUtils.getFileOrURL(this.catalog));
                this.entityResolver = new ForkEntityResolver(er, this.entityResolver);
            }
            this.environment = this.createEnvironment();
            this.configuration = this.createConfiguration();
            this.setEnvironmentValues(this.environment);
            if (this.configuration.getModelInfo() instanceof ClassModelInfo) {
                this.buildModel(((ClassModelInfo)this.configuration.getModelInfo()).getClassName());
            } else {
                this.processor = new Processor(this.configuration, this.properties);
                this.configuration.getModelInfo().setEntityResolver(this.entityResolver);
                this.configuration.getModelInfo().setDefaultJavaPackage(this.defaultPackage);
                this.processor.runModeler();
                this.withModelHook();
                this.registerProcessorActions(this.processor);
                this.processor.runActions();
                if (this.environment.getErrorCount() == 0) {
                    this.compileGeneratedClasses();
                }
            }
            this.afterHook();
        }
        finally {
            if (!this.keepGenerated) {
                this.removeGeneratedFiles();
            }
            if (this.environment != null) {
                this.environment.shutdown();
            }
        }
    }

    protected void setEnvironmentValues(ProcessorEnvironment env) {
        int envFlags = env.getFlags();
        envFlags |= 2;
        if (this.verbose) {
            envFlags |= 1;
        }
        env.setFlags(envFlags);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.properties = new Properties();
        this.actions = new HashMap<String, ProcessorAction>();
        this.actions.put("service.generator", new ServiceGenerator());
        this.actions.put("remote.interface.impl.generator", new SeiGenerator());
        this.actions.put("custom.exception.generator", new CustomExceptionGenerator());
        this.actions.put("jaxb.type.generator", new JAXBTypeGenerator());
    }

    public void removeGeneratedFiles() {
        this.environment.deleteGeneratedFiles();
    }

    public void buildModel(String endpoint) {
        this.context = new AnnotationProcessorContext();
        this.webServiceAP = new WebServiceAP(this, this.environment, this.properties, this.context);
        String classpath = this.environment.getClassPath();
        String[] args = new String[]{"-d", this.destDir.getAbsolutePath(), "-classpath", classpath, "-s", this.sourceDir.getAbsolutePath(), "-XclassesAsDecls", endpoint};
        int result = Main.process((AnnotationProcessorFactory)this, (String[])args);
        if (result != 0) {
            this.environment.error(this.getMessage("wscompile.compilationFailed"));
            return;
        }
        if (this.genWsdl) {
            String tmpPath = this.destDir.getAbsolutePath() + File.pathSeparator + classpath;
            URLClassLoader classLoader = new URLClassLoader(ProcessorEnvironmentBase.pathToURLs(tmpPath), this.getClass().getClassLoader());
            Class<?> endpointClass = null;
            try {
                endpointClass = classLoader.loadClass(endpoint);
            }
            catch (ClassNotFoundException e) {
                this.environment.error(this.getMessage("wsgen.class.not.found", endpoint));
            }
            String bindingID = CompileTool.getBindingID(this.protocol);
            if (!this.protocolSet) {
                BindingImpl binding = (BindingImpl)BindingImpl.getBinding(null, endpointClass, null, false);
                bindingID = binding.getBindingId();
            }
            RuntimeModeler rtModeler = new RuntimeModeler(endpointClass, this.serviceName, bindingID);
            rtModeler.setClassLoader(classLoader);
            if (this.portName != null) {
                rtModeler.setPortName(this.portName);
            }
            RuntimeModel rtModel = rtModeler.buildRuntimeModel();
            WSDLGenerator wsdlGenerator = new WSDLGenerator(rtModel, new WSDLOutputResolver(){

                @Override
                public Result getWSDLOutput(String suggestedFilename) {
                    File wsdlFile = new File(CompileTool.this.nonclassDestDir, suggestedFilename);
                    StreamResult result = new StreamResult();
                    try {
                        result = new StreamResult(new FileOutputStream(wsdlFile));
                        result.setSystemId(wsdlFile.toString().replace('\\', '/'));
                    }
                    catch (FileNotFoundException e) {
                        CompileTool.this.environment.error(CompileTool.this.getMessage("wsgen.could.not.create.file", wsdlFile.toString()));
                    }
                    return result;
                }

                public Result getSchemaOutput(String namespace, String suggestedFilename) {
                    if (namespace.equals("")) {
                        return null;
                    }
                    return this.getWSDLOutput(suggestedFilename);
                }

                @Override
                public Result getAbstractWSDLOutput(Holder<String> filename) {
                    return this.getWSDLOutput((String)filename.value);
                }

                @Override
                public Result getSchemaOutput(String namespace, Holder<String> filename) {
                    return this.getSchemaOutput(namespace, (String)filename.value);
                }
            }, bindingID);
            wsdlGenerator.doGeneration();
        }
    }

    public static String getBindingID(String protocol) {
        if (protocol.equals(SOAP11)) {
            return SOAP11_ID;
        }
        if (protocol.equals(X_SOAP12)) {
            return SOAP12_ID;
        }
        return null;
    }

    @Override
    public void runProcessorActions() {
        if (!(this.configuration.getModelInfo() instanceof ClassModelInfo)) {
            this.onError(this.getMessage("wscompile.classmodelinfo.expected", new Object[]{this.configuration.getModelInfo()}));
            return;
        }
        Model model = this.context.getSEIContext(((ClassModelInfo)this.configuration.getModelInfo()).getClassName()).getModel();
        this.processor = new Processor(this.configuration, this.properties, model);
        this.withModelHook();
        this.registerProcessorActions(this.processor);
        this.processor.runActions();
    }

    protected String getSourceVersion() {
        if (this.targetVersion == null) {
            return "2.0";
        }
        return this.targetVersion;
    }

    protected void withModelHook() {
    }

    protected void afterHook() {
    }

    protected void compileGeneratedClasses() {
        ArrayList<String> sourceFiles = new ArrayList<String>();
        Iterator iter = this.environment.getGeneratedFiles();
        while (iter.hasNext()) {
            GeneratedFileInfo fileInfo = (GeneratedFileInfo)iter.next();
            File f = fileInfo.getFile();
            if (!f.exists() || !f.getName().endsWith(".java")) continue;
            sourceFiles.add(f.getAbsolutePath());
        }
        if (sourceFiles.size() > 0) {
            String classDir = this.destDir.getAbsolutePath();
            String classpathString = this.createClasspathString();
            String[] args = new String[4 + (this.compilerDebug ? 1 : 0) + (this.compilerOptimize ? 1 : 0) + sourceFiles.size()];
            args[0] = "-d";
            args[1] = classDir;
            args[2] = "-classpath";
            args[3] = classpathString;
            int baseIndex = 4;
            if (this.compilerDebug) {
                args[baseIndex++] = "-g";
            }
            if (this.compilerOptimize) {
                args[baseIndex++] = "-O";
            }
            for (int i = 0; i < sourceFiles.size(); ++i) {
                args[baseIndex + i] = (String)sourceFiles.get(i);
            }
            JavaCompilerHelper compilerHelper = new JavaCompilerHelper(this.out);
            boolean result = compilerHelper.compile(args);
            if (!result) {
                this.environment.error(this.getMessage("wscompile.compilationFailed"));
            }
        }
    }

    protected ProcessorAction getAction(String name) {
        return this.actions.get(name);
    }

    protected String createClasspathString() {
        if (this.userClasspath == null) {
            this.userClasspath = "";
        }
        return this.userClasspath + File.pathSeparator + System.getProperty("java.class.path");
    }

    protected void registerProcessorActions(Processor processor) {
        this.register(processor);
    }

    protected void register(Processor processor) {
        boolean genServiceInterface = false;
        boolean genInterface = false;
        boolean genCustomClasses = false;
        if (this.configuration.getModelInfo() instanceof WSDLModelInfo) {
            genInterface = true;
            genServiceInterface = true;
            genCustomClasses = true;
        }
        if (genServiceInterface) {
            processor.add(this.getAction("service.generator"));
        }
        if (genCustomClasses) {
            processor.add(this.getAction("jaxb.type.generator"));
        }
        if (genInterface) {
            processor.add(this.getAction("custom.exception.generator"));
            processor.add(this.getAction("remote.interface.impl.generator"));
        }
    }

    protected Configuration createConfiguration() throws Exception {
        if (this.environment == null) {
            this.environment = this.createEnvironment();
        }
        Reader reader = new Reader(this.environment, this.properties);
        return reader.parse(this.entityResolver, this.inputFiles);
    }

    protected void beforeHook() {
        if (this.destDir == null) {
            this.destDir = new File(".");
        }
        if (this.sourceDir == null) {
            this.sourceDir = this.destDir;
        }
        if (this.nonclassDestDir == null) {
            this.nonclassDestDir = this.destDir;
        }
        this.properties.setProperty("sourceDirectory", this.sourceDir.getAbsolutePath());
        this.properties.setProperty("destinationDirectory", this.destDir.getAbsolutePath());
        this.properties.setProperty("nonclassDestinationDirectory", this.nonclassDestDir.getAbsolutePath());
        this.properties.setProperty("extension", this.extensions ? "true" : "false");
        this.properties.setProperty("printStackTrace", this.verbose ? "true" : "false");
        this.properties.setProperty("protocol", this.protocol);
        this.properties.setProperty("transport", this.transport);
        this.properties.setProperty("sourceVersion", this.getSourceVersion());
        if (this.wsdlLocation != null) {
            this.properties.setProperty("wsdllocation", this.wsdlLocation);
        }
        if (this.defaultPackage != null) {
            this.properties.setProperty("defaultpackage", this.defaultPackage);
        }
        this.properties.setProperty("doNotOverWrite", this.doNotOverWrite ? "true" : "false");
    }

    @Override
    protected String getGenericErrorMessage() {
        return "wscompile.error";
    }

    @Override
    protected String getResourceBundleName() {
        return "org.jboss.com.sun.tools.ws.resources.wscompile";
    }

    public Collection<String> supportedOptions() {
        return supportedOptions;
    }

    public Collection<String> supportedAnnotationTypes() {
        return supportedAnnotations;
    }

    @Override
    public void onError(Localizable msg) {
        this.report(this.getMessage("wscompile.error", this.localizer.localize(msg)));
    }

    @Override
    public void onWarning(Localizable msg) {
        this.report(this.getMessage("wscompile.warning", this.localizer.localize(msg)));
    }

    @Override
    public void onInfo(Localizable msg) {
        this.report(this.getMessage("wscompile.info", this.localizer.localize(msg)));
    }

    public AnnotationProcessor getProcessorFor(Set<AnnotationTypeDeclaration> atds, AnnotationProcessorEnvironment apEnv) {
        if (this.verbose) {
            apEnv.getMessager().printNotice("\tap round: " + ++this.round);
        }
        this.webServiceAP.init(apEnv);
        return this.webServiceAP;
    }

    private Class getClass(String className) {
        try {
            ProcessorEnvironment env = this.createEnvironment();
            return env.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private ProcessorEnvironment createEnvironment() throws Exception {
        String cpath = this.userClasspath + File.pathSeparator + System.getProperty("java.class.path");
        ClientProcessorEnvironment env = new ClientProcessorEnvironment(System.out, cpath, this.listener);
        return env;
    }

    protected void usage() {
        this.help();
    }

    protected void help() {
        this.report(this.getMessage(this.program + ".help", this.program));
        this.report(this.getMessage(this.program + ".usage.examples"));
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    static {
        HashSet<String> types = new HashSet<String>();
        types.add("*");
        types.add("javax.jws.*");
        types.add("javax.jws.soap.*");
        supportedAnnotations = Collections.unmodifiableCollection(types);
    }
}

