/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jgroups.Address;
import org.jgroups.BlockEvent;
import org.jgroups.Channel;
import org.jgroups.ChannelClosedException;
import org.jgroups.ChannelException;
import org.jgroups.ChannelNotConnectedException;
import org.jgroups.Event;
import org.jgroups.ExitEvent;
import org.jgroups.ExtendedReceiver;
import org.jgroups.GetStateEvent;
import org.jgroups.MergeView;
import org.jgroups.Message;
import org.jgroups.SetStateEvent;
import org.jgroups.StreamingGetStateEvent;
import org.jgroups.StreamingSetStateEvent;
import org.jgroups.SuspectEvent;
import org.jgroups.TimeoutException;
import org.jgroups.UnblockEvent;
import org.jgroups.View;
import org.jgroups.conf.ConfiguratorFactory;
import org.jgroups.conf.ProtocolStackConfigurator;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.ProtocolStack;
import org.jgroups.stack.StateTransferInfo;
import org.jgroups.util.Promise;
import org.jgroups.util.Queue;
import org.jgroups.util.QueueClosedException;
import org.jgroups.util.Util;
import org.w3c.dom.Element;

public class JChannel
extends Channel {
    public static final String DEFAULT_PROTOCOL_STACK = "UDP(down_thread=false;mcast_send_buf_size=640000;mcast_port=45566;discard_incompatible_packets=true;ucast_recv_buf_size=20000000;mcast_addr=228.10.10.10;up_thread=false;loopback=false;mcast_recv_buf_size=25000000;max_bundle_size=64000;max_bundle_timeout=30;use_incoming_packet_handler=true;use_outgoing_packet_handler=false;ucast_send_buf_size=640000;tos=16;enable_bundling=true;ip_ttl=2):PING(timeout=2000;down_thread=false;num_initial_members=3;up_thread=false):MERGE2(max_interval=10000;down_thread=false;min_interval=5000;up_thread=false):FD(timeout=2000;max_tries=3;down_thread=false;up_thread=false):VERIFY_SUSPECT(timeout=1500;down_thread=false;up_thread=false):pbcast.NAKACK(max_xmit_size=60000;down_thread=false;use_mcast_xmit=false;gc_lag=0;discard_delivered_msgs=true;up_thread=false;retransmit_timeout=100,200,300,600,1200,2400,4800):UNICAST(timeout=300,600,1200,2400,3600;down_thread=false;up_thread=false):pbcast.STABLE(stability_delay=1000;desired_avg_gossip=50000;max_bytes=400000;down_thread=false;up_thread=false):VIEW_SYNC(down_thread=false;avg_send_interval=60000;up_thread=false):pbcast.GMS(print_local_addr=true;join_timeout=3000;down_thread=false;join_retry_timeout=2000;up_thread=false;shun=true):FC(max_credits=2000000;down_thread=false;up_thread=false;min_threshold=0.10):FRAG2(frag_size=60000;down_thread=false;up_thread=false):pbcast.STATE_TRANSFER(down_thread=false;up_thread=false)";
    static final String FORCE_PROPS = "force.properties";
    private String props = null;
    private Address local_addr = null;
    private String cluster_name = null;
    private View my_view = null;
    private final Queue mq = new Queue();
    private ProtocolStack prot_stack = null;
    protected CloserThread closer = null;
    private final Promise local_addr_promise = new Promise();
    private final Promise connect_promise = new Promise();
    private final Promise disconnect_promise = new Promise();
    private final Promise state_promise = new Promise();
    private final Promise flush_unblock_promise = new Promise();
    private final Promise flush_promise = new Promise();
    private long LOCAL_ADDR_TIMEOUT = 30000L;
    private static final long GET_STATE_DEFAULT_TIMEOUT = 5000L;
    private static final long FLUSH_UNBLOCK_TIMEOUT = 10000L;
    private boolean receive_blocks = false;
    private boolean receive_local_msgs = true;
    private boolean auto_reconnect = false;
    private boolean auto_getstate = false;
    protected boolean connected = false;
    protected boolean closed = false;
    private boolean state_transfer_supported = false;
    private volatile boolean flush_supported = false;
    private byte[] additional_data = null;
    protected final Log log = LogFactory.getLog(this.getClass());
    protected boolean stats = true;
    protected long sent_msgs = 0L;
    protected long received_msgs = 0L;
    protected long sent_bytes = 0L;
    protected long received_bytes = 0L;

    protected JChannel(boolean no_op) {
    }

    public JChannel() throws ChannelException {
        this(DEFAULT_PROTOCOL_STACK);
    }

    public JChannel(File properties) throws ChannelException {
        this(ConfiguratorFactory.getStackConfigurator(properties));
    }

    public JChannel(Element properties) throws ChannelException {
        this(ConfiguratorFactory.getStackConfigurator(properties));
    }

    public JChannel(URL properties) throws ChannelException {
        this(ConfiguratorFactory.getStackConfigurator(properties));
    }

    public JChannel(String properties) throws ChannelException {
        this(ConfiguratorFactory.getStackConfigurator(properties));
    }

    protected JChannel(ProtocolStackConfigurator configurator) throws ChannelException {
        this.init(configurator);
    }

    public JChannel(Object properties) throws ChannelException {
        if (properties == null) {
            properties = DEFAULT_PROTOCOL_STACK;
        }
        ProtocolStackConfigurator c = null;
        try {
            c = ConfiguratorFactory.getStackConfigurator(properties);
        }
        catch (Exception x) {
            throw new ChannelException("unable to load protocol stack", x);
        }
        this.init(c);
    }

    public ProtocolStack getProtocolStack() {
        return this.prot_stack;
    }

    protected Log getLog() {
        return this.log;
    }

    public String getProperties() {
        return this.props;
    }

    public boolean statsEnabled() {
        return this.stats;
    }

    public void enableStats(boolean stats) {
        this.stats = stats;
    }

    public void resetStats() {
        this.received_bytes = 0L;
        this.sent_bytes = 0L;
        this.received_msgs = 0L;
        this.sent_msgs = 0L;
    }

    public long getSentMessages() {
        return this.sent_msgs;
    }

    public long getSentBytes() {
        return this.sent_bytes;
    }

    public long getReceivedMessages() {
        return this.received_msgs;
    }

    public long getReceivedBytes() {
        return this.received_bytes;
    }

    public int getNumberOfTasksInTimer() {
        return this.prot_stack != null ? this.prot_stack.timer.size() : -1;
    }

    public String dumpTimerQueue() {
        return this.prot_stack != null ? this.prot_stack.dumpTimerQueue() : "<n/a";
    }

    public String printProtocolSpec(boolean include_properties) {
        return this.prot_stack != null ? this.prot_stack.printProtocolSpec(include_properties) : null;
    }

    public synchronized void connect(String cluster_name) throws ChannelException, ChannelClosedException {
        block14: {
            this.checkClosed();
            if (this.connected) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)("already connected to " + cluster_name));
                }
                return;
            }
            if (cluster_name == null) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)"cluster_name is null, assuming unicast channel");
                }
            } else {
                this.cluster_name = cluster_name;
            }
            try {
                this.prot_stack.startStack();
            }
            catch (Throwable e) {
                throw new ChannelException("failed to start protocol stack", e);
            }
            String tmp = Util.getProperty(new String[]{"jgroups.channel.local_addr_timeout", "local_addr.timeout"}, null, null, false, "30000");
            this.LOCAL_ADDR_TIMEOUT = Long.parseLong(tmp);
            this.local_addr = (Address)this.local_addr_promise.getResult(this.LOCAL_ADDR_TIMEOUT);
            if (this.local_addr == null) {
                this.log.fatal((Object)"local_addr is null; cannot connect");
                throw new ChannelException("local_addr is null");
            }
            Vector<Address> t = new Vector<Address>(1);
            t.addElement(this.local_addr);
            this.my_view = new View(this.local_addr, 0L, t);
            if (cluster_name != null) {
                boolean shouldWaitForUnblock;
                this.connect_promise.reset();
                if (this.flush_supported) {
                    this.flush_unblock_promise.reset();
                }
                Event connect_event = new Event(2, cluster_name);
                this.down(connect_event);
                Object res = this.connect_promise.getResult();
                if (res != null && res instanceof Exception) {
                    throw new ChannelException("connect() failed", (Throwable)res);
                }
                boolean singletonMember = this.my_view != null && this.my_view.size() == 1;
                boolean bl = shouldWaitForUnblock = this.flush_supported && this.receive_blocks && !singletonMember && !this.flush_unblock_promise.hasResult();
                if (shouldWaitForUnblock) {
                    try {
                        this.flush_unblock_promise.getResultWithTimeout(10000L);
                    }
                    catch (TimeoutException te) {
                        if (!this.log.isWarnEnabled()) break block14;
                        this.log.warn((Object)"waiting on UNBLOCK after connect timed out");
                    }
                }
            }
        }
        this.connected = true;
        this.notifyChannelConnected(this);
    }

    public synchronized boolean connect(String cluster_name, Address target, String state_id, long timeout) throws ChannelException {
        throw new UnsupportedOperationException("not yet implemented");
    }

    public synchronized void disconnect() {
        if (this.closed) {
            return;
        }
        if (this.connected) {
            block5: {
                if (this.cluster_name != null) {
                    Event disconnect_event = new Event(4, this.local_addr);
                    this.disconnect_promise.reset();
                    this.down(disconnect_event);
                    this.disconnect_promise.getResult();
                }
                this.down(new Event(23));
                this.connected = false;
                try {
                    this.prot_stack.stopStack();
                }
                catch (Exception e) {
                    if (!this.log.isErrorEnabled()) break block5;
                    this.log.error((Object)("exception: " + e));
                }
            }
            this.notifyChannelDisconnected(this);
            this.init();
        }
    }

    public synchronized void close() {
        this._close(true, true);
    }

    public synchronized void shutdown() {
        this._close(false, true);
    }

    public synchronized void open() throws ChannelException {
        if (!this.closed) {
            throw new ChannelException("channel is already open");
        }
        try {
            this.mq.reset();
            this.prot_stack = new ProtocolStack(this, this.props);
            this.prot_stack.setup();
            this.closed = false;
        }
        catch (Exception e) {
            throw new ChannelException("failed to open channel", e);
        }
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public int getNumMessages() {
        return this.mq != null ? this.mq.size() : -1;
    }

    public String dumpQueue() {
        return Util.dumpQueue(this.mq);
    }

    public Map dumpStats() {
        Map tmp;
        Map retval = this.prot_stack.dumpStats();
        if (retval != null && (tmp = this.dumpChannelStats()) != null) {
            retval.put("channel", tmp);
        }
        return retval;
    }

    private Map dumpChannelStats() {
        HashMap<String, Long> retval = new HashMap<String, Long>();
        retval.put("sent_msgs", new Long(this.sent_msgs));
        retval.put("sent_bytes", new Long(this.sent_bytes));
        retval.put("received_msgs", new Long(this.received_msgs));
        retval.put("received_bytes", new Long(this.received_bytes));
        return retval;
    }

    public void send(Message msg) throws ChannelNotConnectedException, ChannelClosedException {
        this.checkClosed();
        this.checkNotConnected();
        if (this.stats) {
            ++this.sent_msgs;
            this.sent_bytes += (long)msg.getLength();
        }
        if (msg == null) {
            throw new NullPointerException("msg is null");
        }
        this.down(new Event(1, msg));
    }

    public void send(Address dst, Address src, Serializable obj) throws ChannelNotConnectedException, ChannelClosedException {
        this.send(new Message(dst, src, obj));
    }

    public Object receive(long timeout) throws ChannelNotConnectedException, ChannelClosedException, TimeoutException {
        this.checkClosed();
        this.checkNotConnected();
        try {
            Event evt = timeout <= 0L ? (Event)this.mq.remove() : (Event)this.mq.remove(timeout);
            Object retval = JChannel.getEvent(evt);
            evt = null;
            return retval;
        }
        catch (QueueClosedException queue_closed) {
            throw new ChannelClosedException();
        }
        catch (TimeoutException t) {
            throw t;
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("exception: " + e));
            }
            return null;
        }
    }

    public Object peek(long timeout) throws ChannelNotConnectedException, ChannelClosedException, TimeoutException {
        this.checkClosed();
        this.checkNotConnected();
        try {
            Event evt = timeout <= 0L ? (Event)this.mq.peek() : (Event)this.mq.peek(timeout);
            Object retval = JChannel.getEvent(evt);
            evt = null;
            return retval;
        }
        catch (QueueClosedException queue_closed) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("exception: " + queue_closed));
            }
            return null;
        }
        catch (TimeoutException t) {
            return null;
        }
        catch (Exception e) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("exception: " + e));
            }
            return null;
        }
    }

    public View getView() {
        return this.closed || !this.connected ? null : this.my_view;
    }

    public Address getLocalAddress() {
        return this.closed ? null : this.local_addr;
    }

    public String getChannelName() {
        return this.closed ? null : (!this.connected ? null : this.cluster_name);
    }

    public String getClusterName() {
        return this.cluster_name;
    }

    public void setOpt(int option, Object value) {
        if (this.closed) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)"channel is closed; option not set !");
            }
            return;
        }
        switch (option) {
            case 1: {
                if (!this.log.isWarnEnabled()) break;
                this.log.warn((Object)"option VIEW has been deprecated (it is always true now); this option is ignored");
                break;
            }
            case 2: {
                if (!this.log.isWarnEnabled()) break;
                this.log.warn((Object)"option SUSPECT has been deprecated (it is always true now); this option is ignored");
                break;
            }
            case 0: {
                if (value instanceof Boolean) {
                    this.receive_blocks = (Boolean)value;
                    break;
                }
                if (!this.log.isErrorEnabled()) break;
                this.log.error((Object)("option " + Channel.option2String(option) + " (" + value + "): value has to be Boolean"));
                break;
            }
            case 4: {
                if (!this.log.isTraceEnabled()) break;
                this.log.trace((Object)"option GET_STATE_EVENTS has been deprecated (it is always true now); this option is ignored");
                break;
            }
            case 3: {
                if (value instanceof Boolean) {
                    this.receive_local_msgs = (Boolean)value;
                    break;
                }
                if (!this.log.isErrorEnabled()) break;
                this.log.error((Object)("option " + Channel.option2String(option) + " (" + value + "): value has to be Boolean"));
                break;
            }
            case 5: {
                if (value instanceof Boolean) {
                    this.auto_reconnect = (Boolean)value;
                    break;
                }
                if (!this.log.isErrorEnabled()) break;
                this.log.error((Object)("option " + Channel.option2String(option) + " (" + value + "): value has to be Boolean"));
                break;
            }
            case 6: {
                if (value instanceof Boolean) {
                    this.auto_getstate = (Boolean)value;
                    if (!this.auto_getstate) break;
                    this.auto_reconnect = true;
                    break;
                }
                if (!this.log.isErrorEnabled()) break;
                this.log.error((Object)("option " + Channel.option2String(option) + " (" + value + "): value has to be Boolean"));
                break;
            }
            default: {
                if (!this.log.isErrorEnabled()) break;
                this.log.error((Object)("option " + Channel.option2String(option) + " not known"));
            }
        }
    }

    public Object getOpt(int option) {
        switch (option) {
            case 1: {
                return Boolean.TRUE;
            }
            case 0: {
                return this.receive_blocks ? Boolean.TRUE : Boolean.FALSE;
            }
            case 2: {
                return Boolean.TRUE;
            }
            case 5: {
                return this.auto_reconnect ? Boolean.TRUE : Boolean.FALSE;
            }
            case 6: {
                return this.auto_getstate ? Boolean.TRUE : Boolean.FALSE;
            }
            case 4: {
                return Boolean.TRUE;
            }
            case 3: {
                return this.receive_local_msgs ? Boolean.TRUE : Boolean.FALSE;
            }
        }
        if (this.log.isErrorEnabled()) {
            this.log.error((Object)("option " + Channel.option2String(option) + " not known"));
        }
        return null;
    }

    public void blockOk() {
        this.down(new Event(11));
        this.down(new Event(22));
    }

    public boolean getState(Address target, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
        return this.getState(target, null, timeout);
    }

    public boolean getState(Address target, String state_id, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
        if (target == null) {
            target = this.determineCoordinator();
        }
        if (target != null && this.local_addr != null && target.equals(this.local_addr)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("cannot get state from myself (" + target + "): probably the first member"));
            }
            return false;
        }
        StateTransferInfo info = new StateTransferInfo(target, state_id, timeout);
        boolean rc = this._getState(new Event(19, info), info);
        if (!rc) {
            this.down(new Event(66));
        }
        return rc;
    }

    public boolean getAllStates(Vector targets, long timeout) throws ChannelNotConnectedException, ChannelClosedException {
        throw new UnsupportedOperationException("use getState() instead");
    }

    public void returnState(byte[] state) {
        StateTransferInfo info = new StateTransferInfo(null, null, 0L, state);
        this.down(new Event(18, info));
    }

    public void returnState(byte[] state, String state_id) {
        StateTransferInfo info = new StateTransferInfo(null, state_id, 0L, state);
        this.down(new Event(18, info));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void up(Event evt) {
        block56: {
            int type = evt.getType();
            switch (type) {
                case 1: {
                    Message msg = (Message)evt.getArg();
                    if (this.stats) {
                        ++this.received_msgs;
                        this.received_bytes += (long)msg.getLength();
                    }
                    if (this.receive_local_msgs || this.local_addr == null || msg.getSrc() == null || !this.local_addr.equals(msg.getSrc())) break;
                    return;
                }
                case 6: {
                    View tmp = (View)evt.getArg();
                    this.my_view = tmp instanceof MergeView ? new View(tmp.getVid(), tmp.getMembers()) : tmp;
                    if (!this.connected) {
                        this.connected = true;
                    }
                    this.down(new Event(23));
                    break;
                }
                case 56: {
                    HashMap config = (HashMap)evt.getArg();
                    if (config == null) break;
                    if (config.containsKey("state_transfer")) {
                        this.state_transfer_supported = (Boolean)config.get("state_transfer");
                    }
                    if (!config.containsKey("flush_supported")) break;
                    this.flush_supported = (Boolean)config.get("flush_supported");
                    break;
                }
                case 3: {
                    this.connect_promise.setResult(evt.getArg());
                    break;
                }
                case 69: {
                    this.flush_promise.setResult(Boolean.TRUE);
                    break;
                }
                case 5: {
                    this.disconnect_promise.setResult(Boolean.TRUE);
                    break;
                }
                case 20: {
                    StateTransferInfo info = (StateTransferInfo)evt.getArg();
                    byte[] state = info.state;
                    this.state_promise.setResult(state != null ? Boolean.TRUE : Boolean.FALSE);
                    if (this.up_handler != null) {
                        this.up_handler.up(evt);
                        return;
                    }
                    if (state == null) break;
                    String state_id = info.state_id;
                    if (this.receiver != null) {
                        if (this.receiver instanceof ExtendedReceiver && state_id != null) {
                            ((ExtendedReceiver)this.receiver).setState(state_id, state);
                            break;
                        }
                        this.receiver.setState(state);
                        break;
                    }
                    try {
                        this.mq.add(new Event(21, info));
                    }
                    catch (Exception e) {}
                    break;
                }
                case 71: {
                    StateTransferInfo sti = (StateTransferInfo)evt.getArg();
                    InputStream is = sti.inputStream;
                    if (this.up_handler != null) {
                        this.up_handler.up(evt);
                        return;
                    }
                    if (is == null) break;
                    if (this.receiver instanceof ExtendedReceiver) {
                        if (sti.state_id == null) {
                            ((ExtendedReceiver)this.receiver).setState(is);
                            break;
                        }
                        ((ExtendedReceiver)this.receiver).setState(sti.state_id, is);
                        break;
                    }
                    try {
                        this.mq.add(new Event(71, sti));
                    }
                    catch (Exception e) {}
                    break;
                }
                case 8: {
                    this.local_addr_promise.setResult(evt.getArg());
                    break;
                }
                case 46: {
                    this.handleExit(evt);
                    return;
                }
            }
            if (this.up_handler != null) {
                this.up_handler.up(evt);
                if (type == 75) {
                    this.flush_unblock_promise.setResult(Boolean.TRUE);
                }
                return;
            }
            switch (type) {
                case 1: {
                    if (this.receiver == null) break;
                    this.receiver.receive((Message)evt.getArg());
                    return;
                }
                case 6: {
                    if (this.receiver == null) break;
                    this.receiver.viewAccepted((View)evt.getArg());
                    return;
                }
                case 9: {
                    if (this.receiver == null) break;
                    this.receiver.suspect((Address)evt.getArg());
                    return;
                }
                case 17: {
                    if (this.receiver == null) break;
                    StateTransferInfo info = (StateTransferInfo)evt.getArg();
                    String state_id = info.state_id;
                    byte[] tmp_state = this.receiver instanceof ExtendedReceiver && state_id != null ? ((ExtendedReceiver)this.receiver).getState(state_id) : this.receiver.getState();
                    this.returnState(tmp_state, state_id);
                    return;
                }
                case 72: {
                    if (this.receiver == null) break;
                    StateTransferInfo sti = (StateTransferInfo)evt.getArg();
                    OutputStream os = sti.outputStream;
                    if (os != null && this.receiver instanceof ExtendedReceiver) {
                        if (sti.state_id == null) {
                            ((ExtendedReceiver)this.receiver).getState(os);
                        } else {
                            ((ExtendedReceiver)this.receiver).getState(sti.state_id, os);
                        }
                    }
                    return;
                }
                case 10: {
                    if (!this.receive_blocks) {
                        this.down(new Event(11));
                        this.down(new Event(22));
                        return;
                    }
                    if (this.receiver == null) break;
                    try {
                        this.receiver.block();
                    }
                    catch (Throwable t) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error((Object)"failed calling block() on Receiver", t);
                        }
                    }
                    finally {
                        this.blockOk();
                    }
                    return;
                }
                case 75: {
                    if (!this.receive_blocks) {
                        return;
                    }
                    if (!(this.receiver instanceof ExtendedReceiver)) break;
                    try {
                        ((ExtendedReceiver)this.receiver).unblock();
                    }
                    catch (Throwable t) {
                        if (this.log.isErrorEnabled()) {
                            this.log.error((Object)"failed calling unblock() on Receiver", t);
                        }
                    }
                    finally {
                        this.flush_unblock_promise.setResult(Boolean.TRUE);
                    }
                    return;
                }
            }
            if (type == 1 || type == 6 || type == 9 || type == 17 || type == 72 || type == 10 || type == 75) {
                try {
                    this.mq.add(evt);
                }
                catch (Exception e) {
                    if (!this.log.isErrorEnabled()) break block56;
                    this.log.error((Object)("exception adding event " + evt + " to message queue"), (Throwable)e);
                }
            }
        }
    }

    public void down(Event evt) {
        block10: {
            if (evt == null) {
                return;
            }
            if (evt.getType() == 56) {
                try {
                    Map m = (Map)evt.getArg();
                    if (m != null && m.containsKey("additional_data")) {
                        this.additional_data = (byte[])m.get("additional_data");
                        if (this.local_addr instanceof IpAddress) {
                            ((IpAddress)this.local_addr).setAdditionalData(this.additional_data);
                        }
                    }
                }
                catch (Throwable t) {
                    if (!this.log.isErrorEnabled()) break block10;
                    this.log.error((Object)("CONFIG event did not contain a hashmap: " + t));
                }
            }
        }
        if (evt.getType() == 73) {
            this.state_promise.setResult(Boolean.TRUE);
        }
        if (this.prot_stack != null) {
            this.prot_stack.down(evt);
        } else if (this.log.isErrorEnabled()) {
            this.log.error((Object)"no protocol stack available");
        }
    }

    public String toString(boolean details) {
        StringBuffer sb = new StringBuffer();
        sb.append("local_addr=").append(this.local_addr).append('\n');
        sb.append("cluster_name=").append(this.cluster_name).append('\n');
        sb.append("my_view=").append(this.my_view).append('\n');
        sb.append("connected=").append(this.connected).append('\n');
        sb.append("closed=").append(this.closed).append('\n');
        if (this.mq != null) {
            sb.append("incoming queue size=").append(this.mq.size()).append('\n');
        }
        if (details) {
            sb.append("receive_blocks=").append(this.receive_blocks).append('\n');
            sb.append("receive_local_msgs=").append(this.receive_local_msgs).append('\n');
            sb.append("auto_reconnect=").append(this.auto_reconnect).append('\n');
            sb.append("auto_getstate=").append(this.auto_getstate).append('\n');
            sb.append("state_transfer_supported=").append(this.state_transfer_supported).append('\n');
            sb.append("props=").append(this.props).append('\n');
        }
        return sb.toString();
    }

    protected final void init(ProtocolStackConfigurator configurator) throws ChannelException {
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)"JGroups version: 2.4.4.GA");
        }
        ConfiguratorFactory.substituteVariables(configurator);
        this.props = configurator.getProtocolStackString();
        this.prot_stack = new ProtocolStack(this, this.props);
        try {
            this.prot_stack.setup();
        }
        catch (Throwable e) {
            throw new ChannelException("unable to setup the protocol stack", e);
        }
    }

    private void init() {
        this.local_addr = null;
        this.cluster_name = null;
        this.my_view = null;
        this.connect_promise.reset();
        this.disconnect_promise.reset();
        this.connected = false;
    }

    protected void checkNotConnected() throws ChannelNotConnectedException {
        if (!this.connected) {
            throw new ChannelNotConnectedException();
        }
    }

    protected void checkClosed() throws ChannelClosedException {
        if (this.closed) {
            throw new ChannelClosedException();
        }
    }

    static Object getEvent(Event evt) {
        if (evt == null) {
            return null;
        }
        switch (evt.getType()) {
            case 1: {
                return evt.getArg();
            }
            case 6: {
                return evt.getArg();
            }
            case 9: {
                return new SuspectEvent(evt.getArg());
            }
            case 10: {
                return new BlockEvent();
            }
            case 75: {
                return new UnblockEvent();
            }
            case 17: {
                StateTransferInfo info = (StateTransferInfo)evt.getArg();
                return new GetStateEvent(info.target, info.state_id);
            }
            case 21: {
                StateTransferInfo info = (StateTransferInfo)evt.getArg();
                return new SetStateEvent(info.state, info.state_id);
            }
            case 72: {
                StateTransferInfo info = (StateTransferInfo)evt.getArg();
                return new StreamingGetStateEvent(info.outputStream, info.state_id);
            }
            case 71: {
                StateTransferInfo info = (StateTransferInfo)evt.getArg();
                return new StreamingSetStateEvent(info.inputStream, info.state_id);
            }
            case 46: {
                return new ExitEvent();
            }
        }
        return evt;
    }

    private boolean _getState(Event evt, StateTransferInfo info) throws ChannelNotConnectedException, ChannelClosedException {
        Boolean state_transfer_successfull;
        block5: {
            boolean shouldWaitForUnblock;
            this.checkClosed();
            this.checkNotConnected();
            if (!this.state_transfer_supported) {
                throw new IllegalStateException("fetching state will fail as state transfer is not supported. Add one of the STATE_TRANSFER protocols to your protocol configuration");
            }
            if (this.flush_supported) {
                this.flush_unblock_promise.reset();
            }
            this.state_promise.reset();
            this.down(evt);
            state_transfer_successfull = (Boolean)this.state_promise.getResult(info.timeout);
            boolean bl = shouldWaitForUnblock = this.flush_supported && this.receive_blocks;
            if (shouldWaitForUnblock) {
                try {
                    this.flush_unblock_promise.getResultWithTimeout(10000L);
                }
                catch (TimeoutException te) {
                    if (!this.log.isWarnEnabled()) break block5;
                    this.log.warn((Object)"Waiting on UNBLOCK after getState timed out");
                }
            }
        }
        return state_transfer_successfull != null && state_transfer_successfull != false;
    }

    protected void _close(boolean disconnect, boolean close_mq) {
        block10: {
            block9: {
                if (this.closed) {
                    return;
                }
                if (disconnect) {
                    this.disconnect();
                }
                if (close_mq) {
                    try {
                        if (this.mq != null) {
                            this.mq.close(false);
                        }
                    }
                    catch (Exception e) {
                        if (!this.log.isErrorEnabled()) break block9;
                        this.log.error((Object)("exception: " + e));
                    }
                }
            }
            if (this.prot_stack != null) {
                try {
                    this.prot_stack.stopStack();
                    this.prot_stack.destroy();
                }
                catch (Exception e) {
                    if (!this.log.isErrorEnabled()) break block10;
                    this.log.error((Object)"failed destroying the protocol stack", (Throwable)e);
                }
            }
        }
        this.closed = true;
        this.connected = false;
        this.notifyChannelClosed(this);
        this.init();
    }

    public final void closeMessageQueue(boolean flush_entries) {
        if (this.mq != null) {
            this.mq.close(flush_entries);
        }
    }

    private void handleExit(Event evt) {
        this.notifyChannelShunned();
        if (this.closer != null && !this.closer.isAlive()) {
            this.closer = null;
        }
        if (this.closer == null) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)"received an EXIT event, will leave the channel");
            }
            this.closer = new CloserThread(evt);
            this.closer.start();
        }
    }

    public boolean flushSupported() {
        return this.flush_supported;
    }

    public boolean startFlush(long timeout, int numberOfAttempts, boolean automatic_resume) {
        boolean successfulFlush;
        block8: {
            if (!this.flush_supported) {
                throw new IllegalStateException("Flush is not supported, add pbcast.FLUSH protocol to your configuration");
            }
            successfulFlush = false;
            this.flush_promise.reset();
            this.down(new Event(68));
            try {
                Boolean r = null;
                if (this.flush_promise.hasResult()) {
                    r = (Boolean)this.flush_promise.getResult();
                    successfulFlush = r;
                } else {
                    r = (Boolean)this.flush_promise.getResultWithTimeout(timeout);
                    successfulFlush = r;
                }
            }
            catch (TimeoutException e) {
                if (!this.log.isInfoEnabled()) break block8;
                this.log.info((Object)("JChannel.startFlush requested by " + this.local_addr + " timed out waiting for flush responses after " + timeout + " msec"));
            }
        }
        if (!successfulFlush && numberOfAttempts > 0) {
            long backOffSleepTime = Util.random(5000L);
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Flush in progress detected at " + this.local_addr + ". Backing off for " + backOffSleepTime + " ms. Attempts left " + numberOfAttempts));
            }
            Util.sleepRandom(backOffSleepTime);
            successfulFlush = this.startFlush(timeout, --numberOfAttempts, automatic_resume);
        }
        if (automatic_resume) {
            this.stopFlush();
        }
        return successfulFlush;
    }

    public boolean startFlush(long timeout, boolean automatic_resume) {
        int defaultNumberOfFlushAttempts = 3;
        return this.startFlush(timeout, defaultNumberOfFlushAttempts, automatic_resume);
    }

    public void stopFlush() {
        if (!this.flush_supported) {
            throw new IllegalStateException("Flush is not supported, add pbcast.FLUSH protocol to your configuration");
        }
        this.flush_unblock_promise.reset();
        this.down(new Event(70));
        boolean shouldWaitForUnblock = this.receive_blocks;
        if (shouldWaitForUnblock) {
            try {
                this.flush_unblock_promise.getResultWithTimeout(5000L);
            }
            catch (TimeoutException timeoutException) {
                // empty catch block
            }
        }
    }

    Address determineCoordinator() {
        Vector mbrs;
        Vector vector = mbrs = this.my_view != null ? this.my_view.getMembers() : null;
        if (mbrs == null) {
            return null;
        }
        if (mbrs.size() > 0) {
            return (Address)mbrs.firstElement();
        }
        return null;
    }

    class CloserThread
    extends Thread {
        final Event evt;
        final Thread t;

        CloserThread(Event evt) {
            super(Util.getGlobalThreadGroup(), "CloserThread");
            this.t = null;
            this.evt = evt;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                String old_cluster_name;
                block31: {
                    old_cluster_name = JChannel.this.cluster_name;
                    if (JChannel.this.log.isInfoEnabled()) {
                        JChannel.this.log.info((Object)"closing the channel");
                    }
                    JChannel.this._close(false, false);
                    if (JChannel.this.up_handler != null) {
                        JChannel.this.up_handler.up(this.evt);
                    } else {
                        try {
                            if (JChannel.this.receiver == null) {
                                JChannel.this.mq.add(this.evt);
                            }
                        }
                        catch (Exception ex) {
                            if (!JChannel.this.log.isErrorEnabled()) break block31;
                            JChannel.this.log.error((Object)("exception: " + ex));
                        }
                    }
                }
                if (JChannel.this.mq != null) {
                    Util.sleep(500L);
                    try {
                        JChannel.this.mq.close(false);
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
                if (JChannel.this.auto_reconnect) {
                    try {
                        if (JChannel.this.log.isInfoEnabled()) {
                            JChannel.this.log.info((Object)("reconnecting to group " + old_cluster_name));
                        }
                        JChannel.this.open();
                    }
                    catch (Exception ex) {
                        if (JChannel.this.log.isErrorEnabled()) {
                            JChannel.this.log.error((Object)("failure reopening channel: " + ex));
                        }
                        JChannel.this.closer = null;
                        return;
                    }
                    try {
                        if (JChannel.this.additional_data != null) {
                            HashMap<String, byte[]> m = new HashMap<String, byte[]>(11);
                            m.put("additional_data", JChannel.this.additional_data);
                            JChannel.this.down(new Event(56, m));
                        }
                        JChannel.this.connect(old_cluster_name);
                        JChannel.this.notifyChannelReconnected(JChannel.this.local_addr);
                    }
                    catch (Exception ex) {
                        if (JChannel.this.log.isErrorEnabled()) {
                            JChannel.this.log.error((Object)("failure reconnecting to channel: " + ex));
                        }
                        JChannel.this.closer = null;
                        return;
                    }
                }
                if (JChannel.this.auto_getstate && JChannel.this.state_transfer_supported) {
                    if (JChannel.this.log.isInfoEnabled()) {
                        JChannel.this.log.info((Object)"fetching the state (auto_getstate=true)");
                    }
                    boolean rc = JChannel.this.getState(null, 5000L);
                    if (JChannel.this.log.isInfoEnabled()) {
                        if (rc) {
                            JChannel.this.log.info((Object)"state was retrieved successfully");
                        } else {
                            JChannel.this.log.info((Object)"state transfer failed");
                        }
                    }
                }
            }
            catch (Exception ex) {
                if (JChannel.this.log.isErrorEnabled()) {
                    JChannel.this.log.error((Object)("exception: " + ex));
                }
            }
            finally {
                JChannel.this.closer = null;
            }
        }
    }
}

