/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.com.sun.tools.ws.wsdl.parser;

import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.jboss.com.sun.tools.ws.wsdl.document.Binding;
import org.jboss.com.sun.tools.ws.wsdl.document.BindingFault;
import org.jboss.com.sun.tools.ws.wsdl.document.BindingInput;
import org.jboss.com.sun.tools.ws.wsdl.document.BindingOperation;
import org.jboss.com.sun.tools.ws.wsdl.document.BindingOutput;
import org.jboss.com.sun.tools.ws.wsdl.document.Definitions;
import org.jboss.com.sun.tools.ws.wsdl.document.Documentation;
import org.jboss.com.sun.tools.ws.wsdl.document.Fault;
import org.jboss.com.sun.tools.ws.wsdl.document.Import;
import org.jboss.com.sun.tools.ws.wsdl.document.Input;
import org.jboss.com.sun.tools.ws.wsdl.document.Message;
import org.jboss.com.sun.tools.ws.wsdl.document.MessagePart;
import org.jboss.com.sun.tools.ws.wsdl.document.Operation;
import org.jboss.com.sun.tools.ws.wsdl.document.Output;
import org.jboss.com.sun.tools.ws.wsdl.document.Port;
import org.jboss.com.sun.tools.ws.wsdl.document.PortType;
import org.jboss.com.sun.tools.ws.wsdl.document.Service;
import org.jboss.com.sun.tools.ws.wsdl.document.Types;
import org.jboss.com.sun.tools.ws.wsdl.document.WSDLConstants;
import org.jboss.com.sun.tools.ws.wsdl.document.WSDLDocument;
import org.jboss.com.sun.tools.ws.wsdl.document.WSDLDocumentVisitor;
import org.jboss.com.sun.tools.ws.wsdl.document.schema.SchemaKinds;
import org.jboss.com.sun.tools.ws.wsdl.framework.Extension;
import org.jboss.com.sun.tools.ws.wsdl.framework.Kind;
import org.jboss.com.sun.tools.ws.wsdl.framework.WriterContext;
import org.jboss.com.sun.tools.ws.wsdl.parser.ExtensionHandler;
import org.jboss.com.sun.tools.ws.wsdl.parser.HTTPExtensionHandler;
import org.jboss.com.sun.tools.ws.wsdl.parser.JAXWSBindingExtensionHandler;
import org.jboss.com.sun.tools.ws.wsdl.parser.MIMEExtensionHandler;
import org.jboss.com.sun.tools.ws.wsdl.parser.SOAPExtensionHandler;
import org.jboss.com.sun.tools.ws.wsdl.parser.SchemaExtensionHandler;

public class WSDLWriter {
    private Map _extensionHandlers = new HashMap();
    private static Map<String, String> _commonPrefixes = new HashMap<String, String>();
    private static final String TARGET_NAMESPACE_PREFIX = "tns";
    private static final String NEW_NAMESPACE_PREFIX_BASE = "ns";

    public WSDLWriter() throws IOException {
        this.register(new SOAPExtensionHandler());
        this.register(new HTTPExtensionHandler());
        this.register(new MIMEExtensionHandler());
        this.register(new SchemaExtensionHandler());
        this.register(new JAXWSBindingExtensionHandler());
    }

    public void register(ExtensionHandler h) {
        this._extensionHandlers.put(h.getNamespaceURI(), h);
        h.setExtensionHandlers(this._extensionHandlers);
    }

    public void unregister(ExtensionHandler h) {
        this._extensionHandlers.put(h.getNamespaceURI(), null);
        h.setExtensionHandlers(null);
    }

    public void unregister(String uri) {
        this._extensionHandlers.put(uri, null);
    }

    public void write(final WSDLDocument document, OutputStream os) throws IOException {
        final WriterContext context = new WriterContext(os);
        try {
            document.accept(new WSDLDocumentVisitor(){

                public void preVisit(Definitions definitions) throws Exception {
                    context.push();
                    WSDLWriter.this.initializePrefixes(context, document);
                    context.writeStartTag(definitions.getElementName());
                    context.writeAttribute("name", definitions.getName());
                    context.writeAttribute("targetNamespace", definitions.getTargetNamespaceURI());
                    context.writeAllPendingNamespaceDeclarations();
                }

                public void postVisit(Definitions definitions) throws Exception {
                    context.writeEndTag(definitions.getElementName());
                    context.pop();
                }

                public void visit(Import i) throws Exception {
                    context.writeStartTag(i.getElementName());
                    context.writeAttribute("namespace", i.getNamespace());
                    context.writeAttribute("location", i.getLocation());
                    context.writeEndTag(i.getElementName());
                }

                public void preVisit(Types types) throws Exception {
                    context.writeStartTag(types.getElementName());
                }

                public void postVisit(Types types) throws Exception {
                    context.writeEndTag(types.getElementName());
                }

                public void preVisit(Message message) throws Exception {
                    context.writeStartTag(message.getElementName());
                    context.writeAttribute("name", message.getName());
                }

                public void postVisit(Message message) throws Exception {
                    context.writeEndTag(message.getElementName());
                }

                public void visit(MessagePart part) throws Exception {
                    context.writeStartTag(part.getElementName());
                    context.writeAttribute("name", part.getName());
                    QName dname = part.getDescriptor();
                    Kind dkind = part.getDescriptorKind();
                    if (dname != null && dkind != null) {
                        if (dkind.equals(SchemaKinds.XSD_ELEMENT)) {
                            context.writeAttribute("element", dname);
                        } else if (dkind.equals(SchemaKinds.XSD_TYPE)) {
                            context.writeAttribute("type", dname);
                        }
                    }
                    context.writeEndTag(part.getElementName());
                }

                public void preVisit(PortType portType) throws Exception {
                    context.writeStartTag(portType.getElementName());
                    context.writeAttribute("name", portType.getName());
                }

                public void postVisit(PortType portType) throws Exception {
                    context.writeEndTag(portType.getElementName());
                }

                public void preVisit(Operation operation) throws Exception {
                    context.writeStartTag(operation.getElementName());
                    context.writeAttribute("name", operation.getName());
                    if (operation.getParameterOrder() != null && operation.getParameterOrder().length() > 0) {
                        context.writeAttribute("parameterOrder", operation.getParameterOrder());
                    }
                }

                public void postVisit(Operation operation) throws Exception {
                    context.writeEndTag(operation.getElementName());
                }

                public void preVisit(Input input) throws Exception {
                    context.writeStartTag(input.getElementName());
                    context.writeAttribute("name", input.getName());
                    context.writeAttribute("message", input.getMessage());
                }

                public void postVisit(Input input) throws Exception {
                    context.writeEndTag(input.getElementName());
                }

                public void preVisit(Output output) throws Exception {
                    context.writeStartTag(output.getElementName());
                    context.writeAttribute("name", output.getName());
                    context.writeAttribute("message", output.getMessage());
                }

                public void postVisit(Output output) throws Exception {
                    context.writeEndTag(output.getElementName());
                }

                public void preVisit(Fault fault) throws Exception {
                    context.writeStartTag(fault.getElementName());
                    context.writeAttribute("name", fault.getName());
                    context.writeAttribute("message", fault.getMessage());
                }

                public void postVisit(Fault fault) throws Exception {
                    context.writeEndTag(fault.getElementName());
                }

                public void preVisit(Binding binding) throws Exception {
                    context.writeStartTag(binding.getElementName());
                    context.writeAttribute("name", binding.getName());
                    context.writeAttribute("type", binding.getPortType());
                }

                public void postVisit(Binding binding) throws Exception {
                    context.writeEndTag(binding.getElementName());
                }

                public void preVisit(BindingOperation operation) throws Exception {
                    context.writeStartTag(operation.getElementName());
                    context.writeAttribute("name", operation.getName());
                }

                public void postVisit(BindingOperation operation) throws Exception {
                    context.writeEndTag(operation.getElementName());
                }

                public void preVisit(BindingInput input) throws Exception {
                    context.writeStartTag(input.getElementName());
                    context.writeAttribute("name", input.getName());
                }

                public void postVisit(BindingInput input) throws Exception {
                    context.writeEndTag(input.getElementName());
                }

                public void preVisit(BindingOutput output) throws Exception {
                    context.writeStartTag(output.getElementName());
                    context.writeAttribute("name", output.getName());
                }

                public void postVisit(BindingOutput output) throws Exception {
                    context.writeEndTag(output.getElementName());
                }

                public void preVisit(BindingFault fault) throws Exception {
                    context.writeStartTag(fault.getElementName());
                    context.writeAttribute("name", fault.getName());
                }

                public void postVisit(BindingFault fault) throws Exception {
                    context.writeEndTag(fault.getElementName());
                }

                public void preVisit(Service service) throws Exception {
                    context.writeStartTag(service.getElementName());
                    context.writeAttribute("name", service.getName());
                }

                public void postVisit(Service service) throws Exception {
                    context.writeEndTag(service.getElementName());
                }

                public void preVisit(Port port) throws Exception {
                    context.writeStartTag(port.getElementName());
                    context.writeAttribute("name", port.getName());
                    context.writeAttribute("binding", port.getBinding());
                }

                public void postVisit(Port port) throws Exception {
                    context.writeEndTag(port.getElementName());
                }

                public void preVisit(Extension extension) throws Exception {
                    ExtensionHandler h = (ExtensionHandler)WSDLWriter.this._extensionHandlers.get(extension.getElementName().getNamespaceURI());
                    h.doHandleExtension(context, extension);
                }

                public void postVisit(Extension extension) throws Exception {
                }

                public void visit(Documentation documentation) throws Exception {
                    context.writeTag(WSDLConstants.QNAME_DOCUMENTATION, null);
                }
            });
            context.flush();
        }
        catch (Exception e) {
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new IllegalStateException();
        }
    }

    private void initializePrefixes(WriterContext context, WSDLDocument document) throws IOException {
        String tnsURI = document.getDefinitions().getTargetNamespaceURI();
        if (tnsURI != null) {
            context.setTargetNamespaceURI(tnsURI);
            context.declarePrefix(TARGET_NAMESPACE_PREFIX, tnsURI);
        }
        context.declarePrefix("", "http://schemas.xmlsoap.org/wsdl/");
        Set namespaces = document.collectAllNamespaces();
        for (String nsURI : namespaces) {
            if (context.getPrefixFor(nsURI) != null) continue;
            String prefix = _commonPrefixes.get(nsURI);
            if (prefix == null) {
                prefix = context.findNewPrefix(NEW_NAMESPACE_PREFIX_BASE);
            }
            context.declarePrefix(prefix, nsURI);
        }
    }

    static {
        _commonPrefixes.put("http://schemas.xmlsoap.org/wsdl/", "wsdl");
        _commonPrefixes.put("http://schemas.xmlsoap.org/wsdl/soap/", "soap");
        _commonPrefixes.put("http://schemas.xmlsoap.org/wsdl/http/", "http");
        _commonPrefixes.put("http://schemas.xmlsoap.org/wsdl/mime/", "mime");
        _commonPrefixes.put("http://www.w3.org/2001/XMLSchema", "xsd");
        _commonPrefixes.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
        _commonPrefixes.put("http://java.sun.com/xml/ns/jaxws", "jaxws");
    }
}

