/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.AddressLine;

class AddressLineTable {
    private static Log log = LogFactory.getLog((Class)AddressLineTable.class);
    static String insertSQL = null;
    static String selectSQL = null;
    static String deleteSQL = null;

    AddressLineTable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void insert(String businessKey, int contactID, int addressID, Vector lineList, Connection connection) throws SQLException {
        if (lineList == null || lineList.size() == 0) {
            return;
        }
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(insertSQL);
            statement.setString(1, businessKey.toString());
            statement.setInt(2, contactID);
            statement.setInt(3, addressID);
            int listSize = lineList.size();
            for (int lineID = 0; lineID < listSize; ++lineID) {
                AddressLine line = (AddressLine)lineList.elementAt(lineID);
                statement.setInt(4, lineID);
                statement.setString(5, line.getLineValue());
                statement.setString(6, line.getKeyName());
                statement.setString(7, line.getKeyValue());
                log.debug((Object)("insert into ADDRESS_LINE table:\n\n\t" + insertSQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n\t CONTACT_ID=" + contactID + "\n\t ADDRESS_ID=" + addressID + "\n\t ADDRESS_LINE_ID=" + lineID + "\n\t LINE=" + line.getLineValue() + "\n\t KEY_NAME=" + line.getKeyName() + "\n\t KEY_VALUE=" + line.getKeyValue() + "\n"));
                statement.executeUpdate();
            }
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(String businessKey, int contactID, int addressID, Connection connection) throws SQLException {
        Vector<AddressLine> lineList = new Vector<AddressLine>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.prepareStatement(selectSQL);
            statement.setString(1, businessKey.toString());
            statement.setInt(2, contactID);
            statement.setInt(3, addressID);
            log.debug((Object)("select from ADDRESS_LINE table:\n\n\t" + selectSQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n\t CONTACT_KEY=" + contactID + "\n\t ADDRESS_ID=" + addressID + "\n"));
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                AddressLine line = new AddressLine();
                line.setLineValue(resultSet.getString(1));
                line.setKeyName(resultSet.getString(2));
                line.setKeyValue(resultSet.getString(3));
                lineList.add(line);
            }
            Vector<AddressLine> vector = lineList;
            return vector;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delete(String businessKey, Connection connection) throws SQLException {
        PreparedStatement statement = null;
        try {
            statement = connection.prepareStatement(deleteSQL);
            statement.setString(1, businessKey.toString());
            log.debug((Object)("delete from ADDRESS_LINE table:\n\n\t" + deleteSQL + "\n\t BUSINESS_KEY=" + businessKey.toString() + "\n"));
            statement.executeUpdate();
        }
        finally {
            try {
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    static {
        StringBuffer sql = null;
        sql = new StringBuffer(150);
        sql.append("INSERT INTO ADDRESS_LINE (");
        sql.append("BUSINESS_KEY,");
        sql.append("CONTACT_ID,");
        sql.append("ADDRESS_ID,");
        sql.append("ADDRESS_LINE_ID,");
        sql.append("LINE,");
        sql.append("KEY_NAME,");
        sql.append("KEY_VALUE) ");
        sql.append("VALUES (?,?,?,?,?,?,?)");
        insertSQL = sql.toString();
        sql = new StringBuffer(200);
        sql.append("SELECT ");
        sql.append("LINE,");
        sql.append("KEY_NAME,");
        sql.append("KEY_VALUE, ");
        sql.append("ADDRESS_LINE_ID ");
        sql.append("FROM ADDRESS_LINE ");
        sql.append("WHERE BUSINESS_KEY=? ");
        sql.append("AND CONTACT_ID=? ");
        sql.append("AND ADDRESS_ID=? ");
        sql.append("ORDER BY ADDRESS_LINE_ID");
        selectSQL = sql.toString();
        sql = new StringBuffer(100);
        sql.append("DELETE FROM ADDRESS_LINE ");
        sql.append("WHERE BUSINESS_KEY=?");
        deleteSQL = sql.toString();
    }
}

