/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.datastore.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.juddi.datatype.DiscoveryURL;
import org.apache.juddi.datatype.DiscoveryURLs;
import org.apache.juddi.datatype.request.FindQualifiers;
import org.apache.juddi.util.jdbc.DynamicQuery;

class FindBusinessByDiscoveryURLQuery {
    private static Log log = LogFactory.getLog((Class)FindBusinessByDiscoveryURLQuery.class);
    static String selectSQL;

    FindBusinessByDiscoveryURLQuery() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Vector select(DiscoveryURLs discoveryURLs, Vector keysIn, FindQualifiers qualifiers, Connection connection) throws SQLException {
        if (keysIn != null && keysIn.size() == 0) {
            return keysIn;
        }
        Vector<String> keysOut = new Vector<String>();
        PreparedStatement statement = null;
        ResultSet resultSet = null;
        DynamicQuery sql = new DynamicQuery(selectSQL);
        FindBusinessByDiscoveryURLQuery.appendWhere(sql, discoveryURLs, qualifiers);
        FindBusinessByDiscoveryURLQuery.appendIn(sql, keysIn);
        FindBusinessByDiscoveryURLQuery.appendOrderBy(sql, qualifiers);
        try {
            log.debug((Object)sql.toString());
            statement = sql.buildPreparedStatement(connection);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                keysOut.addElement(resultSet.getString(1));
            }
            Vector<String> vector = keysOut;
            return vector;
        }
        finally {
            try {
                resultSet.close();
            }
            catch (Exception e) {
                log.warn((Object)("An Exception was encountered while attempting to close the Find BusinessEntity ResultSet: " + e.getMessage()), (Throwable)e);
            }
            try {
                statement.close();
            }
            catch (Exception e) {
                log.warn((Object)("An Exception was encountered while attempting to close the Find BusinessEntity Statement: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    private static void appendWhere(DynamicQuery sql, DiscoveryURLs discoveryURLs, FindQualifiers qualifiers) {
        sql.append("WHERE B.BUSINESS_KEY = U.BUSINESS_KEY ");
        Vector urlVector = discoveryURLs.getDiscoveryURLVector();
        int vectorSize = urlVector.size();
        if (vectorSize > 0) {
            sql.append("AND (");
            for (int i = 0; i < vectorSize; ++i) {
                DiscoveryURL discoveryURL = (DiscoveryURL)urlVector.elementAt(i);
                String url = discoveryURL.getValue();
                String useType = discoveryURL.getUseType();
                if (url == null || url.length() <= 0) continue;
                sql.append("(U.URL = ?");
                sql.addValue(url);
                if (useType != null && useType.length() > 0) {
                    sql.append(" AND U.USE_TYPE = ?");
                    sql.addValue(useType);
                }
                sql.append(")");
                if (i + 1 >= vectorSize) continue;
                sql.append(" OR ");
            }
            sql.append(") ");
        }
    }

    private static void appendIn(DynamicQuery sql, Vector keysIn) {
        if (keysIn == null) {
            return;
        }
        sql.append("AND B.BUSINESS_KEY IN (");
        int keyCount = keysIn.size();
        for (int i = 0; i < keyCount; ++i) {
            String key = (String)keysIn.elementAt(i);
            sql.append("?");
            sql.addValue(key);
            if (i + 1 >= keyCount) continue;
            sql.append(",");
        }
        sql.append(") ");
    }

    private static void appendOrderBy(DynamicQuery sql, FindQualifiers qualifiers) {
        sql.append("ORDER BY ");
        if (qualifiers == null) {
            sql.append("B.LAST_UPDATE DESC");
        } else if (qualifiers.sortByDateAsc) {
            sql.append("B.LAST_UPDATE ASC");
        } else {
            sql.append("B.LAST_UPDATE DESC");
        }
    }

    static {
        StringBuffer sql = new StringBuffer(200);
        sql.append("SELECT B.BUSINESS_KEY,B.LAST_UPDATE ");
        sql.append("FROM BUSINESS_ENTITY B,DISCOVERY_URL U ");
        selectSQL = sql.toString();
    }
}

