/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.framework.renderer.AjaxRendererUtils;
import org.ajax4jsf.framework.renderer.HeaderResourcesRendererBase;
import org.ajax4jsf.framework.util.HtmlDimensions;
import org.ajax4jsf.framework.util.javascript.JSFunction;
import org.richfaces.component.UITab;
import org.richfaces.component.UITabPanel;
import org.richfaces.component.util.HtmlUtil;
import org.richfaces.renderkit.TabPanelRendererBase;

public class TabHeaderRendererBase
extends HeaderResourcesRendererBase {
    private static final String LABEL_SUFFIX = "_lbl";
    private static final String ONMOUSEOVER = "RichFaces.overTab(this);";
    private static final String ONMOUSEOUT = "RichFaces.outTab(this);";
    static /* synthetic */ Class class$org$richfaces$component$UITab;

    protected Class getComponentClass() {
        return class$org$richfaces$component$UITab == null ? (class$org$richfaces$component$UITab = TabHeaderRendererBase.class$("org.richfaces.component.UITab")) : class$org$richfaces$component$UITab;
    }

    public void encodeTabLabel(FacesContext context, UITab tab) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        boolean disabled = tab.isDisabled();
        UITabPanel pane = tab.getPane();
        String method = tab.getSwitchType();
        boolean ajax = "ajax".equals(method);
        boolean clientSide = "client".equals(method);
        String label = tab.getLabel();
        if (label == null) {
            label = "";
        }
        String clientId = tab.getClientId(context);
        String style = (String)tab.getAttributes().get("style");
        if (!disabled) {
            if (clientSide) {
                writer.writeAttribute("onclick", (Object)("RichFaces.switchTab('" + pane.getClientId(context) + "','" + clientId + "','" + this.getUtils().formatValue(context, (UIComponent)pane, tab.getName()) + "');"), "switchScript");
            } else {
                String activeCheck = "if (RichFaces.isTabActive('" + clientId + LABEL_SUFFIX + "')) return false;";
                if (ajax) {
                    JSFunction function = AjaxRendererUtils.buildAjaxFunction((UIComponent)tab, (FacesContext)context);
                    Map eventOptions = AjaxRendererUtils.buildEventOptions((FacesContext)context, (UIComponent)tab);
                    function.addParameter((Object)eventOptions);
                    StringBuffer buffer = new StringBuffer();
                    function.appendScript(buffer);
                    buffer.append("; return false; this.onclick = null;");
                    String script = buffer.toString();
                    writer.writeAttribute("onclick", (Object)(activeCheck + script), null);
                } else {
                    StringBuffer script = new StringBuffer("var _formName = A4J.findForm(this).id; var _paramName = '" + clientId + "_server_submit'; var _params = new Object(); _params[_paramName] = _paramName; _JSFFormSubmit('");
                    script.append(clientId);
                    script.append("', _formName, null, _params);");
                    script.append("this.onclick = null; _clearJSFFormParameters(_formName, null, [_paramName]);");
                    writer.writeAttribute("onclick", (Object)(activeCheck + script.toString()), null);
                }
            }
        }
        String width = tab.getLabelWidth();
        style = style + ";height : 100%; position : relative; z-index : 2;";
        if (width != null) {
            style = style + " width: " + this.getUtils().encodePctOrPx(width) + ";";
        }
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "tabStyle");
        }
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeCellClasses(FacesContext context, UITab tab) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        String labelClass = tab.isDisabled() ? "dr-tbpnl-tbcell-dsbld rich-tabhdr-cell-disabled" : (tab.isActive() ? "dr-tbpnl-tbcell-act rich-tabhdr-cell-active" : "dr-tbpnl-tbcell-inact rich-tabhdr-cell-inactive");
        writer.writeAttribute("class", (Object)labelClass, null);
    }

    public void writeLabel(FacesContext context, UITab tab) throws IOException {
        UIComponent facet;
        ResponseWriter writer = context.getResponseWriter();
        String labelClass = "";
        if (tab.isDisabled()) {
            labelClass = TabPanelRendererBase.getDisabledTabClass(tab);
        } else {
            labelClass = tab.isActive() ? TabPanelRendererBase.getActiveTabClass(tab) : TabPanelRendererBase.getInactiveTabClass(tab);
            writer.writeAttribute("onmouseover", (Object)ONMOUSEOVER, "tabOnMouseOver");
            writer.writeAttribute("onmouseout", (Object)ONMOUSEOUT, "tabOnMouseOut");
        }
        writer.writeAttribute("class", (Object)labelClass, "tabClass");
        String title = tab.getTitle();
        if (title != null && title.length() != 0) {
            writer.writeAttribute("title", (Object)title, null);
        }
        if ((facet = tab.getFacet("label")) != null && facet.isRendered()) {
            this.renderChild(context, facet);
        } else {
            String label = tab.getLabel();
            if (label == null || label.length() == 0) {
                label = "&#160;";
            }
            writer.write(label);
        }
    }

    protected String encodeTabLabelWidth(FacesContext context, UITab tab) {
        String labelWidth = tab.getLabelWidth();
        if (labelWidth == null || labelWidth.trim().length() == 0) {
            return "";
        }
        return "width: " + HtmlUtil.qualifySize(labelWidth) + ";";
    }

    public String encodeHeaderSpacing(FacesContext context, UITab tab) throws IOException {
        UITabPanel pane = tab.getPane();
        String headerSpacing = pane.getHeaderSpacing();
        Double decoded = HtmlDimensions.decode((String)headerSpacing);
        if (decoded != 0.0) {
            return "width: " + HtmlUtil.qualifySize(headerSpacing);
        }
        return "";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

