/*
 * Decompiled with CFR 0.152.
 */
package com.mchange.v2.c3p0.impl;

import com.mchange.v2.c3p0.impl.C3P0Defaults;
import com.mchange.v2.c3p0.impl.C3P0PooledConnectionPoolManager;
import com.mchange.v2.c3p0.impl.DbAuth;
import com.mchange.v2.coalesce.Coalescer;
import com.mchange.v2.coalesce.CoalescerFactory;
import com.mchange.v2.lang.ObjectUtils;
import com.mchange.v2.ser.SerializableUtils;
import com.mchange.v2.ser.UnsupportedVersionException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Hashtable;
import javax.naming.BinaryRefAddr;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.PooledConnection;

public abstract class PoolBackedDataSource
implements DataSource,
Referenceable {
    static final Coalescer IMMUTABLES_COALESCER = CoalescerFactory.createCoalescer(true, true);
    transient ConnectionPoolDataSource connectionPoolDataSource;
    transient int numHelperThreads = C3P0Defaults.numHelperThreads();
    transient String factoryClassLocation;
    transient C3P0PooledConnectionPoolManager poolManager;
    static final String REFADDR_VERSION = "version";
    static final String REFADDR_connectionPoolDataSource = "connectionPoolDataSource";
    static final String REFADDR_numHelperThreads = "numHelperThreads";
    static final int CURRENT_VERSION = 1;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$PoolBackedDataSource$Immutable;
    static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$PoolBackedDataSource$ObjectFactory;

    ConnectionPoolDataSource getConnectionPoolDataSource() {
        return this.connectionPoolDataSource;
    }

    int getNumHelperThreads() {
        return this.numHelperThreads;
    }

    String getFactoryClassLocation() {
        return this.factoryClassLocation;
    }

    void setConnectionPoolDataSource(ConnectionPoolDataSource connectionPoolDataSource) {
        this.connectionPoolDataSource = connectionPoolDataSource;
        this._resetPoolManager();
    }

    void setNumHelperThreads(int n) {
        this.numHelperThreads = n;
    }

    void setFactoryClassLocation(String string) {
        this.factoryClassLocation = string;
    }

    public Immutable asImmutable() {
        return Immutable.find(this.connectionPoolDataSource, this.numHelperThreads, this.factoryClassLocation);
    }

    public Connection getConnection() throws SQLException {
        if (this.poolManager == null) {
            this.poolManager = new C3P0PooledConnectionPoolManager(this.connectionPoolDataSource, this.numHelperThreads);
        }
        PooledConnection pooledConnection = this.poolManager.getPool().checkoutPooledConnection();
        return pooledConnection.getConnection();
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        if (this.poolManager == null) {
            this.poolManager = new C3P0PooledConnectionPoolManager(this.connectionPoolDataSource, this.numHelperThreads);
        }
        PooledConnection pooledConnection = this.poolManager.getPool(new DbAuth(string, string2)).checkoutPooledConnection();
        return pooledConnection.getConnection();
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.connectionPoolDataSource.getLogWriter();
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.connectionPoolDataSource.setLogWriter(printWriter);
    }

    public int getLoginTimeout() throws SQLException {
        return this.connectionPoolDataSource.getLoginTimeout();
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.connectionPoolDataSource.setLoginTimeout(n);
    }

    void _resetPoolManager() {
        if (this.poolManager != null) {
            this.poolManager.close();
            this.poolManager = null;
        }
    }

    private static boolean parseBoolean(String string) {
        return Boolean.valueOf(string);
    }

    private static char firstChar(String string) {
        return string.charAt(0);
    }

    public final Reference getReference() throws NamingException {
        try {
            Reference reference = new Reference((class$com$mchange$v2$c3p0$impl$PoolBackedDataSource$Immutable == null ? (class$com$mchange$v2$c3p0$impl$PoolBackedDataSource$Immutable = PoolBackedDataSource.class$("com.mchange.v2.c3p0.impl.PoolBackedDataSource$Immutable")) : class$com$mchange$v2$c3p0$impl$PoolBackedDataSource$Immutable).getName(), (class$com$mchange$v2$c3p0$impl$PoolBackedDataSource$ObjectFactory == null ? (class$com$mchange$v2$c3p0$impl$PoolBackedDataSource$ObjectFactory = PoolBackedDataSource.class$("com.mchange.v2.c3p0.impl.PoolBackedDataSource$ObjectFactory")) : class$com$mchange$v2$c3p0$impl$PoolBackedDataSource$ObjectFactory).getName(), this.factoryClassLocation);
            reference.add(new StringRefAddr(REFADDR_VERSION, String.valueOf(1)));
            reference.add(new BinaryRefAddr(REFADDR_connectionPoolDataSource, SerializableUtils.toByteArray(this.connectionPoolDataSource)));
            reference.add(new StringRefAddr(REFADDR_numHelperThreads, String.valueOf(this.numHelperThreads)));
            return reference;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new NamingException("Nested Exception: " + exception.toString());
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static final class Mutable
    extends PoolBackedDataSource
    implements Serializable {
        public synchronized ConnectionPoolDataSource getConnectionPoolDataSource() {
            return super.getConnectionPoolDataSource();
        }

        public synchronized int getNumHelperThreads() {
            return super.getNumHelperThreads();
        }

        public synchronized String getFactoryClassLocation() {
            return super.getFactoryClassLocation();
        }

        public synchronized void setConnectionPoolDataSource(ConnectionPoolDataSource connectionPoolDataSource) {
            super.setConnectionPoolDataSource(connectionPoolDataSource);
        }

        public synchronized void setNumHelperThreads(int n) {
            super.setNumHelperThreads(n);
        }

        public synchronized void setFactoryClassLocation(String string) {
            super.setFactoryClassLocation(string);
        }

        protected Object writeReplace() throws ObjectStreamException {
            return this.asImmutable();
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            throw new IOException("We should be writing a replacement, can't write mutable version of PoolBackedDataSource");
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException {
            throw new IOException("We should not be finding this mutable version of PoolBackedDataSourceon the wire... we only allow the immutable version to write itself!");
        }
    }

    public static abstract class Base
    extends PoolBackedDataSource
    implements Serializable {
        protected synchronized ConnectionPoolDataSource getConnectionPoolDataSource() {
            return super.getConnectionPoolDataSource();
        }

        protected synchronized int getNumHelperThreads() {
            return super.getNumHelperThreads();
        }

        protected synchronized String getFactoryClassLocation() {
            return super.getFactoryClassLocation();
        }

        protected synchronized void setConnectionPoolDataSource(ConnectionPoolDataSource connectionPoolDataSource) {
            super.setConnectionPoolDataSource(connectionPoolDataSource);
        }

        protected synchronized void setNumHelperThreads(int n) {
            super.setNumHelperThreads(n);
        }

        protected synchronized void setFactoryClassLocation(String string) {
            super.setFactoryClassLocation(string);
        }

        protected Object writeReplace() throws ObjectStreamException {
            return this.asImmutable();
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            throw new IOException("We should be writing a replacement, can't write mutable version of PoolBackedDataSource");
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException {
            throw new IOException("We should not be finding this mutable version of PoolBackedDataSourceon the wire... we only allow the immutable version to write itself!");
        }
    }

    public static final class Immutable
    extends PoolBackedDataSource
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private static final short VERSION = 1;

        public static Immutable find(ConnectionPoolDataSource connectionPoolDataSource, int n, String string) {
            Immutable immutable = new Immutable();
            immutable.connectionPoolDataSource = connectionPoolDataSource;
            immutable._resetPoolManager();
            immutable.numHelperThreads = n;
            immutable.factoryClassLocation = string;
            return (Immutable)IMMUTABLES_COALESCER.coalesce(immutable);
        }

        private Immutable() {
        }

        public ConnectionPoolDataSource getConnectionPoolDataSource() {
            return super.getConnectionPoolDataSource();
        }

        public int getNumHelperThreads() {
            return super.getNumHelperThreads();
        }

        public String getFactoryClassLocation() {
            return super.getFactoryClassLocation();
        }

        public Immutable asImmutable() {
            return this;
        }

        public boolean equals(Object object) {
            if (object instanceof Immutable) {
                Immutable immutable = (Immutable)object;
                return ObjectUtils.eqOrBothNull(this.connectionPoolDataSource, immutable.connectionPoolDataSource) && this.numHelperThreads == immutable.numHelperThreads && ObjectUtils.eqOrBothNull(this.factoryClassLocation, immutable.factoryClassLocation);
            }
            return false;
        }

        public int hashCode() {
            return ObjectUtils.hashOrZero(this.connectionPoolDataSource) ^ this.numHelperThreads ^ ObjectUtils.hashOrZero(this.factoryClassLocation);
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.writeShort(1);
            objectOutputStream.writeObject(this.connectionPoolDataSource);
            objectOutputStream.writeInt(this.numHelperThreads);
            objectOutputStream.writeObject(this.factoryClassLocation);
        }

        private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
            short s = objectInputStream.readShort();
            switch (s) {
                case 1: {
                    this.connectionPoolDataSource = (ConnectionPoolDataSource)objectInputStream.readObject();
                    this._resetPoolManager();
                    this.numHelperThreads = objectInputStream.readInt();
                    this.factoryClassLocation = (String)objectInputStream.readObject();
                    break;
                }
                default: {
                    throw new UnsupportedVersionException(this, s);
                }
            }
        }
    }

    public static class ObjectFactory
    implements javax.naming.spi.ObjectFactory {
        static /* synthetic */ Class class$com$mchange$v2$c3p0$impl$PoolBackedDataSource$Immutable;

        public Object getObjectInstance(Object object, Name name, Context context, Hashtable hashtable) throws Exception {
            Reference reference;
            String string = (class$com$mchange$v2$c3p0$impl$PoolBackedDataSource$Immutable == null ? (class$com$mchange$v2$c3p0$impl$PoolBackedDataSource$Immutable = ObjectFactory.class$("com.mchange.v2.c3p0.impl.PoolBackedDataSource$Immutable")) : class$com$mchange$v2$c3p0$impl$PoolBackedDataSource$Immutable).getName();
            if (object instanceof Reference && (reference = (Reference)object).getClassName().equals(string)) {
                int n = Integer.parseInt((String)reference.get(PoolBackedDataSource.REFADDR_VERSION).getContent());
                if (n == 1) {
                    ConnectionPoolDataSource connectionPoolDataSource = (ConnectionPoolDataSource)SerializableUtils.fromByteArray((byte[])reference.get(PoolBackedDataSource.REFADDR_connectionPoolDataSource).getContent());
                    int n2 = Integer.parseInt((String)reference.get(PoolBackedDataSource.REFADDR_numHelperThreads).getContent());
                    return Immutable.find(connectionPoolDataSource, n2, reference.getFactoryClassLocation());
                }
                throw new NamingException("Cannot resolve reference (version " + n + " unknown.");
            }
            return null;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

