/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import org.jacorb.orb.ORB;
import org.jacorb.orb.giop.MessageInputStream;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.TIMEOUT;
import org.omg.CORBA.portable.RemarshalException;

public abstract class ReplyPlaceholder {
    protected final Object lock = new Object();
    protected boolean ready = false;
    protected boolean communicationException = false;
    protected boolean remarshalException = false;
    protected boolean timeoutException = false;
    protected MessageInputStream in = null;
    protected final int timeout;

    public ReplyPlaceholder(ORB oRB) {
        this.timeout = oRB.getConfiguration().getAttributeAsInteger("jacorb.connection.client.pending_reply_timeout", 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replyReceived(MessageInputStream messageInputStream) {
        Object object = this.lock;
        synchronized (object) {
            if (!this.timeoutException) {
                this.in = messageInputStream;
                this.ready = true;
                this.lock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.lock;
        synchronized (object) {
            if (this.in == null) {
                this.communicationException = true;
                this.ready = true;
                this.lock.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retry() {
        Object object = this.lock;
        synchronized (object) {
            this.remarshalException = true;
            this.ready = true;
            this.lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected MessageInputStream getInputStream(boolean bl) throws RemarshalException {
        boolean bl2 = !bl && this.timeout > 0;
        long l = bl2 ? System.currentTimeMillis() + (long)this.timeout : Long.MAX_VALUE;
        long l2 = bl2 ? (long)this.timeout : 0L;
        Object object = this.lock;
        synchronized (object) {
            try {
                while (!this.ready && System.currentTimeMillis() < l) {
                    this.lock.wait(l2);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.ready && bl2) {
                this.timeoutException = true;
            }
            if (this.remarshalException) {
                throw new RemarshalException();
            }
            if (this.communicationException) {
                throw new COMM_FAILURE(0, CompletionStatus.COMPLETED_MAYBE);
            }
            if (this.timeoutException) {
                throw new TIMEOUT("client timeout reached");
            }
            return this.in;
        }
    }
}

