/*
 * Decompiled with CFR 0.152.
 */
package cirrus.hibernate.collections;

import cirrus.hibernate.HibernateException;
import cirrus.hibernate.collections.PersistentCollection;
import cirrus.hibernate.engine.SessionImplementor;
import cirrus.hibernate.impl.CollectionPersister;
import cirrus.hibernate.type.Type;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ArrayHolder
extends PersistentCollection {
    private Object array;
    private static final Log log = LogFactory.getLog((Class)(class$cirrus$hibernate$collections$PersistentCollection == null ? (class$cirrus$hibernate$collections$PersistentCollection = ArrayHolder.class$("cirrus.hibernate.collections.PersistentCollection")) : class$cirrus$hibernate$collections$PersistentCollection));
    private transient Class elementClass;
    private transient List temp;
    static /* synthetic */ Class class$cirrus$hibernate$collections$PersistentCollection;

    public ArrayHolder(SessionImplementor session, Object array) {
        super(session);
        this.array = array;
        this.initialized = true;
    }

    public Serializable snapshot(CollectionPersister persister) throws HibernateException {
        int length = this.array == null ? this.temp.size() : Array.getLength(this.array);
        Serializable result = (Serializable)Array.newInstance(persister.getElementClass(), length);
        int i = 0;
        while (i < length) {
            Object elt = this.array == null ? this.temp.get(i) : Array.get(this.array, i);
            try {
                Array.set(result, i, persister.getElementType().deepCopy(elt));
            }
            catch (IllegalArgumentException iae) {
                log.error((Object)"Array element type error", (Throwable)iae);
                throw new HibernateException("Array element type error", iae);
            }
            ++i;
        }
        return result;
    }

    public ArrayHolder(SessionImplementor session, CollectionPersister persister) throws HibernateException {
        super(session);
        this.elementClass = persister.getElementClass();
    }

    public Object getArray() {
        return this.array;
    }

    public boolean equalsSnapshot(Type elementType) throws HibernateException {
        Serializable snapshot = this.getSnapshot();
        int xlen = Array.getLength(snapshot);
        if (xlen != Array.getLength(this.array)) {
            return false;
        }
        int i = 0;
        while (i < xlen) {
            if (!elementType.equals(Array.get(snapshot, i), Array.get(this.array, i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void replaceElements(Map replacements) {
        int size = Array.getLength(this.array);
        int i = 0;
        while (i < size) {
            Object r;
            Object val = Array.get(this.array, i);
            if (val != null && (r = replacements.get(val)) != null) {
                Array.set(this.array, i, r);
            }
            ++i;
        }
    }

    public Iterator elements() {
        if (this.array == null) {
            return this.temp.iterator();
        }
        int length = Array.getLength(this.array);
        ArrayList<Object> list = new ArrayList<Object>(length);
        int i = 0;
        while (i < length) {
            list.add(Array.get(this.array, i));
            ++i;
        }
        return list.iterator();
    }

    public boolean empty() {
        return false;
    }

    public void writeTo(PreparedStatement st, CollectionPersister persister, Object entry, int i, boolean writeOrder) throws HibernateException, SQLException {
        persister.writeElement(st, entry, writeOrder, this.session);
        persister.writeIndex(st, new Integer(i), writeOrder, this.session);
    }

    public Object readFrom(ResultSet rs, CollectionPersister persister) throws HibernateException, SQLException {
        Object element = persister.readElement(rs, this.session);
        int index = (Integer)persister.readIndex(rs, this.session);
        int i = this.temp.size();
        while (i <= index) {
            this.temp.add(i, null);
            ++i;
        }
        this.temp.set(index, element);
        return element;
    }

    public Iterator entries() {
        return this.elements();
    }

    public void readEntries(Iterator entries) {
        ArrayList list = new ArrayList();
        while (entries.hasNext()) {
            list.add(entries.next());
        }
        this.array = Array.newInstance(this.elementClass, list.size());
        entries = list.iterator();
        int i = 0;
        while (entries.hasNext()) {
            Array.set(this.array, i++, entries.next());
        }
    }

    public Object getInitialValue(boolean lazy) throws SQLException, HibernateException {
        this.temp = new ArrayList();
        super.getInitialValue(false);
        this.array = Array.newInstance(this.elementClass, this.temp.size());
        int i = 0;
        while (i < this.temp.size()) {
            Array.set(this.array, i, this.temp.get(i));
            ++i;
        }
        this.session.addArrayHolder(this);
        this.temp = null;
        return this.array;
    }

    public void beforeInitialize(CollectionPersister persister) {
    }

    public boolean isArrayHolder() {
        return true;
    }

    public void assemble(CollectionPersister persister) throws HibernateException, SQLException {
        Object[] cached = (Object[])this.array;
        this.array = Array.newInstance(persister.getElementClass(), cached.length);
        int i = 0;
        while (i < cached.length) {
            Array.set(this.array, i, persister.getElementType().assemble((Serializable)cached[i], this.session, null));
            ++i;
        }
    }

    public Serializable disassemble(CollectionPersister persister) throws HibernateException {
        int length = this.temp.size();
        Object[] result = new Object[length];
        int i = 0;
        while (i < length) {
            result[i] = persister.getElementType().disassemble(this.temp.get(i), this.session);
            ++i;
        }
        return result;
    }

    public Object getCachedValue() {
        this.session.addArrayHolder(this);
        return this.array;
    }

    public Iterator getDeletes(Type elemType) throws HibernateException {
        HashSet<Integer> deletes = new HashSet<Integer>();
        int size = Array.getLength(this.getSnapshot());
        int i = Array.getLength(this.array);
        while (i < size) {
            deletes.add(new Integer(i));
            ++i;
        }
        return deletes.iterator();
    }

    public boolean needsInserting(Object entry, int i, Type elemType) throws HibernateException {
        return i >= Array.getLength(this.getSnapshot());
    }

    public boolean needsUpdating(Object entry, int i, Type elemType) throws HibernateException {
        Serializable snapshot = this.getSnapshot();
        return i < Array.getLength(snapshot) && !elemType.equals(Array.get(this.array, i), Array.get(snapshot, i));
    }

    public Object getIndex(Object entry, int i) {
        return new Integer(i);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

