/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.injection.pojo;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import org.jboss.ejb3.EJB3Util;
import org.jboss.ejb3.entity.InjectedEntityManagerFactory;
import org.jboss.ejb3.entity.InjectedSessionFactory;
import org.jboss.ejb3.injection.pojo.InjectionHelper;
import org.jboss.ejb3.injection.pojo.PojoInjector;

public class PersistenceUnitInjector
implements PojoInjector {
    private Hashtable initialContextProperties;

    public PersistenceUnitInjector(Hashtable initialContextProperties) {
        this.initialContextProperties = initialContextProperties;
    }

    public Object getEntityManagerFactory(PersistenceUnit ref, Class type) throws NamingException {
        if (ref.unitName() == null || ref.unitName().equals("")) {
            throw new RuntimeException("You must specify a unit name for @PersistenceUnit");
        }
        InitialContext ctx = EJB3Util.getInitialContext(this.initialContextProperties);
        EntityManagerFactory factory = (EntityManagerFactory)ctx.lookup("java:/ActualEntityManagerFactories/" + ref.unitName());
        if (type.equals(EntityManagerFactory.class)) {
            return new InjectedEntityManagerFactory(factory, "java:/ActualEntityManagerFactories/" + ref.unitName(), this.initialContextProperties);
        }
        return new InjectedSessionFactory(factory, "java:/ActualEntityManagerFactories/" + ref.unitName(), this.initialContextProperties);
    }

    public void inject(Method m, Annotation annotation, Object pojo) {
        InjectionHelper.checkMethodSignature(m, annotation);
        PersistenceUnit pu = (PersistenceUnit)annotation;
        try {
            Object factory = this.getEntityManagerFactory(pu, m.getParameterTypes()[0]);
            m.invoke(pojo, factory);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void inject(Field f, Annotation annotation, Object pojo) {
        PersistenceUnit pu = (PersistenceUnit)annotation;
        try {
            Object factory = this.getEntityManagerFactory(pu, f.getType());
            f.setAccessible(true);
            f.set(pojo, factory);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

